/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdclient.fileStructure;

import com.intellij.ide.structureView.SearchableTextProvider;
import com.intellij.ide.structureView.ShortTextProvider;
import com.intellij.ide.structureView.StructureViewTreeElement;
import com.intellij.ide.util.treeView.smartTree.TreeElement;
import com.intellij.navigation.ColoredItemPresentation;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.jetbrains.rd.ide.model.CodeStructureNavigateTo;
import com.jetbrains.rd.ide.model.CodeStructureTreeModel;
import com.jetbrains.rd.ide.model.CodeStructureTreeNode;
import com.jetbrains.rd.ide.model.IconModel;
import com.jetbrains.rd.ide.model.RdDocumentId;
import com.jetbrains.rd.ui.icons.UtilKt;
import com.jetbrains.rd.util.reactive.ISignal;
import com.jetbrains.rdclient.fileStructure.CodeStructureTextAttributeProvider;
import com.jetbrains.rdclient.fileStructure.ProtocolFileStructureFakePsiElement;
import com.jetbrains.rdclient.fileStructure.TextAttributeProvider;
import java.util.Arrays;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003BA\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00000\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\b\u0010\f\u001a\u0004\u0018\u00010\r\u0012\b\u0010\u000e\u001a\u0004\u0018\u00010\u0000\u00a2\u0006\u0002\u0010\u000fJ\b\u0010%\u001a\u00020&H\u0016J\b\u0010'\u001a\u00020&H\u0016J\u0015\u0010\u0010\u001a\n\u0012\u0006\b\u0001\u0012\u00020(0\tH\u0016\u00a2\u0006\u0002\u0010)J\u0006\u0010*\u001a\u00020+J\b\u0010,\u001a\u00020-H\u0016J\n\u0010.\u001a\u0004\u0018\u00010/H\u0016J\n\u00100\u001a\u0004\u0018\u00010/H\u0016J\b\u00101\u001a\u000202H\u0016J\u0010\u00103\u001a\u0002042\u0006\u00105\u001a\u00020&H\u0016R\"\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00000\tX\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u0014\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u001c\u0010\f\u001a\u0004\u0018\u00010\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u0011\u0010\u001b\u001a\u00020\u001c\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0013\u0010\u000e\u001a\u0004\u0018\u00010\u0000\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$\u00a8\u00066"}, d2={"Lcom/jetbrains/rdclient/fileStructure/ProtocolStructureViewTreeElement;", "Lcom/intellij/ide/structureView/StructureViewTreeElement;", "Lcom/intellij/ide/structureView/SearchableTextProvider;", "Lcom/intellij/ide/structureView/ShortTextProvider;", "codeTree", "Lcom/jetbrains/rd/ide/model/CodeStructureTreeModel;", "protocolTreeNode", "Lcom/jetbrains/rd/ide/model/CodeStructureTreeNode;", "children", "", "project", "Lcom/intellij/openapi/project/Project;", "documentId", "Lcom/jetbrains/rd/ide/model/RdDocumentId;", "parent", "(Lcom/jetbrains/rd/ide/model/CodeStructureTreeModel;Lcom/jetbrains/rd/ide/model/CodeStructureTreeNode;[Lcom/jetbrains/rdclient/fileStructure/ProtocolStructureViewTreeElement;Lcom/intellij/openapi/project/Project;Lcom/jetbrains/rd/ide/model/RdDocumentId;Lcom/jetbrains/rdclient/fileStructure/ProtocolStructureViewTreeElement;)V", "getChildren", "()[Lcom/jetbrains/rdclient/fileStructure/ProtocolStructureViewTreeElement;", "setChildren", "([Lcom/jetbrains/rdclient/fileStructure/ProtocolStructureViewTreeElement;)V", "[Lcom/jetbrains/rdclient/fileStructure/ProtocolStructureViewTreeElement;", "getCodeTree", "()Lcom/jetbrains/rd/ide/model/CodeStructureTreeModel;", "getDocumentId", "()Lcom/jetbrains/rd/ide/model/RdDocumentId;", "setDocumentId", "(Lcom/jetbrains/rd/ide/model/RdDocumentId;)V", "myFakePsiNode", "Lcom/jetbrains/rdclient/fileStructure/ProtocolFileStructureFakePsiElement;", "getMyFakePsiNode", "()Lcom/jetbrains/rdclient/fileStructure/ProtocolFileStructureFakePsiElement;", "getParent", "()Lcom/jetbrains/rdclient/fileStructure/ProtocolStructureViewTreeElement;", "getProject", "()Lcom/intellij/openapi/project/Project;", "getProtocolTreeNode", "()Lcom/jetbrains/rd/ide/model/CodeStructureTreeNode;", "canNavigate", "", "canNavigateToSource", "Lcom/intellij/ide/util/treeView/smartTree/TreeElement;", "()[Lcom/intellij/ide/util/treeView/smartTree/TreeElement;", "getOffset", "", "getPresentation", "Lcom/intellij/navigation/ItemPresentation;", "getSearchableText", "", "getShortText", "getValue", "", "navigate", "", "requestFocus", "intellij.rd.client"})
@SourceDebugExtension(value={"SMAP\nFrontendFileStructureHost.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FrontendFileStructureHost.kt\ncom/jetbrains/rdclient/fileStructure/ProtocolStructureViewTreeElement\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,177:1\n1#2:178\n*E\n"})
public final class ProtocolStructureViewTreeElement
implements StructureViewTreeElement,
SearchableTextProvider,
ShortTextProvider {
    @Nullable
    private final CodeStructureTreeModel codeTree;
    @NotNull
    private final CodeStructureTreeNode protocolTreeNode;
    @NotNull
    private ProtocolStructureViewTreeElement[] children;
    @NotNull
    private final Project project;
    @Nullable
    private RdDocumentId documentId;
    @Nullable
    private final ProtocolStructureViewTreeElement parent;
    @NotNull
    private final ProtocolFileStructureFakePsiElement myFakePsiNode;

    public ProtocolStructureViewTreeElement(@Nullable CodeStructureTreeModel codeTree, @NotNull CodeStructureTreeNode protocolTreeNode, @NotNull ProtocolStructureViewTreeElement[] children2, @NotNull Project project, @Nullable RdDocumentId documentId, @Nullable ProtocolStructureViewTreeElement parent) {
        Intrinsics.checkNotNullParameter((Object)protocolTreeNode, (String)"protocolTreeNode");
        Intrinsics.checkNotNullParameter((Object)children2, (String)"children");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.codeTree = codeTree;
        this.protocolTreeNode = protocolTreeNode;
        this.children = children2;
        this.project = project;
        this.documentId = documentId;
        this.parent = parent;
        this.myFakePsiNode = new ProtocolFileStructureFakePsiElement(this.protocolTreeNode, this, this.project, this.documentId);
    }

    @Nullable
    public final CodeStructureTreeModel getCodeTree() {
        return this.codeTree;
    }

    @NotNull
    public final CodeStructureTreeNode getProtocolTreeNode() {
        return this.protocolTreeNode;
    }

    @NotNull
    public final ProtocolStructureViewTreeElement[] getChildren() {
        return this.children;
    }

    public final void setChildren(@NotNull ProtocolStructureViewTreeElement[] protocolStructureViewTreeElementArray) {
        Intrinsics.checkNotNullParameter((Object)protocolStructureViewTreeElementArray, (String)"<set-?>");
        this.children = protocolStructureViewTreeElementArray;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @Nullable
    public final RdDocumentId getDocumentId() {
        return this.documentId;
    }

    public final void setDocumentId(@Nullable RdDocumentId rdDocumentId) {
        this.documentId = rdDocumentId;
    }

    @Nullable
    public final ProtocolStructureViewTreeElement getParent() {
        return this.parent;
    }

    @NotNull
    public final ProtocolFileStructureFakePsiElement getMyFakePsiNode() {
        return this.myFakePsiNode;
    }

    @Nullable
    public String getSearchableText() {
        String string = CollectionsKt.joinToString$default((Iterable)this.protocolTreeNode.getSearchableTexts(), (CharSequence)" ", null, null, (int)0, null, null, (int)62, null);
        if (StringsKt.isBlank((CharSequence)string)) {
            return null;
        }
        return string;
    }

    @Nullable
    public String getShortText() {
        CharSequence charSequence = this.protocolTreeNode.getShortName();
        if (StringsKt.isBlank((CharSequence)charSequence)) {
            boolean bl = false;
            return null;
        }
        return (String)charSequence;
    }

    @NotNull
    public ItemPresentation getPresentation() {
        return (ItemPresentation)new ColoredItemPresentation(this){
            final /* synthetic */ ProtocolStructureViewTreeElement this$0;
            {
                this.this$0 = $receiver;
            }

            @NotNull
            public String getPresentableText() {
                return this.this$0.getProtocolTreeNode().getName();
            }

            @Nullable
            public Icon getIcon(boolean unused) {
                IconModel iconModel = this.this$0.getProtocolTreeNode().getIcon();
                return iconModel != null ? UtilKt.fromModel(iconModel) : null;
            }

            @Nullable
            public TextAttributesKey getTextAttributesKey() {
                PsiFile psiFile = this.this$0.getMyFakePsiNode().getContainingFile();
                if (psiFile == null || (psiFile = psiFile.getFileType()) == null) {
                    return null;
                }
                PsiFile psiFile2 = psiFile;
                TextAttributeProvider textAttributeProvider = (TextAttributeProvider)CodeStructureTextAttributeProvider.INSTANCE.forFileType((FileType)psiFile2);
                if (textAttributeProvider == null) {
                    return null;
                }
                TextAttributeProvider textAttributeProvider2 = textAttributeProvider;
                return textAttributeProvider2.getTextAttributesKeyFrom(this.this$0.getProtocolTreeNode());
            }
        };
    }

    @NotNull
    public TreeElement[] getChildren() {
        ProtocolStructureViewTreeElement[] protocolStructureViewTreeElementArray = Arrays.copyOf(this.children, this.children.length);
        Intrinsics.checkNotNullExpressionValue((Object)protocolStructureViewTreeElementArray, (String)"copyOf(...)");
        return (TreeElement[])protocolStructureViewTreeElementArray;
    }

    public final int getOffset() {
        return this.protocolTreeNode.getOffset();
    }

    public void navigate(boolean requestFocus) {
        block0: {
            ISignal<CodeStructureNavigateTo> iSignal = this.codeTree;
            if (iSignal == null || (iSignal = iSignal.getNavigateTo()) == null) break block0;
            iSignal.fire((Object)new CodeStructureNavigateTo(this.protocolTreeNode.getId(), requestFocus));
        }
    }

    public boolean canNavigate() {
        return this.protocolTreeNode.getNavigable();
    }

    public boolean canNavigateToSource() {
        return this.protocolTreeNode.getNavigable();
    }

    @NotNull
    public Object getValue() {
        return this.myFakePsiNode;
    }
}

