/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdclient.editors.patchItemHandlers;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.jetbrains.rd.ide.editor.CaretRestoreHelper;
import com.jetbrains.rd.ide.editor.EditorSynchronizer;
import com.jetbrains.rd.ide.editor.UtilKt;
import com.jetbrains.rd.ide.model.RdCaret;
import com.jetbrains.rd.ide.model.RdCaretState;
import com.jetbrains.rd.ide.model.RdEditorChange;
import com.jetbrains.rd.ide.model.RdPatchExtension;
import com.jetbrains.rd.ide.model.RdPatchInitialCaretStateHintExtension;
import com.jetbrains.rd.ide.model.RdPatchItemVersion;
import com.jetbrains.rd.ide.model.RdSelection;
import com.jetbrains.rd.ide.model.RdSelectionChangeBase;
import com.jetbrains.rdclient.document.DocumentExKt;
import com.jetbrains.rdclient.editors.FrontendTextControlHostKt;
import com.jetbrains.rdclient.editors.patchItemHandlers.FrontendSelectionChangeHandlerKt;
import com.jetbrains.rdclient.engine.handlers.FrontendRdPatchHandlerContext;
import com.jetbrains.rdclient.engine.handlers.FrontendRdPatchItemHandler;
import com.jetbrains.rdclient.requests.FrontendRebaseSession;
import com.jetbrains.rdclient.requests.PatchItemOperationType;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0005\u00a2\u0006\u0002\u0010\u0004J\u001e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\tH\u0096@\u00a2\u0006\u0002\u0010\nJ\u0018\u0010\u000b\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\rH\u0002J \u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\rH\u0002\u00a8\u0006\u0010"}, d2={"Lcom/jetbrains/rdclient/editors/patchItemHandlers/FrontendSelectionChangeHandler;", "Lcom/jetbrains/rdclient/engine/handlers/FrontendRdPatchItemHandler;", "Lcom/jetbrains/rd/ide/model/RdPatchItemVersion;", "Lcom/jetbrains/rd/ide/model/RdSelectionChangeBase;", "()V", "apply", "", "item", "context", "Lcom/jetbrains/rdclient/engine/handlers/FrontendRdPatchHandlerContext;", "(Lcom/jetbrains/rd/ide/model/RdSelectionChangeBase;Lcom/jetbrains/rdclient/engine/handlers/FrontendRdPatchHandlerContext;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "j", "rebaseSession", "Lcom/jetbrains/rdclient/requests/FrontendRebaseSession;", "j", "step", "intellij.rd.client"})
@SourceDebugExtension(value={"SMAP\nFrontendSelectionChangeHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FrontendSelectionChangeHandler.kt\ncom/jetbrains/rdclient/editors/patchItemHandlers/FrontendSelectionChangeHandler\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 FrontendRdPatchHandlerContext.kt\ncom/jetbrains/rdclient/engine/handlers/FrontendRdPatchHandlerContext\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,84:1\n65#2,4:85\n65#2,4:96\n65#2,4:100\n65#2,4:104\n32#3:89\n33#3,3:91\n36#3:95\n1855#4:90\n1856#4:94\n*S KotlinDebug\n*F\n+ 1 FrontendSelectionChangeHandler.kt\ncom/jetbrains/rdclient/editors/patchItemHandlers/FrontendSelectionChangeHandler\n*L\n19#1:85,4\n41#1:96,4\n46#1:100,4\n53#1:104,4\n40#1:89\n40#1:91,3\n40#1:95\n40#1:90\n40#1:94\n*E\n"})
public final class FrontendSelectionChangeHandler
implements FrontendRdPatchItemHandler<RdPatchItemVersion, RdSelectionChangeBase> {
    @Override
    @Nullable
    public Object apply(@NotNull RdSelectionChangeBase item, @NotNull FrontendRdPatchHandlerContext context, @NotNull Continuation<? super Unit> $completion) {
        PatchItemOperationType patchItemOperationType = context.getOperation();
        Object object = FrontendSelectionChangeHandlerKt.access$getLogger$p();
        boolean bl = false;
        if (object.isTraceEnabled()) {
            Logger logger = object;
            boolean bl2 = false;
            logger.trace("Applying selection change step: " + item.getEditorId() + " with operation type " + patchItemOperationType);
        }
        object = patchItemOperationType;
        if (object instanceof PatchItemOperationType.Rollback) {
            this.j(item, context, ((PatchItemOperationType.Rollback)patchItemOperationType).getRebaseSession());
        } else if (object instanceof PatchItemOperationType.Redo) {
            this.j(item, ((PatchItemOperationType.Redo)patchItemOperationType).getRebaseSession());
        } else {
            Editor editor2 = FrontendTextControlHostKt.toEditorOrNull(item.getEditorId());
            if (editor2 == null) {
                FrontendSelectionChangeHandler frontendSelectionChangeHandler = this;
                boolean bl3 = false;
                FrontendSelectionChangeHandlerKt.access$getLogger$p().warn("There is no editor for " + item.getEditorId());
                return Unit.INSTANCE;
            }
            Editor editor3 = editor2;
            EditorSynchronizer editorSynchronizer = DocumentExKt.getEditorSynchronizer(editor3);
            Intrinsics.checkNotNull((Object)editorSynchronizer);
            editorSynchronizer.receiveSelection(item);
        }
        return Unit.INSTANCE;
    }

    private final void j(RdSelectionChangeBase rdSelectionChangeBase, FrontendRdPatchHandlerContext frontendRdPatchHandlerContext, FrontendRebaseSession frontendRebaseSession) {
        Unit unit;
        RdEditorChange rdEditorChange;
        boolean bl;
        boolean bl2;
        Object object;
        block10: {
            object = frontendRdPatchHandlerContext;
            bl2 = false;
            Iterable iterable = ((FrontendRdPatchHandlerContext)object).getPatch().getExtensions();
            bl = false;
            for (Object t : iterable) {
                RdPatchExtension rdPatchExtension = (RdPatchExtension)t;
                boolean bl3 = false;
                if (!(rdPatchExtension instanceof RdPatchInitialCaretStateHintExtension)) continue;
                RdPatchInitialCaretStateHintExtension rdPatchInitialCaretStateHintExtension = (RdPatchInitialCaretStateHintExtension)rdPatchExtension;
                boolean bl4 = false;
                rdEditorChange = rdPatchInitialCaretStateHintExtension.getInitialCaretStateHint();
                break block10;
            }
            rdEditorChange = null;
        }
        if (Intrinsics.areEqual((Object)(rdEditorChange != null ? rdEditorChange.getEditorId() : null), (Object)rdSelectionChangeBase.getEditorId())) {
            Logger logger = FrontendSelectionChangeHandlerKt.access$getLogger$p();
            boolean bl5 = false;
            if (logger.isTraceEnabled()) {
                Logger logger2 = logger;
                bl2 = false;
                logger2.trace("Do not rollback initial caret state hint: " + rdSelectionChangeBase.getEditorId() + " - RdPatchInitialCaretStateHintExtension for " + rdSelectionChangeBase.getEditorId() + " is not present");
            }
            return;
        }
        Editor editor2 = FrontendTextControlHostKt.toEditorOrNull(rdSelectionChangeBase.getEditorId());
        if (editor2 == null) {
            object = FrontendSelectionChangeHandlerKt.access$getLogger$p();
            bl2 = false;
            if (object.isTraceEnabled()) {
                Object object2 = object;
                boolean bl6 = false;
                object2.trace("Do not rollback caret state change: " + rdSelectionChangeBase.getEditorId() + " with operation type " + frontendRdPatchHandlerContext.getOperation() + " because editor does not exist");
            }
            return;
        }
        object = CaretRestoreHelper.Companion.getInstance();
        if (((CaretRestoreHelper)object).getLastCaretBeforeRollbackLeansForward() == null) {
            ((CaretRestoreHelper)object).setLastCaretBeforeRollbackLeansForward(editor2.getCaretModel().getPrimaryCaret().getLogicalPosition().leansForward);
        }
        Logger logger = FrontendSelectionChangeHandlerKt.access$getLogger$p();
        boolean bl7 = false;
        if (logger.isTraceEnabled()) {
            Logger logger3 = logger;
            bl = false;
            logger3.trace("Rollback caret state change: " + rdSelectionChangeBase.getEditorId() + " with operation type " + frontendRdPatchHandlerContext.getOperation());
        }
        EditorSynchronizer editorSynchronizer = DocumentExKt.getEditorSynchronizer(editor2);
        if (editorSynchronizer != null) {
            editorSynchronizer.receiveSelection(UtilKt.reverse(rdSelectionChangeBase));
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        if (unit == null) {
            throw new IllegalStateException("editor synchronizer is null".toString());
        }
        frontendRebaseSession.record(rdSelectionChangeBase);
    }

    private final void j(RdSelectionChangeBase rdSelectionChangeBase, FrontendRebaseSession frontendRebaseSession) {
        Editor editor2 = FrontendTextControlHostKt.toEditor(rdSelectionChangeBase.getEditorId());
        RdCaretState rdCaretState = UtilKt.getActualState(frontendRebaseSession.replay(rdSelectionChangeBase));
        for (RdCaret rdCaret : rdCaretState.getCarets()) {
            RdSelection rdSelection;
            CaretModel caretModel = editor2.getCaretModel();
            Intrinsics.checkNotNullExpressionValue((Object)caretModel, (String)"getCaretModel(...)");
            Caret caret = UtilKt.getCaretById(caretModel, rdCaret.getId());
            if (caret == null) {
                LogicalPosition logicalPosition;
                boolean bl = Intrinsics.areEqual((Object)rdCaret.getId(), (Object)rdCaretState.getPrimaryCaretId());
                Intrinsics.checkNotNullExpressionValue((Object)editor2.offsetToLogicalPosition(rdCaret.getOffset().getOffset()), (String)"offsetToLogicalPosition(...)");
                Caret caret2 = caret = editor2.getCaretModel().addCaret(logicalPosition, bl);
                if (caret2 != null) {
                    UtilKt.setId(caret2, rdCaret.getId());
                }
            }
            if (rdCaret.getOffset().getOffset() != -1) {
                Caret caret3 = caret;
                if (caret3 != null) {
                    caret3.moveToOffset(rdCaret.getOffset().getOffset());
                }
            }
            if ((rdSelection = rdCaret.getSelection()).getStart().getOffset() == -1 || rdSelection.getEnd().getOffset() == -1 || rdSelection.getStart().getOffset() >= rdSelection.getEnd().getOffset()) continue;
            Caret caret4 = caret;
            if (caret4 == null) continue;
            caret4.setSelection(rdSelection.getStart().getOffset(), rdSelection.getEnd().getOffset());
        }
    }
}

