/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdclient.editors;

import com.intellij.openapi.client.ClientAppSession;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorSettings;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.impl.EditorState;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.editor.state.ObservableState;
import com.intellij.openapi.editor.state.StateProperty;
import com.intellij.openapi.editor.state.TransferableProperty;
import com.jetbrains.rd.ide.document.PatchEngineDocumentSynchronizer;
import com.jetbrains.rd.ide.editor.PatchEngineEditorSynchronizer;
import com.jetbrains.rd.ide.model.BorderPropertyValueModel;
import com.jetbrains.rd.ide.model.CharSequencePropertyValueModel;
import com.jetbrains.rd.ide.model.ColorPropertyValueModel;
import com.jetbrains.rd.ide.model.EditorSettingsModel;
import com.jetbrains.rd.ide.model.SpecificPropertyValueModel;
import com.jetbrains.rd.ide.model.TextAttributesPropertyValueModel;
import com.jetbrains.rd.ide.model.TextControlId;
import com.jetbrains.rd.ide.model.TextControlModel;
import com.jetbrains.rd.ide.requests.PatchEngine;
import com.jetbrains.rd.platform.colors.ColorHostKt;
import com.jetbrains.rd.platform.daemon.TextAttributesUtilKt;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rdclient.editors.FrontendEditorSettingsUtilsKt;
import com.jetbrains.rdclient.ui.bindableUi.views.utils.BeUtilKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u0001B=\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010J\b\u0010\u0011\u001a\u00020\u0012H\u0014J \u0010\u0013\u001a\u00020\u00122\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u0003H\u0002\u00a8\u0006\u0015"}, d2={"Lcom/jetbrains/rdclient/editors/FrontendPatchEngineEditorSynchronizer;", "Lcom/jetbrains/rd/ide/editor/PatchEngineEditorSynchronizer;", "textControlLifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "session", "Lcom/intellij/openapi/client/ClientAppSession;", "editor", "Lcom/intellij/openapi/editor/Editor;", "editorId", "Lcom/jetbrains/rd/ide/model/TextControlId;", "editorModel", "Lcom/jetbrains/rd/ide/model/TextControlModel;", "documentSynchronizer", "Lcom/jetbrains/rd/ide/document/PatchEngineDocumentSynchronizer;", "engine", "Lcom/jetbrains/rd/ide/requests/PatchEngine;", "(Lcom/jetbrains/rd/util/lifetime/Lifetime;Lcom/intellij/openapi/client/ClientAppSession;Lcom/intellij/openapi/editor/Editor;Lcom/jetbrains/rd/ide/model/TextControlId;Lcom/jetbrains/rd/ide/model/TextControlModel;Lcom/jetbrains/rd/ide/document/PatchEngineDocumentSynchronizer;Lcom/jetbrains/rd/ide/requests/PatchEngine;)V", "init", "", "j", "lifetime", "intellij.rd.client"})
public class FrontendPatchEngineEditorSynchronizer
extends PatchEngineEditorSynchronizer {
    public FrontendPatchEngineEditorSynchronizer(@NotNull Lifetime textControlLifetime, @NotNull ClientAppSession session, @NotNull Editor editor2, @NotNull TextControlId editorId, @NotNull TextControlModel editorModel, @NotNull PatchEngineDocumentSynchronizer documentSynchronizer2, @NotNull PatchEngine engine2) {
        Intrinsics.checkNotNullParameter((Object)textControlLifetime, (String)"textControlLifetime");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)editorId, (String)"editorId");
        Intrinsics.checkNotNullParameter((Object)((Object)editorModel), (String)"editorModel");
        Intrinsics.checkNotNullParameter((Object)documentSynchronizer2, (String)"documentSynchronizer");
        Intrinsics.checkNotNullParameter((Object)engine2, (String)"engine");
        super(textControlLifetime, session, editor2, editorId, editorModel, documentSynchronizer2, engine2);
    }

    @Override
    protected void init() {
        super.init();
        EditorSettingsModel editorSettingsModel = this.getEditorModel().getEditorSettings();
        EditorSettings editorSettings = this.getEditor().getSettings();
        Intrinsics.checkNotNullExpressionValue((Object)editorSettings, (String)"getSettings(...)");
        FrontendEditorSettingsUtilsKt.startSyncEditorSettingsFromModel(editorSettingsModel, editorSettings, this.getTextControlLifetime());
        this.j(this.getEditorModel(), this.getEditor(), this.getTextControlLifetime());
    }

    private final void j(TextControlModel textControlModel, Editor editor2, Lifetime lifetime) {
        if (!(editor2 instanceof EditorImpl)) {
            return;
        }
        EditorState editorState = ((EditorImpl)editor2).getState();
        Intrinsics.checkNotNullExpressionValue((Object)editorState, (String)"getState(...)");
        EditorState editorState2 = editorState;
        textControlModel.getEditorStateProperties().view(lifetime, (Function3)new Function3<Lifetime, String, String, Unit>(editorState2){
            final /* synthetic */ EditorState $editorState;
            {
                this.$editorState = $editorState;
                super(3);
            }

            public final void invoke(@NotNull Lifetime lifetime, @NotNull String propertyName, @NotNull String serializedValue) {
                Object v0;
                block4: {
                    Intrinsics.checkNotNullParameter((Object)lifetime, (String)"<anonymous parameter 0>");
                    Intrinsics.checkNotNullParameter((Object)propertyName, (String)"propertyName");
                    Intrinsics.checkNotNullParameter((Object)serializedValue, (String)"serializedValue");
                    Iterable iterable = this.$editorState.__getProperties();
                    for (T t : iterable) {
                        StateProperty stateProperty = (StateProperty)t;
                        boolean bl = false;
                        if (!Intrinsics.areEqual((Object)stateProperty.getName(), (Object)propertyName)) continue;
                        v0 = t;
                        break block4;
                    }
                    v0 = null;
                }
                StateProperty stateProperty = v0;
                if (stateProperty == null) {
                    return;
                }
                StateProperty stateProperty2 = stateProperty;
                if (!(stateProperty2 instanceof TransferableProperty)) {
                    return;
                }
                Object object = ((TransferableProperty)stateProperty2).decodeFromString(serializedValue);
                if (object == null) {
                    return;
                }
                Object object2 = object;
                stateProperty2.setValue((ObservableState)this.$editorState, object2);
            }
        });
        textControlModel.getSpecificEditorStateProperties().view(lifetime, (Function3)new Function3<Lifetime, String, SpecificPropertyValueModel, Unit>(editorState2){
            final /* synthetic */ EditorState $editorState;
            {
                this.$editorState = $editorState;
                super(3);
            }

            public final void invoke(@NotNull Lifetime lifetime, @NotNull String propertyName, @NotNull SpecificPropertyValueModel model2) {
                Object object;
                Object v0;
                block11: {
                    Intrinsics.checkNotNullParameter((Object)lifetime, (String)"<anonymous parameter 0>");
                    Intrinsics.checkNotNullParameter((Object)propertyName, (String)"propertyName");
                    Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
                    Iterable iterable = this.$editorState.__getProperties();
                    for (T t : iterable) {
                        StateProperty stateProperty = (StateProperty)t;
                        boolean bl = false;
                        if (!Intrinsics.areEqual((Object)stateProperty.getName(), (Object)propertyName)) continue;
                        v0 = t;
                        break block11;
                    }
                    v0 = null;
                }
                StateProperty stateProperty = v0;
                if (stateProperty == null) {
                    return;
                }
                StateProperty stateProperty2 = stateProperty;
                SpecificPropertyValueModel specificPropertyValueModel = model2;
                if (specificPropertyValueModel instanceof TextAttributesPropertyValueModel) {
                    object = TextAttributesUtilKt.toTextAttributes(((TextAttributesPropertyValueModel)model2).getValue());
                } else if (specificPropertyValueModel instanceof CharSequencePropertyValueModel) {
                    object = ((CharSequencePropertyValueModel)model2).getValue();
                } else if (specificPropertyValueModel instanceof ColorPropertyValueModel) {
                    object = ColorHostKt.toColor(((ColorPropertyValueModel)model2).getValue());
                } else if (specificPropertyValueModel instanceof BorderPropertyValueModel) {
                    object = BeUtilKt.toSwingBorder(((BorderPropertyValueModel)model2).getValue());
                    if (object == null) {
                        return;
                    }
                } else {
                    return;
                }
                TextAttributes textAttributes = object;
                stateProperty2.setValue((ObservableState)this.$editorState, (Object)textAttributes);
            }
        });
    }
}

