/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdclient.editorActions.cwm;

import com.intellij.codeWithMe.ClientId;
import com.intellij.codeWithMe.ClientIdExKt;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.client.ClientAppSession;
import com.intellij.openapi.command.impl.ResetUndoHistoryToken;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.jetbrains.rd.ide.model.RdCallEditorActionRequest;
import com.jetbrains.rd.ide.model.RdPatch;
import com.jetbrains.rd.ide.model.RdRequest;
import com.jetbrains.rd.ide.model.TextControlId;
import com.jetbrains.rd.ide.requests.ChangeScope;
import com.jetbrains.rd.ide.requests.PatchEngine;
import com.jetbrains.rd.ide.requests.RdPatchEngine;
import com.jetbrains.rd.util.string.IPrintableKt;
import com.jetbrains.rdclient.editors.FrontendTextControlHostKt;
import com.jetbrains.rdclient.patches.FrontendPatchEngineKt;
import com.jetbrains.rdclient.requests.FrontendAsyncRequestWithImmediateResult;
import com.jetbrains.rdclient.requests.FrontendRebaseSession;
import com.jetbrains.rdclient.services.AppLevelIdeBackend;
import kotlin.Metadata;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0002\u0010\fJ\b\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010\u0018\u001a\u00020\u0007H\u0014J\u0016\u0010\u0019\u001a\u00020\u00122\u0006\u0010\u001a\u001a\u00020\u001bH\u0096@\u00a2\u0006\u0002\u0010\u001cR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0013\u00a8\u0006\u001d"}, d2={"Lcom/jetbrains/rdclient/editorActions/cwm/FrontendCallEditorActionRequest;", "Lcom/jetbrains/rdclient/requests/FrontendAsyncRequestWithImmediateResult;", "patch", "Lcom/jetbrains/rd/ide/model/RdPatch;", "editorId", "Lcom/jetbrains/rd/ide/model/TextControlId;", "frontendActionId", "", "session", "Lcom/intellij/openapi/client/ClientAppSession;", "resetUndoHistoryToken", "Lcom/intellij/openapi/command/impl/ResetUndoHistoryToken;", "(Lcom/jetbrains/rd/ide/model/RdPatch;Lcom/jetbrains/rd/ide/model/TextControlId;Ljava/lang/String;Lcom/intellij/openapi/client/ClientAppSession;Lcom/intellij/openapi/command/impl/ResetUndoHistoryToken;)V", "getEditorId", "()Lcom/jetbrains/rd/ide/model/TextControlId;", "getFrontendActionId", "()Ljava/lang/String;", "isBatchingAllowed", "", "()Z", "assertClientId", "", "createModel", "Lcom/jetbrains/rd/ide/model/RdRequest;", "debugDescription", "redo", "rebaseSession", "Lcom/jetbrains/rdclient/requests/FrontendRebaseSession;", "(Lcom/jetbrains/rdclient/requests/FrontendRebaseSession;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "intellij.rd.client"})
@SourceDebugExtension(value={"SMAP\nFrontendCallEditorActionRequest.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FrontendCallEditorActionRequest.kt\ncom/jetbrains/rdclient/editorActions/cwm/FrontendCallEditorActionRequest\n+ 2 PatchEngine.kt\ncom/jetbrains/rd/ide/requests/PatchEngineKt\n*L\n1#1,76:1\n42#2,3:77\n*S KotlinDebug\n*F\n+ 1 FrontendCallEditorActionRequest.kt\ncom/jetbrains/rdclient/editorActions/cwm/FrontendCallEditorActionRequest\n*L\n41#1:77,3\n*E\n"})
public class FrontendCallEditorActionRequest
extends FrontendAsyncRequestWithImmediateResult {
    @NotNull
    private final TextControlId editorId;
    @NotNull
    private final String frontendActionId;

    public FrontendCallEditorActionRequest(@NotNull RdPatch patch, @NotNull TextControlId editorId, @NotNull String frontendActionId, @NotNull ClientAppSession session, @Nullable ResetUndoHistoryToken resetUndoHistoryToken) {
        Intrinsics.checkNotNullParameter((Object)patch, (String)"patch");
        Intrinsics.checkNotNullParameter((Object)editorId, (String)"editorId");
        Intrinsics.checkNotNullParameter((Object)frontendActionId, (String)"frontendActionId");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        super(session, patch, resetUndoHistoryToken);
        this.editorId = editorId;
        this.frontendActionId = frontendActionId;
    }

    @NotNull
    public final TextControlId getEditorId() {
        return this.editorId;
    }

    @NotNull
    public final String getFrontendActionId() {
        return this.frontendActionId;
    }

    @Override
    public boolean isBatchingAllowed() {
        return true;
    }

    @Override
    @Nullable
    public Object redo(@NotNull FrontendRebaseSession rebaseSession, @NotNull Continuation<? super Boolean> $completion) {
        return FrontendCallEditorActionRequest.redo$suspendImpl(this, rebaseSession, $completion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static /* synthetic */ Object redo$suspendImpl(FrontendCallEditorActionRequest $this, FrontendRebaseSession rebaseSession, Continuation<? super Boolean> $completion) {
        RdPatch rdPatch;
        Object object = FrontendTextControlHostKt.toEditorOrNull($this.editorId);
        EditorImpl editorImpl = object instanceof EditorImpl ? (EditorImpl)object : null;
        if (editorImpl == null) {
            return Boxing.boxBoolean((boolean)false);
        }
        EditorImpl editorImpl2 = editorImpl;
        ResetUndoHistoryToken resetUndoHistoryToken = $this.getResetUndoHistoryToken();
        if (resetUndoHistoryToken != null) {
            resetUndoHistoryToken.refresh();
        }
        object = FrontendPatchEngineKt.getEngine($this.getSession());
        String string = "Redoing call editor action " + $this.frontendActionId;
        boolean bl = false;
        AutoCloseable autoCloseable = (AutoCloseable)((Object)PatchEngine.openAccumulatingSession$default((PatchEngine)object, false, string, null, 4, null));
        Throwable throwable = null;
        try {
            AnAction anAction;
            RdPatchEngine.ChangeAccumulatingSessionToken changeAccumulatingSessionToken = (RdPatchEngine.ChangeAccumulatingSessionToken)((Object)autoCloseable);
            boolean bl2 = false;
            ChangeScope changeScope = changeAccumulatingSessionToken.getSession().getChangeScope();
            boolean bl3 = false;
            ActionManager actionManager = ActionManager.getInstance();
            AnAction anAction2 = anAction = actionManager.getAction($this.frontendActionId);
            if (anAction2 == null) {
                throw new IllegalStateException(("Not found action id: " + $this.frontendActionId).toString());
            }
            Intrinsics.checkNotNull((Object)anAction2);
            AnAction anAction3 = anAction;
            DataContext dataContext = editorImpl2.getDataContext();
            Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getDataContext(...)");
            anAction = dataContext;
            AnActionEvent anActionEvent = AnActionEvent.createFromAnAction((AnAction)anAction3, null, (String)"keyboard shortcut", (DataContext)anAction);
            Intrinsics.checkNotNullExpressionValue((Object)anActionEvent, (String)"createFromAnAction(...)");
            AnActionEvent anActionEvent2 = anActionEvent;
            ActionUtil.performActionDumbAwareWithCallbacks((AnAction)anAction3, (AnActionEvent)anActionEvent2);
            rdPatch = changeAccumulatingSessionToken.getSession().getPatch();
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
        RdPatch rdPatch2 = rdPatch;
        return Boxing.boxBoolean(($this.updatePatchAfterRedo(rdPatch2) != null || $this.getStatus().isExecuting() ? 1 : 0) != 0);
    }

    @Override
    @NotNull
    public RdRequest createModel() {
        String string = AppLevelIdeBackend.Companion.getInstance().getBackendActionId(this.frontendActionId);
        return new RdCallEditorActionRequest(string, this.editorId);
    }

    @Override
    @NotNull
    protected String debugDescription() {
        return "Call editor action=" + this.frontendActionId + " Patch: " + IPrintableKt.printToString((Object)this.getPatch());
    }

    @Override
    public void assertClientId() {
        ClientIdExKt.assertClientIdConsistency((ClientId)new ClientId(this.editorId.getClientId()), (String)(this.debugDescription() + "::" + this.editorId.getDocumentId()));
    }
}

