/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdclient.document;

import com.intellij.openapi.client.ClientAppSession;
import com.intellij.openapi.diagnostic.Logger;
import com.jetbrains.rd.ide.document.DocumentExKt;
import com.jetbrains.rd.ide.document.DocumentSynchronizer;
import com.jetbrains.rd.ide.document.PatchEngineDocumentSynchronizer;
import com.jetbrains.rd.ide.editor.UtilKt;
import com.jetbrains.rd.ide.model.RdDocumentChange;
import com.jetbrains.rd.ide.model.RdDocumentChangeBase;
import com.jetbrains.rd.ide.model.RdDocumentId;
import com.jetbrains.rd.ide.model.RdPatchDocumentVersion;
import com.jetbrains.rd.ide.model.RdPatchItemId;
import com.jetbrains.rd.ide.model.RdResetDocumentChange;
import com.jetbrains.rd.util.string.IPrintableKt;
import com.jetbrains.rdclient.document.FrontendDocumentHost;
import com.jetbrains.rdclient.document.FrontendPatchDocumentItemHandlerKt;
import com.jetbrains.rdclient.engine.handlers.FrontendRdPatchHandlerContext;
import com.jetbrains.rdclient.engine.handlers.FrontendRdPatchItemHandler;
import com.jetbrains.rdclient.requests.PatchItemOperationType;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0005\u00a2\u0006\u0002\u0010\u0004J\u001e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\tH\u0096@\u00a2\u0006\u0002\u0010\nJ\u001a\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0018\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0012\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\u0015"}, d2={"Lcom/jetbrains/rdclient/document/FrontendPatchDocumentItemHandler;", "Lcom/jetbrains/rdclient/engine/handlers/FrontendRdPatchItemHandler;", "Lcom/jetbrains/rd/ide/model/RdPatchDocumentVersion;", "Lcom/jetbrains/rd/ide/model/RdDocumentChangeBase;", "()V", "apply", "", "item", "context", "Lcom/jetbrains/rdclient/engine/handlers/FrontendRdPatchHandlerContext;", "(Lcom/jetbrains/rd/ide/model/RdDocumentChangeBase;Lcom/jetbrains/rdclient/engine/handlers/FrontendRdPatchHandlerContext;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "j", "Lcom/jetbrains/rd/ide/document/PatchEngineDocumentSynchronizer;", "id", "Lcom/jetbrains/rd/ide/model/RdDocumentId;", "session", "Lcom/intellij/openapi/client/ClientAppSession;", "update", "version", "validate", "", "intellij.rd.client"})
@SourceDebugExtension(value={"SMAP\nFrontendPatchDocumentItemHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FrontendPatchDocumentItemHandler.kt\ncom/jetbrains/rdclient/document/FrontendPatchDocumentItemHandler\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,94:1\n65#2,4:95\n65#2,4:99\n65#2,4:103\n65#2,4:107\n65#2,4:111\n*S KotlinDebug\n*F\n+ 1 FrontendPatchDocumentItemHandler.kt\ncom/jetbrains/rdclient/document/FrontendPatchDocumentItemHandler\n*L\n30#1:95,4\n41#1:99,4\n45#1:103,4\n82#1:107,4\n88#1:111,4\n*E\n"})
public final class FrontendPatchDocumentItemHandler
implements FrontendRdPatchItemHandler<RdPatchDocumentVersion, RdDocumentChangeBase> {
    @Override
    public boolean validate(@NotNull RdPatchDocumentVersion version, @NotNull FrontendRdPatchHandlerContext context) {
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        RdPatchItemId rdPatchItemId = version.getId();
        Intrinsics.checkNotNull((Object)rdPatchItemId, (String)"null cannot be cast to non-null type com.jetbrains.rd.ide.model.RdDocumentId");
        PatchEngineDocumentSynchronizer patchEngineDocumentSynchronizer = this.j((RdDocumentId)rdPatchItemId, context.getSession());
        if (patchEngineDocumentSynchronizer == null) {
            return true;
        }
        PatchEngineDocumentSynchronizer patchEngineDocumentSynchronizer2 = patchEngineDocumentSynchronizer;
        if (!Intrinsics.areEqual((Object)patchEngineDocumentSynchronizer2.getVersion(), (Object)version.getVersion())) {
            FrontendPatchDocumentItemHandlerKt.access$getLogger$p().error("Not matched versions for " + version.getId() + " documentId, actual: " + patchEngineDocumentSynchronizer2.getVersion() + ", expected: " + version.getVersion());
            return false;
        }
        return true;
    }

    @Override
    public void update(@NotNull RdPatchDocumentVersion version, @NotNull FrontendRdPatchHandlerContext context) {
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Object object = FrontendPatchDocumentItemHandlerKt.access$getLogger$p();
        boolean bl = false;
        if (object.isTraceEnabled()) {
            Logger logger = object;
            boolean bl2 = false;
            logger.trace("Update document version: " + version.getId() + " to " + version.getVersion() + " with operation type " + context.getOperation());
        }
        RdPatchItemId rdPatchItemId = version.getId();
        Intrinsics.checkNotNull((Object)rdPatchItemId, (String)"null cannot be cast to non-null type com.jetbrains.rd.ide.model.RdDocumentId");
        PatchEngineDocumentSynchronizer patchEngineDocumentSynchronizer = this.j((RdDocumentId)rdPatchItemId, context.getSession());
        if (patchEngineDocumentSynchronizer == null) {
            return;
        }
        object = patchEngineDocumentSynchronizer;
        PatchItemOperationType patchItemOperationType = context.getOperation();
        if (patchItemOperationType instanceof PatchItemOperationType.Rollback) {
            ((PatchEngineDocumentSynchronizer)object).resetVersion(version.getVersion());
        } else if (patchItemOperationType instanceof PatchItemOperationType.Perform) {
            ((PatchEngineDocumentSynchronizer)object).updateLastKnownVersion(version.getVersion());
        }
    }

    @Override
    @Nullable
    public Object apply(@NotNull RdDocumentChangeBase item, @NotNull FrontendRdPatchHandlerContext context, @NotNull Continuation<? super Unit> $completion) {
        RdDocumentChangeBase rdDocumentChangeBase;
        boolean bl;
        Object object;
        PatchItemOperationType patchItemOperationType = context.getOperation();
        Object object2 = FrontendPatchDocumentItemHandlerKt.access$getLogger$p();
        boolean bl2 = false;
        if (object2.isTraceEnabled()) {
            object = object2;
            bl = false;
            object.trace("Apply document step: " + IPrintableKt.printToString((Object)item) + " with operation type " + patchItemOperationType);
        }
        object2 = this.j(item.getDocumentId(), context.getSession());
        if (object2 == null) {
            Logger logger = FrontendPatchDocumentItemHandlerKt.access$getLogger$p();
            bl = false;
            if (logger.isTraceEnabled()) {
                object = logger;
                boolean bl3 = false;
                object.trace("Document synchronizer not found for " + item.getDocumentId() + ": can not apply change: " + IPrintableKt.printToString((Object)item));
            }
            return Unit.INSTANCE;
        }
        PatchItemOperationType patchItemOperationType2 = patchItemOperationType;
        if (patchItemOperationType2 instanceof PatchItemOperationType.Rollback) {
            var8_13 = item;
            if (var8_13 instanceof RdResetDocumentChange) {
                throw new IllegalStateException(("Can't revert initial change for " + DocumentExKt.toDebugString(item.getDocumentId())).toString());
            }
            if (!(var8_13 instanceof RdDocumentChange)) {
                throw new IllegalStateException((item.getClass() + " is not supported for revert operation").toString());
            }
            rdDocumentChangeBase = UtilKt.reverse((RdDocumentChange)item);
        } else if (patchItemOperationType2 instanceof PatchItemOperationType.Redo) {
            RdDocumentChange rdDocumentChange;
            var8_13 = item;
            if (var8_13 instanceof RdResetDocumentChange) {
                throw new IllegalStateException(("Can't redo initial change for " + DocumentExKt.toDebugString(item.getDocumentId())).toString());
            }
            if (var8_13 instanceof RdDocumentChange) {
                boolean bl4;
                rdDocumentChange = ((PatchItemOperationType.Redo)patchItemOperationType).getRebaseSession().replay((RdDocumentChange)item);
                if (rdDocumentChange.getOffset() == -1 || rdDocumentChange.getMoveOffset() == -1 || rdDocumentChange.getOldDocumentLength() == -1) {
                    FrontendPatchDocumentItemHandlerKt.access$getLogger$p().warn("Can't redo change for " + DocumentExKt.toDebugString(item.getDocumentId()) + ": " + IPrintableKt.printToString((Object)item));
                    return Unit.INSTANCE;
                }
                boolean bl5 = bl4 = ((PatchEngineDocumentSynchronizer)object2).getDocument().getTextLength() == rdDocumentChange.getOldDocumentLength();
                if (_Assertions.ENABLED && !bl4) {
                    boolean bl6 = false;
                    String string = "Document length " + ((PatchEngineDocumentSynchronizer)object2).getDocument().getTextLength() + " does not match with expected change length " + rdDocumentChange.getOldDocumentLength();
                    throw new AssertionError((Object)string);
                }
            } else {
                throw new IllegalStateException((item.getClass() + " is not supported for redo operation").toString());
            }
            rdDocumentChangeBase = rdDocumentChange;
        } else {
            rdDocumentChangeBase = item;
        }
        RdDocumentChangeBase rdDocumentChangeBase2 = rdDocumentChangeBase;
        ((PatchEngineDocumentSynchronizer)object2).receiveDocumentChange(rdDocumentChangeBase2, patchItemOperationType instanceof PatchItemOperationType.Redo);
        if (patchItemOperationType instanceof PatchItemOperationType.Rollback) {
            ((PatchItemOperationType.Rollback)patchItemOperationType).getRebaseSession().record(item);
        }
        patchItemOperationType2 = FrontendPatchDocumentItemHandlerKt.access$getLogger$p();
        boolean bl7 = false;
        if (patchItemOperationType2.isTraceEnabled()) {
            object = patchItemOperationType2;
            boolean bl8 = false;
            object.trace("Change " + IPrintableKt.printToString((Object)rdDocumentChangeBase2) + " from operation type " + patchItemOperationType + " was applied. New document length: " + ((PatchEngineDocumentSynchronizer)object2).getDocument().getTextLength());
        }
        return Unit.INSTANCE;
    }

    private final PatchEngineDocumentSynchronizer j(RdDocumentId rdDocumentId, ClientAppSession clientAppSession) {
        FrontendDocumentHost frontendDocumentHost = FrontendDocumentHost.Companion.getInstance(clientAppSession);
        if (frontendDocumentHost.isRecentlyClosed(rdDocumentId)) {
            Logger logger = FrontendPatchDocumentItemHandlerKt.access$getLogger$p();
            boolean bl = false;
            if (logger.isTraceEnabled()) {
                Logger logger2 = logger;
                boolean bl2 = false;
                logger2.trace("Do not promote document version for a recently closed document (it is an expected race case); document: " + rdDocumentId);
            }
            return null;
        }
        DocumentSynchronizer documentSynchronizer2 = frontendDocumentHost.getSynchronizer(rdDocumentId);
        return documentSynchronizer2 instanceof PatchEngineDocumentSynchronizer ? (PatchEngineDocumentSynchronizer)documentSynchronizer2 : null;
    }
}

