/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdclient.document;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.client.ClientAppSession;
import com.intellij.openapi.client.ClientProjectSession;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.impl.DocumentImpl;
import com.intellij.openapi.editor.impl.EditorFactoryImpl;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ApplicationKt;
import com.intellij.util.ModalityUiUtil;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.jetbrains.rd.framework.IProtocol;
import com.jetbrains.rd.ide.document.DocumentSynchronizer;
import com.jetbrains.rd.ide.document.ProtocolDocumentHost;
import com.jetbrains.rd.ide.model.DocumentExtension;
import com.jetbrains.rd.ide.model.DocumentsOperationModel;
import com.jetbrains.rd.ide.model.DocumentsOperationModel_GeneratedKt;
import com.jetbrains.rd.ide.model.RdDocumentId;
import com.jetbrains.rd.ide.model.RdDocumentModel;
import com.jetbrains.rd.platform.util.idea.LifetimedService;
import com.jetbrains.rd.protocol.RootExtListener;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.RLifetimeKt;
import com.jetbrains.rd.util.reactive.IMutableViewableMap;
import com.jetbrains.rd.util.reactive.ViewableMap;
import com.jetbrains.rdclient.client.FrontendSessionsUtilKt;
import com.jetbrains.rdclient.document.DocumentExKt;
import com.jetbrains.rdclient.document.FrontendDocumentExtensionsProvider;
import com.jetbrains.rdclient.document.FrontendDocumentHost;
import com.jetbrains.rdclient.document.FrontendDocumentHostKt;
import com.jetbrains.rdclient.document.FrontendDocumentHostListener;
import com.jetbrains.rdclient.services.AppLevelIdeBackend;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CompletableDeferred;
import kotlinx.coroutines.CompletableDeferredKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\b&\u0018\u0000 62\u00020\u00012\u00020\u0002:\u000267B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u000e\u0010\u001a\u001a\u00020\u0015H\u0086@\u00a2\u0006\u0002\u0010\u001bJ\u0006\u0010\u001c\u001a\u00020\u0015J\u0010\u0010\u001d\u001a\u00020\u000e2\u0006\u0010\u001e\u001a\u00020\u0007H\u0016J0\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u000e2\u0006\u0010\u001e\u001a\u00020\u00072\u0006\u0010$\u001a\u00020%2\u0006\u0010\u0003\u001a\u00020\u0004H$J\u0010\u0010&\u001a\u00020\u000e2\u0006\u0010'\u001a\u00020\u0007H\u0016J\u001e\u0010(\u001a\u00020%2\u0006\u0010'\u001a\u00020\u00072\f\u0010)\u001a\b\u0012\u0004\u0012\u00020+0*H$J\"\u0010,\u001a\u0004\u0018\u00010\u00072\u0006\u0010#\u001a\u00020\u000e2\u0006\u0010$\u001a\u00020%2\u0006\u0010-\u001a\u00020.H\u0014J\u0012\u0010/\u001a\u0004\u0018\u00010 2\u0006\u0010#\u001a\u00020\u000eH\u0016J\u000e\u00100\u001a\u0002012\u0006\u0010#\u001a\u00020\u000eJ\u0006\u00102\u001a\u00020\u0015J\u0010\u00103\u001a\u00020\u00152\u0006\u0010#\u001a\u00020\u000eH\u0016J0\u00104\u001a\u00020\u00152\u0006\u00105\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u000e2\u0006\u0010\u001e\u001a\u00020\u00072\u0006\u0010$\u001a\u00020%2\u0006\u0010\u0003\u001a\u00020\u0004H\u0014R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR&\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u00070\rX\u0084\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u000f\u0010\u0010\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019\u00a8\u00068"}, d2={"Lcom/jetbrains/rdclient/document/FrontendDocumentHost;", "Lcom/jetbrains/rd/platform/util/idea/LifetimedService;", "Lcom/jetbrains/rd/ide/document/ProtocolDocumentHost;", "session", "Lcom/intellij/openapi/client/ClientAppSession;", "(Lcom/intellij/openapi/client/ClientAppSession;)V", "currentlyBindingDocument", "Lcom/intellij/openapi/editor/Document;", "documentsOperationModel", "Lcom/jetbrains/rd/ide/model/DocumentsOperationModel;", "j", "()Lcom/jetbrains/rd/ide/model/DocumentsOperationModel;", "openedDocuments", "Lcom/jetbrains/rd/util/reactive/ViewableMap;", "Lcom/jetbrains/rd/ide/model/RdDocumentId;", "getOpenedDocuments$annotations", "()V", "getOpenedDocuments", "()Lcom/jetbrains/rd/util/reactive/ViewableMap;", "protocolSubscribing", "Lkotlinx/coroutines/CompletableDeferred;", "", "recentlyClosedDocuments", "", "getSession", "()Lcom/intellij/openapi/client/ClientAppSession;", "awaitProtocolSubscriptionsReady", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "beforeRecoveryStarts", "bindDocument", "ideaDocument", "createDocumentSynchronizer", "Lcom/jetbrains/rd/ide/document/DocumentSynchronizer;", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "documentId", "documentModel", "Lcom/jetbrains/rd/ide/model/RdDocumentModel;", "createId", "document", "createModel", "extensions", "", "Lcom/jetbrains/rd/ide/model/DocumentExtension;", "getOrCreateIdeaDocument", "protocol", "Lcom/jetbrains/rd/framework/IProtocol;", "getSynchronizer", "isRecentlyClosed", "", "onProtocolSubscriptionReady", "unregisterDocument", "viewDocumentModel", "documentLifetime", "Companion", "MyProtocolListener", "intellij.rd.client"})
@SourceDebugExtension(value={"SMAP\nFrontendDocumentHost.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FrontendDocumentHost.kt\ncom/jetbrains/rdclient/document/FrontendDocumentHost\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 CollectionEx.kt\ncom/jetbrains/rd/util/CollectionExKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,225:1\n65#2,4:226\n65#2,4:231\n65#2,4:236\n65#2,4:246\n13#2:252\n1#3:230\n66#4:235\n67#4,2:250\n1360#5:240\n1446#5,5:241\n*S KotlinDebug\n*F\n+ 1 FrontendDocumentHost.kt\ncom/jetbrains/rdclient/document/FrontendDocumentHost\n*L\n113#1:226,4\n145#1:231,4\n183#1:236,4\n188#1:246,4\n41#1:252\n182#1:235\n182#1:250,2\n184#1:240\n184#1:241,5\n*E\n"})
public abstract class FrontendDocumentHost
extends LifetimedService
implements ProtocolDocumentHost {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ClientAppSession session;
    @NotNull
    private final ViewableMap<RdDocumentId, Document> openedDocuments;
    @NotNull
    private final List<RdDocumentId> recentlyClosedDocuments;
    @NotNull
    private final CompletableDeferred<Unit> protocolSubscribing;
    @Nullable
    private Document currentlyBindingDocument;
    @NotNull
    private static final Logger LOG;

    public FrontendDocumentHost(@NotNull ClientAppSession session) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        this.session = session;
        this.openedDocuments = new ViewableMap(null, 1, null);
        this.recentlyClosedDocuments = new ArrayList();
        this.protocolSubscribing = CompletableDeferredKt.CompletableDeferred$default(null, (int)1, null);
    }

    @NotNull
    public final ClientAppSession getSession() {
        return this.session;
    }

    @NotNull
    protected final ViewableMap<RdDocumentId, Document> getOpenedDocuments() {
        return this.openedDocuments;
    }

    protected static /* synthetic */ void getOpenedDocuments$annotations() {
    }

    private final DocumentsOperationModel j() {
        return DocumentsOperationModel_GeneratedKt.getDocumentsOperationModel(FrontendSessionsUtilKt.getProtocol(this.session));
    }

    @Nullable
    public final Object awaitProtocolSubscriptionsReady(@NotNull Continuation<? super Unit> $completion) {
        Object object = this.protocolSubscribing.await($completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    public final void onProtocolSubscriptionReady() {
        this.protocolSubscribing.complete((Object)Unit.INSTANCE);
    }

    public final boolean isRecentlyClosed(@NotNull RdDocumentId documentId) {
        Intrinsics.checkNotNullParameter((Object)documentId, (String)"documentId");
        return !((Map)this.openedDocuments).containsKey(documentId) && this.recentlyClosedDocuments.contains(documentId);
    }

    public final void beforeRecoveryStarts() {
        Logger logger = LOG;
        boolean bl = false;
        if (logger.isTraceEnabled()) {
            Logger logger2 = logger;
            boolean bl2 = false;
            logger2.trace("Clear recentlyClosedDocuments before recovery starts.");
        }
        this.recentlyClosedDocuments.clear();
    }

    @Nullable
    protected Document getOrCreateIdeaDocument(@NotNull RdDocumentId documentId, @NotNull RdDocumentModel documentModel, @NotNull IProtocol protocol) {
        Intrinsics.checkNotNullParameter((Object)documentId, (String)"documentId");
        Intrinsics.checkNotNullParameter((Object)((Object)documentModel), (String)"documentModel");
        Intrinsics.checkNotNullParameter((Object)protocol, (String)"protocol");
        Document document = this.currentlyBindingDocument;
        if (document != null) {
            Document document2 = document;
            boolean bl = false;
            return document2;
        }
        document = (Document)this.openedDocuments.get((Object)documentId);
        if (document != null) {
            Document document3 = document;
            boolean bl = false;
            return document3;
        }
        document = AppLevelIdeBackend.Companion.getInstance().tryCreateVirtualFile(documentId);
        if (document != null) {
            return FileDocumentManager.getInstance().getDocument((VirtualFile)document);
        }
        EditorFactory editorFactory = EditorFactory.getInstance();
        boolean bl = documentModel.isWriteThreadOnly();
        EditorFactoryImpl editorFactoryImpl = editorFactory instanceof EditorFactoryImpl ? (EditorFactoryImpl)editorFactory : null;
        if (editorFactoryImpl == null || (editorFactoryImpl = editorFactoryImpl.createDocument(!bl)) == null) {
            Document document4;
            Document document5 = document4 = editorFactory.createDocument((CharSequence)"");
            boolean bl2 = false;
            LOG.warn("It is not possible to create a document with defined `forUseInNonAWTThread` field, because current EditorFactory is not an instance of EditorFactoryImpl class:editorFactory.class=" + editorFactory.getClass() + " documentId=" + documentId + " forUseInNonAWTThread=" + !bl);
            editorFactoryImpl = document4;
        }
        return editorFactoryImpl;
    }

    protected void viewDocumentModel(@NotNull Lifetime documentLifetime, @NotNull RdDocumentId documentId, @NotNull Document ideaDocument, @NotNull RdDocumentModel documentModel, @NotNull ClientAppSession session) {
        Intrinsics.checkNotNullParameter((Object)documentLifetime, (String)"documentLifetime");
        Intrinsics.checkNotNullParameter((Object)documentId, (String)"documentId");
        Intrinsics.checkNotNullParameter((Object)ideaDocument, (String)"ideaDocument");
        Intrinsics.checkNotNullParameter((Object)((Object)documentModel), (String)"documentModel");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        ThreadingAssertions.assertEventDispatchThread();
        Object object = LOG;
        boolean bl = false;
        if (object.isTraceEnabled()) {
            Logger logger = object;
            boolean bl2 = false;
            logger.trace("binding new document " + documentId + " with frontend document " + ideaDocument);
        }
        if (!(ideaDocument instanceof DocumentImpl)) {
            bl = false;
            String string = "ideaDocument is not a DocumentImpl";
            throw new IllegalArgumentException(string.toString());
        }
        LOG.info("Subscribing for document changes.");
        RLifetimeKt.assertAlive((Lifetime)documentLifetime);
        object = this.createDocumentSynchronizer(documentLifetime, documentId, ideaDocument, documentModel, session);
        DocumentExKt.putModel(ideaDocument, session, documentId, (DocumentSynchronizer)object);
        FrontendDocumentHostKt.access$getBindingCounter(ideaDocument).incrementAndGet();
        ((Map)this.openedDocuments).put(documentId, ideaDocument);
        RLifetimeKt.plusAssign((Lifetime)documentLifetime, (Function0)((Function0)new Function0<Unit>(documentId, this, ideaDocument, session){
            final /* synthetic */ RdDocumentId $documentId;
            final /* synthetic */ FrontendDocumentHost this$0;
            final /* synthetic */ Document $ideaDocument;
            final /* synthetic */ ClientAppSession $session;
            {
                this.$documentId = $documentId;
                this.this$0 = $receiver;
                this.$ideaDocument = $ideaDocument;
                this.$session = $session;
                super(0);
            }

            public final void invoke() {
                FrontendDocumentHost.Companion.getLOG().info("Unbinding document " + this.$documentId);
                this.this$0.getOpenedDocuments().remove((Object)this.$documentId);
                FrontendDocumentHostKt.access$getBindingCounter(this.$ideaDocument).decrementAndGet();
                DocumentExKt.removeModel(this.$ideaDocument, this.$session);
            }
        }));
        FrontendDocumentHostListener frontendDocumentHostListener = (FrontendDocumentHostListener)ApplicationKt.getApplication().getMessageBus().syncPublisher(FrontendDocumentHostListener.Companion.getTOPIC());
        frontendDocumentHostListener.documentBound(documentLifetime, session, documentId, documentModel, ideaDocument);
    }

    @NotNull
    protected abstract DocumentSynchronizer createDocumentSynchronizer(@NotNull Lifetime var1, @NotNull RdDocumentId var2, @NotNull Document var3, @NotNull RdDocumentModel var4, @NotNull ClientAppSession var5);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public RdDocumentId bindDocument(@NotNull Document ideaDocument) {
        Intrinsics.checkNotNullParameter((Object)ideaDocument, (String)"ideaDocument");
        try {
            this.currentlyBindingDocument = ideaDocument;
            RdDocumentId rdDocumentId = this.createId(ideaDocument);
            IMutableViewableMap<RdDocumentId, RdDocumentModel> iMutableViewableMap = this.j().getDocuments();
            Object object = (Map)iMutableViewableMap;
            boolean bl = false;
            Object object2 = object.get(rdDocumentId);
            if (object2 == null) {
                boolean bl2;
                Logger logger;
                RdDocumentId rdDocumentId2 = rdDocumentId;
                boolean bl3 = false;
                Object object3 = FrontendDocumentHost.LOG;
                boolean bl4 = false;
                if (object3.isTraceEnabled()) {
                    logger = object3;
                    bl2 = false;
                    logger.trace("Creating model document. ee.Path: " + com.jetbrains.rd.ide.document.DocumentExKt.toDebugString(rdDocumentId));
                }
                Object object4 = FrontendDocumentExtensionsProvider.Companion.getEP_NAME().getExtensionList();
                bl2 = false;
                Iterable iterable = object4;
                Collection collection = new ArrayList();
                boolean bl5 = false;
                for (Object t : iterable) {
                    Object object5 = (FrontendDocumentExtensionsProvider)t;
                    boolean bl6 = false;
                    object5 = object5.getExtensions(ideaDocument);
                    CollectionsKt.addAll((Collection)collection, (Iterable)object5);
                }
                object3 = (List)collection;
                object4 = this.createModel(ideaDocument, (List<? extends DocumentExtension>)object3);
                Logger logger2 = FrontendDocumentHost.LOG;
                boolean bl7 = false;
                if (logger2.isTraceEnabled()) {
                    logger = logger2;
                    boolean bl8 = false;
                    logger.trace("Created model: " + (RdDocumentModel)((Object)object4) + ", creation side:" + ((RdDocumentModel)((Object)object4)).getCreationSide());
                }
                Object object6 = object4;
                boolean bl9 = false;
                object.put(rdDocumentId, object6);
                object2 = object6;
            }
            LOG.info("finished registering document " + com.jetbrains.rd.ide.document.DocumentExKt.toDebugString(rdDocumentId));
            object = rdDocumentId;
            return object;
        }
        finally {
            this.currentlyBindingDocument = null;
        }
    }

    @NotNull
    protected abstract RdDocumentModel createModel(@NotNull Document var1, @NotNull List<? extends DocumentExtension> var2);

    @Override
    @NotNull
    public RdDocumentId createId(@NotNull Document document) {
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        RdDocumentId rdDocumentId = DocumentExKt.getDocumentId(document, this.session);
        if (rdDocumentId != null) {
            return rdDocumentId;
        }
        return ProtocolDocumentHost.super.createId(document);
    }

    public void unregisterDocument(@NotNull RdDocumentId documentId) {
        Intrinsics.checkNotNullParameter((Object)documentId, (String)"documentId");
        ThreadingAssertions.assertEventDispatchThread();
        this.j().getDocuments().remove((Object)documentId);
    }

    @Nullable
    public DocumentSynchronizer getSynchronizer(@NotNull RdDocumentId documentId) {
        Intrinsics.checkNotNullParameter((Object)documentId, (String)"documentId");
        Document document = (Document)this.openedDocuments.get((Object)documentId);
        if (document == null) {
            return null;
        }
        Document document2 = document;
        return DocumentExKt.getDocumentSynchronizer(document2, this.session);
    }

    public static final /* synthetic */ List access$getRecentlyClosedDocuments$p(FrontendDocumentHost $this) {
        return $this.recentlyClosedDocuments;
    }

    static {
        boolean bl = false;
        Logger logger = Logger.getInstance(FrontendDocumentHost.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\fH\u0007J\u0014\u0010\r\u001a\u0004\u0018\u00010\b2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0007R\u0014\u0010\u0003\u001a\u00020\u0004X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rdclient/document/FrontendDocumentHost$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "getInstance", "Lcom/jetbrains/rdclient/document/FrontendDocumentHost;", "session", "Lcom/intellij/openapi/client/ClientAppSession;", "project", "Lcom/intellij/openapi/project/Project;", "tryGetInstance", "intellij.rd.client"})
    @SourceDebugExtension(value={"SMAP\nFrontendDocumentHost.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FrontendDocumentHost.kt\ncom/jetbrains/rdclient/document/FrontendDocumentHost$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,225:1\n51#2:226\n31#2,2:227\n*S KotlinDebug\n*F\n+ 1 FrontendDocumentHost.kt\ncom/jetbrains/rdclient/document/FrontendDocumentHost$Companion\n*L\n47#1:226\n50#1:227,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        protected final Logger getLOG() {
            return LOG;
        }

        @Deprecated(message="Use an overload with client app session")
        @Nullable
        public final FrontendDocumentHost tryGetInstance(@Nullable Project project) {
            if (project == null || project.isDisposed()) {
                return null;
            }
            ClientProjectSession clientProjectSession = FrontendSessionsUtilKt.getFrontendProjectSessionOrNull(project);
            if (clientProjectSession == null) {
                return null;
            }
            ClientProjectSession clientProjectSession2 = clientProjectSession;
            ComponentManager componentManager = (ComponentManager)clientProjectSession2.getAppSession();
            boolean bl = false;
            return (FrontendDocumentHost)componentManager.getService(FrontendDocumentHost.class);
        }

        @NotNull
        public final FrontendDocumentHost getInstance(@NotNull ClientAppSession session) {
            Intrinsics.checkNotNullParameter((Object)session, (String)"session");
            ComponentManager componentManager = (ComponentManager)session;
            boolean bl = false;
            Class<FrontendDocumentHost> clazz = FrontendDocumentHost.class;
            Object object = componentManager.getService(clazz);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)componentManager, clazz);
            }
            return (FrontendDocumentHost)object;
        }

        @Deprecated(message="Use an overload with client app session")
        @NotNull
        public final FrontendDocumentHost getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            return this.getInstance(FrontendSessionsUtilKt.getFrontendProjectSession(project).getAppSession());
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0002H\u0016\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/rdclient/document/FrontendDocumentHost$MyProtocolListener;", "Lcom/jetbrains/rd/protocol/RootExtListener;", "Lcom/jetbrains/rd/ide/model/DocumentsOperationModel;", "()V", "extensionCreated", "", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "session", "Lcom/intellij/openapi/client/ClientAppSession;", "model", "intellij.rd.client"})
    @SourceDebugExtension(value={"SMAP\nFrontendDocumentHost.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FrontendDocumentHost.kt\ncom/jetbrains/rdclient/document/FrontendDocumentHost$MyProtocolListener\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,225:1\n65#2,4:226\n*S KotlinDebug\n*F\n+ 1 FrontendDocumentHost.kt\ncom/jetbrains/rdclient/document/FrontendDocumentHost$MyProtocolListener\n*L\n66#1:226,4\n*E\n"})
    public static final class MyProtocolListener
    implements RootExtListener<DocumentsOperationModel> {
        @Override
        public void extensionCreated(@NotNull Lifetime lifetime, @NotNull ClientAppSession session, @NotNull DocumentsOperationModel model2) {
            Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
            Intrinsics.checkNotNullParameter((Object)session, (String)"session");
            Intrinsics.checkNotNullParameter((Object)((Object)model2), (String)"model");
            Logger logger = Companion.getLOG();
            boolean bl = false;
            if (logger.isTraceEnabled()) {
                Logger logger2 = logger;
                boolean bl2 = false;
                logger2.trace("[service] MyProtocolListener$extensionCreated: subscribe on `documents` model");
            }
            model2.getDocuments().view(lifetime, (Function3)new Function3<Lifetime, RdDocumentId, RdDocumentModel, Unit>(session, this){
                final /* synthetic */ ClientAppSession $session;
                final /* synthetic */ MyProtocolListener this$0;
                {
                    this.$session = $session;
                    this.this$0 = $receiver;
                    super(3);
                }

                public final void invoke(@NotNull Lifetime documentLifetime, @NotNull RdDocumentId documentId, @NotNull RdDocumentModel documentModel) {
                    Intrinsics.checkNotNullParameter((Object)documentLifetime, (String)"documentLifetime");
                    Intrinsics.checkNotNullParameter((Object)documentId, (String)"documentId");
                    Intrinsics.checkNotNullParameter((Object)((Object)documentModel), (String)"documentModel");
                    boolean bl = ApplicationManager.getApplication().isDispatchThread();
                    Logger logger = FrontendDocumentHost.Companion.getLOG();
                    boolean bl2 = false;
                    if (logger.isTraceEnabled()) {
                        Logger logger2 = logger;
                        boolean bl3 = false;
                        logger2.trace("[file] MyProtocolListener$extensionCreated$solutions.view$documents.view before invokeLaterIfNeeded. isEdt=" + bl + " document=" + com.jetbrains.rd.ide.document.DocumentExKt.toDebugString(documentId));
                    }
                    ModalityUiUtil.invokeLaterIfNeeded((ModalityState)ModalityState.defaultModalityState(), () -> extensionCreated.2.j(this.$session, documentId, documentModel, this.this$0, documentLifetime));
                    documentLifetime.onTermination((Function0)new Function0<Unit>(this.$session, documentId){
                        final /* synthetic */ ClientAppSession $session;
                        final /* synthetic */ RdDocumentId $documentId;
                        {
                            this.$session = $session;
                            this.$documentId = $documentId;
                            super(0);
                        }

                        public final void invoke() {
                            Logger logger = FrontendDocumentHost.Companion.getLOG();
                            RdDocumentId rdDocumentId = this.$documentId;
                            boolean bl = false;
                            if (logger.isTraceEnabled()) {
                                Logger logger2 = logger;
                                boolean bl2 = false;
                                logger2.trace("document lifetime is terminating. Moving it's id to recentlyClosedDocuments: documentId=" + com.jetbrains.rd.ide.document.DocumentExKt.toDebugString(rdDocumentId));
                            }
                            FrontendDocumentHost.access$getRecentlyClosedDocuments$p(FrontendDocumentHost.Companion.getInstance(this.$session)).add(this.$documentId);
                        }
                    });
                }

                private static final void j(ClientAppSession clientAppSession, RdDocumentId rdDocumentId, RdDocumentModel rdDocumentModel, MyProtocolListener myProtocolListener, Lifetime lifetime) {
                    Intrinsics.checkNotNullParameter((Object)clientAppSession, (String)"$session");
                    Intrinsics.checkNotNullParameter((Object)rdDocumentId, (String)"$documentId");
                    Intrinsics.checkNotNullParameter((Object)((Object)rdDocumentModel), (String)"$documentModel");
                    Intrinsics.checkNotNullParameter((Object)myProtocolListener, (String)"this$0");
                    Intrinsics.checkNotNullParameter((Object)lifetime, (String)"$documentLifetime");
                    Logger logger = FrontendDocumentHost.Companion.getLOG();
                    boolean bl = false;
                    if (logger.isTraceEnabled()) {
                        Logger logger2 = logger;
                        boolean bl2 = false;
                        logger2.trace("[file] MyProtocolListener$extensionCreated$solutions.view$documents.view$invokeLaterIfNeeded: document=" + com.jetbrains.rd.ide.document.DocumentExKt.toDebugString(rdDocumentId));
                    }
                    Document document = FrontendDocumentHost.Companion.getInstance(clientAppSession).getOrCreateIdeaDocument(rdDocumentId, rdDocumentModel, FrontendSessionsUtilKt.getProtocol(clientAppSession));
                    if (document == null) {
                        MyProtocolListener myProtocolListener2 = myProtocolListener;
                        boolean bl3 = false;
                        FrontendDocumentHost.Companion.getLOG().warn("It's not possible to get or create a Document for " + com.jetbrains.rd.ide.document.DocumentExKt.toDebugString(rdDocumentId));
                        return;
                    }
                    logger = document;
                    FrontendDocumentHost.Companion.getInstance(clientAppSession).viewDocumentModel(lifetime, rdDocumentId, (Document)logger, rdDocumentModel, clientAppSession);
                }
            });
            model2.getHostReleasedDocument().advise(lifetime, (Function1)new Function1<RdDocumentId, Unit>(session){
                final /* synthetic */ ClientAppSession $session;
                {
                    this.$session = $session;
                    super(1);
                }

                public final void invoke(@NotNull RdDocumentId it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    Logger logger = FrontendDocumentHost.Companion.getLOG();
                    boolean bl = false;
                    if (logger.isTraceEnabled()) {
                        Logger logger2 = logger;
                        boolean bl2 = false;
                        logger2.trace("document was released on host. Remove it's id from recentlyClosedEditors: documentId=" + com.jetbrains.rd.ide.document.DocumentExKt.toDebugString(it) + " ");
                    }
                    FrontendDocumentHost.access$getRecentlyClosedDocuments$p(FrontendDocumentHost.Companion.getInstance(this.$session)).remove(it);
                }
            });
            Companion.getInstance(session).onProtocolSubscriptionReady();
        }
    }
}

