/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdclient.document;

import com.intellij.openapi.client.ClientAppSession;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.jetbrains.rd.ide.document.DocumentSynchronizer;
import com.jetbrains.rd.ide.editor.EditorSynchronizer;
import com.jetbrains.rd.ide.model.RdDocumentId;
import com.jetbrains.rd.ide.model.TextControlId;
import com.jetbrains.rd.ide.model.TextControlModel;
import com.jetbrains.rdclient.client.FrontendSessionsUtilKt;
import com.jetbrains.rdclient.document.DocumentModel;
import com.jetbrains.rdclient.document.PerProtocolData;
import com.jetbrains.rdclient.editors.FrontendTextControlHost;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000V\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\u001a\u0019\u0010\r\u001a\u0004\u0018\u00010\u000e*\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\u0002\u0010\u0012\u001a\u0014\u0010\u0013\u001a\u0004\u0018\u00010\u0014*\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u0016\u001a\u0014\u0010\u0013\u001a\u0004\u0018\u00010\u0014*\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u0018\u001a\u0014\u0010\u0019\u001a\u0004\u0018\u00010\u001a*\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u0016\u001a\u0014\u0010\u0019\u001a\u0004\u0018\u00010\u001a*\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u0018\u001a\u0016\u0010\u001b\u001a\u0004\u0018\u00010\u001c*\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002\u001a\"\u0010\u001d\u001a\u00020\u001e*\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u001f\u001a\u00020\u00142\u0006\u0010 \u001a\u00020\u001a\u001a\u0012\u0010!\u001a\u00020\u001e*\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u0016\"\u0017\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\"\u0017\u0010\u0005\u001a\u0004\u0018\u00010\u0006*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\"\u0017\u0010\t\u001a\u0004\u0018\u00010\n*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\""}, d2={"editorSynchronizer", "Lcom/jetbrains/rd/ide/editor/EditorSynchronizer;", "Lcom/intellij/openapi/editor/Editor;", "getEditorSynchronizer", "(Lcom/intellij/openapi/editor/Editor;)Lcom/jetbrains/rd/ide/editor/EditorSynchronizer;", "textControlId", "Lcom/jetbrains/rd/ide/model/TextControlId;", "getTextControlId", "(Lcom/intellij/openapi/editor/Editor;)Lcom/jetbrains/rd/ide/model/TextControlId;", "textControlModel", "Lcom/jetbrains/rd/ide/model/TextControlModel;", "getTextControlModel", "(Lcom/intellij/openapi/editor/Editor;)Lcom/jetbrains/rd/ide/model/TextControlModel;", "getCharAt", "", "Lcom/intellij/openapi/editor/Document;", "offset", "", "(Lcom/intellij/openapi/editor/Document;I)Ljava/lang/Character;", "getDocumentId", "Lcom/jetbrains/rd/ide/model/RdDocumentId;", "session", "Lcom/intellij/openapi/client/ClientAppSession;", "project", "Lcom/intellij/openapi/project/Project;", "getDocumentSynchronizer", "Lcom/jetbrains/rd/ide/document/DocumentSynchronizer;", "j", "Lcom/jetbrains/rdclient/document/DocumentModel;", "putModel", "", "documentId", "documentSynchronizer", "removeModel", "intellij.rd.client"})
@SourceDebugExtension(value={"SMAP\nDocumentEx.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DocumentEx.kt\ncom/jetbrains/rdclient/document/DocumentExKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,70:1\n1#2:71\n*E\n"})
public final class DocumentExKt {
    @Nullable
    public static final TextControlId getTextControlId(@NotNull Editor $this$textControlId) {
        Intrinsics.checkNotNullParameter((Object)$this$textControlId, (String)"<this>");
        return (TextControlId)$this$textControlId.getUserData(FrontendTextControlHost.Companion.getTextControlIdKey());
    }

    @Nullable
    public static final TextControlModel getTextControlModel(@NotNull Editor $this$textControlModel) {
        Intrinsics.checkNotNullParameter((Object)$this$textControlModel, (String)"<this>");
        EditorSynchronizer editorSynchronizer = DocumentExKt.getEditorSynchronizer($this$textControlModel);
        return editorSynchronizer != null ? editorSynchronizer.getEditorModel() : null;
    }

    @Nullable
    public static final EditorSynchronizer getEditorSynchronizer(@NotNull Editor $this$editorSynchronizer) {
        Intrinsics.checkNotNullParameter((Object)$this$editorSynchronizer, (String)"<this>");
        return (EditorSynchronizer)$this$editorSynchronizer.getUserData(FrontendTextControlHost.Companion.getTextControlSynchronizerKey());
    }

    @Nullable
    public static final DocumentSynchronizer getDocumentSynchronizer(@NotNull Document $this$getDocumentSynchronizer, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)$this$getDocumentSynchronizer, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return DocumentExKt.getDocumentSynchronizer($this$getDocumentSynchronizer, FrontendSessionsUtilKt.getFrontendProjectSession(project).getAppSession());
    }

    @Nullable
    public static final DocumentSynchronizer getDocumentSynchronizer(@NotNull Document $this$getDocumentSynchronizer, @NotNull ClientAppSession session) {
        Intrinsics.checkNotNullParameter((Object)$this$getDocumentSynchronizer, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        DocumentModel documentModel = PerProtocolData.Companion.getInstance(session).getDocumentToModel().get($this$getDocumentSynchronizer);
        return documentModel != null ? documentModel.getDocumentSynchronizer() : null;
    }

    public static final void putModel(@NotNull Document $this$putModel, @NotNull ClientAppSession session, @NotNull RdDocumentId documentId, @NotNull DocumentSynchronizer documentSynchronizer2) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)$this$putModel, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)documentId, (String)"documentId");
        Intrinsics.checkNotNullParameter((Object)documentSynchronizer2, (String)"documentSynchronizer");
        PerProtocolData perProtocolData = PerProtocolData.Companion.getInstance(session);
        boolean bl2 = bl = !perProtocolData.getDocumentToModel().containsKey($this$putModel);
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string = "Document " + $this$putModel + " with id " + documentId + " already has a model";
            throw new AssertionError((Object)string);
        }
        perProtocolData.getDocumentToModel().put($this$putModel, new DocumentModel(documentId, documentSynchronizer2));
    }

    public static final void removeModel(@NotNull Document $this$removeModel, @NotNull ClientAppSession session) {
        Intrinsics.checkNotNullParameter((Object)$this$removeModel, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        PerProtocolData.Companion.getInstance(session).getDocumentToModel().remove($this$removeModel);
    }

    private static final DocumentModel j(Document document, ClientAppSession clientAppSession) {
        return PerProtocolData.Companion.getInstance(clientAppSession).getDocumentToModel().get(document);
    }

    @Nullable
    public static final RdDocumentId getDocumentId(@NotNull Document $this$getDocumentId, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)$this$getDocumentId, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        DocumentModel documentModel = DocumentExKt.j($this$getDocumentId, FrontendSessionsUtilKt.getFrontendProjectSession(project).getAppSession());
        return documentModel != null ? documentModel.getDocumentId() : null;
    }

    @Nullable
    public static final RdDocumentId getDocumentId(@NotNull Document $this$getDocumentId, @NotNull ClientAppSession session) {
        Intrinsics.checkNotNullParameter((Object)$this$getDocumentId, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        DocumentModel documentModel = DocumentExKt.j($this$getDocumentId, session);
        return documentModel != null ? documentModel.getDocumentId() : null;
    }

    @Nullable
    public static final Character getCharAt(@NotNull Document $this$getCharAt, int offset) {
        Intrinsics.checkNotNullParameter((Object)$this$getCharAt, (String)"<this>");
        if (!(0 <= offset ? offset < $this$getCharAt.getTextLength() : false)) {
            return null;
        }
        return Character.valueOf($this$getCharAt.getImmutableCharSequence().charAt(offset));
    }
}

