/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdclient.daemon.highlighters.tooltips;

import com.jetbrains.rd.ide.model.NotCalculatedTooltipModel;
import com.jetbrains.rd.ide.model.TooltipModel;
import com.jetbrains.rdclient.daemon.highlighters.tooltips.FrontendTooltipProvider;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b&\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J(\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\nH\u0002J\u0006\u0010\u0011\u001a\u00020\fJ\u0012\u0010\u0012\u001a\u00020\f2\b\u0010\u0013\u001a\u0004\u0018\u00010\u000eH&R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/jetbrains/rdclient/daemon/highlighters/tooltips/FrontendTooltipCalculator;", "", "modelId", "", "provider", "Lcom/jetbrains/rdclient/daemon/highlighters/tooltips/FrontendTooltipProvider;", "(JLcom/jetbrains/rdclient/daemon/highlighters/tooltips/FrontendTooltipProvider;)V", "requested", "Ljava/util/concurrent/atomic/AtomicBoolean;", "tooltipTimestamp", "", "j", "", "model", "Lcom/jetbrains/rd/ide/model/TooltipModel;", "currentTimestamp", "retry", "calculateTooltip", "updateData", "tooltipModel", "Companion", "intellij.rd.client"})
public abstract class FrontendTooltipCalculator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final long modelId;
    @NotNull
    private final FrontendTooltipProvider provider;
    @NotNull
    private final AtomicBoolean requested;
    private int tooltipTimestamp;
    private static final int CALCULATION_RETRY_LIMIT = 10;

    public FrontendTooltipCalculator(long modelId, @NotNull FrontendTooltipProvider provider2) {
        Intrinsics.checkNotNullParameter((Object)provider2, (String)"provider");
        this.modelId = modelId;
        this.provider = provider2;
        this.requested = new AtomicBoolean();
        this.tooltipTimestamp = -1;
    }

    public abstract void updateData(@Nullable TooltipModel var1);

    public final void calculateTooltip() {
        if (this.modelId < 0L) {
            return;
        }
        int n = this.provider.getCurrentTimestamp();
        if (this.tooltipTimestamp == n) {
            return;
        }
        if (!this.requested.compareAndSet(false, true)) {
            return;
        }
        this.tooltipTimestamp = n;
        this.updateData(null);
        this.provider.requestTooltip(this.modelId, (Function1<? super TooltipModel, Unit>)((Function1)new Function1<TooltipModel, Unit>(this, n){
            final /* synthetic */ FrontendTooltipCalculator this$0;
            final /* synthetic */ int $currentTimestamp;
            {
                this.this$0 = $receiver;
                this.$currentTimestamp = $currentTimestamp;
                super(1);
            }

            public final void invoke(@NotNull TooltipModel it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                FrontendTooltipCalculator.access$applyUpdateWithRetry(this.this$0, it, FrontendTooltipCalculator.access$getProvider$p(this.this$0), this.$currentTimestamp, 10);
            }
        }));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void j(TooltipModel tooltipModel, FrontendTooltipProvider frontendTooltipProvider, int n, int n2) {
        try {
            if (n == frontendTooltipProvider.getCurrentTimestamp() && !(tooltipModel instanceof NotCalculatedTooltipModel)) {
                this.updateData(tooltipModel);
            } else {
                if (n2 <= 0) {
                    this.updateData(tooltipModel);
                    return;
                }
                this.updateData(tooltipModel);
                frontendTooltipProvider.requestTooltip(this.modelId, (Function1<? super TooltipModel, Unit>)((Function1)new Function1<TooltipModel, Unit>(this, tooltipModel, frontendTooltipProvider, n2){
                    final /* synthetic */ FrontendTooltipCalculator this$0;
                    final /* synthetic */ TooltipModel $model;
                    final /* synthetic */ FrontendTooltipProvider $provider;
                    final /* synthetic */ int $retry;
                    {
                        this.this$0 = $receiver;
                        this.$model = $model;
                        this.$provider = $provider;
                        this.$retry = $retry;
                        super(1);
                    }

                    public final void invoke(@NotNull TooltipModel it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        FrontendTooltipCalculator.access$applyUpdateWithRetry(this.this$0, this.$model, this.$provider, this.$provider.getCurrentTimestamp(), this.$retry - 1);
                    }
                }));
                this.tooltipTimestamp = -1;
            }
        }
        finally {
            this.requested.set(false);
        }
    }

    public static final /* synthetic */ void access$applyUpdateWithRetry(FrontendTooltipCalculator $this, TooltipModel model2, FrontendTooltipProvider provider2, int currentTimestamp, int retry) {
        $this.j(model2, provider2, currentTimestamp, retry);
    }

    public static final /* synthetic */ FrontendTooltipProvider access$getProvider$p(FrontendTooltipCalculator $this) {
        return $this.provider;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/jetbrains/rdclient/daemon/highlighters/tooltips/FrontendTooltipCalculator$Companion;", "", "()V", "CALCULATION_RETRY_LIMIT", "", "intellij.rd.client"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

