/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdclient.daemon.highlighters.tooltips;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.event.EditorMouseEvent;
import com.intellij.openapi.editor.event.EditorMouseEventArea;
import com.intellij.openapi.editor.event.EditorMouseMotionListener;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.impl.DocumentMarkupModel;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.registry.Registry;
import com.jetbrains.rdclient.daemon.highlighters.tooltips.FrontendLazyTooltipHighlightInfoRequester;
import com.jetbrains.rdclient.document.DocumentExKt;
import java.awt.Point;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0006H\u0016J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0004H\u0002J\u0014\u0010\u000f\u001a\u00020\b*\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u000bH\u0002\u00a8\u0006\u0012"}, d2={"Lcom/jetbrains/rdclient/daemon/highlighters/tooltips/FrontendLazyTooltipHighlightInfoRequester;", "Lcom/intellij/openapi/editor/event/EditorMouseMotionListener;", "()V", "j", "", "event", "Lcom/intellij/openapi/editor/event/EditorMouseEvent;", "mouseMoved", "", "e", "j", "Lcom/intellij/openapi/util/TextRange;", "editor", "Lcom/intellij/openapi/editor/Editor;", "offset", "j", "Lcom/intellij/openapi/editor/ex/MarkupModelEx;", "range", "intellij.rd.client"})
public final class FrontendLazyTooltipHighlightInfoRequester
implements EditorMouseMotionListener {
    public void mouseMoved(@NotNull EditorMouseEvent e) {
        block4: {
            MarkupModelEx markupModelEx;
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            if (Registry.is((String)"ide.disable.editor.tooltips")) {
                return;
            }
            int n = this.j(e);
            if (n == -1) {
                return;
            }
            Editor editor2 = e.getEditor();
            Intrinsics.checkNotNullExpressionValue((Object)editor2, (String)"getEditor(...)");
            if (DocumentExKt.getTextControlId(editor2) == null) {
                return;
            }
            Document document = e.getEditor().getDocument();
            Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
            Document document2 = document;
            MarkupModel markupModel = DocumentMarkupModel.forDocument((Document)document2, (Project)e.getEditor().getProject(), (boolean)false);
            MarkupModelEx markupModelEx2 = markupModelEx = markupModel instanceof MarkupModelEx ? (MarkupModelEx)markupModel : null;
            if (markupModelEx2 != null) {
                this.j(markupModelEx2, new TextRange(n, n));
            }
            Editor editor3 = e.getEditor();
            Intrinsics.checkNotNullExpressionValue((Object)editor3, (String)"getEditor(...)");
            markupModel = this.j(editor3, n);
            MarkupModelEx markupModelEx3 = markupModelEx;
            if (markupModelEx3 == null) break block4;
            this.j(markupModelEx3, (TextRange)markupModel);
        }
    }

    private final void j(MarkupModelEx markupModelEx, TextRange textRange) {
        markupModelEx.processRangeHighlightersOverlappingWith(textRange.getStartOffset(), textRange.getEndOffset(), arg_0 -> FrontendLazyTooltipHighlightInfoRequester.j(startTooltipPrecalculation.1.INSTANCE, arg_0));
    }

    private final TextRange j(Editor editor2, int n) {
        LogicalPosition logicalPosition = editor2.offsetToLogicalPosition(n);
        Intrinsics.checkNotNullExpressionValue((Object)logicalPosition, (String)"offsetToLogicalPosition(...)");
        LogicalPosition logicalPosition2 = logicalPosition;
        int n2 = Math.max(logicalPosition2.line - 1, 0);
        int n3 = logicalPosition2.line + 2;
        LogicalPosition logicalPosition3 = new LogicalPosition(n2, 0);
        LogicalPosition logicalPosition4 = new LogicalPosition(n3, 0);
        int n4 = editor2.logicalPositionToOffset(logicalPosition3);
        int n5 = editor2.logicalPositionToOffset(logicalPosition4);
        return new TextRange(n4, n5);
    }

    private final int j(EditorMouseEvent editorMouseEvent) {
        Editor editor2 = editorMouseEvent.getEditor();
        Intrinsics.checkNotNullExpressionValue((Object)editor2, (String)"getEditor(...)");
        Editor editor3 = editor2;
        Point point = editorMouseEvent.getMouseEvent().getPoint();
        if (editor3 instanceof EditorEx && editor3.getProject() != null && editorMouseEvent.getArea() == EditorMouseEventArea.EDITING_AREA && editorMouseEvent.getMouseEvent().getModifiers() == 0 && EditorUtil.isPointOverText((Editor)editor3, (Point)point) && ((EditorEx)editor3).getFoldingModel().getFoldingPlaceholderAt(point) == null) {
            LogicalPosition logicalPosition = editor3.xyToLogicalPosition(point);
            Intrinsics.checkNotNullExpressionValue((Object)logicalPosition, (String)"xyToLogicalPosition(...)");
            LogicalPosition logicalPosition2 = logicalPosition;
            return editor3.logicalPositionToOffset(logicalPosition2);
        }
        return -1;
    }

    private static final boolean j(Function1 function1, Object object) {
        Intrinsics.checkNotNullParameter((Object)function1, (String)"$tmp0");
        return (Boolean)function1.invoke(object);
    }
}

