/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdclient.daemon.highlighters.renderedDocs;

import com.intellij.codeInsight.documentation.render.DocRenderItem;
import com.intellij.codeInsight.documentation.render.DocRenderItemManager;
import com.intellij.codeInsight.documentation.render.DocRenderItemUpdater;
import com.intellij.codeInsight.documentation.render.DocRenderLinkActivationHandler;
import com.intellij.codeInsight.documentation.render.DocRenderPassFactory;
import com.intellij.codeInsight.documentation.render.DocRenderer;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.CustomFoldRegion;
import com.intellij.openapi.editor.CustomFoldRegionRenderer;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.util.Key;
import com.jetbrains.rd.ide.editor.markup.ExtendedBackendProperties;
import com.jetbrains.rd.ide.editor.markup.UtilKt;
import com.jetbrains.rd.ide.model.TextUpdateModel;
import com.jetbrains.rdclient.daemon.highlighters.renderedDocs.DocRenderInfo;
import com.jetbrains.rdclient.daemon.highlighters.renderedDocs.FrontendDocRenderHighlighterModelHandler;
import com.jetbrains.rdclient.daemon.highlighters.renderedDocs.FrontendDocRenderItem;
import com.jetbrains.rdclient.daemon.highlighters.renderedDocs.FrontendDocRenderLinkActivationHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 )2\u00020\u0001:\u0001)B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u001c\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\n0\u000eJ\u0018\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u0012J\u0016\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J!\u0010\u0016\u001a\u0013\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00100\u0017\u00a2\u0006\u0002\b\u00182\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0010\u0010\u001d\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u001c\u0010\u001e\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00120\u000eJ\u0010\u0010 \u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J \u0010!\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u001aH\u0016J$\u0010%\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010&\u001a\b\u0012\u0004\u0012\u00020'0\u000e2\u0006\u0010(\u001a\u00020\u001a\u00a8\u0006*"}, d2={"Lcom/jetbrains/rdclient/daemon/highlighters/renderedDocs/FrontendDocRenderItemManager;", "Lcom/intellij/codeInsight/documentation/render/DocRenderItemManager;", "()V", "addFolding", "Lcom/intellij/openapi/editor/CustomFoldRegion;", "editor", "Lcom/intellij/openapi/editor/Editor;", "info", "Lcom/jetbrains/rdclient/daemon/highlighters/renderedDocs/DocRenderInfo;", "h", "Lcom/intellij/openapi/editor/ex/RangeHighlighterEx;", "addItems", "", "highlighters", "", "getItem", "Lcom/jetbrains/rdclient/daemon/highlighters/renderedDocs/FrontendDocRenderItem;", "id", "", "getItems", "", "Lcom/intellij/codeInsight/documentation/render/DocRenderItem;", "j", "", "Lorg/jetbrains/annotations/Nullable;", "isRenderedDocHighlighter", "", "highlighter", "Lcom/intellij/openapi/editor/markup/RangeHighlighter;", "removeAllItems", "removeItems", "ids", "resetToDefaultState", "setItemsToEditor", "itemsToSet", "Lcom/intellij/codeInsight/documentation/render/DocRenderPassFactory$Items;", "collapseNewItems", "updateItems", "updates", "Lcom/jetbrains/rd/ide/model/TextUpdateModel;", "recreate", "Companion", "intellij.rd.client"})
@SourceDebugExtension(value={"SMAP\nFrontendDocRenderItemManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FrontendDocRenderItemManager.kt\ncom/jetbrains/rdclient/daemon/highlighters/renderedDocs/FrontendDocRenderItemManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,125:1\n1603#2,9:126\n1855#2:135\n1856#2:137\n1612#2:138\n1#3:136\n13#4:139\n*S KotlinDebug\n*F\n+ 1 FrontendDocRenderItemManager.kt\ncom/jetbrains/rdclient/daemon/highlighters/renderedDocs/FrontendDocRenderItemManager\n*L\n80#1:126,9\n80#1:135\n80#1:137\n80#1:138\n80#1:136\n99#1:139\n*E\n"})
public final class FrontendDocRenderItemManager
implements DocRenderItemManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Key<Map<Long, FrontendDocRenderItem>> OUR_ITEMS;
    @NotNull
    private static final Logger logger;

    public void removeAllItems(@NotNull Editor editor2) {
        Unit unit;
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Map map = (Map)editor2.getUserData(OUR_ITEMS);
        if (map != null) {
            map.clear();
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        if (unit == null) {
            return;
        }
        this.setupListeners(editor2, true);
        editor2.putUserData(OUR_ITEMS, null);
    }

    public void setItemsToEditor(@NotNull Editor editor2, @NotNull DocRenderPassFactory.Items itemsToSet, boolean collapseNewItems) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)itemsToSet, (String)"itemsToSet");
    }

    public void resetToDefaultState(@NotNull Editor editor2) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
    }

    @NotNull
    public Collection<DocRenderItem> getItems(@NotNull Editor editor2) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Object object = (Map)editor2.getUserData(OUR_ITEMS);
        if (object == null || (object = object.values()) == null) {
            object = CollectionsKt.emptyList();
        }
        return object;
    }

    public boolean isRenderedDocHighlighter(@NotNull RangeHighlighter highlighter2) {
        Intrinsics.checkNotNullParameter((Object)highlighter2, (String)"highlighter");
        ExtendedBackendProperties extendedBackendProperties = UtilKt.getExtendedBackendProperties(highlighter2);
        return (extendedBackendProperties != null ? extendedBackendProperties.getHandler() : null) instanceof FrontendDocRenderHighlighterModelHandler;
    }

    @Nullable
    public final CustomFoldRegion addFolding(@NotNull Editor editor2, @NotNull DocRenderInfo info2, @NotNull RangeHighlighterEx h) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)info2, (String)"info");
        Intrinsics.checkNotNullParameter((Object)h, (String)"h");
        long l = info2.getId();
        FrontendDocRenderItem frontendDocRenderItem = this.j(editor2).get(l);
        if (frontendDocRenderItem == null) {
            logger.error("no item on folding creation in " + editor2);
            return null;
        }
        frontendDocRenderItem.setTextToRender(info2.getTextToRender());
        frontendDocRenderItem.setRenderer(info2.getGutterRenderer());
        DocRenderer docRenderer = new DocRenderer((DocRenderItem)frontendDocRenderItem, (DocRenderLinkActivationHandler)FrontendDocRenderLinkActivationHandler.INSTANCE);
        CustomFoldRegion customFoldRegion = editor2.getFoldingModel().addCustomLinesFolding(editor2.getDocument().getLineNumber(h.getStartOffset()), editor2.getDocument().getLineNumber(h.getEndOffset()), (CustomFoldRegionRenderer)docRenderer);
        frontendDocRenderItem.setFoldRegion(customFoldRegion);
        frontendDocRenderItem.setRegionBackendId(UtilKt.getBackendId((RangeHighlighter)h));
        return customFoldRegion;
    }

    public final void addItems(@NotNull Editor editor2, @NotNull List<? extends RangeHighlighterEx> highlighters) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter(highlighters, (String)"highlighters");
        if (highlighters.isEmpty()) {
            return;
        }
        Map<Long, FrontendDocRenderItem> map = this.j(editor2);
        for (RangeHighlighterEx rangeHighlighterEx : highlighters) {
            Long l = UtilKt.getBackendId((RangeHighlighter)rangeHighlighterEx);
            Intrinsics.checkNotNull((Object)l);
            map.put(l, new FrontendDocRenderItem((RangeHighlighter)rangeHighlighterEx, editor2));
        }
    }

    public final void removeItems(@NotNull Editor editor2, @NotNull List<Long> ids) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter(ids, (String)"ids");
        if (ids.isEmpty()) {
            return;
        }
        Map<Long, FrontendDocRenderItem> map = this.j(editor2);
        Iterator<Long> iterator2 = ids.iterator();
        while (iterator2.hasNext()) {
            long l = ((Number)iterator2.next()).longValue();
            map.remove(l);
        }
        if (map.isEmpty()) {
            this.removeAllItems(editor2);
        }
    }

    public final void updateItems(@NotNull Editor editor2, @NotNull List<TextUpdateModel> updates, boolean recreate) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter(updates, (String)"updates");
        if (updates.isEmpty()) {
            return;
        }
        Map<Long, FrontendDocRenderItem> map = this.j(editor2);
        Iterable iterable = updates;
        boolean bl = false;
        Iterable iterable2 = iterable;
        Collection collection = new ArrayList();
        boolean bl2 = false;
        Iterable iterable3 = iterable2;
        boolean bl3 = false;
        Iterator iterator2 = iterable3.iterator();
        while (iterator2.hasNext()) {
            FrontendDocRenderItem frontendDocRenderItem;
            FrontendDocRenderItem frontendDocRenderItem2;
            Object t;
            Object t2 = t = iterator2.next();
            boolean bl4 = false;
            TextUpdateModel textUpdateModel = (TextUpdateModel)t2;
            boolean bl5 = false;
            FrontendDocRenderItem frontendDocRenderItem3 = frontendDocRenderItem2 = map.get(textUpdateModel.getId());
            if (frontendDocRenderItem3 != null) {
                frontendDocRenderItem3.setTextToRender(textUpdateModel.getText());
            }
            if (frontendDocRenderItem2 == null) continue;
            boolean bl6 = false;
            collection.add(frontendDocRenderItem);
        }
        List list2 = (List)collection;
        DocRenderItemUpdater.updateRenderers((Collection)list2, (boolean)recreate);
    }

    @Nullable
    public final FrontendDocRenderItem getItem(@NotNull Editor editor2, long id) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        return this.j(editor2).get(id);
    }

    private final Map<Long, FrontendDocRenderItem> j(Editor editor2) {
        Map map = (Map)editor2.getUserData(OUR_ITEMS);
        if (map == null) {
            HashMap hashMap;
            HashMap hashMap2 = hashMap = new HashMap();
            boolean bl = false;
            this.setupListeners(editor2, false);
            editor2.putUserData(OUR_ITEMS, hashMap2);
            map = hashMap;
        }
        return map;
    }

    static {
        Key key = Key.create((String)"frontend.doc.render.items");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        OUR_ITEMS = key;
        boolean bl = false;
        Logger logger = Logger.getInstance(FrontendDocRenderItemManager.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        FrontendDocRenderItemManager.logger = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010%\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R9\u0010\u0003\u001a-\u0012$\u0012\"\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0007 \b*\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u00050\u00050\u0004\u00a2\u0006\u0002\b\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rdclient/daemon/highlighters/renderedDocs/FrontendDocRenderItemManager$Companion;", "", "()V", "OUR_ITEMS", "Lcom/intellij/openapi/util/Key;", "", "", "Lcom/jetbrains/rdclient/daemon/highlighters/renderedDocs/FrontendDocRenderItem;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "getLogger", "()Lcom/intellij/openapi/diagnostic/Logger;", "intellij.rd.client"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLogger() {
            return logger;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

