/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdclient.daemon.highlighters.inlays;

import com.intellij.ide.IdeEventQueue;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.FocusChangeListener;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.rd.LifetimeDisposableExKt;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import com.jetbrains.rd.platform.util.ApplicationKt;
import com.jetbrains.rd.platform.util.ComponentsKt;
import com.jetbrains.rd.util.AdditionalApiKt;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.RLifetimeKt;
import com.jetbrains.rd.util.reactive.ExecutionOrder;
import com.jetbrains.rd.util.reactive.IOptProperty;
import com.jetbrains.rd.util.reactive.IScheduler;
import com.jetbrains.rd.util.reactive.ISource;
import com.jetbrains.rd.util.reactive.Property;
import com.jetbrains.rdclient.daemon.highlighters.inlays.FrontendInlayModelAdapter;
import com.jetbrains.rdclient.daemon.highlighters.inlays.PushToHintController;
import com.jetbrains.rdclient.daemon.highlighters.inlays.PushToHintSettingsHost;
import com.jetbrains.rdclient.daemon.highlighters.inlays.PushToHintUsagesCollector;
import java.awt.AWTEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.time.Duration;
import javax.swing.SwingUtilities;
import kotlin.Function;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.FunctionAdapter;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/jetbrains/rdclient/daemon/highlighters/inlays/PushToHintController;", "", "editorLifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "editor", "Lcom/intellij/openapi/editor/impl/EditorImpl;", "inlayModelAdapter", "Lcom/jetbrains/rdclient/daemon/highlighters/inlays/FrontendInlayModelAdapter;", "(Lcom/jetbrains/rd/util/lifetime/Lifetime;Lcom/intellij/openapi/editor/impl/EditorImpl;Lcom/jetbrains/rdclient/daemon/highlighters/inlays/FrontendInlayModelAdapter;)V", "intellij.rd.client"})
public final class PushToHintController {
    @NotNull
    private final EditorImpl editor;

    public PushToHintController(@NotNull Lifetime editorLifetime, @NotNull EditorImpl editor2, final @NotNull FrontendInlayModelAdapter inlayModelAdapter) {
        Intrinsics.checkNotNullParameter((Object)editorLifetime, (String)"editorLifetime");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)inlayModelAdapter, (String)"inlayModelAdapter");
        this.editor = editor2;
        Property property = new Property((Object)false);
        Property property2 = new Property((Object)false);
        final Ref.BooleanRef booleanRef = new Ref.BooleanRef();
        final Project project = this.editor.getProject();
        if (project != null) {
            Lifetime lifetime = RLifetimeKt.intersect((Lifetime)ComponentsKt.getLifetime((UserDataHolder)project), (Lifetime)editorLifetime);
            PushToHintSettingsHost pushToHintSettingsHost = (PushToHintSettingsHost)project.getService(PushToHintSettingsHost.class);
            Ref.BooleanRef booleanRef2 = new Ref.BooleanRef();
            FocusChangeListener focusChangeListener = new FocusChangeListener(this, booleanRef2){
                final /* synthetic */ PushToHintController this$0;
                final /* synthetic */ Ref.BooleanRef $hasFocus;
                {
                    this.this$0 = $receiver;
                    this.$hasFocus = $hasFocus;
                }

                public void focusLost(@NotNull Editor e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    if (Intrinsics.areEqual((Object)e, (Object)PushToHintController.access$getEditor$p(this.this$0))) {
                        this.$hasFocus.element = false;
                    }
                }

                public void focusGained(@NotNull Editor e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    if (Intrinsics.areEqual((Object)e, (Object)PushToHintController.access$getEditor$p(this.this$0))) {
                        this.$hasFocus.element = true;
                    }
                }
            };
            Function1 function1 = (Function1)new Function1<AWTEvent, Boolean>(booleanRef2, pushToHintSettingsHost, (Property<Boolean>)property, booleanRef){
                final /* synthetic */ Ref.BooleanRef $hasFocus;
                final /* synthetic */ PushToHintSettingsHost $settingsHost;
                final /* synthetic */ Property<Boolean> $controlPressed;
                final /* synthetic */ Ref.BooleanRef $hintsShown;
                {
                    this.$hasFocus = $hasFocus;
                    this.$settingsHost = $settingsHost;
                    this.$controlPressed = $controlPressed;
                    this.$hintsShown = $hintsShown;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull AWTEvent event) {
                    Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                    if (!this.$hasFocus.element || !this.$settingsHost.isEnabled()) {
                        return false;
                    }
                    if (event instanceof KeyEvent) {
                        if (((KeyEvent)event).getKeyCode() == 17) {
                            this.$controlPressed.set((Object)((KeyEvent)event).isControlDown());
                        } else if (!this.$hintsShown.element) {
                            this.$controlPressed.set((Object)false);
                        }
                    }
                    if (event instanceof MouseEvent && ((MouseEvent)event).isControlDown() && !this.$hintsShown.element) {
                        this.$controlPressed.set((Object)false);
                        if (((MouseEvent)event).getButton() == 0 && !(event instanceof MouseWheelEvent)) {
                            this.$controlPressed.set((Object)true);
                        }
                    }
                    return false;
                }
            };
            IdeEventQueue.Companion.getInstance().addPostprocessor(new IdeEventQueue.EventDispatcher(function1){
                private final /* synthetic */ Function1 function;
                {
                    Intrinsics.checkNotNullParameter((Object)function, (String)"function");
                    this.function = function;
                }

                public final /* synthetic */ boolean dispatch(AWTEvent e) {
                    return (Boolean)this.function.invoke((Object)e);
                }

                @NotNull
                public final Function<?> getFunctionDelegate() {
                    return (Function)this.function;
                }

                public final boolean equals(@Nullable Object other) {
                    return other instanceof IdeEventQueue.EventDispatcher ? (other instanceof FunctionAdapter ? Intrinsics.areEqual(this.getFunctionDelegate(), (Object)((FunctionAdapter)other).getFunctionDelegate()) : false) : false;
                }

                public final int hashCode() {
                    return this.getFunctionDelegate().hashCode();
                }
            }, LifetimeDisposableExKt.createNestedDisposable$default((Lifetime)lifetime, null, (int)1, null));
            this.editor.addFocusListener(focusChangeListener);
            IScheduler iScheduler = new IScheduler(){

                public void flush() {
                    SwingUtilities.invokeAndWait(scheduler.1::j);
                }

                public void queue(@NotNull Function0<Unit> action3) {
                    Intrinsics.checkNotNullParameter(action3, (String)"action");
                    SwingUtilities.invokeLater(() -> scheduler.1.j(action3));
                }

                @NotNull
                public ExecutionOrder getExecutionOrder() {
                    return ExecutionOrder.Sequential;
                }

                public boolean isActive() {
                    return SwingUtilities.isEventDispatchThread();
                }

                public void assertThread(@Nullable Object debugInfo) {
                    IScheduler.DefaultImpls.assertThread((IScheduler)this, (Object)debugInfo);
                }

                public void invokeOrQueue(@NotNull Function0<Unit> action3) {
                    IScheduler.DefaultImpls.invokeOrQueue((IScheduler)this, action3);
                }

                private static final void j() {
                }

                private static final void j(Function0 function0) {
                    Intrinsics.checkNotNullParameter((Object)function0, (String)"$action");
                    function0.invoke();
                }
            };
            Function2 function2 = createQueue.1.INSTANCE;
            Ref.ObjectRef objectRef = new Ref.ObjectRef();
            IOptProperty<Integer> iOptProperty = pushToHintSettingsHost.getTapDuration();
            if (iOptProperty != null) {
                iOptProperty.view(lifetime, (Function2)new Function2<Lifetime, Integer, Unit>((Ref.ObjectRef<MergingUpdateQueue>)objectRef, (Function2<? super Lifetime, ? super Integer, ? extends MergingUpdateQueue>)function2){
                    final /* synthetic */ Ref.ObjectRef<MergingUpdateQueue> $activationDebounceQueue;
                    final /* synthetic */ Function2<Lifetime, Integer, MergingUpdateQueue> $createQueue;
                    {
                        this.$activationDebounceQueue = $activationDebounceQueue;
                        this.$createQueue = $createQueue;
                        super(2);
                    }

                    public final void invoke(@NotNull Lifetime lt, int tapDuration) {
                        Intrinsics.checkNotNullParameter((Object)lt, (String)"lt");
                        this.$activationDebounceQueue.element = this.$createQueue.invoke((Object)lt, (Object)tapDuration);
                    }
                });
            }
            property.view(lifetime, (Function2)new Function2<Lifetime, Boolean, Unit>((Ref.ObjectRef<MergingUpdateQueue>)objectRef, (Property<Boolean>)property2){
                final /* synthetic */ Ref.ObjectRef<MergingUpdateQueue> $activationDebounceQueue;
                final /* synthetic */ Property<Boolean> $pushToHintActive;
                {
                    this.$activationDebounceQueue = $activationDebounceQueue;
                    this.$pushToHintActive = $pushToHintActive;
                    super(2);
                }

                public final void invoke(final @NotNull Lifetime lt, boolean value2) {
                    Intrinsics.checkNotNullParameter((Object)lt, (String)"lt");
                    if (!value2) {
                        return;
                    }
                    if (!booleanRef.element) {
                        MergingUpdateQueue mergingUpdateQueue = (MergingUpdateQueue)this.$activationDebounceQueue.element;
                        if (mergingUpdateQueue != null) {
                            mergingUpdateQueue.queue(new Update(){

                                public void run() {
                                    Application application = ApplicationKt.getApplicationOrNull();
                                    if (application != null) {
                                        application.assertIsDispatchThread();
                                    }
                                    $pushToHintActive.set((Object)true);
                                }

                                public boolean isDisposed() {
                                    return RLifetimeKt.isNotAlive((Lifetime)lt);
                                }
                            });
                        }
                    }
                    lt.onTermination((Function0)new Function0<Unit>(){

                        public final void invoke() {
                            $pushToHintActive.set((Object)false);
                        }
                    });
                }
            });
            ISource iSource = (ISource)property2;
            Duration duration = Duration.ofMillis(50L);
            Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofMillis(...)");
            AdditionalApiKt.throttleLast((ISource)iSource, (Duration)duration, (IScheduler)iScheduler).advise(lifetime, (Function1)new Function1<Boolean, Unit>(){

                public final void invoke(boolean it) {
                    PushToHintUsagesCollector.INSTANCE.logStateChange(project, it);
                    boolean bl = it;
                    if (bl) {
                        inlayModelAdapter.showPushToShowHints();
                    } else if (!bl) {
                        inlayModelAdapter.hidePushToShowHints();
                    }
                    booleanRef.element = it;
                }
            });
        }
    }

    public static final /* synthetic */ EditorImpl access$getEditor$p(PushToHintController $this) {
        return $this.editor;
    }
}

