/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdclient.daemon.highlighters.inlays;

import com.intellij.codeInsight.hints.HorizontalConstrainedPresentation;
import com.intellij.codeInsight.hints.HorizontalConstraints;
import com.intellij.codeInsight.hints.InlayContentListener;
import com.intellij.codeInsight.hints.InlayPresentationFactory;
import com.intellij.codeInsight.hints.InlineInlayRenderer;
import com.intellij.codeInsight.hints.LinearOrderInlayRenderer;
import com.intellij.codeInsight.hints.presentation.InlayPresentation;
import com.intellij.codeInsight.hints.presentation.InlayTextMetricsStorage;
import com.intellij.codeInsight.hints.presentation.PresentationFactory;
import com.intellij.codeInsight.hints.presentation.PresentationListener;
import com.intellij.codeInsight.hints.presentation.RecursivelyUpdatingRootPresentation;
import com.intellij.codeInsight.hints.presentation.RootInlayPresentation;
import com.intellij.codeInsight.hints.presentation.ScaleAwarePresentationFactory;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorCustomElementRenderer;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.impl.RangeMarkerImpl;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.project.Project;
import com.jetbrains.rd.ide.model.ConstrainedInlayHighlighterModel;
import com.jetbrains.rd.ide.model.HighlighterModel;
import com.jetbrains.rd.ide.model.HorizontalConstraintsModel;
import com.jetbrains.rd.ide.model.InlayConstraintsModel;
import com.jetbrains.rd.ide.model.InlayWithPresentationEventsModel;
import com.jetbrains.rd.ide.model.RootPresentationModel;
import com.jetbrains.rdclient.daemon.IProtocolHighlighterModelHandler;
import com.jetbrains.rdclient.daemon.highlighters.inlays.FrontendInlayWithPresentationModelSupportKt;
import com.jetbrains.rdclient.daemon.util.HighlighterModelAgnosticComparator;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0018\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J \u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/jetbrains/rdclient/daemon/highlighters/inlays/FrontendInlayWithPresentationModelHandler;", "Lcom/jetbrains/rdclient/daemon/IProtocolHighlighterModelHandler;", "editor", "Lcom/intellij/openapi/editor/impl/EditorImpl;", "project", "Lcom/intellij/openapi/project/Project;", "inlayEventsModel", "Lcom/jetbrains/rd/ide/model/InlayWithPresentationEventsModel;", "(Lcom/intellij/openapi/editor/impl/EditorImpl;Lcom/intellij/openapi/project/Project;Lcom/jetbrains/rd/ide/model/InlayWithPresentationEventsModel;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "textMetricsStorage", "Lcom/intellij/codeInsight/hints/presentation/InlayTextMetricsStorage;", "accept", "", "model", "Lcom/jetbrains/rd/ide/model/HighlighterModel;", "compare", "highlighter", "Lcom/intellij/openapi/editor/markup/RangeHighlighter;", "initialize", "", "move", "startOffset", "", "endOffset", "intellij.rd.client"})
public final class FrontendInlayWithPresentationModelHandler
implements IProtocolHighlighterModelHandler {
    @NotNull
    private final EditorImpl editor;
    @Nullable
    private final Project project;
    @NotNull
    private final InlayWithPresentationEventsModel inlayEventsModel;
    @NotNull
    private final InlayTextMetricsStorage textMetricsStorage;

    public FrontendInlayWithPresentationModelHandler(@NotNull EditorImpl editor2, @Nullable Project project, @NotNull InlayWithPresentationEventsModel inlayEventsModel) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)((Object)inlayEventsModel), (String)"inlayEventsModel");
        this.editor = editor2;
        this.project = project;
        this.inlayEventsModel = inlayEventsModel;
        this.textMetricsStorage = new InlayTextMetricsStorage((Editor)this.editor);
    }

    @Nullable
    public final Project getProject() {
        return this.project;
    }

    @Override
    public boolean accept(@NotNull HighlighterModel model2) {
        Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
        return model2 instanceof ConstrainedInlayHighlighterModel;
    }

    @Override
    public void initialize(@NotNull HighlighterModel model2, @NotNull RangeHighlighter highlighter2) {
        block5: {
            Inlay inlay;
            Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
            Intrinsics.checkNotNullParameter((Object)highlighter2, (String)"highlighter");
            ConstrainedInlayHighlighterModel cfr_ignored_0 = (ConstrainedInlayHighlighterModel)model2;
            InlayConstraintsModel inlayConstraintsModel = ((ConstrainedInlayHighlighterModel)model2).getConstraints();
            Intrinsics.checkNotNull((Object)inlayConstraintsModel, (String)"null cannot be cast to non-null type com.jetbrains.rd.ide.model.HorizontalConstraintsModel");
            boolean bl = ((HorizontalConstraintsModel)inlayConstraintsModel).getRelatesToPrecedingText();
            ((RangeMarkerImpl)highlighter2).setStickingToRight(bl);
            PresentationFactory presentationFactory = new PresentationFactory((Editor)this.editor);
            ScaleAwarePresentationFactory scaleAwarePresentationFactory = new ScaleAwarePresentationFactory((Editor)this.editor, presentationFactory);
            RootPresentationModel rootPresentationModel = ((ConstrainedInlayHighlighterModel)model2).getPresentation();
            InlayPresentation inlayPresentation = FrontendInlayWithPresentationModelSupportKt.access$toPresentation(rootPresentationModel.getPresentation(), this.textMetricsStorage, model2.getId(), this.inlayEventsModel, scaleAwarePresentationFactory);
            if (inlayPresentation == null) {
                return;
            }
            InlayPresentation inlayPresentation2 = inlayPresentation;
            RecursivelyUpdatingRootPresentation recursivelyUpdatingRootPresentation = new RecursivelyUpdatingRootPresentation(inlayPresentation2);
            if (FrontendInlayWithPresentationModelSupportKt.getInlay(highlighter2) != null) {
                Inlay<?> inlay2 = FrontendInlayWithPresentationModelSupportKt.getInlay(highlighter2);
                EditorCustomElementRenderer editorCustomElementRenderer = inlay2 != null ? inlay2.getRenderer() : null;
                LinearOrderInlayRenderer linearOrderInlayRenderer = editorCustomElementRenderer instanceof LinearOrderInlayRenderer ? (LinearOrderInlayRenderer)editorCustomElementRenderer : null;
                InlayPresentation inlayPresentation3 = linearOrderInlayRenderer != null ? linearOrderInlayRenderer.getCachedPresentation() : null;
                RecursivelyUpdatingRootPresentation cfr_ignored_1 = (RecursivelyUpdatingRootPresentation)inlayPresentation3;
                RecursivelyUpdatingRootPresentation recursivelyUpdatingRootPresentation2 = (RecursivelyUpdatingRootPresentation)inlayPresentation3;
                if (recursivelyUpdatingRootPresentation2 != null) {
                    recursivelyUpdatingRootPresentation2.update(recursivelyUpdatingRootPresentation.getContent(), (Editor)this.editor, (InlayPresentationFactory)presentationFactory);
                }
                return;
            }
            InlayConstraintsModel inlayConstraintsModel2 = ((ConstrainedInlayHighlighterModel)model2).getConstraints();
            HorizontalConstraints horizontalConstraints = inlayConstraintsModel2 != null ? FrontendInlayWithPresentationModelSupportKt.access$fromModel(inlayConstraintsModel2) : null;
            HorizontalConstrainedPresentation horizontalConstrainedPresentation = new HorizontalConstrainedPresentation((RootInlayPresentation)recursivelyUpdatingRootPresentation, horizontalConstraints);
            InlineInlayRenderer inlineInlayRenderer = new InlineInlayRenderer((Collection)CollectionsKt.listOf((Object)horizontalConstrainedPresentation));
            HorizontalConstraints horizontalConstraints2 = horizontalConstraints;
            boolean bl2 = horizontalConstraints2 != null ? horizontalConstraints2.getPlacedAtTheEndOfLine() : false;
            if (bl2) {
                inlay = this.editor.getInlayModel().addAfterLineEndElement(model2.getStart(), horizontalConstraints.getRelatesToPrecedingText(), (EditorCustomElementRenderer)inlineInlayRenderer);
            } else {
                HorizontalConstraints horizontalConstraints3 = horizontalConstraints;
                HorizontalConstraints horizontalConstraints4 = horizontalConstraints;
                inlay = this.editor.getInlayModel().addInlineElement(model2.getStart(), horizontalConstraints3 != null ? horizontalConstraints3.getRelatesToPrecedingText() : false, horizontalConstraints4 != null ? horizontalConstraints4.getPriority() : 0, (EditorCustomElementRenderer)inlineInlayRenderer);
            }
            Inlay inlay3 = inlay;
            FrontendInlayWithPresentationModelSupportKt.setInlay(highlighter2, inlay3);
            Inlay inlay4 = inlay3;
            if (inlay4 == null || (inlay4 = (InlineInlayRenderer)inlay4.getRenderer()) == null) break block5;
            inlay4.setListener((PresentationListener)new InlayContentListener(inlay3));
        }
    }

    @Override
    public boolean compare(@NotNull HighlighterModel model2, @NotNull RangeHighlighter highlighter2) {
        Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
        Intrinsics.checkNotNullParameter((Object)highlighter2, (String)"highlighter");
        Inlay<?> inlay = FrontendInlayWithPresentationModelSupportKt.getInlay(highlighter2);
        if (inlay == null) {
            return false;
        }
        Inlay<?> inlay2 = inlay;
        if (!(inlay2.getRenderer() instanceof InlineInlayRenderer)) {
            return false;
        }
        return HighlighterModelAgnosticComparator.INSTANCE.compare(model2, highlighter2);
    }

    @Override
    @NotNull
    public HighlighterModel move(int startOffset, int endOffset, @NotNull HighlighterModel model2) {
        Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
        return FrontendInlayWithPresentationModelSupportKt.move((ConstrainedInlayHighlighterModel)model2, startOffset, endOffset);
    }
}

