/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdclient.daemon.highlighters.inlays;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorCustomElementRenderer;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.rd.LifetimeDisposableExKt;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rdclient.daemon.FrontendMarkupContributor;
import com.jetbrains.rdclient.daemon.components.FrontendMarkupHost;
import com.jetbrains.rdclient.daemon.highlighters.inlays.FrontendHintInlayModelSupportKt;
import com.jetbrains.rdclient.daemon.highlighters.inlays.FrontendInlayModelAdapter;
import com.jetbrains.rdclient.daemon.highlighters.inlays.FrontendInlineInlayRenderer;
import com.jetbrains.rdclient.daemon.highlighters.inlays.InlayInfo;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0016\u0010\u0010\u001a\u0004\u0018\u00010\u00112\n\u0010\u0012\u001a\u0006\u0012\u0002\b\u00030\u0013H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/jetbrains/rdclient/daemon/highlighters/inlays/FrontendInlayDocumentWatcher;", "Lcom/intellij/openapi/editor/event/DocumentListener;", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "frontendInlayModelAdapter", "Lcom/jetbrains/rdclient/daemon/highlighters/inlays/FrontendInlayModelAdapter;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/editor/Editor;Lcom/jetbrains/rdclient/daemon/highlighters/inlays/FrontendInlayModelAdapter;)V", "attach", "", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "documentChanged", "event", "Lcom/intellij/openapi/editor/event/DocumentEvent;", "j", "Lcom/jetbrains/rdclient/daemon/highlighters/inlays/InlayInfo;", "inlay", "Lcom/intellij/openapi/editor/Inlay;", "intellij.rd.client"})
public final class FrontendInlayDocumentWatcher
implements DocumentListener {
    @Nullable
    private final Project project;
    @NotNull
    private final Editor editor;
    @NotNull
    private final FrontendInlayModelAdapter frontendInlayModelAdapter;

    public FrontendInlayDocumentWatcher(@Nullable Project project, @NotNull Editor editor2, @NotNull FrontendInlayModelAdapter frontendInlayModelAdapter) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)frontendInlayModelAdapter, (String)"frontendInlayModelAdapter");
        this.project = project;
        this.editor = editor2;
        this.frontendInlayModelAdapter = frontendInlayModelAdapter;
    }

    public final void attach(@NotNull Lifetime lifetime) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        this.editor.getDocument().addDocumentListener((DocumentListener)this, LifetimeDisposableExKt.createNestedDisposable$default((Lifetime)lifetime, null, (int)1, null));
    }

    public void documentChanged(@NotNull DocumentEvent event) {
        InlayInfo inlayInfo;
        block11: {
            block10: {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                if (event.getDocument().isInBulkUpdate()) {
                    return;
                }
                CharSequence charSequence = event.getNewFragment();
                Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"getNewFragment(...)");
                if (charSequence.length() == 0) break block10;
                CharSequence charSequence2 = event.getNewFragment();
                Intrinsics.checkNotNullExpressionValue((Object)charSequence2, (String)"getNewFragment(...)");
                if (StringsKt.isBlank((CharSequence)charSequence2)) break block11;
            }
            return;
        }
        int n = event.getOffset();
        int n2 = event.getOffset() + event.getNewFragment().length();
        VisualPosition visualPosition = this.editor.offsetToVisualPosition(event.getOffset());
        Intrinsics.checkNotNullExpressionValue((Object)visualPosition, (String)"offsetToVisualPosition(...)");
        VisualPosition visualPosition2 = visualPosition;
        Inlay inlay = this.editor.getInlayModel().getInlineElementAt(visualPosition2);
        if (inlay != null) {
            InlayInfo inlayInfo2 = this.j(inlay);
            if (inlayInfo2 == null) {
                return;
            }
            inlayInfo = inlayInfo2;
            if (!inlayInfo.getRelatesToPrecedingText()) {
                this.frontendInlayModelAdapter.moveInlay(inlay, inlayInfo, n2);
            }
        }
        VisualPosition visualPosition3 = EditorUtil.inlayAwareOffsetToVisualPosition((Editor)this.editor, (int)n2);
        Intrinsics.checkNotNullExpressionValue((Object)visualPosition3, (String)"inlayAwareOffsetToVisualPosition(...)");
        inlayInfo = visualPosition3;
        Inlay inlay2 = this.editor.getInlayModel().getInlineElementAt((VisualPosition)inlayInfo);
        if (inlay2 != null) {
            InlayInfo inlayInfo3 = this.j(inlay2);
            if (inlayInfo3 == null) {
                return;
            }
            InlayInfo inlayInfo4 = inlayInfo3;
            if (inlayInfo4.getRelatesToPrecedingText()) {
                this.frontendInlayModelAdapter.moveInlay(inlay2, inlayInfo4, n);
            }
        }
    }

    private final InlayInfo j(Inlay<?> inlay) {
        EditorCustomElementRenderer editorCustomElementRenderer = inlay.getRenderer();
        FrontendInlineInlayRenderer frontendInlineInlayRenderer = editorCustomElementRenderer instanceof FrontendInlineInlayRenderer ? (FrontendInlineInlayRenderer)editorCustomElementRenderer : null;
        if (frontendInlineInlayRenderer == null) {
            return null;
        }
        FrontendInlineInlayRenderer frontendInlineInlayRenderer2 = frontendInlineInlayRenderer;
        Document document = this.editor.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        FrontendMarkupContributor frontendMarkupContributor = FrontendMarkupHost.Companion.getMarkupContributor(this.project, document);
        if (frontendMarkupContributor == null) {
            return null;
        }
        FrontendMarkupContributor frontendMarkupContributor2 = frontendMarkupContributor;
        RangeHighlighterEx rangeHighlighterEx = frontendMarkupContributor2.getStorage().getAll().get(frontendInlineInlayRenderer2.getId());
        return rangeHighlighterEx != null ? FrontendHintInlayModelSupportKt.getInlayInfo((RangeHighlighter)rangeHighlighterEx) : null;
    }
}

