/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdclient.daemon.highlighters.inlays;

import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.event.EditorMouseEvent;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.ui.SimpleColoredText;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.xdebugger.impl.inline.InlineDebugRendererBase;
import com.jetbrains.rd.ide.editor.markup.UtilKt;
import com.jetbrains.rd.ide.model.DebugClickArea;
import com.jetbrains.rd.ide.model.DebugMouseClickedEventModel;
import com.jetbrains.rd.ide.model.InlayMouseEvent;
import com.jetbrains.rd.ide.model.InlineDebugRendererModel;
import com.jetbrains.rd.ide.model.RichStringModel;
import com.jetbrains.rdclient.daemon.highlighters.inlays.FrontendMouseAwareInlayRenderer;
import com.jetbrains.rdclient.util.idea.ui.ModelRichTextExKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\u000e\u001a\u00020\u000fH\u0014J\b\u0010\u0010\u001a\u00020\rH\u0016J\b\u0010\u0011\u001a\u00020\u000fH\u0016J\b\u0010\u0012\u001a\u00020\u000fH\u0016J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u001e\u0010\u0017\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u00162\n\u0010\u0018\u001a\u0006\u0012\u0002\b\u00030\u0019H\u0016J\u0012\u0010\u001a\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u000e\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0003\u001a\u00020\u0004R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/jetbrains/rdclient/daemon/highlighters/inlays/FrontendDebugRenderer;", "Lcom/jetbrains/rdclient/daemon/highlighters/inlays/FrontendMouseAwareInlayRenderer;", "Lcom/intellij/xdebugger/impl/inline/InlineDebugRendererBase;", "model", "Lcom/jetbrains/rd/ide/model/InlineDebugRendererModel;", "highlighter", "Lcom/intellij/openapi/editor/markup/RangeHighlighter;", "(Lcom/jetbrains/rd/ide/model/InlineDebugRendererModel;Lcom/intellij/openapi/editor/markup/RangeHighlighter;)V", "getModel", "()Lcom/jetbrains/rd/ide/model/InlineDebugRendererModel;", "setModel", "(Lcom/jetbrains/rd/ide/model/InlineDebugRendererModel;)V", "myPresentation", "Lcom/intellij/ui/SimpleColoredText;", "calculateIsInExecutionPoint", "", "getPresentation", "isCustomNode", "isErrorMessage", "mouseClicked", "Lcom/jetbrains/rd/ide/model/InlayMouseEvent;", "event", "Lcom/intellij/openapi/editor/event/EditorMouseEvent;", "mouseExited", "inlay", "Lcom/intellij/openapi/editor/Inlay;", "mouseMoved", "updateFromModel", "", "intellij.rd.client"})
@SourceDebugExtension(value={"SMAP\nFrontendDebugInlayModelSupport.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FrontendDebugInlayModelSupport.kt\ncom/jetbrains/rdclient/daemon/highlighters/inlays/FrontendDebugRenderer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,138:1\n1549#2:139\n1620#2,3:140\n*S KotlinDebug\n*F\n+ 1 FrontendDebugInlayModelSupport.kt\ncom/jetbrains/rdclient/daemon/highlighters/inlays/FrontendDebugRenderer\n*L\n135#1:139\n135#1:140,3\n*E\n"})
final class FrontendDebugRenderer
extends InlineDebugRendererBase
implements FrontendMouseAwareInlayRenderer {
    @NotNull
    private final RangeHighlighter highlighter;
    private SimpleColoredText myPresentation;
    public InlineDebugRendererModel model;

    public FrontendDebugRenderer(@NotNull InlineDebugRendererModel model2, @NotNull RangeHighlighter highlighter2) {
        Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
        Intrinsics.checkNotNullParameter((Object)highlighter2, (String)"highlighter");
        this.highlighter = highlighter2;
        this.updateFromModel(model2);
    }

    @NotNull
    public final InlineDebugRendererModel getModel() {
        InlineDebugRendererModel inlineDebugRendererModel = this.model;
        if (inlineDebugRendererModel != null) {
            return inlineDebugRendererModel;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"model");
        return null;
    }

    public final void setModel(@NotNull InlineDebugRendererModel inlineDebugRendererModel) {
        Intrinsics.checkNotNullParameter((Object)inlineDebugRendererModel, (String)"<set-?>");
        this.model = inlineDebugRendererModel;
    }

    @Override
    @Nullable
    public InlayMouseEvent mouseClicked(@NotNull EditorMouseEvent event) {
        DebugClickArea debugClickArea;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (event.getMouseEvent().getX() >= this.getRemoveXCoordinate()) {
            debugClickArea = DebugClickArea.REMOVE_WATCH;
        } else if (event.getMouseEvent().getX() >= this.getTextStartXCoordinate()) {
            debugClickArea = DebugClickArea.TEXT;
        } else {
            return null;
        }
        DebugClickArea debugClickArea2 = debugClickArea;
        Long l = UtilKt.getBackendId(this.highlighter);
        if (l == null) {
            return null;
        }
        return new DebugMouseClickedEventModel(debugClickArea2, l);
    }

    @Override
    @Nullable
    public InlayMouseEvent mouseExited(@NotNull EditorMouseEvent event, @NotNull Inlay<?> inlay) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter(inlay, (String)"inlay");
        this.onMouseExit(inlay);
        return null;
    }

    @Override
    @Nullable
    public InlayMouseEvent mouseMoved(@NotNull EditorMouseEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Inlay inlay = event.getInlay();
        if (inlay == null) {
            return null;
        }
        this.onMouseMove(inlay, event);
        return null;
    }

    @NotNull
    public SimpleColoredText getPresentation() {
        SimpleColoredText simpleColoredText = this.myPresentation;
        if (simpleColoredText == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"myPresentation");
            simpleColoredText = null;
        }
        return simpleColoredText;
    }

    protected boolean calculateIsInExecutionPoint() {
        return this.getModel().isInExecutionPointHighlight();
    }

    public boolean isCustomNode() {
        return this.getModel().isCustomNode();
    }

    public boolean isErrorMessage() {
        return this.getModel().isErrorMessage();
    }

    public final void updateFromModel(@NotNull InlineDebugRendererModel model2) {
        boolean bl;
        Collection collection;
        RichStringModel richStringModel;
        SimpleColoredText simpleColoredText;
        Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
        this.setModel(model2);
        SimpleColoredText simpleColoredText2 = simpleColoredText = new SimpleColoredText();
        FrontendDebugRenderer frontendDebugRenderer = this;
        boolean bl2 = false;
        Iterable iterable = model2.getColoredText().getParts();
        boolean bl3 = false;
        Iterable iterable2 = iterable;
        Collection collection2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)iterable, (int)10));
        boolean bl4 = false;
        for (Object t : iterable2) {
            richStringModel = (RichStringModel)t;
            collection = collection2;
            bl = false;
            collection.add(TuplesKt.to((Object)richStringModel.getText(), (Object)ModelRichTextExKt.toSimpleTextAttributes$default(richStringModel, null, null, false, 7, null)));
        }
        iterable = (List)collection2;
        bl3 = false;
        iterable2 = iterable;
        collection2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)iterable, (int)10));
        bl4 = false;
        for (Object t : iterable2) {
            richStringModel = (Pair)t;
            collection = collection2;
            bl = false;
            simpleColoredText2.append((String)richStringModel.getFirst(), (SimpleTextAttributes)richStringModel.getSecond());
            collection.add(Unit.INSTANCE);
        }
        List cfr_ignored_0 = (List)collection2;
        frontendDebugRenderer.myPresentation = simpleColoredText;
    }
}

