/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdclient.daemon.highlighters.inlays;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.EditorCustomElementRenderer;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.InlayProperties;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.util.Disposer;
import com.jetbrains.rd.ide.model.HighlighterModel;
import com.jetbrains.rd.ide.model.InlineDebugRendererModel;
import com.jetbrains.rdclient.daemon.IProtocolHighlighterModelHandler;
import com.jetbrains.rdclient.daemon.highlighters.inlays.FrontendDebugRenderer;
import com.jetbrains.rdclient.daemon.highlighters.inlays.FrontendInlayWithPresentationModelSupportKt;
import com.jetbrains.rdclient.daemon.util.HighlighterModelAgnosticComparator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\t\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000bH\u0016J \u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0007\u001a\u00020\bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/jetbrains/rdclient/daemon/highlighters/inlays/FrontendDebugInlayModelHandler;", "Lcom/jetbrains/rdclient/daemon/IProtocolHighlighterModelHandler;", "editor", "Lcom/intellij/openapi/editor/impl/EditorImpl;", "(Lcom/intellij/openapi/editor/impl/EditorImpl;)V", "accept", "", "model", "Lcom/jetbrains/rd/ide/model/HighlighterModel;", "compare", "highlighter", "Lcom/intellij/openapi/editor/markup/RangeHighlighter;", "initialize", "", "move", "startOffset", "", "endOffset", "intellij.rd.client"})
public final class FrontendDebugInlayModelHandler
implements IProtocolHighlighterModelHandler {
    @NotNull
    private final EditorImpl editor;

    public FrontendDebugInlayModelHandler(@NotNull EditorImpl editor2) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        this.editor = editor2;
    }

    @Override
    public boolean accept(@NotNull HighlighterModel model2) {
        Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
        return model2 instanceof InlineDebugRendererModel;
    }

    @Override
    public void initialize(@NotNull HighlighterModel model2, @NotNull RangeHighlighter highlighter2) {
        EditorCustomElementRenderer editorCustomElementRenderer;
        Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
        Intrinsics.checkNotNullParameter((Object)highlighter2, (String)"highlighter");
        InlineDebugRendererModel cfr_ignored_0 = (InlineDebugRendererModel)model2;
        Inlay<?> inlay = FrontendInlayWithPresentationModelSupportKt.getInlay(highlighter2);
        if (inlay != null) {
            editorCustomElementRenderer = inlay.getRenderer();
            if (editorCustomElementRenderer instanceof FrontendDebugRenderer) {
                ((FrontendDebugRenderer)editorCustomElementRenderer).updateFromModel((InlineDebugRendererModel)model2);
                inlay.update();
                return;
            }
            Disposer.dispose((Disposable)((Disposable)inlay));
            FrontendInlayWithPresentationModelSupportKt.setInlay(highlighter2, null);
        }
        editorCustomElementRenderer = new InlayProperties().disableSoftWrapping(true).priority(((InlineDebugRendererModel)model2).isCustomNode() ? 0 : -1);
        Inlay inlay2 = this.editor.getInlayModel().addAfterLineEndElement(model2.getStart(), (InlayProperties)editorCustomElementRenderer, (EditorCustomElementRenderer)new FrontendDebugRenderer((InlineDebugRendererModel)model2, highlighter2));
        FrontendInlayWithPresentationModelSupportKt.setInlay(highlighter2, inlay2);
    }

    @Override
    public boolean compare(@NotNull HighlighterModel model2, @NotNull RangeHighlighter highlighter2) {
        Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
        Intrinsics.checkNotNullParameter((Object)highlighter2, (String)"highlighter");
        if (!HighlighterModelAgnosticComparator.INSTANCE.compare(model2, highlighter2)) {
            return false;
        }
        Inlay<?> inlay = FrontendInlayWithPresentationModelSupportKt.getInlay(highlighter2);
        if (inlay == null) {
            return false;
        }
        Inlay<?> inlay2 = inlay;
        EditorCustomElementRenderer editorCustomElementRenderer = inlay2.getRenderer();
        return editorCustomElementRenderer instanceof FrontendDebugRenderer && Intrinsics.areEqual((Object)((FrontendDebugRenderer)editorCustomElementRenderer).getModel(), (Object)model2);
    }

    @Override
    @NotNull
    public HighlighterModel move(int startOffset, int endOffset, @NotNull HighlighterModel model2) {
        Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
        InlineDebugRendererModel inlineDebugRendererModel = (InlineDebugRendererModel)model2;
        boolean bl = false;
        return new InlineDebugRendererModel(inlineDebugRendererModel.getColoredText(), inlineDebugRendererModel.isInExecutionPointHighlight(), inlineDebugRendererModel.isCustomNode(), inlineDebugRendererModel.isErrorMessage(), inlineDebugRendererModel.getLayer(), inlineDebugRendererModel.isExactRange(), inlineDebugRendererModel.getDocumentVersion(), inlineDebugRendererModel.isGreedyToLeft(), inlineDebugRendererModel.isGreedyToRight(), inlineDebugRendererModel.isThinErrorStripeMark(), inlineDebugRendererModel.getTextToHighlight(), inlineDebugRendererModel.getTextAttributesKey(), inlineDebugRendererModel.getId(), inlineDebugRendererModel.getProperties(), startOffset, endOffset);
    }
}

