/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdclient.daemon.highlighters.inlays;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.ex.RangeMarkerEx;
import com.intellij.openapi.editor.impl.EditorEmbeddedComponentManager;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.IdeFocusManager;
import com.jetbrains.ide.model.uiautomation.BeControl;
import com.jetbrains.rd.ide.model.BlockInlayComponentsModel;
import com.jetbrains.rd.ide.model.RdMarkupModel;
import com.jetbrains.rd.ui.bindable.ViewRegistryKt;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rdclient.daemon.FrontendMarkupAdapterListener;
import com.jetbrains.rdclient.daemon.FrontendMarkupContributor;
import com.jetbrains.rdclient.daemon.HighlighterStorage;
import com.jetbrains.rdclient.daemon.components.FrontendMarkupHost;
import com.jetbrains.rdclient.daemon.highlighters.inlays.BlockInlayInfo;
import com.jetbrains.rdclient.daemon.highlighters.inlays.FrontendBlockInlayModelSupportKt;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0016\u0010\u000b\u001a\u00020\b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\n0\rH\u0016J\u0016\u0010\u000e\u001a\u00020\b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\n0\rH\u0016J\u0010\u0010\u000f\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/jetbrains/rdclient/daemon/highlighters/inlays/FrontendBlockInlayModelAdapterListener;", "Lcom/jetbrains/rdclient/daemon/FrontendMarkupAdapterListener;", "editor", "Lcom/intellij/openapi/editor/impl/EditorImpl;", "rdMarkupModel", "Lcom/jetbrains/rd/ide/model/RdMarkupModel;", "(Lcom/intellij/openapi/editor/impl/EditorImpl;Lcom/jetbrains/rd/ide/model/RdMarkupModel;)V", "j", "", "blockInlayHighlighter", "Lcom/intellij/openapi/editor/ex/RangeHighlighterEx;", "afterBulkAdd", "highlighters", "", "beforeBulkRemove", "N", "intellij.rd.client"})
@SourceDebugExtension(value={"SMAP\nFrontendBlockInlayModelSupport.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FrontendBlockInlayModelSupport.kt\ncom/jetbrains/rdclient/daemon/highlighters/inlays/FrontendBlockInlayModelAdapterListener\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,163:1\n766#2:164\n857#2,2:165\n1855#2,2:167\n*S KotlinDebug\n*F\n+ 1 FrontendBlockInlayModelSupport.kt\ncom/jetbrains/rdclient/daemon/highlighters/inlays/FrontendBlockInlayModelAdapterListener\n*L\n114#1:164\n114#1:165,2\n121#1:167,2\n*E\n"})
public final class FrontendBlockInlayModelAdapterListener
implements FrontendMarkupAdapterListener {
    @NotNull
    private final EditorImpl editor;
    @NotNull
    private final RdMarkupModel rdMarkupModel;

    public FrontendBlockInlayModelAdapterListener(@NotNull EditorImpl editor2, @NotNull RdMarkupModel rdMarkupModel) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)((Object)rdMarkupModel), (String)"rdMarkupModel");
        this.editor = editor2;
        this.rdMarkupModel = rdMarkupModel;
    }

    private final void j(RangeHighlighterEx rangeHighlighterEx) {
        BlockInlayInfo blockInlayInfo = FrontendBlockInlayModelSupportKt.getBlockInlayInfo((RangeHighlighter)rangeHighlighterEx);
        if (blockInlayInfo == null) {
            return;
        }
        BlockInlayInfo blockInlayInfo2 = blockInlayInfo;
        BlockInlayComponentsModel blockInlayComponentsModel = FrontendBlockInlayModelSupportKt.getBlockInlaysModel(this.rdMarkupModel);
        if (!((Map)blockInlayComponentsModel.getBlockInlayComponents()).containsKey(blockInlayInfo2.getId())) {
            return;
        }
        Object object = FrontendMarkupHost.Companion.getMarkupContributor((Editor)this.editor);
        if (object == null || (object = ((FrontendMarkupContributor)object).getStorage()) == null) {
            return;
        }
        Object object2 = object;
        BeControl beControl = (BeControl)((Object)blockInlayComponentsModel.getBlockInlayComponents().get((Object)blockInlayInfo2.getId()));
        if (beControl == null) {
            return;
        }
        BeControl beControl2 = beControl;
        Lifetime lifetime = ((HighlighterStorage)object2).getLifetime(rangeHighlighterEx);
        JComponent jComponent = ViewRegistryKt.getView(beControl2, lifetime);
        Inlay inlay = EditorEmbeddedComponentManager.getInstance().addComponent((EditorEx)this.editor, jComponent, new EditorEmbeddedComponentManager.Properties(EditorEmbeddedComponentManager.ResizePolicy.none(), null, true, blockInlayInfo2.getShowAbove(), false, blockInlayInfo2.getFullWidth(), blockInlayInfo2.getPriority(), rangeHighlighterEx.getStartOffset()));
        if (blockInlayInfo2.getFocusOnShow()) {
            Component[] componentArray = jComponent.getComponents();
            Intrinsics.checkNotNullExpressionValue((Object)componentArray, (String)"getComponents(...)");
            Component component = (Component)ArraysKt.firstOrNull((Object[])componentArray);
            if (component == null) {
                component = jComponent;
            }
            Component component2 = component;
            IdeFocusManager.getInstance((Project)this.editor.getProject()).requestFocus(component2, false);
        }
        blockInlayInfo2.setBlockInlay(inlay);
        Map map = FrontendBlockInlayModelSupportKt.getBackendToFrontendInlayIdMap();
        Long l = blockInlayInfo2.getId();
        Intrinsics.checkNotNull((Object)inlay, (String)"null cannot be cast to non-null type com.intellij.openapi.editor.ex.RangeMarkerEx");
        map.put(l, ((RangeMarkerEx)inlay).getId());
    }

    private final void N(RangeHighlighterEx rangeHighlighterEx) {
        Inlay<?> inlay = FrontendBlockInlayModelSupportKt.getBlockInlayInfo((RangeHighlighter)rangeHighlighterEx);
        if (inlay == null || (inlay = inlay.getBlockInlay()) == null) {
            return;
        }
        Inlay<?> inlay2 = inlay;
        FrontendBlockInlayModelSupportKt.getBackendToFrontendInlayIdMap().remove(rangeHighlighterEx.getId());
        Disposer.dispose((Disposable)((Disposable)inlay2));
    }

    @Override
    public void afterBulkAdd(@NotNull List<? extends RangeHighlighterEx> highlighters) {
        Intrinsics.checkNotNullParameter(highlighters, (String)"highlighters");
        Iterable iterable = FrontendBlockInlayModelSupportKt.access$getBlockInlays(highlighters);
        boolean bl = false;
        Iterable iterable2 = iterable;
        Collection collection = new ArrayList();
        boolean bl2 = false;
        for (Object t : iterable2) {
            RangeHighlighterEx rangeHighlighterEx = (RangeHighlighterEx)t;
            boolean bl3 = false;
            if (!(FrontendBlockInlayModelSupportKt.getBlockInlayInfo((RangeHighlighter)rangeHighlighterEx) != null)) continue;
            collection.add(t);
        }
        List list2 = (List)collection;
        for (RangeHighlighterEx rangeHighlighterEx : list2) {
            this.j(rangeHighlighterEx);
        }
    }

    @Override
    public void beforeBulkRemove(@NotNull List<? extends RangeHighlighterEx> highlighters) {
        Intrinsics.checkNotNullParameter(highlighters, (String)"highlighters");
        Iterable iterable = FrontendBlockInlayModelSupportKt.access$getBlockInlays(highlighters);
        boolean bl = false;
        for (Object t : iterable) {
            RangeHighlighterEx rangeHighlighterEx = (RangeHighlighterEx)t;
            boolean bl2 = false;
            this.N(rangeHighlighterEx);
        }
    }
}

