/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdclient.daemon.highlighters.indentGuides;

import com.intellij.codeInsight.daemon.impl.IndentGuideRenderer;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.jetbrains.rdclient.daemon.highlighters.indentGuides.FrontendIndentGuideHighlighterModelHandler;
import com.jetbrains.rdclient.daemon.highlighters.indentGuides.FrontendIndentGuideRenderResultCollector;
import com.jetbrains.rdclient.daemon.highlighters.indentGuides.FrontendIndentGuideRendererKt;
import java.awt.Graphics;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J \u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0007J(\u0010\f\u001a\u00020\r2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u000fH\u0014J \u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016\u00a8\u0006\u0015"}, d2={"Lcom/jetbrains/rdclient/daemon/highlighters/indentGuides/FrontendIndentGuideRenderer;", "Lcom/intellij/codeInsight/daemon/impl/IndentGuideRenderer;", "()V", "j", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "highlighter", "Lcom/intellij/openapi/editor/markup/RangeHighlighter;", "resultCollector", "Lcom/jetbrains/rdclient/daemon/highlighters/indentGuides/FrontendIndentGuideRenderResultCollector;", "doPaintInTest", "isSelected", "", "endOffset", "", "off", "indentColumn", "paint", "g", "Ljava/awt/Graphics;", "intellij.rd.client"})
public final class FrontendIndentGuideRenderer
extends IndentGuideRenderer {
    protected boolean isSelected(@NotNull Editor editor2, int endOffset, int off, int indentColumn) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        return IndentGuideRenderer.isCaretOnGuide((Editor)editor2, (int)endOffset, (int)off, (int)indentColumn);
    }

    public void paint(@NotNull Editor editor2, @NotNull RangeHighlighter highlighter2, @NotNull Graphics g) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)highlighter2, (String)"highlighter");
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        if (!editor2.getSettings().isIndentGuidesShown()) {
            return;
        }
        if (FrontendIndentGuideHighlighterModelHandler.Companion.getIndentLevel(highlighter2) == null) {
            super.paint(editor2, highlighter2, g);
            return;
        }
        FrontendIndentGuideRenderResultCollector frontendIndentGuideRenderResultCollector = (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5) -> FrontendIndentGuideRenderer.j(this, g, arg_0, arg_1, arg_2, arg_3, arg_4, arg_5);
        this.j(editor2, highlighter2, frontendIndentGuideRenderResultCollector);
    }

    private final void j(Editor editor2, RangeHighlighter rangeHighlighter, FrontendIndentGuideRenderResultCollector frontendIndentGuideRenderResultCollector) {
        Integer n = FrontendIndentGuideHighlighterModelHandler.Companion.getIndentLevel(rangeHighlighter);
        Intrinsics.checkNotNull((Object)n);
        int n2 = n;
        int n3 = rangeHighlighter.getStartOffset();
        Document document = rangeHighlighter.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        Document document2 = document;
        if (n3 >= document2.getTextLength()) {
            return;
        }
        int n4 = rangeHighlighter.getEndOffset();
        int n5 = document2.getLineNumber(n3);
        int n6 = document2.getLineNumber(n4);
        int n7 = editor2.logicalPositionToOffset(new LogicalPosition(n5, 0)) + n2;
        int n8 = editor2.offsetToVisualPosition((int)n7).column;
        int n9 = editor2.offsetToLogicalPosition((int)n7).column;
        Integer n10 = n5;
        for (int k = n5; k < n6; ++k) {
            if (FrontendIndentGuideRendererKt.access$shouldRenderIndentGuideOnLine(editor2, k, n9)) {
                Integer n11 = n10;
                if (n11 == null) {
                    n11 = k - 1;
                }
                n10 = n11;
                continue;
            }
            if (n10 == null) continue;
            FrontendIndentGuideRenderer.j(editor2, n2, n8, frontendIndentGuideRenderResultCollector, n7, n4, document2, n10, k);
            n10 = null;
        }
        if (n10 == null) {
            return;
        }
        FrontendIndentGuideRenderer.j(editor2, n2, n8, frontendIndentGuideRenderResultCollector, n7, n4, document2, n10, n6);
    }

    @TestOnly
    public final void doPaintInTest(@NotNull Editor editor2, @NotNull RangeHighlighter highlighter2, @NotNull FrontendIndentGuideRenderResultCollector resultCollector) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)highlighter2, (String)"highlighter");
        Intrinsics.checkNotNullParameter((Object)resultCollector, (String)"resultCollector");
        this.j(editor2, highlighter2, resultCollector);
    }

    private static final void j(FrontendIndentGuideRenderer frontendIndentGuideRenderer, Graphics graphics, Editor editor2, VisualPosition visualPosition, VisualPosition visualPosition2, int n, int n2, Document document) {
        Intrinsics.checkNotNullParameter((Object)((Object)frontendIndentGuideRenderer), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)graphics, (String)"$g");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editorParam");
        Intrinsics.checkNotNullParameter((Object)visualPosition, (String)"currentPartStartVisualPosition");
        Intrinsics.checkNotNullParameter((Object)visualPosition2, (String)"currentPartEndVisualPosition");
        Intrinsics.checkNotNullParameter((Object)document, (String)"doc");
        frontendIndentGuideRenderer.paint(editor2, visualPosition, visualPosition2, n, n2, document, graphics);
    }

    private static final void j(Editor editor2, int n, int n2, FrontendIndentGuideRenderResultCollector frontendIndentGuideRenderResultCollector, int n3, int n4, Document document, int n5, int n6) {
        int n7 = editor2.logicalPositionToOffset(new LogicalPosition(n5, 0)) + n;
        VisualPosition visualPosition = new VisualPosition(editor2.offsetToVisualPosition((int)n7).line, n2);
        int n8 = editor2.logicalPositionToOffset(new LogicalPosition(n6, 0)) + n;
        VisualPosition visualPosition2 = new VisualPosition(editor2.offsetToVisualPosition((int)n8).line, n2);
        frontendIndentGuideRenderResultCollector.collect(editor2, visualPosition, visualPosition2, n3, n4, document);
    }
}

