/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdclient.daemon.highlighters.indentGuides;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.IndentGuideDescriptor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.impl.IndentsModelCaretListener;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import com.jetbrains.rd.framework.IRdTask;
import com.jetbrains.rd.framework.RdTaskResult;
import com.jetbrains.rd.framework.impl.RdCall;
import com.jetbrains.rd.ide.model.InvisibleBraceHintModel;
import com.jetbrains.rd.ide.model.InvisibleBraceHintProviderModel;
import com.jetbrains.rd.ide.model.RdTextRange;
import com.jetbrains.rd.platform.util.ComponentsKt;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.LifetimeDefinition;
import com.jetbrains.rd.util.reactive.IOptPropertyView;
import com.jetbrains.rd.util.reactive.ISource;
import com.jetbrains.rd.util.reactive.SourceExKt;
import com.jetbrains.rdclient.daemon.FrontendMarkupAdapter;
import com.jetbrains.rdclient.daemon.FrontendMarkupContributor;
import com.jetbrains.rdclient.daemon.components.FrontendMarkupHost;
import com.jetbrains.rdclient.daemon.highlighters.indentGuides.FrontendIndentGuideHighlighterModelHandler;
import com.jetbrains.rdclient.daemon.highlighters.indentGuides.FrontendIndentGuideProtocolMarkupExtension;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0012\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u000b\u001a\u00020\fH\u0014J\u0010\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u0012H\u0014J\u0016\u0010\u0015\u001a\u0004\u0018\u00010\u0012*\u00020\u000e2\u0006\u0010\u0004\u001a\u00020\u0016H\u0002J\u0014\u0010\u0017\u001a\u00020\u0012*\u00020\u00122\u0006\u0010\u0018\u001a\u00020\bH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/jetbrains/rdclient/daemon/highlighters/indentGuides/FrontendIndentGuideCaretListener;", "Lcom/intellij/openapi/editor/impl/IndentsModelCaretListener;", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/impl/EditorImpl;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/editor/impl/EditorImpl;)V", "version", "", "caretPositionChanged", "", "event", "Lcom/intellij/openapi/editor/event/CaretEvent;", "j", "Lcom/intellij/openapi/editor/ex/RangeHighlighterEx;", "adapter", "Lcom/jetbrains/rdclient/daemon/FrontendMarkupAdapter;", "getCaretIndentGuide", "Lcom/intellij/openapi/editor/IndentGuideDescriptor;", "showHint", "newGuide", "j", "Lcom/intellij/openapi/editor/Editor;", "j", "codeConstructStartLine", "Companion", "intellij.rd.client"})
@SourceDebugExtension(value={"SMAP\nFrontendIndentGuideCaretListener.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FrontendIndentGuideCaretListener.kt\ncom/jetbrains/rdclient/daemon/highlighters/indentGuides/FrontendIndentGuideCaretListener\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,113:1\n288#2,2:114\n13#3:116\n*S KotlinDebug\n*F\n+ 1 FrontendIndentGuideCaretListener.kt\ncom/jetbrains/rdclient/daemon/highlighters/indentGuides/FrontendIndentGuideCaretListener\n*L\n97#1:114,2\n111#1:116\n*E\n"})
public final class FrontendIndentGuideCaretListener
extends IndentsModelCaretListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final EditorImpl editor;
    private int version;
    @NotNull
    private static final Logger logger;

    public FrontendIndentGuideCaretListener(@NotNull Project project, @NotNull EditorImpl editor2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        super(editor2);
        this.project = project;
        this.editor = editor2;
    }

    @Nullable
    protected IndentGuideDescriptor getCaretIndentGuide(@NotNull CaretEvent event) {
        RangeHighlighterEx rangeHighlighterEx;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        DocumentEx documentEx = this.editor.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)documentEx, (String)"getDocument(...)");
        FrontendMarkupContributor frontendMarkupContributor = FrontendMarkupHost.Companion.getMarkupContributor(this.project, (Document)documentEx);
        Object object = frontendMarkupContributor;
        if (object == null || (object = ((FrontendMarkupContributor)object).getMarkupAdapter()) == null) {
            return null;
        }
        Object object2 = object;
        RangeHighlighterEx rangeHighlighterEx2 = rangeHighlighterEx = this.j((FrontendMarkupAdapter)object2);
        return rangeHighlighterEx2 != null ? this.j(rangeHighlighterEx2, (Editor)this.editor) : null;
    }

    protected void showHint(@NotNull IndentGuideDescriptor newGuide) {
        block3: {
            IOptPropertyView iOptPropertyView;
            IRdTask iRdTask;
            RdCall<Long, InvisibleBraceHintModel> rdCall;
            Intrinsics.checkNotNullParameter((Object)newGuide, (String)"newGuide");
            DocumentEx documentEx = this.editor.getDocument();
            Intrinsics.checkNotNullExpressionValue((Object)documentEx, (String)"getDocument(...)");
            FrontendMarkupContributor frontendMarkupContributor = FrontendMarkupHost.Companion.getMarkupContributor(this.project, (Document)documentEx);
            Object object = frontendMarkupContributor;
            if (object == null || (object = ((FrontendMarkupContributor)object).getMarkupAdapter()) == null) {
                return;
            }
            Object object2 = object;
            RangeHighlighterEx rangeHighlighterEx = this.j((FrontendMarkupAdapter)object2);
            if (rangeHighlighterEx == null) {
                return;
            }
            RangeHighlighterEx rangeHighlighterEx2 = rangeHighlighterEx;
            Long l = frontendMarkupContributor.getStorage().get(rangeHighlighterEx2);
            if (l == null) {
                return;
            }
            long l2 = l;
            LifetimeDefinition lifetimeDefinition = ComponentsKt.getLifetime((UserDataHolder)this.project).createNested();
            int n = this.version;
            InvisibleBraceHintProviderModel invisibleBraceHintProviderModel = FrontendIndentGuideProtocolMarkupExtension.Companion.getInvisibleBraceHintProviderModel((FrontendMarkupAdapter)object2);
            if (invisibleBraceHintProviderModel == null || (rdCall = invisibleBraceHintProviderModel.getGetInvisibleBraceHint()) == null || (iRdTask = rdCall.start((Lifetime)lifetimeDefinition, (Object)l2)) == null || (iOptPropertyView = iRdTask.getResult()) == null) break block3;
            SourceExKt.adviseOnce((ISource)((ISource)iOptPropertyView), (Lifetime)((Lifetime)lifetimeDefinition), (Function1)((Function1)new Function1<RdTaskResult<? extends InvisibleBraceHintModel>, Unit>(this, n, newGuide){
                final /* synthetic */ FrontendIndentGuideCaretListener this$0;
                final /* synthetic */ int $currentVersion;
                final /* synthetic */ IndentGuideDescriptor $newGuide;
                {
                    this.this$0 = $receiver;
                    this.$currentVersion = $currentVersion;
                    this.$newGuide = $newGuide;
                    super(1);
                }

                public final void invoke(@NotNull RdTaskResult<InvisibleBraceHintModel> callResult) {
                    Intrinsics.checkNotNullParameter(callResult, (String)"callResult");
                    if (!(callResult instanceof RdTaskResult.Success)) {
                        FrontendIndentGuideCaretListener.access$getLogger$cp().warn("Invisible brace hint range calculation failed");
                        return;
                    }
                    if (FrontendIndentGuideCaretListener.access$getVersion$p(this.this$0) != this.$currentVersion) {
                        return;
                    }
                    Object object = (InvisibleBraceHintModel)((RdTaskResult.Success)callResult).getValue();
                    if (object == null || (object = ((InvisibleBraceHintModel)object).getHintRange()) == null) {
                        return;
                    }
                    int n = ((RdTextRange)object).getStartOffset();
                    int n2 = FrontendIndentGuideCaretListener.access$getEditor$p((FrontendIndentGuideCaretListener)this.this$0).offsetToLogicalPosition((int)n).line;
                    FrontendIndentGuideCaretListener.access$showHint$s1196841525(this.this$0, FrontendIndentGuideCaretListener.access$withCodeConstructStartLine(this.this$0, this.$newGuide, n2));
                }
            }));
        }
    }

    public void caretPositionChanged(@NotNull CaretEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        ++this.version;
        super.caretPositionChanged(event);
    }

    private final RangeHighlighterEx j(FrontendMarkupAdapter frontendMarkupAdapter) {
        Object v1;
        block1: {
            LogicalPosition logicalPosition = this.editor.getCaretModel().getLogicalPosition();
            Intrinsics.checkNotNullExpressionValue((Object)logicalPosition, (String)"getLogicalPosition(...)");
            LogicalPosition logicalPosition2 = logicalPosition;
            int n = this.editor.logicalPositionToOffset(new LogicalPosition(logicalPosition2.line, 0));
            int n2 = logicalPosition2.column;
            int n3 = this.editor.getCaretModel().getOffset();
            int n4 = n3 - n;
            Iterable iterable = frontendMarkupAdapter.getHighlighters(n3);
            boolean bl = false;
            for (Object t : iterable) {
                RangeHighlighterEx rangeHighlighterEx = (RangeHighlighterEx)t;
                boolean bl2 = false;
                if (!FrontendIndentGuideCaretListener.j(rangeHighlighterEx, n3, this, n4, n2)) continue;
                v1 = t;
                break block1;
            }
            v1 = null;
        }
        return v1;
    }

    private final IndentGuideDescriptor j(RangeHighlighterEx rangeHighlighterEx, Editor editor2) {
        Integer n = FrontendIndentGuideHighlighterModelHandler.Companion.getIndentLevel((RangeHighlighter)rangeHighlighterEx);
        if (n == null) {
            return null;
        }
        int n2 = n;
        int n3 = editor2.offsetToLogicalPosition((int)rangeHighlighterEx.getStartOffset()).line;
        int n4 = editor2.offsetToLogicalPosition((int)rangeHighlighterEx.getEndOffset()).line;
        return new IndentGuideDescriptor(n2, n3, n4);
    }

    private final IndentGuideDescriptor j(IndentGuideDescriptor indentGuideDescriptor, int n) {
        return new IndentGuideDescriptor(indentGuideDescriptor.indentLevel, n, indentGuideDescriptor.startLine, indentGuideDescriptor.endLine);
    }

    private static final int j(RangeHighlighterEx rangeHighlighterEx, FrontendIndentGuideCaretListener frontendIndentGuideCaretListener) {
        int n;
        int n2 = frontendIndentGuideCaretListener.editor.offsetToLogicalPosition((int)rangeHighlighterEx.getStartOffset()).line;
        int n3 = frontendIndentGuideCaretListener.editor.getDocument().getLineEndOffset(n2) - frontendIndentGuideCaretListener.editor.getDocument().getLineStartOffset(n2);
        Integer n4 = FrontendIndentGuideHighlighterModelHandler.Companion.getIndentLevel((RangeHighlighter)rangeHighlighterEx);
        Intrinsics.checkNotNull((Object)n4);
        if (n4 <= n3) {
            int n5 = frontendIndentGuideCaretListener.editor.logicalPositionToOffset(new LogicalPosition(n2, 0));
            Integer n6 = FrontendIndentGuideHighlighterModelHandler.Companion.getIndentLevel((RangeHighlighter)rangeHighlighterEx);
            Intrinsics.checkNotNull((Object)n6);
            n = n5 + n6;
        } else {
            n = rangeHighlighterEx.getStartOffset();
        }
        int n7 = n;
        return frontendIndentGuideCaretListener.editor.offsetToVisualPosition((int)n7).column;
    }

    private static final boolean j(RangeHighlighterEx rangeHighlighterEx, int n, FrontendIndentGuideCaretListener frontendIndentGuideCaretListener, int n2, int n3) {
        Integer n4 = FrontendIndentGuideHighlighterModelHandler.Companion.getIndentLevel((RangeHighlighter)rangeHighlighterEx);
        if (n4 == null) {
            return false;
        }
        int n5 = n4;
        if (rangeHighlighterEx.getEndOffset() == n) {
            return true;
        }
        if (frontendIndentGuideCaretListener.editor.getFoldingModel().isOffsetCollapsed(rangeHighlighterEx.getStartOffset())) {
            return n5 == n2;
        }
        return FrontendIndentGuideCaretListener.j(rangeHighlighterEx, frontendIndentGuideCaretListener) == n3;
    }

    public static final /* synthetic */ Logger access$getLogger$cp() {
        return logger;
    }

    public static final /* synthetic */ int access$getVersion$p(FrontendIndentGuideCaretListener $this) {
        return $this.version;
    }

    public static final /* synthetic */ EditorImpl access$getEditor$p(FrontendIndentGuideCaretListener $this) {
        return $this.editor;
    }

    public static final /* synthetic */ void access$showHint$s1196841525(FrontendIndentGuideCaretListener $this, IndentGuideDescriptor p0) {
        super.showHint(p0);
    }

    public static final /* synthetic */ IndentGuideDescriptor access$withCodeConstructStartLine(FrontendIndentGuideCaretListener $this, IndentGuideDescriptor $receiver, int codeConstructStartLine) {
        return $this.j($receiver, codeConstructStartLine);
    }

    static {
        boolean bl = false;
        Logger logger = Logger.getInstance(FrontendIndentGuideCaretListener.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        FrontendIndentGuideCaretListener.logger = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/jetbrains/rdclient/daemon/highlighters/indentGuides/FrontendIndentGuideCaretListener$Companion;", "", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.rd.client"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

