/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdclient.daemon.highlighters.foldings;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.jetbrains.rd.ide.model.FoldingHighlighterModel;
import com.jetbrains.rd.ide.model.HighlighterModel;
import com.jetbrains.rd.util.string.IPrintableKt;
import com.jetbrains.rdclient.daemon.IProtocolHighlighterModelHandler;
import com.jetbrains.rdclient.daemon.highlighters.foldings.FoldingInfo;
import com.jetbrains.rdclient.daemon.highlighters.foldings.FoldingInfoKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0018\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\tH\u0016J \u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0011"}, d2={"Lcom/jetbrains/rdclient/daemon/highlighters/foldings/FrontendCodeFoldingModelHandler;", "Lcom/jetbrains/rdclient/daemon/IProtocolHighlighterModelHandler;", "()V", "accept", "", "model", "Lcom/jetbrains/rd/ide/model/HighlighterModel;", "compare", "highlighter", "Lcom/intellij/openapi/editor/markup/RangeHighlighter;", "initialize", "", "move", "startOffset", "", "endOffset", "Companion", "intellij.rd.client"})
@SourceDebugExtension(value={"SMAP\nFrontendCodeFoldingModelHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FrontendCodeFoldingModelHandler.kt\ncom/jetbrains/rdclient/daemon/highlighters/foldings/FrontendCodeFoldingModelHandler\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,65:1\n13#2:66\n*S KotlinDebug\n*F\n+ 1 FrontendCodeFoldingModelHandler.kt\ncom/jetbrains/rdclient/daemon/highlighters/foldings/FrontendCodeFoldingModelHandler\n*L\n12#1:66\n*E\n"})
public final class FrontendCodeFoldingModelHandler
implements IProtocolHighlighterModelHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Logger LOG;

    @Override
    public boolean accept(@NotNull HighlighterModel model2) {
        Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
        return model2 instanceof FoldingHighlighterModel;
    }

    @Override
    public void initialize(@NotNull HighlighterModel model2, @NotNull RangeHighlighter highlighter2) {
        Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
        Intrinsics.checkNotNullParameter((Object)highlighter2, (String)"highlighter");
        FoldingHighlighterModel cfr_ignored_0 = (FoldingHighlighterModel)model2;
        FoldingInfo foldingInfo = FoldingInfoKt.getFoldingInfo(highlighter2);
        if (foldingInfo != null) {
            foldingInfo.setPlaceholderText(((FoldingHighlighterModel)model2).getPlaceholderText());
            foldingInfo.setCollapsedByDefault(((FoldingHighlighterModel)model2).getCollapsedByDefault());
            return;
        }
        if (highlighter2.getStartOffset() >= highlighter2.getEndOffset()) {
            LOG.warn("Folding have invalid length, ignore it: " + IPrintableKt.printToString((Object)model2));
            return;
        }
        FoldingInfoKt.setFoldingInfo(highlighter2, new FoldingInfo((FoldingHighlighterModel)model2));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean compare(@NotNull HighlighterModel model2, @NotNull RangeHighlighter highlighter2) {
        Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
        Intrinsics.checkNotNullParameter((Object)highlighter2, (String)"highlighter");
        FoldingHighlighterModel cfr_ignored_0 = (FoldingHighlighterModel)model2;
        if (!highlighter2.isValid()) {
            return false;
        }
        if (highlighter2.getStartOffset() != model2.getStart()) return false;
        if (highlighter2.getEndOffset() != model2.getEnd()) {
            return false;
        }
        FoldingInfo foldingInfo = FoldingInfoKt.getFoldingInfo(highlighter2);
        if (!Intrinsics.areEqual((Object)((FoldingHighlighterModel)model2).getPlaceholderText(), (Object)(foldingInfo != null ? foldingInfo.getPlaceholderText() : null))) return false;
        FoldingInfo foldingInfo2 = FoldingInfoKt.getFoldingInfo(highlighter2);
        if (!Intrinsics.areEqual((Object)model2.getProperties().getAttributeId(), (Object)(foldingInfo2 != null ? foldingInfo2.getAttributeId() : null))) return false;
        return true;
    }

    @Override
    @NotNull
    public HighlighterModel move(int startOffset, int endOffset, @NotNull HighlighterModel model2) {
        Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
        FoldingHighlighterModel foldingHighlighterModel = (FoldingHighlighterModel)model2;
        boolean bl = false;
        return new FoldingHighlighterModel(foldingHighlighterModel.getPlaceholderText(), foldingHighlighterModel.getCollapsedByDefault(), foldingHighlighterModel.getGroupId(), ((FoldingHighlighterModel)model2).getNeverExpands(), foldingHighlighterModel.getLayer(), foldingHighlighterModel.isExactRange(), foldingHighlighterModel.getDocumentVersion(), foldingHighlighterModel.isGreedyToLeft(), foldingHighlighterModel.isGreedyToRight(), foldingHighlighterModel.isThinErrorStripeMark(), foldingHighlighterModel.getTextToHighlight(), foldingHighlighterModel.getTextAttributesKey(), foldingHighlighterModel.getId(), foldingHighlighterModel.getProperties(), startOffset, endOffset);
    }

    static {
        boolean bl = false;
        Logger logger = Logger.getInstance(FrontendCodeFoldingModelHandler.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/jetbrains/rdclient/daemon/highlighters/foldings/FrontendCodeFoldingModelHandler$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.rd.client"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

