/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdclient.daemon.highlighters.fileAnnotations;

import com.intellij.codeInsight.intention.impl.FileLevelIntentionComponent;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.impl.text.TextEditorProvider;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.jetbrains.rd.ide.model.FileAnnotationType;
import com.jetbrains.rdclient.daemon.FrontendMarkupAdapterListener;
import com.jetbrains.rdclient.daemon.highlighters.fileAnnotations.FileAnnotationInfo;
import com.jetbrains.rdclient.daemon.highlighters.fileAnnotations.FrontendFileAnnotationModelHandlerKt;
import com.jetbrains.rdclient.daemon.util.HighlightersUtilKt;
import com.jetbrains.rdclient.editors.TextControlUtilsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0016J\u0010\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u000fH\u0016J\u0016\u0010\u0012\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0016J\u001c\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0014H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/jetbrains/rdclient/daemon/highlighters/fileAnnotations/FrontendFileAnnotationModelAdapter;", "Lcom/jetbrains/rdclient/daemon/FrontendMarkupAdapterListener;", "editor", "Lcom/intellij/openapi/editor/Editor;", "(Lcom/intellij/openapi/editor/Editor;)V", "getEditor", "()Lcom/intellij/openapi/editor/Editor;", "fileEditorManager", "Lcom/intellij/openapi/fileEditor/FileEditorManager;", "textEditorProvider", "Lcom/intellij/openapi/fileEditor/impl/text/TextEditorProvider;", "afterBulkAdd", "", "highlighters", "", "Lcom/intellij/openapi/editor/ex/RangeHighlighterEx;", "afterUpdated", "highlighter", "beforeBulkRemove", "j", "", "intellij.rd.client"})
@SourceDebugExtension(value={"SMAP\nFrontendFileAnnotationModelAdapter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FrontendFileAnnotationModelAdapter.kt\ncom/jetbrains/rdclient/daemon/highlighters/fileAnnotations/FrontendFileAnnotationModelAdapter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,64:1\n766#2:65\n857#2,2:66\n*S KotlinDebug\n*F\n+ 1 FrontendFileAnnotationModelAdapter.kt\ncom/jetbrains/rdclient/daemon/highlighters/fileAnnotations/FrontendFileAnnotationModelAdapter\n*L\n20#1:65\n20#1:66,2\n*E\n"})
public final class FrontendFileAnnotationModelAdapter
implements FrontendMarkupAdapterListener {
    @NotNull
    private final Editor editor;
    @NotNull
    private final TextEditorProvider textEditorProvider;
    @NotNull
    private final FileEditorManager fileEditorManager;

    public FrontendFileAnnotationModelAdapter(@NotNull Editor editor2) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        this.editor = editor2;
        this.textEditorProvider = TextEditorProvider.Companion.getInstance();
        Project project = this.editor.getProject();
        Intrinsics.checkNotNull((Object)project);
        FileEditorManager fileEditorManager = FileEditorManager.getInstance((Project)project);
        Intrinsics.checkNotNullExpressionValue((Object)fileEditorManager, (String)"getInstance(...)");
        this.fileEditorManager = fileEditorManager;
    }

    @NotNull
    public final Editor getEditor() {
        return this.editor;
    }

    private final List<RangeHighlighterEx> j(Collection<? extends RangeHighlighterEx> collection) {
        Iterable iterable = collection;
        boolean bl = false;
        Iterable iterable2 = iterable;
        Collection collection2 = new ArrayList();
        boolean bl2 = false;
        for (Object t : iterable2) {
            RangeHighlighterEx rangeHighlighterEx = (RangeHighlighterEx)t;
            boolean bl3 = false;
            if (!(HighlightersUtilKt.isBackendHighlighter((RangeHighlighter)rangeHighlighterEx) && FrontendFileAnnotationModelHandlerKt.getFileAnnotation((RangeHighlighter)rangeHighlighterEx) != null)) continue;
            collection2.add(t);
        }
        return (List)collection2;
    }

    @Override
    public void afterBulkAdd(@NotNull List<? extends RangeHighlighterEx> highlighters) {
        Intrinsics.checkNotNullParameter(highlighters, (String)"highlighters");
        TextEditor textEditor = this.textEditorProvider.getTextEditor(this.editor);
        List<RangeHighlighterEx> list2 = this.j((Collection<? extends RangeHighlighterEx>)highlighters);
        if (list2.isEmpty()) {
            return;
        }
        PsiFile psiFile = TextControlUtilsKt.getPsiFile(this.editor);
        if (psiFile == null) {
            return;
        }
        PsiFile psiFile2 = psiFile;
        for (RangeHighlighterEx rangeHighlighterEx : list2) {
            FileAnnotationInfo fileAnnotationInfo;
            Intrinsics.checkNotNull((Object)FrontendFileAnnotationModelHandlerKt.getFileAnnotation((RangeHighlighter)rangeHighlighterEx));
            Object object = rangeHighlighterEx.getErrorStripeTooltip();
            String string = object != null ? object.toString() : null;
            HighlightSeverity highlightSeverity = switch (WhenMappings.$EnumSwitchMapping$0[fileAnnotationInfo.getType().ordinal()]) {
                case 1 -> HighlightSeverity.ERROR;
                case 2 -> HighlightSeverity.INFORMATION;
                case 3 -> HighlightSeverity.WARNING;
                default -> HighlightSeverity.INFORMATION;
            };
            FileLevelIntentionComponent fileLevelIntentionComponent = new FileLevelIntentionComponent(fileAnnotationInfo.getDescription(), highlightSeverity, null, null, psiFile2, this.editor, string);
            fileAnnotationInfo.setComponent(fileLevelIntentionComponent);
            this.fileEditorManager.addTopComponent((FileEditor)textEditor, (JComponent)fileLevelIntentionComponent);
        }
    }

    @Override
    public void beforeBulkRemove(@NotNull List<? extends RangeHighlighterEx> highlighters) {
        Intrinsics.checkNotNullParameter(highlighters, (String)"highlighters");
        TextEditor textEditor = this.textEditorProvider.getTextEditor(this.editor);
        for (RangeHighlighterEx rangeHighlighterEx : this.j((Collection<? extends RangeHighlighterEx>)highlighters)) {
            FileLevelIntentionComponent fileLevelIntentionComponent;
            FileAnnotationInfo fileAnnotationInfo;
            Intrinsics.checkNotNull((Object)FrontendFileAnnotationModelHandlerKt.getFileAnnotation((RangeHighlighter)rangeHighlighterEx));
            if (fileAnnotationInfo.getComponent() == null) continue;
            this.fileEditorManager.removeTopComponent((FileEditor)textEditor, (JComponent)fileLevelIntentionComponent);
            fileAnnotationInfo.setComponent(null);
        }
    }

    @Override
    public void afterUpdated(@NotNull RangeHighlighterEx highlighter2) {
        Intrinsics.checkNotNullParameter((Object)highlighter2, (String)"highlighter");
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[FileAnnotationType.values().length];
            try {
                nArray[FileAnnotationType.ERROR.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FileAnnotationType.INFO.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FileAnnotationType.WARN.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

