/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdclient.daemon.highlighters.defaultHighlighters;

import com.intellij.analysis.problemsView.toolWindow.ProblemViewSuppressor;
import com.intellij.codeHighlighting.RainbowHighlighter;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInspection.ExternalSourceProblemGroup;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.lang.annotation.ProblemGroup;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.TextRange;
import com.jetbrains.ide.model.highlighterRegistration.TextAttributesKeyModel;
import com.jetbrains.rd.ide.model.DefaultHighlighterModel;
import com.jetbrains.rd.ide.model.HighlightInfoModel;
import com.jetbrains.rd.ide.model.HighlighterModel;
import com.jetbrains.rd.platform.daemon.TextAttributesRegistrationHost;
import com.jetbrains.rdclient.daemon.IProtocolHighlighterModelHandler;
import com.jetbrains.rdclient.daemon.highlighters.tooltips.FrontendAsyncTooltipHighlightInfo;
import com.jetbrains.rdclient.daemon.highlighters.tooltips.FrontendEmptyTooltipHighlightInfo;
import com.jetbrains.rdclient.daemon.highlighters.tooltips.FrontendTooltipProvider;
import com.jetbrains.rdclient.daemon.util.HighlighterModelAgnosticComparator;
import com.jetbrains.rdclient.daemon.util.HighlightersUtilKt;
import com.jetbrains.rdclient.highlighting.FrontendHighlighterAttributeCustomizer;
import java.awt.Color;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u000b\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\rH\u0016J\u001a\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\t\u001a\u00020\u0012H\u0002J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\rH\u0016J \u0010\u0015\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010\t\u001a\u00020\nH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/jetbrains/rdclient/daemon/highlighters/defaultHighlighters/FrontendDefaultHighlighterModelHandler;", "Lcom/jetbrains/rdclient/daemon/IProtocolHighlighterModelHandler;", "editorColorsManager", "Lcom/intellij/openapi/editor/colors/EditorColorsManager;", "tooltipProvider", "Lcom/jetbrains/rdclient/daemon/highlighters/tooltips/FrontendTooltipProvider;", "(Lcom/intellij/openapi/editor/colors/EditorColorsManager;Lcom/jetbrains/rdclient/daemon/highlighters/tooltips/FrontendTooltipProvider;)V", "accept", "", "model", "Lcom/jetbrains/rd/ide/model/HighlighterModel;", "compare", "highlighter", "Lcom/intellij/openapi/editor/markup/RangeHighlighter;", "j", "Lcom/intellij/codeInsight/daemon/impl/HighlightInfo;", "range", "Lcom/intellij/openapi/util/TextRange;", "Lcom/jetbrains/rd/ide/model/DefaultHighlighterModel;", "initialize", "", "move", "startOffset", "", "endOffset", "Companion", "intellij.rd.client"})
@SourceDebugExtension(value={"SMAP\nFrontendDefaultHighlighterModelHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FrontendDefaultHighlighterModelHandler.kt\ncom/jetbrains/rdclient/daemon/highlighters/defaultHighlighters/FrontendDefaultHighlighterModelHandler\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,128:1\n13#2:129\n*S KotlinDebug\n*F\n+ 1 FrontendDefaultHighlighterModelHandler.kt\ncom/jetbrains/rdclient/daemon/highlighters/defaultHighlighters/FrontendDefaultHighlighterModelHandler\n*L\n126#1:129\n*E\n"})
public final class FrontendDefaultHighlighterModelHandler
implements IProtocolHighlighterModelHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final EditorColorsManager editorColorsManager;
    @NotNull
    private final FrontendTooltipProvider tooltipProvider;
    @NotNull
    private static final Logger logger;

    public FrontendDefaultHighlighterModelHandler(@NotNull EditorColorsManager editorColorsManager, @NotNull FrontendTooltipProvider tooltipProvider) {
        Intrinsics.checkNotNullParameter((Object)editorColorsManager, (String)"editorColorsManager");
        Intrinsics.checkNotNullParameter((Object)tooltipProvider, (String)"tooltipProvider");
        this.editorColorsManager = editorColorsManager;
        this.tooltipProvider = tooltipProvider;
    }

    @Override
    public boolean accept(@NotNull HighlighterModel model2) {
        Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
        return model2 instanceof DefaultHighlighterModel;
    }

    @Override
    public boolean compare(@NotNull HighlighterModel model2, @NotNull RangeHighlighter highlighter2) {
        Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
        Intrinsics.checkNotNullParameter((Object)highlighter2, (String)"highlighter");
        return HighlighterModelAgnosticComparator.INSTANCE.compare(model2, highlighter2);
    }

    @Override
    @NotNull
    public HighlighterModel move(int startOffset, int endOffset, @NotNull HighlighterModel model2) {
        Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
        DefaultHighlighterModel defaultHighlighterModel = (DefaultHighlighterModel)model2;
        boolean bl = false;
        return new DefaultHighlighterModel(defaultHighlighterModel.getInfo(), defaultHighlighterModel.getAfterEndOfLine(), defaultHighlighterModel.getNeedsUpdateOnTyping(), defaultHighlighterModel.getErased(), defaultHighlighterModel.getRestrictCalculateTooltip(), defaultHighlighterModel.getLayer(), defaultHighlighterModel.isExactRange(), defaultHighlighterModel.getDocumentVersion(), defaultHighlighterModel.isGreedyToLeft(), defaultHighlighterModel.isGreedyToRight(), defaultHighlighterModel.isThinErrorStripeMark(), defaultHighlighterModel.getTextToHighlight(), defaultHighlighterModel.getTextAttributesKey(), defaultHighlighterModel.getId(), defaultHighlighterModel.getProperties(), startOffset, endOffset);
    }

    @Override
    public void initialize(@NotNull HighlighterModel model2, @NotNull RangeHighlighter highlighter2) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
        Intrinsics.checkNotNullParameter((Object)highlighter2, (String)"highlighter");
        if (!(model2 instanceof DefaultHighlighterModel)) {
            logger.warn("DefaultHighlighterModel was expected but got " + model2.getClass());
            return;
        }
        if (!(highlighter2 instanceof RangeHighlighterEx)) {
            logger.warn("RangeHighlighterEx was expected but got " + highlighter2.getClass());
            return;
        }
        if (((DefaultHighlighterModel)model2).getErased()) {
            ((RangeHighlighterEx)highlighter2).setTextAttributes(TextAttributes.ERASE_MARKER);
        }
        EditorColorsScheme editorColorsScheme = this.editorColorsManager.getGlobalScheme();
        Intrinsics.checkNotNullExpressionValue((Object)editorColorsScheme, (String)"getGlobalScheme(...)");
        EditorColorsScheme editorColorsScheme2 = editorColorsScheme;
        TextAttributesKeyModel textAttributesKeyModel = model2.getTextAttributesKey();
        if (textAttributesKeyModel != null) {
            object = textAttributesKeyModel;
            boolean bl = false;
            TextAttributesKey textAttributesKey = FrontendHighlighterAttributeCustomizer.Companion.getTextAttributesKey(editorColorsScheme2, (TextAttributesKeyModel)object, model2.getProperties().getAttributeId());
            if (textAttributesKey == null) {
                textAttributesKey = TextAttributesRegistrationHost.Companion.getInstance().getTextAttributesKey((TextAttributesKeyModel)object);
            }
            TextAttributesKey textAttributesKey2 = textAttributesKey;
            RainbowHighlighter.createLazyRainbowKeyIfNeed((TextAttributesKey)textAttributesKey2, (EditorColorsScheme)editorColorsScheme2);
            highlighter2.setTextAttributesKey(textAttributesKey2);
        }
        TextRange textRange = new TextRange(((RangeHighlighterEx)highlighter2).getStartOffset(), ((RangeHighlighterEx)highlighter2).getEndOffset());
        HighlightInfo highlightInfo = this.j(textRange, (DefaultHighlighterModel)model2);
        HighlightInfoModel highlightInfoModel = ((DefaultHighlighterModel)model2).getInfo();
        ProblemViewSuppressor.INSTANCE.setSuppressedInProblemView(highlighter2, highlightInfoModel != null ? highlightInfoModel.getSuppressOnErrorStripe() : false);
        if (highlightInfo != null) {
            Color color;
            highlightInfo.setHighlighter((RangeHighlighterEx)highlighter2);
            ((RangeHighlighterEx)highlighter2).setAfterEndOfLine(highlightInfo.isAfterEndOfLine());
            ((RangeHighlighterEx)highlighter2).setErrorStripeTooltip((Object)highlightInfo);
            if (highlightInfo.getSeverity().compareTo(HighlightSeverity.INFORMATION) > 0 && !Intrinsics.areEqual((Object)(object = HighlightersUtilKt.getErrorStripeColor(highlightInfo, editorColorsScheme2)), (Object)(color = highlighter2.getErrorStripeMarkColor(editorColorsScheme2)))) {
                highlighter2.setErrorStripeMarkColor((Color)object);
            }
        }
    }

    private final HighlightInfo j(TextRange textRange, DefaultHighlighterModel defaultHighlighterModel) {
        HighlightInfoModel highlightInfoModel = defaultHighlighterModel.getInfo();
        if (highlightInfoModel == null) {
            return null;
        }
        HighlightInfoModel highlightInfoModel2 = highlightInfoModel;
        boolean bl = defaultHighlighterModel.getAfterEndOfLine();
        Boolean bl2 = defaultHighlighterModel.getNeedsUpdateOnTyping();
        HighlightInfoType.HighlightInfoTypeImpl highlightInfoTypeImpl = TextAttributesRegistrationHost.Companion.getInstance().getHighlightInfoType(highlightInfoModel2.getType());
        ExternalSourceProblemGroup externalSourceProblemGroup = new ExternalSourceProblemGroup(highlightInfoModel2){
            final /* synthetic */ HighlightInfoModel $infoModel;
            {
                this.$infoModel = $infoModel;
            }

            @Nullable
            public String getExternalCheckName() {
                return this.$infoModel.getInspectionId();
            }

            @Nullable
            public String getProblemName() {
                return null;
            }
        };
        if (defaultHighlighterModel.getRestrictCalculateTooltip()) {
            return new FrontendEmptyTooltipHighlightInfo(null, (HighlightInfoType)highlightInfoTypeImpl, textRange, bl, bl2, (ProblemGroup)externalSourceProblemGroup);
        }
        return new FrontendAsyncTooltipHighlightInfo(null, (HighlightInfoType)highlightInfoTypeImpl, textRange, bl, bl2, defaultHighlighterModel.getId(), this.tooltipProvider, (ProblemGroup)externalSourceProblemGroup);
    }

    static {
        boolean bl = false;
        Logger logger = Logger.getInstance(FrontendDefaultHighlighterModelHandler.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        FrontendDefaultHighlighterModelHandler.logger = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/jetbrains/rdclient/daemon/highlighters/defaultHighlighters/FrontendDefaultHighlighterModelHandler$Companion;", "", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.rd.client"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

