/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdclient.daemon.highlighters;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.project.Project;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rdclient.daemon.FrontendMarkupAdapter;
import com.jetbrains.rdclient.daemon.FrontendMarkupAdapterListener;
import com.jetbrains.rdclient.daemon.FrontendMarkupContributor;
import com.jetbrains.rdclient.daemon.components.FrontendMarkupHost;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b&\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\u0017\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H&J\u0018\u0010\u0016\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0014\u001a\u00020\u0015H$J\u0016\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0014\u001a\u00020\u0015R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0017\u0010\f\u001a\b\u0012\u0004\u0012\u00020\t0\r8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001c"}, d2={"Lcom/jetbrains/rdclient/daemon/highlighters/MarkupListenerAggregator;", "", "project", "Lcom/intellij/openapi/project/Project;", "document", "Lcom/intellij/openapi/editor/Document;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/editor/Document;)V", "_listeners", "", "Lcom/jetbrains/rdclient/daemon/FrontendMarkupAdapterListener;", "getDocument", "()Lcom/intellij/openapi/editor/Document;", "listeners", "", "getListeners", "()Ljava/util/List;", "getProject", "()Lcom/intellij/openapi/project/Project;", "canHandleEditor", "", "editor", "Lcom/intellij/openapi/editor/impl/EditorImpl;", "createListener", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "handleEditor", "", "Companion", "intellij.rd.client"})
@SourceDebugExtension(value={"SMAP\nMarkupListenerAggregator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MarkupListenerAggregator.kt\ncom/jetbrains/rdclient/daemon/highlighters/MarkupListenerAggregator\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,43:1\n13#2:44\n*S KotlinDebug\n*F\n+ 1 MarkupListenerAggregator.kt\ncom/jetbrains/rdclient/daemon/highlighters/MarkupListenerAggregator\n*L\n17#1:44\n*E\n"})
public abstract class MarkupListenerAggregator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final Project project;
    @NotNull
    private final Document document;
    @NotNull
    private final List<FrontendMarkupAdapterListener> _listeners;
    @NotNull
    private static final Logger logger;

    public MarkupListenerAggregator(@Nullable Project project, @NotNull Document document) {
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        this.project = project;
        this.document = document;
        this._listeners = new ArrayList();
    }

    @Nullable
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final Document getDocument() {
        return this.document;
    }

    @NotNull
    public final List<FrontendMarkupAdapterListener> getListeners() {
        return this._listeners;
    }

    @NotNull
    protected abstract FrontendMarkupAdapterListener createListener(@NotNull Lifetime var1, @NotNull EditorImpl var2);

    public abstract boolean canHandleEditor(@NotNull EditorImpl var1);

    public final void handleEditor(@NotNull Lifetime lifetime, @NotNull EditorImpl editor2) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        FrontendMarkupAdapterListener frontendMarkupAdapterListener = this.createListener(lifetime, editor2);
        logger.debug("Creating " + frontendMarkupAdapterListener + " for editor: " + editor2);
        this._listeners.add(frontendMarkupAdapterListener);
        FrontendMarkupContributor frontendMarkupContributor = FrontendMarkupHost.Companion.getMarkupContributor(this.project, this.document);
        Intrinsics.checkNotNull((Object)frontendMarkupContributor);
        FrontendMarkupAdapter frontendMarkupAdapter = frontendMarkupContributor.getMarkupAdapter();
        frontendMarkupAdapterListener.afterBulkAdd(ArraysKt.toList((Object[])frontendMarkupAdapter.getAllHighlighters()));
        lifetime.onTermination((Function0)new Function0<Unit>(editor2, frontendMarkupAdapterListener, frontendMarkupAdapter, this){
            final /* synthetic */ EditorImpl $editor;
            final /* synthetic */ FrontendMarkupAdapterListener $markupAdapterListener;
            final /* synthetic */ FrontendMarkupAdapter $markupAdapter;
            final /* synthetic */ MarkupListenerAggregator this$0;
            {
                this.$editor = $editor;
                this.$markupAdapterListener = $markupAdapterListener;
                this.$markupAdapter = $markupAdapter;
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                if (!this.$editor.isDisposed()) {
                    this.$markupAdapterListener.beforeBulkRemove(ArraysKt.toList((Object[])this.$markupAdapter.getAllHighlighters()));
                }
                MarkupListenerAggregator.access$get_listeners$p(this.this$0).remove(this.$markupAdapterListener);
                MarkupListenerAggregator.access$getLogger$cp().debug("Removing " + this.$markupAdapterListener + " for editor: " + this.$editor);
            }
        });
        frontendMarkupAdapter.addListener(lifetime, frontendMarkupAdapterListener);
    }

    public static final /* synthetic */ List access$get_listeners$p(MarkupListenerAggregator $this) {
        return $this._listeners;
    }

    public static final /* synthetic */ Logger access$getLogger$cp() {
        return logger;
    }

    static {
        boolean bl = false;
        Logger logger = Logger.getInstance(MarkupListenerAggregator.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        MarkupListenerAggregator.logger = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/jetbrains/rdclient/daemon/highlighters/MarkupListenerAggregator$Companion;", "", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.rd.client"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

