/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdclient.daemon.components;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.analysis.FileHighlightingSetting;
import com.intellij.codeInsight.daemon.impl.analysis.FileHighlightingSettingListener;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightingSettingsPerFile;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.client.ClientAppSession;
import com.intellij.openapi.client.ClientProjectSession;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.impl.EditorHistoryManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SingleRootFileViewProvider;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.Topic;
import com.jetbrains.rd.ide.document.DocumentSynchronizer;
import com.jetbrains.rd.ide.document.VersionsExKt;
import com.jetbrains.rd.ide.model.BackendDaemonStateEnum;
import com.jetbrains.rd.ide.model.HighlightingSettingsModel;
import com.jetbrains.rd.ide.model.RdDaemonModel;
import com.jetbrains.rd.ide.model.RdDocumentId;
import com.jetbrains.rd.ide.model.RdDocumentModel;
import com.jetbrains.rd.ide.model.RdMarkupKey;
import com.jetbrains.rd.ide.model.RdMarkupModel;
import com.jetbrains.rd.ide.model.RdMarkupModelBase;
import com.jetbrains.rd.ide.model.RdProjectId;
import com.jetbrains.rd.platform.ProjectUtilKt;
import com.jetbrains.rd.platform.daemon.ModelUtilKt;
import com.jetbrains.rd.platform.diagnostics.StructuredLoggingKt;
import com.jetbrains.rd.platform.util.ListenersKt;
import com.jetbrains.rd.util.Boxed;
import com.jetbrains.rd.util.CollectionExKt;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.reactive.BoolPropertyExKt;
import com.jetbrains.rd.util.reactive.IOptProperty;
import com.jetbrains.rd.util.reactive.IOptPropertyView;
import com.jetbrains.rd.util.reactive.ISource;
import com.jetbrains.rd.util.reactive.IViewable;
import com.jetbrains.rd.util.reactive.InterfacesKt;
import com.jetbrains.rd.util.reactive.OptProperty;
import com.jetbrains.rd.util.reactive.PropertyCombinatorsKt;
import com.jetbrains.rd.util.reactive.SourceExKt;
import com.jetbrains.rdclient.client.FrontendSessionsUtilKt;
import com.jetbrains.rdclient.daemon.DaemonKind;
import com.jetbrains.rdclient.daemon.FrontendDaemon;
import com.jetbrains.rdclient.daemon.FrontendDaemonModel;
import com.jetbrains.rdclient.daemon.FrontendMarkupSuppressor;
import com.jetbrains.rdclient.daemon.MarkupSuppressionKind;
import com.jetbrains.rdclient.daemon.components.FrontendDaemonHost;
import com.jetbrains.rdclient.daemon.components.FrontendMarkupHost;
import com.jetbrains.rdclient.daemon.components.statistics.DaemonRedCodeLogUsageCollector;
import com.jetbrains.rdclient.document.DocumentExKt;
import com.jetbrains.rdclient.document.FrontendDocumentHost;
import com.jetbrains.rdclient.document.FrontendDocumentHostListener;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KMutableProperty1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u001b2\u00020\u0001:\u0002\u001b\u001cB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\t\u001a\u00020\nJ\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J \u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0010\u0010\u0016\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0018\u0010\u0019\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\fH\u0016R\u0014\u0010\u0005\u001a\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/jetbrains/rdclient/daemon/components/FrontendDaemonHost;", "Lcom/jetbrains/rdclient/daemon/FrontendDaemon;", "session", "Lcom/intellij/openapi/client/ClientProjectSession;", "(Lcom/intellij/openapi/client/ClientProjectSession;)V", "project", "Lcom/intellij/openapi/project/Project;", "j", "()Lcom/intellij/openapi/project/Project;", "dropAllBackendHighlighters", "", "getHighlightingSetting", "Lcom/intellij/codeInsight/daemon/impl/analysis/FileHighlightingSetting;", "psiFile", "Lcom/intellij/psi/PsiFile;", "j", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "document", "Lcom/intellij/openapi/editor/Document;", "markup", "Lcom/jetbrains/rd/ide/model/RdMarkupModel;", "restart", "daemon", "Lcom/jetbrains/rdclient/daemon/DaemonKind;", "setHighlightingSetting", "setting", "Companion", "MyListener", "intellij.rd.client"})
@SourceDebugExtension(value={"SMAP\nFrontendDaemonHost.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FrontendDaemonHost.kt\ncom/jetbrains/rdclient/daemon/components/FrontendDaemonHost\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,201:1\n13#2:202\n*S KotlinDebug\n*F\n+ 1 FrontendDaemonHost.kt\ncom/jetbrains/rdclient/daemon/components/FrontendDaemonHost\n*L\n49#1:202\n*E\n"})
public final class FrontendDaemonHost
implements FrontendDaemon {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ClientProjectSession session;
    @NotNull
    private static final Logger logger;
    @NotNull
    private static final Key<Map<Document, FrontendDaemonModel>> KEY;

    public FrontendDaemonHost(@NotNull ClientProjectSession session) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        this.session = session;
    }

    private final Project j() {
        return this.session.getProject();
    }

    private final void j(Lifetime lifetime, Document document, RdMarkupModel rdMarkupModel) {
        VirtualFile virtualFile = FileDocumentManager.getInstance().getFile(document);
        if (virtualFile == null) {
            return;
        }
        VirtualFile virtualFile2 = virtualFile;
        if (EditorHistoryManager.Companion.getInstance(this.j()).hasBeenOpen(virtualFile2)) {
            return;
        }
        RdDocumentId rdDocumentId = DocumentExKt.getDocumentId(document, this.j());
        if (rdDocumentId == null) {
            return;
        }
        RdDocumentId rdDocumentId2 = rdDocumentId;
        DocumentSynchronizer documentSynchronizer2 = FrontendDocumentHost.Companion.getInstance(this.session.getAppSession()).getSynchronizer(rdDocumentId2);
        if (documentSynchronizer2 == null) {
            return;
        }
        DocumentSynchronizer documentSynchronizer3 = documentSynchronizer2;
        if (VersionsExKt.moreThan(documentSynchronizer3.getVersion(), 1)) {
            return;
        }
        SourceExKt.adviseUntil((ISource)((ISource)rdMarkupModel.getDaemon().getState()), (Lifetime)lifetime, (Function1)((Function1)new Function1<BackendDaemonStateEnum, Boolean>(documentSynchronizer3, this, document){
            final /* synthetic */ DocumentSynchronizer $documentSynchronizer;
            final /* synthetic */ FrontendDaemonHost this$0;
            final /* synthetic */ Document $document;
            {
                this.$documentSynchronizer = $documentSynchronizer;
                this.this$0 = $receiver;
                this.$document = $document;
                super(1);
            }

            /*
             * Unable to fully structure code
             */
            @NotNull
            public final Boolean invoke(@NotNull BackendDaemonStateEnum it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                switch (reportDaemonState.WhenMappings.$EnumSwitchMapping$0[it.ordinal()]) {
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: {
                        v0 = true;
                        break;
                    }
                    case 5: 
                    case 6: 
                    case 7: {
                        v0 = false;
                        break;
                    }
                    case 8: {
                        if (VersionsExKt.moreThan(this.$documentSynchronizer.getVersion(), 1)) {
                            return true;
                        }
                        v1 = FrontendMarkupHost.Companion.getMarkupContributor(FrontendDaemonHost.access$getProject(this.this$0), this.$document);
                        if (v1 == null) {
                            return true;
                        }
                        var2_2 = v1;
                        var3_3 = var2_2.getMarkupAdapter();
                        var5_4 = var3_3.getAllHighlighters();
                        var6_5 = false;
                        var8_7 = var5_4.length;
                        for (var7_6 = 0; var7_6 < var8_7; ++var7_6) {
                            var10_9 = var9_8 = var5_4[var7_6];
                            var11_10 = false;
                            v2 = HighlightInfo.fromRangeHighlighter((RangeHighlighter)((RangeHighlighter)var10_9));
                            if (!Intrinsics.areEqual((Object)(v2 != null ? v2.getSeverity() : null), (Object)HighlightSeverity.ERROR)) continue;
                            v3 = true;
                            ** GOTO lbl28
                        }
                        v3 = var4_11 = false;
lbl28:
                        // 2 sources

                        if (var4_11) {
                            DaemonRedCodeLogUsageCollector.INSTANCE.log(FrontendDaemonHost.access$getProject(this.this$0));
                        }
                        v0 = true;
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
                return v0;
            }
        }));
    }

    @Override
    public void setHighlightingSetting(@NotNull PsiFile psiFile, @NotNull FileHighlightingSetting setting) {
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        Intrinsics.checkNotNullParameter((Object)setting, (String)"setting");
        HighlightingSettingsPerFile highlightingSettingsPerFile = HighlightingSettingsPerFile.getInstance((Project)this.j());
        if (highlightingSettingsPerFile.getHighlightingSettingForRoot((PsiElement)psiFile) == setting) {
            return;
        }
        highlightingSettingsPerFile.setHighlightingSettingForRoot((PsiElement)psiFile, setting);
        InjectedLanguageManager.getInstance((Project)this.j()).dropFileCaches(psiFile);
        this.restart(DaemonKind.Frontend);
    }

    @Override
    @NotNull
    public FileHighlightingSetting getHighlightingSetting(@NotNull PsiFile psiFile) {
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        FileHighlightingSetting fileHighlightingSetting = HighlightingSettingsPerFile.getInstance((Project)this.j()).getHighlightingSettingForRoot((PsiElement)psiFile);
        Intrinsics.checkNotNullExpressionValue((Object)fileHighlightingSetting, (String)"getHighlightingSettingForRoot(...)");
        return fileHighlightingSetting;
    }

    @Override
    public void restart(@NotNull DaemonKind daemon) {
        Intrinsics.checkNotNullParameter((Object)((Object)daemon), (String)"daemon");
        if (daemon.isFrontendInvolved()) {
            DaemonCodeAnalyzer.getInstance((Project)this.j()).restart();
        }
        if (daemon.isBackendInvolved()) {
            InterfacesKt.fire(FrontendSessionsUtilKt.getProtocolModel(FrontendSessionsUtilKt.getFrontendProjectSession(this.j())).getDaemon().getInvalidateAll());
        }
    }

    public final void dropAllBackendHighlighters() {
        InterfacesKt.fire(FrontendSessionsUtilKt.getProtocolModel(FrontendSessionsUtilKt.getFrontendProjectSession(this.j())).getDaemon().getDropAllHighlighters());
    }

    public static final /* synthetic */ Logger access$getLogger$cp() {
        return logger;
    }

    public static final /* synthetic */ void access$reportDaemonState(FrontendDaemonHost $this, Lifetime lifetime, Document document, RdMarkupModel markup) {
        $this.j(lifetime, document, markup);
    }

    public static final /* synthetic */ Project access$getProject(FrontendDaemonHost $this) {
        return $this.j();
    }

    static {
        boolean bl = false;
        Logger logger = Logger.getInstance(FrontendDaemonHost.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        FrontendDaemonHost.logger = logger;
        KEY = new Key("FRONTEND_DAEMON_KEY");
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0018\u0010\u0010\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0006J\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017J\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0011\u001a\u00020\u0012J(\u0010\u0018\u001a\u00020\u00192\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u001a\u001a\u00020\u0007H\u0002R \u0010\u0003\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/jetbrains/rdclient/daemon/components/FrontendDaemonHost$Companion;", "", "()V", "KEY", "Lcom/intellij/openapi/util/Key;", "", "Lcom/intellij/openapi/editor/Document;", "Lcom/jetbrains/rdclient/daemon/FrontendDaemonModel;", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "createMarkupSuppressor", "Lcom/jetbrains/rdclient/daemon/FrontendMarkupSuppressor;", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "daemonModel", "Lcom/jetbrains/rd/ide/model/RdDaemonModel;", "getFrontendDaemonModel", "project", "Lcom/intellij/openapi/project/Project;", "document", "getInstance", "Lcom/jetbrains/rdclient/daemon/components/FrontendDaemonHost;", "session", "Lcom/intellij/openapi/client/ClientProjectSession;", "j", "", "contributor", "intellij.rd.client"})
    @SourceDebugExtension(value={"SMAP\nFrontendDaemonHost.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FrontendDaemonHost.kt\ncom/jetbrains/rdclient/daemon/components/FrontendDaemonHost$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 3 UserDataHolderEx.kt\ncom/intellij/openapi/util/UserDataHolderExKt\n*L\n1#1,201:1\n31#2,2:202\n7#3,6:204\n*S KotlinDebug\n*F\n+ 1 FrontendDaemonHost.kt\ncom/jetbrains/rdclient/daemon/components/FrontendDaemonHost$Companion\n*L\n52#1:202,2\n61#1:204,6\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final FrontendDaemonHost getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            return this.getInstance(FrontendSessionsUtilKt.getFrontendProjectSession(project));
        }

        @NotNull
        public final FrontendDaemonHost getInstance(@NotNull ClientProjectSession session) {
            Intrinsics.checkNotNullParameter((Object)session, (String)"session");
            ComponentManager componentManager = (ComponentManager)session;
            boolean bl = false;
            Class<FrontendDaemonHost> clazz = FrontendDaemonHost.class;
            Object object = componentManager.getService(clazz);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)componentManager, clazz);
            }
            return (FrontendDaemonHost)object;
        }

        @Nullable
        public final FrontendDaemonModel getFrontendDaemonModel(@NotNull Project project, @NotNull Document document) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)document, (String)"document");
            Map map = (Map)project.getUserData(KEY);
            return map != null ? (FrontendDaemonModel)map.get(document) : null;
        }

        private final void j(Lifetime lifetime, Project project, Document document, FrontendDaemonModel frontendDaemonModel) {
            UserDataHolder userDataHolder = (UserDataHolder)project;
            Key key = KEY;
            boolean bl = false;
            Object object = userDataHolder.getUserData(key);
            Object object2 = object;
            if (object2 == null) {
                boolean bl2 = false;
                Map map = new LinkedHashMap();
                userDataHolder.putUserData(key, (Object)map);
                object2 = map;
            }
            Map map = (Map)object2;
            CollectionExKt.addUnique((Map)map, (Lifetime)lifetime, (Object)document, (Object)frontendDaemonModel);
        }

        @NotNull
        public final FrontendMarkupSuppressor createMarkupSuppressor(@NotNull Lifetime lifetime, @NotNull RdDaemonModel daemonModel) {
            FrontendMarkupSuppressor frontendMarkupSuppressor;
            Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
            Intrinsics.checkNotNullParameter((Object)((Object)daemonModel), (String)"daemonModel");
            IOptPropertyView iOptPropertyView = PropertyCombinatorsKt.map((IOptPropertyView)((IOptPropertyView)daemonModel.getHighlightingProgressState()), (Function1)createMarkupSuppressor.isLocalStageRunning.1.INSTANCE);
            IOptPropertyView iOptPropertyView2 = PropertyCombinatorsKt.map((IOptPropertyView)((IOptPropertyView)daemonModel.getState()), (Function1)createMarkupSuppressor.isDaemonStateInvalidated.1.INSTANCE);
            IOptPropertyView iOptPropertyView3 = BoolPropertyExKt.or((IOptPropertyView)iOptPropertyView, (IOptPropertyView)iOptPropertyView2);
            FrontendMarkupSuppressor frontendMarkupSuppressor2 = frontendMarkupSuppressor = new FrontendMarkupSuppressor(lifetime);
            boolean bl = false;
            frontendMarkupSuppressor2.addSuppressionRule(lifetime, MarkupSuppressionKind.DELETION, (IViewable<Boolean>)((IViewable)iOptPropertyView3));
            return frontendMarkupSuppressor;
        }

        public static final /* synthetic */ void access$putFrontendDaemonModel(Companion $this, Lifetime lifetime, Project project, Document document, FrontendDaemonModel contributor) {
            $this.j(lifetime, project, document, contributor);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J0\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016\u00a8\u0006\u000f"}, d2={"Lcom/jetbrains/rdclient/daemon/components/FrontendDaemonHost$MyListener;", "Lcom/jetbrains/rdclient/document/FrontendDocumentHostListener;", "()V", "documentBound", "", "documentLifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "session", "Lcom/intellij/openapi/client/ClientAppSession;", "documentId", "Lcom/jetbrains/rd/ide/model/RdDocumentId;", "documentModel", "Lcom/jetbrains/rd/ide/model/RdDocumentModel;", "document", "Lcom/intellij/openapi/editor/Document;", "intellij.rd.client"})
    public static final class MyListener
    implements FrontendDocumentHostListener {
        @Override
        public void documentBound(@NotNull Lifetime documentLifetime, @NotNull ClientAppSession session, @NotNull RdDocumentId documentId, @NotNull RdDocumentModel documentModel, @NotNull Document document) {
            Intrinsics.checkNotNullParameter((Object)documentLifetime, (String)"documentLifetime");
            Intrinsics.checkNotNullParameter((Object)session, (String)"session");
            Intrinsics.checkNotNullParameter((Object)documentId, (String)"documentId");
            Intrinsics.checkNotNullParameter((Object)((Object)documentModel), (String)"documentModel");
            Intrinsics.checkNotNullParameter((Object)document, (String)"document");
            com.jetbrains.rd.ide.document.DocumentExKt.getMarkups(documentModel).view(documentLifetime, (Function3)new Function3<Lifetime, RdMarkupKey, RdMarkupModelBase, Unit>(document, documentId){
                final /* synthetic */ Document $document;
                final /* synthetic */ RdDocumentId $documentId;
                {
                    this.$document = $document;
                    this.$documentId = $documentId;
                    super(3);
                }

                public final void invoke(@NotNull Lifetime markupLifetime, @NotNull RdMarkupKey key, @NotNull RdMarkupModelBase markup) {
                    Intrinsics.checkNotNullParameter((Object)markupLifetime, (String)"markupLifetime");
                    Intrinsics.checkNotNullParameter((Object)key, (String)"key");
                    Intrinsics.checkNotNullParameter((Object)((Object)markup), (String)"markup");
                    if (!(markup instanceof RdMarkupModel)) {
                        return;
                    }
                    long l = System.nanoTime();
                    RdDaemonModel rdDaemonModel = ((RdMarkupModel)markup).getDaemon();
                    rdDaemonModel.getState().advise(markupLifetime, (Function1)new Function1<BackendDaemonStateEnum, Unit>(this.$documentId){
                        final /* synthetic */ RdDocumentId $documentId;
                        {
                            this.$documentId = $documentId;
                            super(1);
                        }

                        public final void invoke(@NotNull BackendDaemonStateEnum it) {
                            Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
                            FrontendDaemonHost.access$getLogger$cp().debug("Daemon state for " + com.jetbrains.rd.ide.document.DocumentExKt.toDebugString(this.$documentId) + " -> " + it);
                        }
                    });
                    RdProjectId rdProjectId = key.getProjectId();
                    if (rdProjectId == null || (rdProjectId = ProjectUtilKt.toProject(rdProjectId)) == null) {
                        return;
                    }
                    RdProjectId rdProjectId2 = rdProjectId;
                    Ref.ObjectRef objectRef = new Ref.ObjectRef();
                    PsiFile psiFile = PsiDocumentManager.getInstance((Project)rdProjectId2).getPsiFile(this.$document);
                    if (psiFile == null) {
                        return;
                    }
                    objectRef.element = psiFile;
                    IOptProperty<HighlightingSettingsModel> iOptProperty = rdDaemonModel.getSettings();
                    Boxed boxed = new Boxed((Object)false);
                    iOptProperty.advise(markupLifetime, (Function1)new Function1<HighlightingSettingsModel, Unit>((Ref.ObjectRef<PsiFile>)objectRef, (Boxed<Boolean>)boxed, this.$documentId, (Project)rdProjectId2){
                        final /* synthetic */ Ref.ObjectRef<PsiFile> $psiFile;
                        final /* synthetic */ Boxed<Boolean> $guard;
                        final /* synthetic */ RdDocumentId $documentId;
                        final /* synthetic */ Project $project;
                        {
                            this.$psiFile = $psiFile;
                            this.$guard = $guard;
                            this.$documentId = $documentId;
                            this.$project = $project;
                            super(1);
                        }

                        public final void invoke(@NotNull HighlightingSettingsModel it) {
                            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                            if (ModelUtilKt.fromModel(it) == FileHighlightingSetting.FORCE_HIGHLIGHTING && SingleRootFileViewProvider.isTooLargeForIntelligence((VirtualFile)((PsiFile)this.$psiFile.element).getVirtualFile())) {
                                SingleRootFileViewProvider.doNotCheckFileSizeLimit((VirtualFile)((PsiFile)this.$psiFile.element).getVirtualFile());
                                VirtualFile[] virtualFileArray = new VirtualFile[]{((PsiFile)this.$psiFile.element).getVirtualFile()};
                                FileDocumentManager.getInstance().reloadFiles(virtualFileArray);
                            }
                            if (((Boolean)this.$guard.getValue()).booleanValue()) {
                                return;
                            }
                            FrontendDaemonHost.access$getLogger$cp().debug("Daemon settings changed from protocol. " + this.$documentId + " -> " + it);
                            FrontendDaemonHost.Companion.getInstance(this.$project).setHighlightingSetting((PsiFile)this.$psiFile.element, ModelUtilKt.fromModel(it));
                        }
                    });
                    OptProperty optProperty = new OptProperty();
                    markupLifetime.onTermination((Function0)new Function0<Unit>((OptProperty<BackendDaemonStateEnum>)optProperty){
                        final /* synthetic */ OptProperty<BackendDaemonStateEnum> $frontendDaemonState;
                        {
                            this.$frontendDaemonState = $frontendDaemonState;
                            super(0);
                        }

                        public final void invoke() {
                            this.$frontendDaemonState.set((Object)((Object)BackendDaemonStateEnum.UNSUPPORTED));
                        }
                    });
                    MessageBus messageBus = rdProjectId2.getMessageBus();
                    Intrinsics.checkNotNullExpressionValue((Object)messageBus, (String)"getMessageBus(...)");
                    Topic topic = DaemonCodeAnalyzer.DAEMON_EVENT_TOPIC;
                    Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"DAEMON_EVENT_TOPIC");
                    ListenersKt.subscribe(messageBus, markupLifetime, topic, new DaemonCodeAnalyzer.DaemonListener((OptProperty<BackendDaemonStateEnum>)optProperty, this.$document, l){
                        final /* synthetic */ OptProperty<BackendDaemonStateEnum> $frontendDaemonState;
                        final /* synthetic */ Document $document;
                        final /* synthetic */ long $daemonStartTime;
                        {
                            this.$frontendDaemonState = $frontendDaemonState;
                            this.$document = $document;
                            this.$daemonStartTime = $daemonStartTime;
                        }

                        public void daemonStarting(@NotNull Collection<? extends FileEditor> fileEditors) {
                            boolean bl;
                            block4: {
                                Intrinsics.checkNotNullParameter(fileEditors, (String)"fileEditors");
                                Iterable iterable = fileEditors;
                                Document document = this.$document;
                                boolean bl2 = false;
                                if (((Collection)iterable).isEmpty()) {
                                    bl = false;
                                } else {
                                    for (T t : iterable) {
                                        FileEditor fileEditor = (FileEditor)t;
                                        boolean bl3 = false;
                                        TextEditor textEditor = fileEditor instanceof TextEditor ? (TextEditor)fileEditor : null;
                                        if (!Intrinsics.areEqual((Object)(textEditor != null && (textEditor = textEditor.getEditor()) != null ? textEditor.getDocument() : null), (Object)document)) continue;
                                        bl = true;
                                        break block4;
                                    }
                                    bl = false;
                                }
                            }
                            if (bl) {
                                this.$frontendDaemonState.set((Object)((Object)BackendDaemonStateEnum.IN_PROGRESS_LOCAL));
                            }
                        }

                        public void daemonFinished(@NotNull Collection<? extends FileEditor> fileEditors) {
                            boolean bl;
                            block4: {
                                Intrinsics.checkNotNullParameter(fileEditors, (String)"fileEditors");
                                Iterable iterable = fileEditors;
                                Document document = this.$document;
                                boolean bl2 = false;
                                if (((Collection)iterable).isEmpty()) {
                                    bl = false;
                                } else {
                                    for (T t : iterable) {
                                        FileEditor fileEditor = (FileEditor)t;
                                        boolean bl3 = false;
                                        TextEditor textEditor = fileEditor instanceof TextEditor ? (TextEditor)fileEditor : null;
                                        if (!Intrinsics.areEqual((Object)(textEditor != null && (textEditor = textEditor.getEditor()) != null ? textEditor.getDocument() : null), (Object)document)) continue;
                                        bl = true;
                                        break block4;
                                    }
                                    bl = false;
                                }
                            }
                            if (bl) {
                                this.$frontendDaemonState.set((Object)((Object)BackendDaemonStateEnum.UP_TO_DATE));
                            }
                            StructuredLoggingKt.logMeasuredTime$default(FrontendDaemonHost.access$getLogger$cp(), "FrontendDaemonHost", (long)((double)(System.nanoTime() - this.$daemonStartTime) / 1000000.0), null, 4, null);
                        }
                    });
                    com.jetbrains.rdclient.daemon.components.FrontendDaemonHost$Companion.access$putFrontendDaemonModel(FrontendDaemonHost.Companion, markupLifetime, (Project)rdProjectId2, this.$document, new FrontendDaemonModel((IOptPropertyView<? extends BackendDaemonStateEnum>)((IOptPropertyView)optProperty)));
                    MessageBus messageBus2 = rdProjectId2.getMessageBus();
                    Intrinsics.checkNotNullExpressionValue((Object)messageBus2, (String)"getMessageBus(...)");
                    Topic topic2 = FileHighlightingSettingListener.SETTING_CHANGE;
                    Intrinsics.checkNotNullExpressionValue((Object)topic2, (String)"SETTING_CHANGE");
                    ListenersKt.subscribe(messageBus2, markupLifetime, topic2, (arg_0, arg_1) -> documentBound.1.j(objectRef, (Project)rdProjectId2, this.$document, boxed, iOptProperty, this.$documentId, rdDaemonModel, arg_0, arg_1));
                    FrontendDaemonHost.access$reportDaemonState(FrontendDaemonHost.Companion.getInstance((Project)rdProjectId2), markupLifetime, this.$document, (RdMarkupModel)markup);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                private static final void j(Ref.ObjectRef objectRef, Project project, Document document, Boxed boxed, IOptProperty iOptProperty, RdDocumentId rdDocumentId, RdDaemonModel rdDaemonModel, PsiElement psiElement, FileHighlightingSetting fileHighlightingSetting) {
                    Intrinsics.checkNotNullParameter((Object)objectRef, (String)"$psiFile");
                    Intrinsics.checkNotNullParameter((Object)project, (String)"$project");
                    Intrinsics.checkNotNullParameter((Object)document, (String)"$document");
                    Intrinsics.checkNotNullParameter((Object)boxed, (String)"$guard");
                    Intrinsics.checkNotNullParameter((Object)iOptProperty, (String)"$settingsModel");
                    Intrinsics.checkNotNullParameter((Object)rdDocumentId, (String)"$documentId");
                    Intrinsics.checkNotNullParameter((Object)((Object)rdDaemonModel), (String)"$daemon");
                    Intrinsics.checkNotNullParameter((Object)psiElement, (String)"root");
                    Intrinsics.checkNotNullParameter((Object)fileHighlightingSetting, (String)"change");
                    if (!((PsiFile)objectRef.element).isValid()) {
                        PsiFile psiFile = PsiDocumentManager.getInstance((Project)project).getPsiFile(document);
                        if (psiFile == null) {
                            return;
                        }
                        objectRef.element = psiFile;
                    }
                    if (Intrinsics.areEqual((Object)psiElement.getContainingFile(), (Object)objectRef.element)) {
                        Boxed boxed2 = boxed;
                        KMutableProperty1 kMutableProperty1 = (KMutableProperty1)documentBound.5.1.INSTANCE;
                        boolean bl = true;
                        boolean bl2 = false;
                        if (!((Boolean)kMutableProperty1.get((Object)boxed2) == false)) {
                            String string = "Failed requirement.";
                            throw new IllegalArgumentException(string.toString());
                        }
                        try {
                            kMutableProperty1.set((Object)boxed2, (Object)true);
                            boolean bl3 = false;
                            HighlightingSettingsModel highlightingSettingsModel = (HighlightingSettingsModel)iOptProperty.getValueOrNull();
                            HighlightingSettingsModel highlightingSettingsModel2 = ModelUtilKt.toModel(fileHighlightingSetting);
                            HighlightingSettingsModel highlightingSettingsModel3 = highlightingSettingsModel;
                            if ((highlightingSettingsModel3 != null ? highlightingSettingsModel3.getState() : null) != highlightingSettingsModel2.getState()) {
                                FrontendDaemonHost.access$getLogger$cp().debug("Daemon settings changed from frontend. " + rdDocumentId + " -> " + highlightingSettingsModel2);
                                iOptProperty.set((Object)highlightingSettingsModel2);
                                rdDaemonModel.getStateChanged().fire((Object)((Object)highlightingSettingsModel2.getState()));
                            }
                            Unit unit = Unit.INSTANCE;
                        }
                        finally {
                            kMutableProperty1.set((Object)boxed2, (Object)false);
                        }
                    }
                }
            });
        }
    }
}

