/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdclient.daemon;

import com.intellij.openapi.client.ClientAppSession;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.util.TextRange;
import com.jetbrains.rd.ide.document.DocumentSynchronizer;
import com.jetbrains.rd.ide.model.AbstractDocumentVersion;
import com.jetbrains.rd.ide.model.ConstrainedInlayHighlighterModel;
import com.jetbrains.rd.ide.model.HighlighterModel;
import com.jetbrains.rd.ide.model.HintInlayHighlighterModel;
import com.jetbrains.rd.ide.model.HorizontalConstraintsModel;
import com.jetbrains.rd.ide.model.InlayConstraintsModel;
import com.jetbrains.rd.platform.util.IDocumentRangeShifter;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rdclient.daemon.CompoundHighlighterModelsHandler;
import com.jetbrains.rdclient.daemon.util.HighlightersUtilKt;
import com.jetbrains.rdclient.document.DocumentExKt;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 $2\u00020\u0001:\u0001$B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0010\u0010\u001b\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u0019\u001a\u00020\u001aJ\u0012\u0010\u001c\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u001d\u001a\u00020\u001aH\u0002J\u0006\u0010\u001e\u001a\u00020\u001fJ\u001a\u0010 \u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u001d\u001a\u00020\u001aH\u0002J\u0013\u0010!\u001a\u0004\u0018\u00010\u0016*\u00020\"H\u0002\u00a2\u0006\u0002\u0010#R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u000b\u001a\u00020\f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/jetbrains/rdclient/daemon/HighlighterRangeRepairer;", "", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "session", "Lcom/intellij/openapi/client/ClientAppSession;", "document", "Lcom/intellij/openapi/editor/Document;", "compoundHandler", "Lcom/jetbrains/rdclient/daemon/CompoundHighlighterModelsHandler;", "(Lcom/jetbrains/rd/util/lifetime/Lifetime;Lcom/intellij/openapi/client/ClientAppSession;Lcom/intellij/openapi/editor/Document;Lcom/jetbrains/rdclient/daemon/CompoundHighlighterModelsHandler;)V", "documentSynchronizer", "Lcom/jetbrains/rd/ide/document/DocumentSynchronizer;", "j", "()Lcom/jetbrains/rd/ide/document/DocumentSynchronizer;", "documentSynchronizer$delegate", "Lkotlin/Lazy;", "getLifetime", "()Lcom/jetbrains/rd/util/lifetime/Lifetime;", "shifter", "Lcom/jetbrains/rd/platform/util/IDocumentRangeShifter;", "N", "", "correctedRange", "Lcom/intellij/openapi/util/TextRange;", "model", "Lcom/jetbrains/rd/ide/model/HighlighterModel;", "repair", "j", "h", "shrinkHistory", "", "j", "j", "Lcom/jetbrains/rd/ide/model/ConstrainedInlayHighlighterModel;", "(Lcom/jetbrains/rd/ide/model/ConstrainedInlayHighlighterModel;)Ljava/lang/Boolean;", "Companion", "intellij.rd.client"})
@SourceDebugExtension(value={"SMAP\nHighlighterRangeRepairer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HighlighterRangeRepairer.kt\ncom/jetbrains/rdclient/daemon/HighlighterRangeRepairer\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,87:1\n13#2:88\n*S KotlinDebug\n*F\n+ 1 HighlighterRangeRepairer.kt\ncom/jetbrains/rdclient/daemon/HighlighterRangeRepairer\n*L\n21#1:88\n*E\n"})
public final class HighlighterRangeRepairer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Lifetime lifetime;
    @NotNull
    private final Document document;
    @NotNull
    private final CompoundHighlighterModelsHandler compoundHandler;
    @NotNull
    private final Lazy documentSynchronizer$delegate;
    @NotNull
    private final IDocumentRangeShifter shifter;
    @NotNull
    private static final Logger LOG;

    public HighlighterRangeRepairer(@NotNull Lifetime lifetime, @NotNull ClientAppSession session, @NotNull Document document, @NotNull CompoundHighlighterModelsHandler compoundHandler) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        Intrinsics.checkNotNullParameter((Object)compoundHandler, (String)"compoundHandler");
        this.lifetime = lifetime;
        this.document = document;
        this.compoundHandler = compoundHandler;
        this.documentSynchronizer$delegate = LazyKt.lazy((Function0)((Function0)new Function0<DocumentSynchronizer>(this, session){
            final /* synthetic */ HighlighterRangeRepairer this$0;
            final /* synthetic */ ClientAppSession $session;
            {
                this.this$0 = $receiver;
                this.$session = $session;
                super(0);
            }

            @NotNull
            public final DocumentSynchronizer invoke() {
                DocumentSynchronizer documentSynchronizer2 = DocumentExKt.getDocumentSynchronizer(HighlighterRangeRepairer.access$getDocument$p(this.this$0), this.$session);
                Intrinsics.checkNotNull((Object)documentSynchronizer2);
                return documentSynchronizer2;
            }
        }));
        this.shifter = this.j().createRangeShifter();
    }

    @NotNull
    public final Lifetime getLifetime() {
        return this.lifetime;
    }

    private final DocumentSynchronizer j() {
        Lazy lazy = this.documentSynchronizer$delegate;
        return (DocumentSynchronizer)lazy.getValue();
    }

    @Nullable
    public final HighlighterModel repair(@NotNull HighlighterModel model2) {
        Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
        if (model2.getId() < 0L) {
            return model2;
        }
        TextRange textRange = this.j(model2);
        if (textRange == null || !this.j(textRange, model2)) {
            return null;
        }
        if (textRange.getStartOffset() == model2.getStart() && textRange.getEndOffset() == model2.getEnd()) {
            return model2;
        }
        return this.compoundHandler.move(textRange.getStartOffset(), textRange.getEndOffset(), model2);
    }

    private final TextRange j(HighlighterModel highlighterModel) {
        AbstractDocumentVersion abstractDocumentVersion = highlighterModel.getDocumentVersion();
        if (highlighterModel.getStart() == highlighterModel.getEnd()) {
            boolean bl;
            HintInlayHighlighterModel hintInlayHighlighterModel = highlighterModel instanceof HintInlayHighlighterModel ? (HintInlayHighlighterModel)highlighterModel : null;
            if (hintInlayHighlighterModel != null) {
                bl = hintInlayHighlighterModel.getRelatesToPrecedingText();
            } else {
                ConstrainedInlayHighlighterModel constrainedInlayHighlighterModel = highlighterModel instanceof ConstrainedInlayHighlighterModel ? (ConstrainedInlayHighlighterModel)highlighterModel : null;
                Boolean bl2 = constrainedInlayHighlighterModel != null ? this.j(constrainedInlayHighlighterModel) : null;
                bl = bl2 != null ? bl2 : false;
            }
            boolean bl3 = bl;
            int n = this.shifter.shiftOnePoint(abstractDocumentVersion, highlighterModel.getStart(), bl3);
            return n == -1 ? null : new TextRange(n, n);
        }
        TextRange textRange = new TextRange(highlighterModel.getStart(), highlighterModel.getEnd());
        boolean bl = highlighterModel.getProperties().isVerifiable();
        return this.shifter.shiftRange(abstractDocumentVersion, textRange, bl, highlighterModel.isGreedyToLeft(), highlighterModel.isGreedyToRight());
    }

    private final boolean j(TextRange textRange, HighlighterModel highlighterModel) {
        if (textRange == null) {
            LOG.debug("Received invalid highlighter. Unrolling " + HighlightersUtilKt.prettyPrint(highlighterModel));
            return false;
        }
        if (textRange.getStartOffset() < 0 || textRange.getEndOffset() > this.document.getTextLength()) {
            LOG.error("Corrected range:" + textRange + " for highlighter:" + HighlightersUtilKt.prettyPrint(highlighterModel) + ",text:\"" + highlighterModel.getTextToHighlight() + "\"} is shifted out of the document (0," + this.document.getTextLength() + ")");
            return false;
        }
        return !highlighterModel.getProperties().isVerifiable() || this.N(textRange, highlighterModel);
    }

    private final boolean N(TextRange textRange, HighlighterModel highlighterModel) {
        String string = highlighterModel.getTextToHighlight();
        CharSequence charSequence = string;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            return true;
        }
        if (textRange.getEndOffset() > this.document.getTextLength()) {
            return false;
        }
        charSequence = this.document.getImmutableCharSequence().subSequence(textRange.getStartOffset(), textRange.getEndOffset());
        boolean bl = string.contentEquals(charSequence);
        if (!bl) {
            AbstractDocumentVersion abstractDocumentVersion = this.j().getVersion();
            AbstractDocumentVersion abstractDocumentVersion2 = highlighterModel.getDocumentVersion();
            LOG.error("Highlighter " + HighlightersUtilKt.prettyPrint(highlighterModel) + " is applied to the wrong text.\n Versions: document=" + abstractDocumentVersion + " highlighter=" + abstractDocumentVersion2 + "\nText: \nbackend=\"" + string + "\"\nfrontend=\"" + charSequence + "\"");
        }
        return bl;
    }

    public final void shrinkHistory() {
        this.shifter.shrinkHistory();
    }

    private final Boolean j(ConstrainedInlayHighlighterModel constrainedInlayHighlighterModel) {
        InlayConstraintsModel inlayConstraintsModel = constrainedInlayHighlighterModel.getConstraints();
        HorizontalConstraintsModel horizontalConstraintsModel = inlayConstraintsModel instanceof HorizontalConstraintsModel ? (HorizontalConstraintsModel)inlayConstraintsModel : null;
        return horizontalConstraintsModel != null ? Boolean.valueOf(horizontalConstraintsModel.getRelatesToPrecedingText()) : null;
    }

    public static final /* synthetic */ Document access$getDocument$p(HighlighterRangeRepairer $this) {
        return $this.document;
    }

    static {
        boolean bl = false;
        Logger logger = Logger.getInstance(HighlighterRangeRepairer.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/jetbrains/rdclient/daemon/HighlighterRangeRepairer$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.rd.client"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

