/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdclient.daemon;

import com.intellij.codeInsight.daemon.impl.SeverityRegistrar;
import com.intellij.codeInsight.daemon.impl.TrafficLightRenderer;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.util.ArrayUtilRt;
import com.jetbrains.rd.ide.model.BackendDaemonStateEnum;
import com.jetbrains.rd.ide.model.HeavyProcessTypeModel;
import com.jetbrains.rd.ide.model.RdDaemonModel;
import com.jetbrains.rd.util.reactive.BoolPropertyExKt;
import com.jetbrains.rd.util.reactive.IOptPropertyView;
import com.jetbrains.rd.util.reactive.InterfacesKt;
import com.jetbrains.rdclient.FrontendBundle;
import com.jetbrains.rdclient.daemon.FrontendTrafficLightRendererExtension;
import com.jetbrains.rdclient.daemon.FrontendTrafficLightRendererKt;
import com.jetbrains.rdclient.services.IdeBackend;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB=\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r\u00a2\u0006\u0002\u0010\u000fJ\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0014J\b\u0010\u001b\u001a\u00020\u0012H\u0016R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u00128BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\u00128BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0013R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/jetbrains/rdclient/daemon/FrontendTrafficLightRenderer;", "Lcom/intellij/codeInsight/daemon/impl/TrafficLightRenderer;", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "psiFile", "Lcom/intellij/psi/PsiFile;", "backend", "Lcom/jetbrains/rdclient/services/IdeBackend;", "model", "Lcom/jetbrains/rd/ide/model/RdDaemonModel;", "extensions", "", "Lcom/jetbrains/rdclient/daemon/FrontendTrafficLightRendererExtension;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/editor/Editor;Lcom/intellij/psi/PsiFile;Lcom/jetbrains/rdclient/services/IdeBackend;Lcom/jetbrains/rd/ide/model/RdDaemonModel;[Lcom/jetbrains/rdclient/daemon/FrontendTrafficLightRendererExtension;)V", "[Lcom/jetbrains/rdclient/daemon/FrontendTrafficLightRendererExtension;", "N", "", "()Z", "j", "fillDaemonCodeAnalyzerErrorsStatus", "", "status", "Lcom/intellij/codeInsight/daemon/impl/TrafficLightRenderer$DaemonCodeAnalyzerStatus;", "severityRegistrar", "Lcom/intellij/codeInsight/daemon/impl/SeverityRegistrar;", "isValid", "Companion", "intellij.rd.client"})
@SourceDebugExtension(value={"SMAP\nFrontendTrafficLightRenderer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FrontendTrafficLightRenderer.kt\ncom/jetbrains/rdclient/daemon/FrontendTrafficLightRenderer\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,123:1\n1282#2,2:124\n65#3,4:126\n13#3:130\n*S KotlinDebug\n*F\n+ 1 FrontendTrafficLightRenderer.kt\ncom/jetbrains/rdclient/daemon/FrontendTrafficLightRenderer\n*L\n39#1:124,2\n103#1:126,4\n30#1:130\n*E\n"})
public final class FrontendTrafficLightRenderer
extends TrafficLightRenderer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final PsiFile psiFile;
    @NotNull
    private final IdeBackend backend;
    @NotNull
    private final RdDaemonModel model;
    @NotNull
    private final FrontendTrafficLightRendererExtension[] extensions;
    @NotNull
    private static final Logger logger;

    public FrontendTrafficLightRenderer(@NotNull Project project, @NotNull Editor editor2, @Nullable PsiFile psiFile, @NotNull IdeBackend backend, @NotNull RdDaemonModel model2, @NotNull FrontendTrafficLightRendererExtension[] extensions) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)backend, (String)"backend");
        Intrinsics.checkNotNullParameter((Object)((Object)model2), (String)"model");
        Intrinsics.checkNotNullParameter((Object)extensions, (String)"extensions");
        super(project, editor2);
        this.psiFile = psiFile;
        this.backend = backend;
        this.model = model2;
        this.extensions = extensions;
    }

    protected void fillDaemonCodeAnalyzerErrorsStatus(@NotNull TrafficLightRenderer.DaemonCodeAnalyzerStatus status, @NotNull SeverityRegistrar severityRegistrar) {
        Logger logger;
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)status, (String)"status");
        Intrinsics.checkNotNullParameter((Object)severityRegistrar, (String)"severityRegistrar");
        if (this.N() && !this.j() || !InterfacesKt.getHasValue((IOptPropertyView)((IOptPropertyView)this.model.getState()))) {
            status.reasonWhySuspended = FrontendBundle.INSTANCE.message("loading.solution.components", new Object[0]);
            status.errorAnalyzingFinished = true;
        } else {
            Object object;
            block19: {
                FrontendTrafficLightRendererExtension frontendTrafficLightRendererExtension;
                object = this.extensions;
                bl = false;
                int n = ((FrontendTrafficLightRendererExtension[])object).length;
                for (int k = 0; k < n; ++k) {
                    FrontendTrafficLightRendererExtension frontendTrafficLightRendererExtension2;
                    FrontendTrafficLightRendererExtension frontendTrafficLightRendererExtension3 = frontendTrafficLightRendererExtension2 = object[k];
                    boolean bl2 = false;
                    if (!frontendTrafficLightRendererExtension3.isAvailable()) continue;
                    frontendTrafficLightRendererExtension = frontendTrafficLightRendererExtension2;
                    break block19;
                }
                frontendTrafficLightRendererExtension = logger = null;
            }
            if (logger != null) {
                status.reasonWhySuspended = logger.getTooltip();
                status.errorAnalyzingFinished = true;
                return;
            }
            object = (BackendDaemonStateEnum)((Object)this.model.getState().getValueOrNull());
            if (status.errorAnalyzingFinished) {
                Object object2 = object;
                switch (object2 == null ? -1 : WhenMappings.$EnumSwitchMapping$0[((Enum)object2).ordinal()]) {
                    case -1: {
                        break;
                    }
                    case 1: {
                        if (status.reasonWhyDisabled == null) break;
                        status.reasonWhyDisabled = FrontendBundle.INSTANCE.message("analysis.is.not.supported.for.this.file", new Object[0]);
                        status.errorAnalyzingFinished = true;
                        status.errorCounts = ArrayUtilRt.EMPTY_INT_ARRAY;
                        break;
                    }
                    case 2: {
                        status.reasonWhyDisabled = FrontendBundle.INSTANCE.message("analysis.is.unsupported.for.document", new Object[0]);
                        status.errorAnalyzingFinished = true;
                        status.errorCounts = ArrayUtilRt.EMPTY_INT_ARRAY;
                        break;
                    }
                    case 3: {
                        Object object3;
                        Object object4;
                        String string = (String)this.model.getMessage().getValue();
                        if (string == null) {
                            string = object4 = status.reasonWhyDisabled;
                        }
                        if (string == null) {
                            object4 = object3 = "";
                        }
                        if (!(((CharSequence)(object3 = ((Object)StringsKt.trimEnd((CharSequence)((CharSequence)object3))).toString())).length() == 0)) {
                            object3 = (String)object3 + (StringsKt.endsWith$default((String)object3, (String)"", (boolean)false, (int)2, null) ? " " : " ");
                        }
                        status.reasonWhyDisabled = object3;
                        status.errorAnalyzingFinished = true;
                        status.errorCounts = ArrayUtilRt.EMPTY_INT_ARRAY;
                        break;
                    }
                    case 4: {
                        String string = (String)this.model.getMessage().getValue();
                        if (string == null && (string = status.reasonWhySuspended) == null) {
                            string = "Code analysis suspended";
                        }
                        status.reasonWhySuspended = string;
                        status.errorAnalyzingFinished = true;
                        HeavyProcessTypeModel heavyProcessTypeModel = (HeavyProcessTypeModel)((Object)this.model.getHeavyProcessType().getValue());
                        Object object5 = status.heavyProcessType = heavyProcessTypeModel != null ? FrontendTrafficLightRendererKt.access$fromModel(heavyProcessTypeModel) : null;
                        if (status.heavyProcessType == null) break;
                        status.errorCounts = ArrayUtilRt.EMPTY_INT_ARRAY;
                        break;
                    }
                    case 5: 
                    case 6: {
                        status.errorAnalyzingFinished = false;
                        status.errorCounts = this.getErrorCounts();
                        break;
                    }
                    case 7: 
                    case 8: {
                        status.errorAnalyzingFinished = true;
                        status.errorCounts = this.getErrorCounts();
                    }
                }
            }
        }
        logger = FrontendTrafficLightRenderer.logger;
        boolean bl3 = false;
        if (logger.isTraceEnabled()) {
            Logger logger2 = logger;
            bl = false;
            PsiFile psiFile = this.psiFile;
            logger2.trace("Backend daemon status for " + (psiFile != null && (psiFile = psiFile.getVirtualFile()) != null ? psiFile.getName() : null) + " is " + this.model.getState().getValueOrNull() + ", IDEA status is " + status);
        }
    }

    public boolean isValid() {
        if (!this.model.isBound()) {
            return false;
        }
        return super.isValid();
    }

    private final boolean N() {
        return this.model.getState().getValueOrNull() == BackendDaemonStateEnum.HIDDEN;
    }

    private final boolean j() {
        return BoolPropertyExKt.getHasTrueValue((IOptPropertyView)((IOptPropertyView)this.backend.getSolution().isLoaded()));
    }

    static {
        boolean bl = false;
        Logger logger = Logger.getInstance(FrontendTrafficLightRenderer.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        FrontendTrafficLightRenderer.logger = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/jetbrains/rdclient/daemon/FrontendTrafficLightRenderer$Companion;", "", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.rd.client"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[BackendDaemonStateEnum.values().length];
            try {
                nArray[BackendDaemonStateEnum.HIDDEN.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BackendDaemonStateEnum.UNSUPPORTED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BackendDaemonStateEnum.DISABLED.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BackendDaemonStateEnum.SUSPENDED.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BackendDaemonStateEnum.INVALIDATED.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BackendDaemonStateEnum.IN_PROGRESS_LOCAL.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BackendDaemonStateEnum.IN_PROGRESS_GLOBAL.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BackendDaemonStateEnum.UP_TO_DATE.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

