/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdclient.daemon;

import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.rd.LifetimeDisposableExKt;
import com.intellij.util.ApplicationKt;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import com.jetbrains.ide.model.highlighterRegistration.IdeaTextAttributesKey;
import com.jetbrains.ide.model.highlighterRegistration.TextAttributesKeyModel;
import com.jetbrains.rd.ide.editor.markup.UtilKt;
import com.jetbrains.rd.ide.model.HighlighterElement;
import com.jetbrains.rd.ide.model.HighlighterExtension;
import com.jetbrains.rd.ide.model.HighlighterModel;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.RLifetimeKt;
import com.jetbrains.rdclient.daemon.FrontendHighlighterSuppressionHandler;
import com.jetbrains.rdclient.daemon.FrontendMarkupAdapter;
import com.jetbrains.rdclient.daemon.FrontendMarkupSuppressor;
import com.jetbrains.rdclient.daemon.HighlighterRangeRepairer;
import com.jetbrains.rdclient.daemon.MarkupSuppressionKind;
import com.jetbrains.rdclient.daemon.RecyclingHighlighterStorage;
import com.jetbrains.rdclient.daemon.suppressors.ProtocolSuppressableMarkupModel;
import com.jetbrains.rdclient.daemon.util.HighlightersUtilKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 :2\u00020\u0001:\u0002:;B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u001d\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u001b\u001a\u00020\u001cH\u0000\u00a2\u0006\u0002\b\u001dJ\b\u0010\u001e\u001a\u00020\u001aH\u0002J\u0016\u0010\u001f\u001a\u00020\u001a2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\"0!H\u0002J\u0016\u0010#\u001a\u00020\u001a2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020%0!H\u0002J\u0016\u0010&\u001a\u00020\u001a2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\"0!H\u0002J\u0010\u0010(\u001a\u00020\u000e2\u0006\u0010)\u001a\u00020*H\u0002J\b\u0010+\u001a\u00020,H\u0007J\b\u0010-\u001a\u00020\u001aH\u0002J\u0012\u0010.\u001a\u0004\u0018\u00010/2\u0006\u00100\u001a\u00020\"H\u0002J\b\u00101\u001a\u00020\u001aH\u0002J\u001a\u00102\u001a\u0004\u0018\u00010*2\u0006\u00103\u001a\u00020*2\u0006\u00104\u001a\u00020\u000eH\u0002J\u0016\u00105\u001a\u00020\u001a2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u00106\u001a\u00020,J\u0016\u00107\u001a\u00020\u001a2\f\u00108\u001a\b\u0012\u0004\u0012\u00020\u001a09H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\u000e@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006<"}, d2={"Lcom/jetbrains/rdclient/daemon/FrontendMarkupContributor;", "", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "markupAdapter", "Lcom/jetbrains/rdclient/daemon/FrontendMarkupAdapter;", "highlighterRepairer", "Lcom/jetbrains/rdclient/daemon/HighlighterRangeRepairer;", "storage", "Lcom/jetbrains/rdclient/daemon/RecyclingHighlighterStorage;", "suppressor", "Lcom/jetbrains/rdclient/daemon/FrontendMarkupSuppressor;", "(Lcom/jetbrains/rd/util/lifetime/Lifetime;Lcom/jetbrains/rdclient/daemon/FrontendMarkupAdapter;Lcom/jetbrains/rdclient/daemon/HighlighterRangeRepairer;Lcom/jetbrains/rdclient/daemon/RecyclingHighlighterStorage;Lcom/jetbrains/rdclient/daemon/FrontendMarkupSuppressor;)V", "<set-?>", "", "isUpdating", "()Z", "getLifetime", "()Lcom/jetbrains/rd/util/lifetime/Lifetime;", "getMarkupAdapter", "()Lcom/jetbrains/rdclient/daemon/FrontendMarkupAdapter;", "mergingUpdateQueue", "Lcom/intellij/util/ui/update/MergingUpdateQueue;", "getStorage", "()Lcom/jetbrains/rdclient/daemon/RecyclingHighlighterStorage;", "bind", "", "protocolMarkup", "Lcom/jetbrains/rdclient/daemon/suppressors/ProtocolSuppressableMarkupModel;", "bind$intellij_rd_client", "w", "w", "added", "", "Lcom/jetbrains/rd/ide/model/HighlighterElement;", "j", "removed", "", "N", "updated", "j", "highlighterModel", "Lcom/jetbrains/rd/ide/model/HighlighterModel;", "isSuppressed", "Lcom/jetbrains/rdclient/daemon/MarkupSuppressionKind;", "j", "j", "Lcom/intellij/openapi/editor/ex/RangeHighlighterEx;", "element", "N", "j", "model", "trackInvalid", "suppress", "suppressionKind", "j", "block", "Lkotlin/Function0;", "Companion", "MergingUpdateTask", "intellij.rd.client"})
@SourceDebugExtension(value={"SMAP\nFrontendMarkupContributor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FrontendMarkupContributor.kt\ncom/jetbrains/rdclient/daemon/FrontendMarkupContributor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,311:1\n1747#2,3:312\n1#3:315\n13#4:316\n*S KotlinDebug\n*F\n+ 1 FrontendMarkupContributor.kt\ncom/jetbrains/rdclient/daemon/FrontendMarkupContributor\n*L\n147#1:312,3\n284#1:316\n*E\n"})
public final class FrontendMarkupContributor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Lifetime lifetime;
    @NotNull
    private final FrontendMarkupAdapter markupAdapter;
    @NotNull
    private final HighlighterRangeRepairer highlighterRepairer;
    @NotNull
    private final RecyclingHighlighterStorage storage;
    @NotNull
    private final FrontendMarkupSuppressor suppressor;
    private boolean isUpdating;
    @NotNull
    private final MergingUpdateQueue mergingUpdateQueue;
    @NotNull
    private static final Logger logger;

    public FrontendMarkupContributor(@NotNull Lifetime lifetime, @NotNull FrontendMarkupAdapter markupAdapter, @NotNull HighlighterRangeRepairer highlighterRepairer, @NotNull RecyclingHighlighterStorage storage, @NotNull FrontendMarkupSuppressor suppressor) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)markupAdapter, (String)"markupAdapter");
        Intrinsics.checkNotNullParameter((Object)highlighterRepairer, (String)"highlighterRepairer");
        Intrinsics.checkNotNullParameter((Object)storage, (String)"storage");
        Intrinsics.checkNotNullParameter((Object)suppressor, (String)"suppressor");
        this.lifetime = lifetime;
        this.markupAdapter = markupAdapter;
        this.highlighterRepairer = highlighterRepairer;
        this.storage = storage;
        this.suppressor = suppressor;
        this.mergingUpdateQueue = new MergingUpdateQueue("FrontendMarkupContributor.mergingUpdateQueue", 50, true, null, LifetimeDisposableExKt.createNestedDisposable$default((Lifetime)this.lifetime, null, (int)1, null));
    }

    @NotNull
    public final Lifetime getLifetime() {
        return this.lifetime;
    }

    @NotNull
    public final FrontendMarkupAdapter getMarkupAdapter() {
        return this.markupAdapter;
    }

    @NotNull
    public final RecyclingHighlighterStorage getStorage() {
        return this.storage;
    }

    public final boolean isUpdating() {
        return this.isUpdating;
    }

    private final void j() {
        if (this.suppressor.isSuppressed$intellij_rd_client() == MarkupSuppressionKind.NONE) {
            ModalityState modalityState = ModalityState.current();
            Intrinsics.checkNotNullExpressionValue((Object)modalityState, (String)"current(...)");
            this.mergingUpdateQueue.queue((Update)new MergingUpdateTask(modalityState));
        }
    }

    private final void w() {
        this.j((Function0<Unit>)((Function0)new Function0<Unit>(this){
            final /* synthetic */ FrontendMarkupContributor this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                List<RangeHighlighterEx> list2;
                HighlighterModel highlighterModel;
                List<HighlighterExtension> list3;
                Object object;
                int n;
                Object object2;
                FrontendMarkupContributor.access$getLogger$cp().debug("highlighter flush triggered!");
                Object object3 = FrontendMarkupContributor.access$getLogger$cp();
                ArrayList<HighlighterElement> arrayList = this.this$0;
                boolean bl = false;
                if (object3.isTraceEnabled()) {
                    object2 = object3;
                    n = 0;
                    object2.trace("highlighters in document:" + ((FrontendMarkupContributor)((Object)arrayList)).getMarkupAdapter().getAllHighlighters().length);
                }
                object3 = this.this$0.getStorage().flushNotUpdated();
                if (!((Collection)object3).isEmpty()) {
                    arrayList = object3.iterator();
                    while (arrayList.hasNext()) {
                        Map.Entry entry = (Map.Entry)arrayList.next();
                        RangeHighlighterEx rangeHighlighterEx = (RangeHighlighterEx)entry.getKey();
                        object = (HighlighterElement)entry.getValue();
                        HighlighterModel highlighterModel2 = ((HighlighterElement)object).component1();
                        list3 = ((HighlighterElement)object).component2();
                        highlighterModel = FrontendMarkupContributor.access$repair(this.this$0, highlighterModel2, false);
                        if (highlighterModel == null) {
                            FrontendMarkupContributor.access$getLogger$cp().warn("Received unrepairable update for highlighter during flush. Model: " + HighlightersUtilKt.prettyPrint(highlighterModel2));
                            continue;
                        }
                        this.this$0.getMarkupAdapter().updateHighlighter(rangeHighlighterEx, new HighlighterElement(highlighterModel, list3));
                    }
                }
                arrayList = new ArrayList<HighlighterElement>();
                List<HighlighterElement> list4 = this.this$0.getStorage().flushNotRegistered();
                if (!((Collection)list4).isEmpty()) {
                    Logger logger = FrontendMarkupContributor.access$getLogger$cp();
                    boolean bl2 = false;
                    if (logger.isTraceEnabled()) {
                        object2 = logger;
                        boolean bl3 = false;
                        object2.trace("Flushing to markup " + list4.size() + " not registered highlighters");
                    }
                    for (HighlighterElement highlighterElement : list4) {
                        HighlighterModel highlighterModel3 = highlighterElement.component1();
                        list3 = highlighterElement.component2();
                        highlighterModel = FrontendMarkupContributor.access$repair(this.this$0, highlighterModel3, true);
                        if (highlighterModel == null) {
                            FrontendMarkupContributor.access$getLogger$cp().warn("Invalid highlighters are presented in notRegistered highlighters during flush");
                            continue;
                        }
                        HighlighterElement highlighterElement2 = new HighlighterElement(highlighterModel, list3);
                        RangeHighlighterEx rangeHighlighterEx = FrontendMarkupContributor.access$recycle(this.this$0, highlighterElement2);
                        if (rangeHighlighterEx != null) continue;
                        arrayList.add(highlighterElement2);
                    }
                    n = list4.size() - arrayList.size();
                    object = FrontendMarkupContributor.access$getLogger$cp();
                    boolean bl4 = false;
                    if (object.isTraceEnabled()) {
                        object2 = object;
                        boolean bl5 = false;
                        object2.trace("Reused " + n + " highlighters during flush");
                    }
                }
                if (!((Collection)(list2 = this.this$0.getStorage().flushNotDeleted())).isEmpty()) {
                    object = FrontendMarkupContributor.access$getLogger$cp();
                    boolean bl6 = false;
                    if (object.isTraceEnabled()) {
                        object2 = object;
                        boolean bl7 = false;
                        object2.trace("Deleting " + list2.size() + " highlighters from markup");
                    }
                    this.this$0.getMarkupAdapter().bulkRemoveHighlighters(list2);
                }
                if (arrayList.size() != 0) {
                    object = FrontendMarkupContributor.access$getLogger$cp();
                    int n2 = 0;
                    if (object.isTraceEnabled()) {
                        object2 = object;
                        boolean bl8 = false;
                        object2.trace("Registering last portion of " + arrayList.size() + " highlighters which have failed at reusing");
                    }
                    object = this.this$0.getMarkupAdapter().bulkAddHighlighters((List<HighlighterElement>)arrayList);
                    int n3 = object.size();
                    for (n2 = 0; n2 < n3; ++n2) {
                        this.this$0.getStorage().addHighlighter(((HighlighterElement)arrayList.get(n2)).getHighlighter().getId(), (RangeHighlighterEx)object.get(n2));
                    }
                }
                FrontendMarkupContributor.access$getHighlighterRepairer$p(this.this$0).shrinkHistory();
            }
        }));
    }

    private final void w(List<HighlighterElement> list2) {
        this.j((Function0<Unit>)((Function0)new Function0<Unit>(list2, this){
            final /* synthetic */ List<HighlighterElement> $added;
            final /* synthetic */ FrontendMarkupContributor this$0;
            {
                this.$added = $added;
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                List list2 = new ArrayList<E>();
                for (HighlighterElement highlighterElement : this.$added) {
                    HighlighterModel highlighterModel;
                    boolean bl;
                    HighlighterModel highlighterModel2 = highlighterElement.getHighlighter();
                    List<HighlighterExtension> list3 = highlighterElement.getExtensions();
                    boolean bl2 = bl = this.this$0.getStorage().get(highlighterModel2.getId()) == null;
                    if (_Assertions.ENABLED && !bl) {
                        boolean bl3 = false;
                        String string = "Multiple highlighter registration on IDEA-side! id: " + highlighterModel2.getId() + " model: " + HighlightersUtilKt.prettyPrint(highlighterModel2);
                        throw new AssertionError((Object)string);
                    }
                    if (FrontendMarkupContributor.access$repair(this.this$0, highlighterModel2, true) == null || FrontendMarkupContributor.access$isReplaced(this.this$0, highlighterModel2)) continue;
                    HighlighterElement highlighterElement2 = new HighlighterElement(highlighterModel, list3);
                    if (FrontendMarkupContributor.access$getSuppressor$p(this.this$0).shouldSuppressAddition(highlighterModel2.getProperties())) {
                        RangeHighlighterEx rangeHighlighterEx = FrontendMarkupContributor.access$recycle(this.this$0, highlighterElement2);
                        if (rangeHighlighterEx == null) {
                            FrontendMarkupContributor frontendMarkupContributor = this.this$0;
                            boolean bl4 = false;
                            frontendMarkupContributor.getStorage().queueRegistration(highlighterElement);
                            FrontendMarkupContributor.access$queueUpdateIfNeed(frontendMarkupContributor);
                            rangeHighlighterEx = Unit.INSTANCE;
                        }
                        continue;
                    }
                    list2.add(highlighterElement2);
                }
                if (list2.isEmpty()) {
                    return;
                }
                List<RangeHighlighterEx> list4 = this.this$0.getMarkupAdapter().bulkAddHighlighters(list2);
                int n = list4.size();
                for (int k = 0; k < n; ++k) {
                    this.this$0.getStorage().addHighlighter(((HighlighterElement)list2.get(k)).getHighlighter().getId(), (RangeHighlighterEx)list4.get(k));
                }
            }
        }));
    }

    private final boolean j(HighlighterModel highlighterModel) {
        boolean bl;
        block3: {
            Iterable iterable = FrontendHighlighterSuppressionHandler.Companion.getEP_NAME().getExtensionList();
            boolean bl2 = false;
            if (iterable instanceof Collection && ((Collection)iterable).isEmpty()) {
                bl = false;
            } else {
                for (Object t : iterable) {
                    FrontendHighlighterSuppressionHandler frontendHighlighterSuppressionHandler = (FrontendHighlighterSuppressionHandler)t;
                    boolean bl3 = false;
                    if (!frontendHighlighterSuppressionHandler.shouldSuppress(highlighterModel, this.markupAdapter.getDocument())) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    private final void N(List<HighlighterElement> list2) {
        this.j((Function0<Unit>)((Function0)new Function0<Unit>(list2, this){
            final /* synthetic */ List<HighlighterElement> $updated;
            final /* synthetic */ FrontendMarkupContributor this$0;
            {
                this.$updated = $updated;
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                for (HighlighterElement highlighterElement : this.$updated) {
                    if (this.this$0.getStorage().updateRegistration(highlighterElement)) continue;
                    RangeHighlighterEx rangeHighlighterEx = this.this$0.getStorage().get(highlighterElement.getHighlighter().getId());
                    if (rangeHighlighterEx == null) {
                        FrontendMarkupContributor.access$getLogger$cp().warn("Received update for not registered highlighter " + HighlightersUtilKt.prettyPrint(highlighterElement.getHighlighter()));
                        continue;
                    }
                    if (FrontendMarkupContributor.access$getSuppressor$p(this.this$0).shouldSuppressUpdate()) {
                        this.this$0.getStorage().queueUpdate(rangeHighlighterEx, highlighterElement);
                        FrontendMarkupContributor.access$queueUpdateIfNeed(this.this$0);
                        continue;
                    }
                    HighlighterModel highlighterModel = FrontendMarkupContributor.access$repair(this.this$0, highlighterElement.getHighlighter(), false);
                    if (highlighterModel == null) {
                        FrontendMarkupContributor.access$getLogger$cp().warn("Received unrepairable update for highlighter. Model: " + HighlightersUtilKt.prettyPrint(highlighterElement.getHighlighter()));
                        continue;
                    }
                    this.this$0.getMarkupAdapter().updateHighlighter(rangeHighlighterEx, new HighlighterElement(highlighterModel, highlighterElement.getExtensions()));
                }
            }
        }));
    }

    private final HighlighterModel j(HighlighterModel highlighterModel, boolean bl) {
        HighlighterModel highlighterModel2 = this.highlighterRepairer.repair(highlighterModel);
        if (highlighterModel2 != null) {
            HighlighterModel highlighterModel3 = highlighterModel2;
            boolean bl2 = false;
            return highlighterModel3;
        }
        if (bl) {
            this.storage.addInvalidHighlighter(highlighterModel);
        }
        return null;
    }

    private final RangeHighlighterEx j(HighlighterElement highlighterElement) {
        RangeHighlighterEx rangeHighlighterEx = this.storage.recycle(highlighterElement.getHighlighter());
        if (rangeHighlighterEx != null) {
            this.markupAdapter.updateHighlighter(rangeHighlighterEx, highlighterElement);
        }
        return rangeHighlighterEx;
    }

    private final void j(List<Long> list2) {
        this.j((Function0<Unit>)((Function0)new Function0<Unit>(list2, this){
            final /* synthetic */ List<Long> $removed;
            final /* synthetic */ FrontendMarkupContributor this$0;
            {
                this.$removed = $removed;
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                List list2 = new ArrayList<E>();
                Iterator<Long> iterator2 = this.$removed.iterator();
                while (iterator2.hasNext()) {
                    RangeHighlighterEx rangeHighlighterEx;
                    long l = ((Number)iterator2.next()).longValue();
                    if (this.this$0.getStorage().remove(l) == null) continue;
                    if (FrontendMarkupContributor.access$getSuppressor$p(this.this$0).shouldSuppressDeletion(UtilKt.getBackendProperties((RangeHighlighter)rangeHighlighterEx))) {
                        this.this$0.getStorage().queueDeletion(rangeHighlighterEx);
                        FrontendMarkupContributor.access$queueUpdateIfNeed(this.this$0);
                        continue;
                    }
                    list2.add(rangeHighlighterEx);
                }
                if (list2.isEmpty()) {
                    return;
                }
                this.this$0.getMarkupAdapter().bulkRemoveHighlighters(list2);
            }
        }));
    }

    private final void N() {
        this.j((Function0<Unit>)((Function0)new Function0<Unit>(this){
            final /* synthetic */ FrontendMarkupContributor this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                boolean bl;
                block3: {
                    boolean bl2;
                    int n;
                    List list2 = CollectionsKt.plus(this.this$0.getStorage().getRegisteredHighlighters(), (Iterable)this.this$0.getStorage().flushNotDeleted());
                    FrontendMarkupContributor.access$getLogger$cp().debug("Cleaning highlighter storage. Total amount " + list2.size());
                    this.this$0.getMarkupAdapter().bulkRemoveHighlighters(list2);
                    this.this$0.getStorage().clear();
                    Logger logger = FrontendMarkupContributor.access$getLogger$cp();
                    RangeHighlighterEx[] rangeHighlighterExArray = this.this$0;
                    boolean bl3 = false;
                    if (logger.isTraceEnabled()) {
                        Logger logger2 = logger;
                        n = 0;
                        logger2.trace("storage: " + rangeHighlighterExArray.getStorage());
                    }
                    rangeHighlighterExArray = this.this$0.getMarkupAdapter().getAllHighlighters();
                    bl3 = false;
                    int n2 = rangeHighlighterExArray.length;
                    for (n = 0; n < n2; ++n) {
                        RangeHighlighterEx rangeHighlighterEx;
                        RangeHighlighterEx rangeHighlighterEx2 = rangeHighlighterEx = rangeHighlighterExArray[n];
                        boolean bl4 = false;
                        if (!HighlightersUtilKt.isBackendHighlighter((RangeHighlighter)rangeHighlighterEx2)) continue;
                        bl2 = true;
                        break block3;
                    }
                    bl2 = bl = false;
                }
                if (bl) {
                    FrontendMarkupContributor.access$getLogger$cp().error("backend highlighters present in Markup model after cleaning");
                }
            }
        }));
    }

    public final void suppress(@NotNull Lifetime lifetime, @NotNull MarkupSuppressionKind suppressionKind) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)((Object)suppressionKind), (String)"suppressionKind");
        this.suppressor.suppress(lifetime, suppressionKind);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void j(Function0<Unit> function0) {
        try {
            this.isUpdating = true;
            function0.invoke();
        }
        finally {
            this.isUpdating = false;
        }
    }

    public final void bind$intellij_rd_client(@NotNull Lifetime lifetime, @NotNull ProtocolSuppressableMarkupModel protocolMarkup) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)protocolMarkup, (String)"protocolMarkup");
        protocolMarkup.getHighlightersRemoved().advise(lifetime, (Function1)new Function1<List<? extends Long>, Unit>(this){
            final /* synthetic */ FrontendMarkupContributor this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull List<Long> it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                Logger logger = FrontendMarkupContributor.access$getLogger$cp();
                boolean bl = false;
                if (logger.isTraceEnabled()) {
                    Logger logger2 = logger;
                    boolean bl2 = false;
                    logger2.trace("RdMarkupModel.highlightersRemoved fired: count=" + it.size());
                }
                FrontendMarkupContributor.access$highlightersRemoved(this.this$0, it);
            }
        });
        protocolMarkup.getHighlightersAdded().advise(lifetime, (Function1)new Function1<List<? extends HighlighterElement>, Unit>(this){
            final /* synthetic */ FrontendMarkupContributor this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull List<HighlighterElement> it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                Logger logger = FrontendMarkupContributor.access$getLogger$cp();
                boolean bl = false;
                if (logger.isTraceEnabled()) {
                    Logger logger2 = logger;
                    boolean bl2 = false;
                    StringBuilder stringBuilder = new StringBuilder().append("RdMarkupModel.highlightersAdded fired: count=" + it.size());
                    Intrinsics.checkNotNullExpressionValue((Object)stringBuilder, (String)"append(...)");
                    StringBuilder stringBuilder2 = stringBuilder.append('\n');
                    Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append(...)");
                    StringBuilder stringBuilder3 = stringBuilder2.append("Received highlighters from backend.  Highlighter breakdown:");
                    Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3, (String)"append(...)");
                    StringBuilder stringBuilder4 = stringBuilder3.append('\n');
                    Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4, (String)"append(...)");
                    StringBuilder stringBuilder5 = stringBuilder4;
                    Iterable iterable = it;
                    boolean bl3 = false;
                    Iterable iterable2 = iterable;
                    Collection collection = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)iterable, (int)10));
                    boolean bl4 = false;
                    for (T t : iterable2) {
                        HighlighterElement highlighterElement = (HighlighterElement)t;
                        Collection collection2 = collection;
                        boolean bl5 = false;
                        HighlighterModel highlighterModel = highlighterElement.getHighlighter();
                        stringBuilder5.append(highlighterModel.getProperties().getAttributeId()).append(":");
                        com.jetbrains.rdclient.daemon.FrontendMarkupContributor$Companion.prettyPrint$default(FrontendMarkupContributor.Companion, highlighterModel.getTextAttributesKey(), stringBuilder5, 0, 2, null);
                        collection2.add(Unit.INSTANCE);
                    }
                    List cfr_ignored_0 = (List)collection;
                    String string = stringBuilder5.toString();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                    logger2.trace(string);
                }
                FrontendMarkupContributor.access$highlightersAdded(this.this$0, it);
            }
        });
        protocolMarkup.getHighlightersUpdated().advise(lifetime, (Function1)new Function1<List<? extends HighlighterElement>, Unit>(this){
            final /* synthetic */ FrontendMarkupContributor this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull List<HighlighterElement> it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                Logger logger = FrontendMarkupContributor.access$getLogger$cp();
                boolean bl = false;
                if (logger.isTraceEnabled()) {
                    Logger logger2 = logger;
                    boolean bl2 = false;
                    logger2.trace("RdMarkupModel.highlightersUpdated fired: count=" + it.size());
                }
                FrontendMarkupContributor.access$highlightersUpdated(this.this$0, it);
            }
        });
        protocolMarkup.getHighlightersCleared().advise(lifetime, (Function1)new Function1<Unit, Unit>(this){
            final /* synthetic */ FrontendMarkupContributor this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull Unit it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                Logger logger = FrontendMarkupContributor.access$getLogger$cp();
                boolean bl = false;
                if (logger.isTraceEnabled()) {
                    Logger logger2 = logger;
                    boolean bl2 = false;
                    logger2.trace("RdMarkupModel.highlightersCleared fired. call removeAllHighlighters()");
                }
                FrontendMarkupContributor.access$removeAllHighlighters(this.this$0);
            }
        });
        this.suppressor.released(lifetime, (Function1<? super Lifetime, Unit>)((Function1)new Function1<Lifetime, Unit>(this){
            final /* synthetic */ FrontendMarkupContributor this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull Lifetime it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                Logger logger = FrontendMarkupContributor.access$getLogger$cp();
                boolean bl = false;
                if (logger.isTraceEnabled()) {
                    Logger logger2 = logger;
                    boolean bl2 = false;
                    logger2.trace("suppressor is released. call flushHighlighters()");
                }
                FrontendMarkupContributor.access$flushHighlighters(this.this$0);
            }
        }));
        lifetime.onTermination((Function0)new Function0<Unit>(this){
            final /* synthetic */ FrontendMarkupContributor this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                Logger logger = FrontendMarkupContributor.access$getLogger$cp();
                boolean bl = false;
                if (logger.isTraceEnabled()) {
                    Logger logger2 = logger;
                    boolean bl2 = false;
                    logger2.trace("RdMarkupModel.highlightersCleared fired. call removeAllHighlighters()");
                }
                FrontendMarkupContributor.access$removeAllHighlighters(this.this$0);
            }
        });
        protocolMarkup.bind(lifetime);
    }

    @TestOnly
    @NotNull
    public final MarkupSuppressionKind isSuppressed() {
        return this.suppressor.isSuppressed$intellij_rd_client();
    }

    public static final /* synthetic */ HighlighterModel access$repair(FrontendMarkupContributor $this, HighlighterModel model2, boolean trackInvalid) {
        return $this.j(model2, trackInvalid);
    }

    public static final /* synthetic */ RangeHighlighterEx access$recycle(FrontendMarkupContributor $this, HighlighterElement element) {
        return $this.j(element);
    }

    public static final /* synthetic */ HighlighterRangeRepairer access$getHighlighterRepairer$p(FrontendMarkupContributor $this) {
        return $this.highlighterRepairer;
    }

    public static final /* synthetic */ boolean access$isReplaced(FrontendMarkupContributor $this, HighlighterModel highlighterModel) {
        return $this.j(highlighterModel);
    }

    public static final /* synthetic */ void access$queueUpdateIfNeed(FrontendMarkupContributor $this) {
        $this.j();
    }

    public static final /* synthetic */ void access$highlightersRemoved(FrontendMarkupContributor $this, List removed) {
        $this.j(removed);
    }

    public static final /* synthetic */ void access$highlightersAdded(FrontendMarkupContributor $this, List added) {
        $this.w(added);
    }

    public static final /* synthetic */ void access$highlightersUpdated(FrontendMarkupContributor $this, List updated) {
        $this.N(updated);
    }

    public static final /* synthetic */ void access$removeAllHighlighters(FrontendMarkupContributor $this) {
        $this.N();
    }

    static {
        boolean bl = false;
        Logger logger = Logger.getInstance(FrontendMarkupContributor.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        FrontendMarkupContributor.logger = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0005\u001a\u00020\u0006*\u0004\u0018\u00010\u00072\n\u0010\b\u001a\u00060\tj\u0002`\n2\b\b\u0002\u0010\u000b\u001a\u00020\fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/jetbrains/rdclient/daemon/FrontendMarkupContributor$Companion;", "", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "prettyPrint", "", "Lcom/jetbrains/ide/model/highlighterRegistration/TextAttributesKeyModel;", "result", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "depth", "", "intellij.rd.client"})
    public static final class Companion {
        private Companion() {
        }

        public final void prettyPrint(@Nullable TextAttributesKeyModel $this$prettyPrint, @NotNull StringBuilder result2, int depth) {
            Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
            if ($this$prettyPrint == null) {
                StringBuilder stringBuilder = result2.append("[NULL KEY]");
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder, (String)"append(...)");
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder.append('\n'), (String)"append(...)");
                return;
            }
            if (!($this$prettyPrint instanceof IdeaTextAttributesKey)) {
                StringBuilder stringBuilder = result2.append("[NON-IDEA KEY]");
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder, (String)"append(...)");
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder.append('\n'), (String)"append(...)");
                return;
            }
            String string = "  ";
            StringBuilder stringBuilder = result2.append($this$prettyPrint.getExternalName());
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder, (String)"append(...)");
            Object object = stringBuilder;
            StringBuilder stringBuilder2 = ((StringBuilder)object).append(" (");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append(...)");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2.append('\n'), (String)"append(...)");
            com.jetbrains.rdclient.daemon.FrontendMarkupContributor$Companion.j(depth, result2, string).append(string).append("fallback: ");
            object = ((IdeaTextAttributesKey)$this$prettyPrint).getFallback();
            if (object == null) {
                StringBuilder stringBuilder3 = result2.append("NULL");
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3, (String)"append(...)");
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3.append('\n'), (String)"append(...)");
            } else {
                this.prettyPrint((TextAttributesKeyModel)object, result2, depth + 1);
            }
            StringBuilder stringBuilder4 = com.jetbrains.rdclient.daemon.FrontendMarkupContributor$Companion.j(depth, result2, string).append(")");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4, (String)"append(...)");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4.append('\n'), (String)"append(...)");
        }

        public static /* synthetic */ void prettyPrint$default(Companion companion, TextAttributesKeyModel textAttributesKeyModel, StringBuilder stringBuilder, int n, int n2, Object object) {
            if ((n2 & 2) != 0) {
                n = 0;
            }
            companion.prettyPrint(textAttributesKeyModel, stringBuilder, n);
        }

        private static final StringBuilder j(int n, StringBuilder stringBuilder, String string) {
            for (int k = 0; k < n; ++k) {
                stringBuilder.append(string);
            }
            return stringBuilder;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0001H\u0016J\b\u0010\b\u001a\u00020\tH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/jetbrains/rdclient/daemon/FrontendMarkupContributor$MergingUpdateTask;", "Lcom/intellij/util/ui/update/Update;", "modality", "Lcom/intellij/openapi/application/ModalityState;", "(Lcom/jetbrains/rdclient/daemon/FrontendMarkupContributor;Lcom/intellij/openapi/application/ModalityState;)V", "canEat", "", "update", "run", "", "intellij.rd.client"})
    @SourceDebugExtension(value={"SMAP\nFrontendMarkupContributor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FrontendMarkupContributor.kt\ncom/jetbrains/rdclient/daemon/FrontendMarkupContributor$MergingUpdateTask\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,311:1\n65#2,4:312\n*S KotlinDebug\n*F\n+ 1 FrontendMarkupContributor.kt\ncom/jetbrains/rdclient/daemon/FrontendMarkupContributor$MergingUpdateTask\n*L\n41#1:312,4\n*E\n"})
    private final class MergingUpdateTask
    extends Update {
        @NotNull
        private final ModalityState modality;

        public MergingUpdateTask(ModalityState modality) {
            Intrinsics.checkNotNullParameter((Object)modality, (String)"modality");
            super((Object)modality);
            this.modality = modality;
        }

        public void run() {
            ApplicationKt.getApplication().invokeLater(() -> MergingUpdateTask.j(FrontendMarkupContributor.this, this), this.modality);
        }

        public boolean canEat(@NotNull Update update2) {
            Intrinsics.checkNotNullParameter((Object)update2, (String)"update");
            if (!(update2 instanceof MergingUpdateTask)) {
                return false;
            }
            ModalityState modalityState = ((MergingUpdateTask)update2).modality;
            return Intrinsics.areEqual((Object)this.modality, (Object)modalityState) || this.modality.dominates(modalityState);
        }

        private static final void j(FrontendMarkupContributor frontendMarkupContributor, MergingUpdateTask mergingUpdateTask) {
            Intrinsics.checkNotNullParameter((Object)frontendMarkupContributor, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)((Object)mergingUpdateTask), (String)"this$1");
            if (frontendMarkupContributor.suppressor.isSuppressed$intellij_rd_client() == MarkupSuppressionKind.NONE && RLifetimeKt.isAlive((Lifetime)frontendMarkupContributor.getLifetime())) {
                Logger logger = logger;
                boolean bl = false;
                if (logger.isTraceEnabled()) {
                    Logger logger2 = logger;
                    boolean bl2 = false;
                    logger2.trace("MergingUpdateTask.run&invokeLater: call flushHighlighters(). modality: " + mergingUpdateTask.modality);
                }
                frontendMarkupContributor.w();
            }
        }
    }
}

