/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdclient.daemon;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.impl.event.MarkupModelListener;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.rd.LifetimeDisposableExKt;
import com.intellij.openapi.util.Key;
import com.jetbrains.rd.ide.editor.markup.ExtendedBackendProperties;
import com.jetbrains.rd.ide.editor.markup.UtilKt;
import com.jetbrains.rd.ide.model.HighlighterElement;
import com.jetbrains.rd.ide.model.HighlighterModel;
import com.jetbrains.rd.ide.model.MarkupModelExtension;
import com.jetbrains.rd.ide.model.RdDaemonModel;
import com.jetbrains.rd.ide.model.RdMarkupModel;
import com.jetbrains.rd.util.CollectionExKt;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rdclient.daemon.CompoundHighlighterModelsHandler;
import com.jetbrains.rdclient.daemon.FrontendHighlighterExtensionHandler;
import com.jetbrains.rdclient.daemon.FrontendMarkupAdapter;
import com.jetbrains.rdclient.daemon.FrontendMarkupAdapterImpl;
import com.jetbrains.rdclient.daemon.FrontendMarkupAdapterListener;
import com.jetbrains.rdclient.daemon.IProtocolHighlighterModelHandler;
import com.jetbrains.rdclient.daemon.util.HighlightersUtilKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\b\u0016\u0018\u0000 72\u00020\u0001:\u00017B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u001d\u001a\u00020\u000b2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0018\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u001cH\u0016J\u001c\u0010%\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00182\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\u001f0\u0018H\u0016J\u0016\u0010'\u001a\u00020!2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0018H\u0016J\u001c\u0010)\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020!0*2\u0006\u0010+\u001a\u00020\u001fH\u0002J'\u0010,\u001a\u0004\u0018\u0001H-\"\b\b\u0000\u0010-*\u00020\u00192\f\u0010.\u001a\b\u0012\u0004\u0012\u0002H-0/H\u0016\u00a2\u0006\u0002\u00100J\u0016\u00101\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00182\u0006\u00102\u001a\u000203H\u0016J\u0010\u00104\u001a\u00020!2\u0006\u00105\u001a\u00020\u000bH\u0016J\u0018\u00106\u001a\u00020!2\u0006\u00105\u001a\u00020\u000b2\u0006\u0010+\u001a\u00020\u001fH\u0016R\u001a\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\u00020\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0019\u0010\u0012\u001a\u00070\u0013\u00a2\u0006\u0002\b\u0014X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00068"}, d2={"Lcom/jetbrains/rdclient/daemon/FrontendMarkupAdapterImpl;", "Lcom/jetbrains/rdclient/daemon/FrontendMarkupAdapter;", "rdMarkupModel", "Lcom/jetbrains/rd/ide/model/RdMarkupModel;", "ideaMarkup", "Lcom/intellij/openapi/editor/ex/MarkupModelEx;", "compoundHandler", "Lcom/jetbrains/rdclient/daemon/CompoundHighlighterModelsHandler;", "(Lcom/jetbrains/rd/ide/model/RdMarkupModel;Lcom/intellij/openapi/editor/ex/MarkupModelEx;Lcom/jetbrains/rdclient/daemon/CompoundHighlighterModelsHandler;)V", "allHighlighters", "", "Lcom/intellij/openapi/editor/ex/RangeHighlighterEx;", "getAllHighlighters", "()[Lcom/intellij/openapi/editor/ex/RangeHighlighterEx;", "daemonModel", "Lcom/jetbrains/rd/ide/model/RdDaemonModel;", "getDaemonModel", "()Lcom/jetbrains/rd/ide/model/RdDaemonModel;", "document", "Lcom/intellij/openapi/editor/Document;", "Lorg/jetbrains/annotations/NotNull;", "getDocument", "()Lcom/intellij/openapi/editor/Document;", "extensions", "", "Lcom/jetbrains/rd/ide/model/MarkupModelExtension;", "listeners", "", "Lcom/jetbrains/rdclient/daemon/FrontendMarkupAdapterListener;", "addHighlighter", "element", "Lcom/jetbrains/rd/ide/model/HighlighterElement;", "addListener", "", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "listener", "bulkAddHighlighters", "elements", "bulkRemoveHighlighters", "highlighters", "j", "Lkotlin/Function1;", "newElement", "getExtension", "T", "key", "Lcom/intellij/openapi/util/Key;", "(Lcom/intellij/openapi/util/Key;)Lcom/jetbrains/rd/ide/model/MarkupModelExtension;", "getHighlighters", "offset", "", "removeHighlighter", "highlighter", "updateHighlighter", "Companion", "intellij.rd.client"})
@SourceDebugExtension(value={"SMAP\nFrontendMarkupAdapterImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FrontendMarkupAdapterImpl.kt\ncom/jetbrains/rdclient/daemon/FrontendMarkupAdapterImpl\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 6 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,128:1\n65#2,4:129\n65#2,4:133\n65#2,4:137\n65#2,4:142\n13#2:167\n1#3:141\n1#3:162\n1549#4:146\n1620#4,3:147\n288#4,2:150\n11383#5,9:152\n13309#5:161\n13310#5:163\n11392#5:164\n37#6,2:165\n*S KotlinDebug\n*F\n+ 1 FrontendMarkupAdapterImpl.kt\ncom/jetbrains/rdclient/daemon/FrontendMarkupAdapterImpl\n*L\n34#1:129,4\n38#1:133,4\n55#1:137,4\n89#1:142,4\n27#1:167\n122#1:162\n102#1:146\n102#1:147,3\n118#1:150,2\n122#1:152,9\n122#1:161\n122#1:163\n122#1:164\n122#1:165,2\n*E\n"})
public class FrontendMarkupAdapterImpl
implements FrontendMarkupAdapter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final MarkupModelEx ideaMarkup;
    @NotNull
    private final CompoundHighlighterModelsHandler compoundHandler;
    @NotNull
    private final List<FrontendMarkupAdapterListener> listeners;
    @NotNull
    private final List<MarkupModelExtension> extensions;
    @NotNull
    private final Document document;
    @NotNull
    private final RdDaemonModel daemonModel;
    @NotNull
    private static final Logger logger;

    public FrontendMarkupAdapterImpl(@NotNull RdMarkupModel rdMarkupModel, @NotNull MarkupModelEx ideaMarkup, @NotNull CompoundHighlighterModelsHandler compoundHandler) {
        Intrinsics.checkNotNullParameter((Object)((Object)rdMarkupModel), (String)"rdMarkupModel");
        Intrinsics.checkNotNullParameter((Object)ideaMarkup, (String)"ideaMarkup");
        Intrinsics.checkNotNullParameter((Object)compoundHandler, (String)"compoundHandler");
        this.ideaMarkup = ideaMarkup;
        this.compoundHandler = compoundHandler;
        this.listeners = new ArrayList();
        this.extensions = rdMarkupModel.getExtensions();
        Document document = this.ideaMarkup.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        this.document = document;
        this.daemonModel = rdMarkupModel.getDaemon();
    }

    @Override
    public void updateHighlighter(@NotNull RangeHighlighterEx highlighter2, @NotNull HighlighterElement newElement) {
        Intrinsics.checkNotNullParameter((Object)highlighter2, (String)"highlighter");
        Intrinsics.checkNotNullParameter((Object)newElement, (String)"newElement");
        if (!highlighter2.isValid()) {
            Logger logger = FrontendMarkupAdapterImpl.logger;
            boolean bl = false;
            if (logger.isTraceEnabled()) {
                Logger logger2 = logger;
                boolean bl2 = false;
                logger2.trace("Skipping update of invalid highlighter " + HighlightersUtilKt.prettyPrint((RangeHighlighter)highlighter2));
            }
            return;
        }
        HighlighterModel highlighterModel = newElement.getHighlighter();
        Logger logger = FrontendMarkupAdapterImpl.logger;
        boolean bl = false;
        if (logger.isTraceEnabled()) {
            Logger logger3 = logger;
            boolean bl3 = false;
            logger3.trace("Updating highlighter " + HighlightersUtilKt.prettyPrint((RangeHighlighter)highlighter2));
        }
        this.ideaMarkup.changeAttributesInBatch(highlighter2, arg_0 -> FrontendMarkupAdapterImpl.N(this.j(newElement), arg_0));
        FrontendHighlighterExtensionHandler.Companion.getEP_NAME().forEachExtensionSafe(arg_0 -> FrontendMarkupAdapterImpl.w((Function1)new Function1<FrontendHighlighterExtensionHandler, Unit>(highlighter2, highlighterModel, newElement){
            final /* synthetic */ RangeHighlighterEx $highlighter;
            final /* synthetic */ HighlighterModel $newModel;
            final /* synthetic */ HighlighterElement $newElement;
            {
                this.$highlighter = $highlighter;
                this.$newModel = $newModel;
                this.$newElement = $newElement;
                super(1);
            }

            public final void invoke(@NotNull FrontendHighlighterExtensionHandler it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                it.processExtension(this.$highlighter, this.$newModel, this.$newElement.getExtensions());
            }
        }, arg_0));
        for (FrontendMarkupAdapterListener frontendMarkupAdapterListener : this.listeners) {
            frontendMarkupAdapterListener.afterUpdated(highlighter2);
        }
    }

    @Override
    @NotNull
    public RangeHighlighterEx addHighlighter(@NotNull HighlighterElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        HighlighterModel highlighterModel = element.getHighlighter();
        int n = highlighterModel.getStart();
        int n2 = highlighterModel.getEnd();
        int n3 = highlighterModel.getLayer();
        HighlighterTargetArea highlighterTargetArea = HighlightersUtilKt.toIdeaTargetArea(highlighterModel);
        Logger logger = FrontendMarkupAdapterImpl.logger;
        boolean bl = false;
        if (logger.isTraceEnabled()) {
            Logger logger2 = logger;
            boolean bl2 = false;
            logger2.trace("Registering new highlighter '" + highlighterModel.getProperties().getAttributeId() + "', model: " + HighlightersUtilKt.prettyPrint(highlighterModel));
        }
        RangeHighlighterEx rangeHighlighterEx = this.ideaMarkup.addRangeHighlighterAndChangeAttributes(null, n, n2, n3, highlighterTargetArea, false, arg_0 -> FrontendMarkupAdapterImpl.j(this.j(element), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)rangeHighlighterEx, (String)"addRangeHighlighterAndChangeAttributes(...)");
        logger = rangeHighlighterEx;
        return logger;
    }

    @Override
    @NotNull
    public List<RangeHighlighterEx> getHighlighters(int offset) {
        List list2 = new ArrayList();
        this.ideaMarkup.processRangeHighlightersOverlappingWith(offset, offset, arg_0 -> FrontendMarkupAdapterImpl.j((Function1)new Function1<RangeHighlighterEx, Boolean>((List<RangeHighlighterEx>)list2){
            final /* synthetic */ List<RangeHighlighterEx> $result;
            {
                this.$result = $result;
                super(1);
            }

            @NotNull
            public final Boolean invoke(RangeHighlighterEx it) {
                Intrinsics.checkNotNull((Object)it);
                if (HighlightersUtilKt.isFromBackend((RangeHighlighter)it)) {
                    this.$result.add(it);
                }
                return true;
            }
        }, arg_0));
        return list2;
    }

    private final Function1<RangeHighlighterEx, Unit> j(HighlighterElement highlighterElement) {
        return (Function1)new Function1<RangeHighlighterEx, Unit>(highlighterElement, this){
            final /* synthetic */ HighlighterElement $newElement;
            final /* synthetic */ FrontendMarkupAdapterImpl this$0;
            {
                this.$newElement = $newElement;
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull RangeHighlighterEx highlighter2) {
                Intrinsics.checkNotNullParameter((Object)highlighter2, (String)"highlighter");
                HighlighterModel highlighterModel = this.$newElement.getHighlighter();
                highlighter2.setGreedyToLeft(highlighterModel.isGreedyToLeft());
                highlighter2.setGreedyToRight(highlighterModel.isGreedyToRight());
                highlighter2.setThinErrorStripeMark(highlighterModel.isThinErrorStripeMark());
                highlighter2.setVisibleIfFolded(highlighterModel.getProperties().isVisibleIfFolded());
                IProtocolHighlighterModelHandler iProtocolHighlighterModelHandler = FrontendMarkupAdapterImpl.access$getCompoundHandler$p(this.this$0).getHandler(highlighterModel);
                iProtocolHighlighterModelHandler.initialize(highlighterModel, (RangeHighlighter)highlighter2);
                UtilKt.setExtendedBackendProperties((RangeHighlighter)highlighter2, new ExtendedBackendProperties(highlighterModel.getProperties(), highlighterModel.getId(), iProtocolHighlighterModelHandler, false, 8, null));
                FrontendHighlighterExtensionHandler.Companion.getEP_NAME().forEachExtensionSafe(arg_0 -> changeAttributeAction.1.j((Function1)new Function1<FrontendHighlighterExtensionHandler, Unit>(highlighter2, highlighterModel, this.$newElement){
                    final /* synthetic */ RangeHighlighterEx $highlighter;
                    final /* synthetic */ HighlighterModel $newModel;
                    final /* synthetic */ HighlighterElement $newElement;
                    {
                        this.$highlighter = $highlighter;
                        this.$newModel = $newModel;
                        this.$newElement = $newElement;
                        super(1);
                    }

                    public final void invoke(@NotNull FrontendHighlighterExtensionHandler it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        it.processExtension(this.$highlighter, this.$newModel, this.$newElement.getExtensions());
                    }
                }, arg_0));
            }

            private static final void j(Function1 function1, Object object) {
                Intrinsics.checkNotNullParameter((Object)function1, (String)"$tmp0");
                function1.invoke(object);
            }
        };
    }

    @Override
    public void removeHighlighter(@NotNull RangeHighlighterEx highlighter2) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)highlighter2, (String)"highlighter");
        boolean bl2 = bl = HighlightersUtilKt.getBackendAttributeId((RangeHighlighter)highlighter2) != null;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string = "Removing highlighter hasn't been registered by markup adapter";
            throw new AssertionError((Object)string);
        }
        Logger logger = FrontendMarkupAdapterImpl.logger;
        boolean bl4 = false;
        if (logger.isTraceEnabled()) {
            Logger logger2 = logger;
            boolean bl5 = false;
            logger2.trace("Removed highlighter from markup: " + HighlightersUtilKt.prettyPrint((RangeHighlighter)highlighter2));
        }
        Object object = UtilKt.getHandler((RangeHighlighter)highlighter2);
        IProtocolHighlighterModelHandler iProtocolHighlighterModelHandler = object instanceof IProtocolHighlighterModelHandler ? (IProtocolHighlighterModelHandler)object : null;
        if (iProtocolHighlighterModelHandler != null) {
            iProtocolHighlighterModelHandler.deinitialize((RangeHighlighter)highlighter2);
        }
        this.ideaMarkup.removeHighlighter((RangeHighlighter)highlighter2);
    }

    @Override
    public void bulkRemoveHighlighters(@NotNull List<? extends RangeHighlighterEx> highlighters) {
        Intrinsics.checkNotNullParameter(highlighters, (String)"highlighters");
        for (FrontendMarkupAdapterListener frontendMarkupAdapterListener : this.listeners) {
            frontendMarkupAdapterListener.beforeBulkRemove(highlighters);
        }
        for (RangeHighlighterEx rangeHighlighterEx : highlighters) {
            this.removeHighlighter(rangeHighlighterEx);
        }
    }

    @Override
    @NotNull
    public List<RangeHighlighterEx> bulkAddHighlighters(@NotNull List<HighlighterElement> elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        Iterable iterable = elements;
        boolean bl = false;
        Iterable iterable2 = iterable;
        Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)iterable, (int)10));
        boolean bl2 = false;
        for (Object t : iterable2) {
            HighlighterElement highlighterElement = (HighlighterElement)t;
            Collection collection2 = collection;
            boolean bl3 = false;
            collection2.add(this.addHighlighter(highlighterElement));
        }
        List list2 = (List)collection;
        for (FrontendMarkupAdapterListener frontendMarkupAdapterListener : this.listeners) {
            frontendMarkupAdapterListener.afterBulkAdd(list2);
        }
        return list2;
    }

    @Override
    public void addListener(@NotNull Lifetime lifetime, @NotNull FrontendMarkupAdapterListener listener2) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        CollectionExKt.addUnique((Collection)this.listeners, (Lifetime)lifetime, (Object)listener2);
        String string = Reflection.getOrCreateKotlinClass(FrontendMarkupAdapterListener.class).getSimpleName();
        Intrinsics.checkNotNull((Object)string);
        Disposable disposable = LifetimeDisposableExKt.createNestedDisposable((Lifetime)lifetime, (String)string);
        this.ideaMarkup.addMarkupModelListener(disposable, (MarkupModelListener)listener2);
    }

    @Override
    @Nullable
    public <T extends MarkupModelExtension> T getExtension(@NotNull Key<T> key) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter(key, (String)"key");
            Iterable iterable = this.extensions;
            boolean bl = false;
            for (Object t : iterable) {
                MarkupModelExtension markupModelExtension = (MarkupModelExtension)((Object)t);
                boolean bl2 = false;
                if (!Intrinsics.areEqual((Object)markupModelExtension.getKey(), (Object)key.toString())) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        Object var2_8 = v0;
        return (T)((Object)(var2_8 instanceof MarkupModelExtension ? (MarkupModelExtension)var2_8 : null));
    }

    @Override
    @NotNull
    public RangeHighlighterEx[] getAllHighlighters() {
        RangeHighlighter[] rangeHighlighterArray = this.ideaMarkup.getAllHighlighters();
        Intrinsics.checkNotNullExpressionValue((Object)rangeHighlighterArray, (String)"getAllHighlighters(...)");
        Object object = rangeHighlighterArray;
        boolean bl = false;
        Object[] objectArray = object;
        Collection collection = new ArrayList();
        boolean bl2 = false;
        Object[] objectArray2 = objectArray;
        boolean bl3 = false;
        int n = objectArray2.length;
        for (int k = 0; k < n; ++k) {
            RangeHighlighterEx rangeHighlighterEx;
            Object object2;
            Object object3 = object2 = objectArray2[k];
            boolean bl4 = false;
            RangeHighlighter rangeHighlighter = (RangeHighlighter)object3;
            boolean bl5 = false;
            Intrinsics.checkNotNull((Object)rangeHighlighter);
            if ((HighlightersUtilKt.isFromBackend(rangeHighlighter) ? (rangeHighlighter instanceof RangeHighlighterEx ? (RangeHighlighterEx)rangeHighlighter : null) : null) == null) continue;
            rangeHighlighterEx = rangeHighlighterEx;
            boolean bl6 = false;
            collection.add(rangeHighlighterEx);
        }
        object = (List)collection;
        bl = false;
        objectArray = object;
        return objectArray.toArray(new RangeHighlighterEx[0]);
    }

    @Override
    @NotNull
    public Document getDocument() {
        return this.document;
    }

    @Override
    @NotNull
    public RdDaemonModel getDaemonModel() {
        return this.daemonModel;
    }

    private static final void N(Function1 function1, Object object) {
        Intrinsics.checkNotNullParameter((Object)function1, (String)"$tmp0");
        function1.invoke(object);
    }

    private static final void w(Function1 function1, Object object) {
        Intrinsics.checkNotNullParameter((Object)function1, (String)"$tmp0");
        function1.invoke(object);
    }

    private static final void j(Function1 function1, Object object) {
        Intrinsics.checkNotNullParameter((Object)function1, (String)"$tmp0");
        function1.invoke(object);
    }

    private static final boolean j(Function1 function1, Object object) {
        Intrinsics.checkNotNullParameter((Object)function1, (String)"$tmp0");
        return (Boolean)function1.invoke(object);
    }

    public static final /* synthetic */ CompoundHighlighterModelsHandler access$getCompoundHandler$p(FrontendMarkupAdapterImpl $this) {
        return $this.compoundHandler;
    }

    static {
        boolean bl = false;
        Logger logger = Logger.getInstance(FrontendMarkupAdapterImpl.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        FrontendMarkupAdapterImpl.logger = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/jetbrains/rdclient/daemon/FrontendMarkupAdapterImpl$Companion;", "", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.rd.client"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

