/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdclient.daemon;

import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.jetbrains.rd.ide.model.HighlighterModel;
import com.jetbrains.rdclient.daemon.IProtocolHighlighterModelHandler;
import com.jetbrains.rdclient.daemon.util.HighlightersUtilKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\t\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u000e\u0010\f\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\bJ\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\"\u0010\u000f\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0007\u001a\u00020\bH\u0016R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/jetbrains/rdclient/daemon/CompoundHighlighterModelsHandler;", "Lcom/jetbrains/rdclient/daemon/IProtocolHighlighterModelHandler;", "handlers", "", "(Ljava/util/List;)V", "accept", "", "model", "Lcom/jetbrains/rd/ide/model/HighlighterModel;", "compare", "highlighter", "Lcom/intellij/openapi/editor/markup/RangeHighlighter;", "getHandler", "initialize", "", "move", "startOffset", "", "endOffset", "intellij.rd.client"})
public final class CompoundHighlighterModelsHandler
implements IProtocolHighlighterModelHandler {
    @NotNull
    private final List<IProtocolHighlighterModelHandler> handlers;

    public CompoundHighlighterModelsHandler(@NotNull List<? extends IProtocolHighlighterModelHandler> handlers2) {
        Intrinsics.checkNotNullParameter(handlers2, (String)"handlers");
        this.handlers = handlers2;
    }

    @Override
    public boolean accept(@NotNull HighlighterModel model2) {
        Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
        this.getHandler(model2);
        return true;
    }

    @Override
    public void initialize(@NotNull HighlighterModel model2, @NotNull RangeHighlighter highlighter2) {
        Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
        Intrinsics.checkNotNullParameter((Object)highlighter2, (String)"highlighter");
        this.getHandler(model2).initialize(model2, highlighter2);
    }

    @Override
    public boolean compare(@NotNull HighlighterModel model2, @NotNull RangeHighlighter highlighter2) {
        Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
        Intrinsics.checkNotNullParameter((Object)highlighter2, (String)"highlighter");
        return this.getHandler(model2).compare(model2, highlighter2);
    }

    @Override
    @Nullable
    public HighlighterModel move(int startOffset, int endOffset, @NotNull HighlighterModel model2) {
        Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
        return this.getHandler(model2).move(startOffset, endOffset, model2);
    }

    @NotNull
    public final IProtocolHighlighterModelHandler getHandler(@NotNull HighlighterModel model2) {
        Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
        Object object = null;
        for (IProtocolHighlighterModelHandler iProtocolHighlighterModelHandler : this.handlers) {
            if (!iProtocolHighlighterModelHandler.accept(model2)) continue;
            if (object != null) {
                String string = "Both '" + Reflection.getOrCreateKotlinClass(object.getClass()).getQualifiedName() + "' and '" + Reflection.getOrCreateKotlinClass(iProtocolHighlighterModelHandler.getClass()).getQualifiedName() + "' are registered for " + HighlightersUtilKt.prettyPrint(model2) + ", class: " + Reflection.getOrCreateKotlinClass(model2.getClass()).getQualifiedName();
                throw new IllegalArgumentException(string);
            }
            object = iProtocolHighlighterModelHandler;
        }
        if (object == null) {
            throw new IllegalArgumentException("Haven't found matching handler for " + HighlightersUtilKt.prettyPrint(model2) + ", class: " + Reflection.getOrCreateKotlinClass(model2.getClass()).getQualifiedName());
        }
        return object;
    }
}

