/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdclient.completion;

import com.intellij.codeInsight.lookup.LookupElementPresentation;
import com.intellij.codeInsight.lookup.impl.LookupManagerImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.ui.EmptyIcon;
import com.jetbrains.rd.ide.completion.IProtocolLookupItem;
import com.jetbrains.rd.ide.model.CompletionItem;
import com.jetbrains.rd.ide.model.LookupSummaryInfo;
import com.jetbrains.rd.ui.completion.RdLookupItemBase;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.RLifetimeKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0016\u0018\u0000 \u001e2\u00020\u00012\u00020\u0002:\u0001\u001eB\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\u0017\u001a\u00020\u0018H\u0004J\u0010\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0006\u0010\u001c\u001a\u00020\u001dR\u0016\u0010\b\u001a\n\u0018\u00010\tj\u0004\u0018\u0001`\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001c\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016\u00a8\u0006\u001f"}, d2={"Lcom/jetbrains/rdclient/completion/ProtocolLookupItemBase;", "Lcom/jetbrains/rd/ide/completion/IProtocolLookupItem;", "Lcom/jetbrains/rd/ui/completion/RdLookupItemBase;", "completionItem", "Lcom/jetbrains/rd/ide/model/CompletionItem;", "sessionLifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "(Lcom/jetbrains/rd/ide/model/CompletionItem;Lcom/jetbrains/rd/util/lifetime/Lifetime;)V", "lifetimeTerminationStacktrace", "Ljava/lang/Exception;", "Lkotlin/Exception;", "priority", "", "getPriority", "()J", "getSessionLifetime", "()Lcom/jetbrains/rd/util/lifetime/Lifetime;", "summaryInfo", "Lcom/jetbrains/rd/ide/model/LookupSummaryInfo;", "getSummaryInfo", "()Lcom/jetbrains/rd/ide/model/LookupSummaryInfo;", "setSummaryInfo", "(Lcom/jetbrains/rd/ide/model/LookupSummaryInfo;)V", "checkLifetime", "", "renderElement", "presentation", "Lcom/intellij/codeInsight/lookup/LookupElementPresentation;", "shouldRequestUpdate", "", "Companion", "intellij.rd.client"})
@SourceDebugExtension(value={"SMAP\nProtocolLookupItem.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProtocolLookupItem.kt\ncom/jetbrains/rdclient/completion/ProtocolLookupItemBase\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Logger.kt\ncom/jetbrains/rd/platform/util/LoggerKt\n*L\n1#1,69:1\n65#2,4:70\n13#2:76\n1#3:74\n13#4:75\n*S KotlinDebug\n*F\n+ 1 ProtocolLookupItem.kt\ncom/jetbrains/rdclient/completion/ProtocolLookupItemBase\n*L\n40#1:70,4\n27#1:76\n27#1:75\n*E\n"})
public class ProtocolLookupItemBase
extends RdLookupItemBase
implements IProtocolLookupItem {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Lifetime sessionLifetime;
    @Nullable
    private LookupSummaryInfo summaryInfo;
    @Nullable
    private Exception lifetimeTerminationStacktrace;
    @NotNull
    private static final Logger logger;

    public ProtocolLookupItemBase(@NotNull CompletionItem completionItem, @NotNull Lifetime sessionLifetime) {
        Intrinsics.checkNotNullParameter((Object)completionItem, (String)"completionItem");
        Intrinsics.checkNotNullParameter((Object)sessionLifetime, (String)"sessionLifetime");
        super(completionItem);
        this.sessionLifetime = sessionLifetime;
        this.putUserData(LookupManagerImpl.SUPPRESS_AUTOPOPUP_JAVADOC, true);
        if (logger.isTraceEnabled() && RLifetimeKt.isNotAlive((Lifetime)this.sessionLifetime)) {
            Logger logger = ProtocolLookupItemBase.logger;
            boolean bl = false;
            if (logger.isTraceEnabled()) {
                Logger logger2 = logger;
                boolean bl2 = false;
                logger2.trace("Lifetime of lookup item " + this + " is terminated");
            }
        }
        this.sessionLifetime.onTerminationIfAlive((Function0)new Function0<Unit>(){

            public final void invoke() {
                if (logger.isTraceEnabled()) {
                    lifetimeTerminationStacktrace = new Exception();
                }
            }
        });
    }

    @NotNull
    public final Lifetime getSessionLifetime() {
        return this.sessionLifetime;
    }

    @Nullable
    public final LookupSummaryInfo getSummaryInfo() {
        return this.summaryInfo;
    }

    public final void setSummaryInfo(@Nullable LookupSummaryInfo lookupSummaryInfo) {
        this.summaryInfo = lookupSummaryInfo;
    }

    protected final void checkLifetime() {
        if (logger.isTraceEnabled() && RLifetimeKt.isNotAlive((Lifetime)this.sessionLifetime)) {
            logger.error("Session lifetime of lookup item " + this + " was terminated from following stack", (Throwable)this.lifetimeTerminationStacktrace);
        }
        if (!RLifetimeKt.isAlive((Lifetime)this.sessionLifetime)) {
            boolean bl = false;
            String string = "Session lifetime of lookup item " + this + " is terminated";
            throw new IllegalArgumentException(string.toString());
        }
    }

    public final boolean shouldRequestUpdate() {
        return this.getDisplayName() == null;
    }

    @Override
    public void renderElement(@NotNull LookupElementPresentation presentation) {
        Intrinsics.checkNotNullParameter((Object)presentation, (String)"presentation");
        super.renderElement(presentation);
        if (presentation.getIcon() == null) {
            presentation.setIcon(EmptyIcon.ICON_16);
        }
    }

    @Override
    public long getPriority() {
        return this.getCompletionItem().getPriority();
    }

    static {
        boolean bl = false;
        boolean bl2 = false;
        Logger logger = Logger.getInstance(ProtocolLookupItemBase.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        ProtocolLookupItemBase.logger = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/jetbrains/rdclient/completion/ProtocolLookupItemBase$Companion;", "", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.rd.client"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

