/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdclient.completion;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupEvent;
import com.intellij.codeInsight.lookup.LookupListener;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.codeInsight.lookup.impl.LookupImpl;
import com.intellij.codeInsight.lookup.impl.LookupManagerImpl;
import com.intellij.codeWithMe.ClientId;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.client.ClientAppSession;
import com.intellij.openapi.client.ClientSession;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.rd.LifetimeDisposableExKt;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.jetbrains.rd.ide.completion.LookupImplWrapper;
import com.jetbrains.rd.ide.completion.LookupModelWrapper;
import com.jetbrains.rd.ide.completion.LookupWrapper;
import com.jetbrains.rd.ide.completion.LookupWrapperListener;
import com.jetbrains.rd.ide.editor.EditorSynchronizer;
import com.jetbrains.rd.ide.model.CompletionItem;
import com.jetbrains.rd.ide.model.CustomLookupModel;
import com.jetbrains.rd.ide.model.LookupModel;
import com.jetbrains.rd.ide.model.LookupModel_GeneratedKt;
import com.jetbrains.rd.ide.model.RdFakeLookupChooseItemStep;
import com.jetbrains.rd.ide.model.TextControlId;
import com.jetbrains.rd.ide.model.TextControlModel;
import com.jetbrains.rd.ide.requests.ChangeScope;
import com.jetbrains.rd.ide.requests.PatchEngine;
import com.jetbrains.rd.ide.requests.RdPatchEngine;
import com.jetbrains.rd.platform.util.idea.LifetimedService;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.LifetimeDefinition;
import com.jetbrains.rd.util.reactive.ISource;
import com.jetbrains.rd.util.reactive.SourceExKt;
import com.jetbrains.rdclient.client.FrontendSessionsUtilKt;
import com.jetbrains.rdclient.completion.CustomLookupHost;
import com.jetbrains.rdclient.completion.FrontendLookupManagerImpl;
import com.jetbrains.rdclient.completion.ProtocolLookupItemBase;
import com.jetbrains.rdclient.document.DocumentExKt;
import com.jetbrains.rdclient.editors.FrontendTextControlHostKt;
import com.jetbrains.rdclient.patches.FrontendPatchEngineKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J(\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0016\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018J\u0006\u0010\u0019\u001a\u00020\fJ\u0010\u0010\u001a\u001a\u00020\f2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\b\u0010\u001d\u001a\u00020\fH\u0002R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u001f"}, d2={"Lcom/jetbrains/rdclient/completion/CustomLookupHost;", "Lcom/jetbrains/rd/platform/util/idea/LifetimedService;", "session", "Lcom/intellij/openapi/client/ClientAppSession;", "(Lcom/intellij/openapi/client/ClientAppSession;)V", "currentCustomLookup", "Lcom/intellij/codeInsight/lookup/impl/LookupImpl;", "lookupEventMask", "Lcom/jetbrains/rd/ide/completion/LookupWrapperListener$EventMask;", "getSession", "()Lcom/intellij/openapi/client/ClientAppSession;", "createCustomLookup", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "customLookup", "Lcom/jetbrains/rd/ide/model/CustomLookupModel;", "lookupModel", "Lcom/jetbrains/rd/ide/model/LookupModel;", "project", "Lcom/intellij/openapi/project/Project;", "editorId", "Lcom/jetbrains/rd/ide/model/TextControlId;", "lookupId", "", "globallyHideCustomLookup", "j", "ignoreHiding", "", "j", "Companion", "intellij.rd.client"})
@SourceDebugExtension(value={"SMAP\nCustomLookupHost.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CustomLookupHost.kt\ncom/jetbrains/rdclient/completion/CustomLookupHost\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,142:1\n65#2,4:143\n13#2:147\n*S KotlinDebug\n*F\n+ 1 CustomLookupHost.kt\ncom/jetbrains/rdclient/completion/CustomLookupHost\n*L\n44#1:143,4\n134#1:147\n*E\n"})
public final class CustomLookupHost
extends LifetimedService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ClientAppSession session;
    @Nullable
    private LookupImpl currentCustomLookup;
    @NotNull
    private final LookupWrapperListener.EventMask lookupEventMask;
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static final Key<Boolean> BACKEND_LOOKUP;

    public CustomLookupHost(@NotNull ClientAppSession session) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        this.session = session;
        this.lookupEventMask = new LookupWrapperListener.EventMask(true, false, false, true, false, true, 22, null);
    }

    @NotNull
    public final ClientAppSession getSession() {
        return this.session;
    }

    public final void createCustomLookup(@NotNull TextControlId editorId, int lookupId) {
        Intrinsics.checkNotNullParameter((Object)editorId, (String)"editorId");
        Logger logger = LOG;
        boolean bl = false;
        if (logger.isTraceEnabled()) {
            Logger logger2 = logger;
            boolean bl2 = false;
            logger2.trace("createCustomLookup called. lookupId=" + lookupId);
        }
        Editor editor2 = FrontendTextControlHostKt.toEditorOrNull(editorId);
        if (editor2 == null) {
            return;
        }
        logger = editor2;
        Project project = logger.getProject();
        if (project == null) {
            return;
        }
        Project project2 = project;
        Object object = DocumentExKt.getEditorSynchronizer((Editor)logger);
        if (object == null || (object = object.getEditorModel()) == null) {
            return;
        }
        Object object2 = object;
        LookupModel lookupModel2 = LookupModel_GeneratedKt.getLookupModel((TextControlModel)((Object)object2));
        EditorSynchronizer editorSynchronizer = DocumentExKt.getEditorSynchronizer((Editor)logger);
        if (editorSynchronizer == null || (editorSynchronizer = editorSynchronizer.getTextControlLifetime()) == null) {
            editorSynchronizer = this.getServiceLifetime();
        }
        EditorSynchronizer editorSynchronizer2 = editorSynchronizer;
        SourceExKt.adviseUntil((ISource)((ISource)lookupModel2.getCustomLookup()), (Lifetime)editorSynchronizer2, (Function1)((Function1)new Function1<CustomLookupModel, Boolean>(lookupId, this, (Editor)logger, lookupModel2, project2, (Lifetime)editorSynchronizer2){
            final /* synthetic */ int $lookupId;
            final /* synthetic */ CustomLookupHost this$0;
            final /* synthetic */ Editor $editor;
            final /* synthetic */ LookupModel $lookupModel;
            final /* synthetic */ Project $project;
            final /* synthetic */ Lifetime $lifetime;
            {
                this.$lookupId = $lookupId;
                this.this$0 = $receiver;
                this.$editor = $editor;
                this.$lookupModel = $lookupModel;
                this.$project = $project;
                this.$lifetime = $lifetime;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@Nullable CustomLookupModel customLookup) {
                CustomLookupModel customLookupModel = customLookup;
                boolean bl = customLookupModel != null ? customLookupModel.getId() == this.$lookupId : false;
                if (bl) {
                    Logger logger = CustomLookupHost.access$getLOG$cp();
                    int n = this.$lookupId;
                    boolean bl2 = false;
                    if (logger.isTraceEnabled()) {
                        Logger logger2 = logger;
                        boolean bl3 = false;
                        logger2.trace("textControlModel.lookupModel$advise: creating custom lookup. lookupId=" + n);
                    }
                    CustomLookupHost.access$createCustomLookup(this.this$0, this.$editor, customLookup, this.$lookupModel, this.$project);
                    SourceExKt.adviseUntil((ISource)((ISource)this.$lookupModel.getCustomLookup()), (Lifetime)this.$lifetime, (Function1)((Function1)new Function1<CustomLookupModel, Boolean>(this.this$0){
                        final /* synthetic */ CustomLookupHost this$0;
                        {
                            this.this$0 = $receiver;
                            super(1);
                        }

                        @NotNull
                        public final Boolean invoke(@Nullable CustomLookupModel model2) {
                            if (model2 == null) {
                                Logger logger = CustomLookupHost.access$getLOG$cp();
                                boolean bl = false;
                                if (logger.isTraceEnabled()) {
                                    Logger logger2 = logger;
                                    boolean bl2 = false;
                                    logger2.trace("textControlModel.lookupModel.customLookup$advise: new model is `null`. So hide local lookup");
                                }
                                CustomLookupHost.access$locallyHideCustomLookup(this.this$0);
                            }
                            return model2 == null;
                        }
                    }));
                }
                return customLookup != null && customLookup.getId() >= this.$lookupId;
            }
        }));
    }

    private final void j() {
        this.j(true);
    }

    public final void globallyHideCustomLookup() {
        this.j(false);
    }

    private final void j(boolean bl) {
        block0: {
            ThreadingAssertions.assertEventDispatchThread();
            this.lookupEventMask.setIgnoreHiding(bl);
            LookupImpl lookupImpl = this.currentCustomLookup;
            if (lookupImpl == null) break block0;
            lookupImpl.hide();
        }
    }

    private final void j(Editor editor2, CustomLookupModel customLookupModel, LookupModel lookupModel2, Project project) {
        LookupImpl lookupImpl;
        this.j();
        ClientId clientId = new ClientId(customLookupModel.getOwnerId());
        boolean bl = Intrinsics.areEqual((Object)clientId, (Object)ClientId.Companion.getLocalId());
        LookupManager lookupManager = LookupManagerImpl.getInstance((Project)project);
        Intrinsics.checkNotNull((Object)lookupManager, (String)"null cannot be cast to non-null type com.jetbrains.rdclient.completion.FrontendLookupManagerImpl");
        FrontendLookupManagerImpl frontendLookupManagerImpl = (FrontendLookupManagerImpl)lookupManager;
        this.currentCustomLookup = lookupImpl = frontendLookupManagerImpl.createEmptyLookup(editor2, bl);
        this.lookupEventMask.setIgnoreHiding(false);
        Intrinsics.checkNotNull((Object)lookupImpl, (String)"null cannot be cast to non-null type com.intellij.openapi.Disposable");
        Disposer.register((Disposable)((Disposable)lookupImpl), () -> CustomLookupHost.j(customLookupModel, this));
        LifetimeDefinition lifetimeDefinition = LifetimeDisposableExKt.defineNestedLifetime((Disposable)((Disposable)lookupImpl));
        LookupImplWrapper lookupImplWrapper = new LookupImplWrapper(lookupImpl, false);
        LookupModelWrapper lookupModelWrapper2 = new LookupModelWrapper(customLookupModel, lookupModel2.getCustomLookup(), (Lifetime)lifetimeDefinition, (Function1<? super List<CompletionItem>, ? extends Promise<List<LookupElement>>>)((Function1)new Function1<List<? extends CompletionItem>, Promise<List<? extends LookupElement>>>(lifetimeDefinition){
            final /* synthetic */ LifetimeDefinition $lookupLifetime;
            {
                this.$lookupLifetime = $lookupLifetime;
                super(1);
            }

            @NotNull
            public final Promise<List<LookupElement>> invoke(@NotNull List<CompletionItem> items) {
                Intrinsics.checkNotNullParameter(items, (String)"items");
                Iterable iterable = items;
                LifetimeDefinition lifetimeDefinition = this.$lookupLifetime;
                boolean bl = false;
                Iterable iterable2 = iterable;
                Collection collection = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)iterable, (int)10));
                boolean bl2 = false;
                for (T t : iterable2) {
                    CompletionItem completionItem = (CompletionItem)t;
                    Collection collection2 = collection;
                    boolean bl3 = false;
                    collection2.add(new ProtocolLookupItemBase(completionItem, (Lifetime)lifetimeDefinition));
                }
                return Promises.resolvedPromise((Object)((List)collection));
            }
        }), (Function1<? super List<? extends LookupElement>, ? extends Promise<List<CompletionItem>>>)((Function1)createCustomLookup.lookupModelWrapper.2.INSTANCE));
        lookupImpl.putUserData(BACKEND_LOOKUP, (Object)true);
        LookupWrapper.mirrorFrom$default(lookupImplWrapper, lookupModelWrapper2, null, 2, null);
        if (bl) {
            lookupModelWrapper2.mirrorFrom(lookupImplWrapper, this.lookupEventMask);
            lookupImpl.addLookupListener(new LookupListener(editor2, this, project){
                final /* synthetic */ Editor $editor;
                final /* synthetic */ CustomLookupHost this$0;
                final /* synthetic */ Project $project;
                {
                    this.$editor = $editor;
                    this.this$0 = $receiver;
                    this.$project = $project;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public boolean beforeItemSelected(@NotNull LookupEvent event) {
                    TextControlId textControlId;
                    Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                    if (this.$editor instanceof EditorImpl) {
                        CustomLookupHost.access$getLookupEventMask$p(this.this$0).setIgnoreHiding(true);
                    }
                    if ((textControlId = DocumentExKt.getTextControlId(this.$editor)) != null) {
                        PatchEngine patchEngine = FrontendPatchEngineKt.getEngine(FrontendSessionsUtilKt.getFrontendProjectSession(this.$project).getAppSession());
                        String string = "Lookup item selected";
                        boolean bl = false;
                        AutoCloseable autoCloseable = (AutoCloseable)((Object)PatchEngine.openAccumulatingSession$default(patchEngine, true, string, null, 4, null));
                        Throwable throwable = null;
                        try {
                            RdPatchEngine.ChangeAccumulatingSessionToken changeAccumulatingSessionToken = (RdPatchEngine.ChangeAccumulatingSessionToken)((Object)autoCloseable);
                            boolean bl2 = false;
                            ChangeScope changeScope = changeAccumulatingSessionToken.getSession().getChangeScope();
                            boolean bl3 = false;
                            changeScope.pushFeature(new RdFakeLookupChooseItemStep(textControlId));
                            Unit unit = Unit.INSTANCE;
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
                        }
                    }
                    return true;
                }
            });
        }
    }

    private static final void j(CustomLookupModel customLookupModel, CustomLookupHost customLookupHost) {
        Intrinsics.checkNotNullParameter((Object)((Object)customLookupModel), (String)"$customLookup");
        Intrinsics.checkNotNullParameter((Object)customLookupHost, (String)"this$0");
        if (LOG.isTraceEnabled()) {
            LOG.trace(new Throwable("local lookup instance related to custom lookup with id=" + customLookupModel.getId() + " is being disposed"));
        }
        customLookupHost.currentCustomLookup = null;
    }

    public static final /* synthetic */ Logger access$getLOG$cp() {
        return LOG;
    }

    public static final /* synthetic */ void access$createCustomLookup(CustomLookupHost $this, Editor editor2, CustomLookupModel customLookup, LookupModel lookupModel2, Project project) {
        $this.j(editor2, customLookup, lookupModel2, project);
    }

    public static final /* synthetic */ void access$locallyHideCustomLookup(CustomLookupHost $this) {
        $this.j();
    }

    public static final /* synthetic */ LookupWrapperListener.EventMask access$getLookupEventMask$p(CustomLookupHost $this) {
        return $this.lookupEventMask;
    }

    static {
        boolean bl = false;
        Logger logger = Logger.getInstance(CustomLookupHost.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
        Key key = Key.create((String)"rdclient.BackendLookup");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        BACKEND_LOOKUP = key;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0011R$\u0010\u0003\u001a\u0015\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u00050\u0004\u00a2\u0006\u0002\b\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/jetbrains/rdclient/completion/CustomLookupHost$Companion;", "", "()V", "BACKEND_LOOKUP", "Lcom/intellij/openapi/util/Key;", "", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "getBACKEND_LOOKUP", "()Lcom/intellij/openapi/util/Key;", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getInstance", "Lcom/jetbrains/rdclient/completion/CustomLookupHost;", "session", "Lcom/intellij/openapi/client/ClientAppSession;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.rd.client"})
    @SourceDebugExtension(value={"SMAP\nCustomLookupHost.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CustomLookupHost.kt\ncom/jetbrains/rdclient/completion/CustomLookupHost$Companion\n+ 2 Components.kt\ncom/jetbrains/rd/platform/util/ComponentsKt\n*L\n1#1,142:1\n23#2:143\n*S KotlinDebug\n*F\n+ 1 CustomLookupHost.kt\ncom/jetbrains/rdclient/completion/CustomLookupHost$Companion\n*L\n138#1:143\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Key<Boolean> getBACKEND_LOOKUP() {
            return BACKEND_LOOKUP;
        }

        @NotNull
        public final CustomLookupHost getInstance(@NotNull ClientAppSession session) {
            Intrinsics.checkNotNullParameter((Object)session, (String)"session");
            ClientSession clientSession = (ClientSession)session;
            boolean bl = false;
            Object object = clientSession.getService(CustomLookupHost.class);
            if (object == null) {
                throw new IllegalStateException(("Can't find service for " + clientSession).toString());
            }
            return (CustomLookupHost)object;
        }

        @NotNull
        public final CustomLookupHost getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            return this.getInstance(FrontendSessionsUtilKt.getFrontendProjectSession(project).getAppSession());
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

