/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdclient.actions.cwm;

import com.jetbrains.rd.ide.model.ActionTimestampSetModel;
import com.jetbrains.rd.ide.model.RdPromoteActionRequest;
import com.jetbrains.rd.ide.model.RdRequest;
import com.jetbrains.rd.util.string.IPrintableKt;
import com.jetbrains.rdclient.actions.cwm.ActionTimestampModelProvider;
import com.jetbrains.rdclient.requests.FrontendAsyncRequest;
import com.jetbrains.rdclient.requests.FrontendSimpleRequest;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0005\u00a2\u0006\u0002\u0010\tJ\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\u0006H\u0014J\u0012\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0016R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/jetbrains/rdclient/actions/cwm/FrontendPromoteActionRequest;", "Lcom/jetbrains/rdclient/requests/FrontendSimpleRequest;", "timestampSetModel", "Lcom/jetbrains/rd/ide/model/ActionTimestampSetModel;", "backendActionIds", "", "", "areDelegating", "", "(Lcom/jetbrains/rd/ide/model/ActionTimestampSetModel;Ljava/util/List;Ljava/util/List;)V", "createModel", "Lcom/jetbrains/rd/ide/model/RdRequest;", "debugDescription", "tryMergeWith", "Lcom/jetbrains/rdclient/requests/FrontendAsyncRequest;", "nextRequest", "intellij.rd.client"})
public final class FrontendPromoteActionRequest
extends FrontendSimpleRequest {
    @NotNull
    private final ActionTimestampSetModel timestampSetModel;
    @NotNull
    private final List<String> backendActionIds;
    @NotNull
    private final List<Boolean> areDelegating;

    public FrontendPromoteActionRequest(@NotNull ActionTimestampSetModel timestampSetModel, @NotNull List<String> backendActionIds, @NotNull List<Boolean> areDelegating) {
        Intrinsics.checkNotNullParameter((Object)timestampSetModel, (String)"timestampSetModel");
        Intrinsics.checkNotNullParameter(backendActionIds, (String)"backendActionIds");
        Intrinsics.checkNotNullParameter(areDelegating, (String)"areDelegating");
        super(false, true, 1, null);
        this.timestampSetModel = timestampSetModel;
        this.backendActionIds = backendActionIds;
        this.areDelegating = areDelegating;
    }

    @Override
    @NotNull
    public RdRequest createModel() {
        ActionTimestampSetModel actionTimestampSetModel = ActionTimestampModelProvider.Companion.filterOutTransientTimestamps(this.timestampSetModel);
        return new RdPromoteActionRequest(actionTimestampSetModel, this.areDelegating, this.backendActionIds);
    }

    @Override
    @Nullable
    public FrontendAsyncRequest tryMergeWith(@NotNull FrontendAsyncRequest nextRequest) {
        Intrinsics.checkNotNullParameter((Object)nextRequest, (String)"nextRequest");
        if (!(nextRequest instanceof FrontendPromoteActionRequest)) {
            return null;
        }
        if (Intrinsics.areEqual(((FrontendPromoteActionRequest)nextRequest).backendActionIds, this.backendActionIds) && Intrinsics.areEqual(((FrontendPromoteActionRequest)nextRequest).areDelegating, this.areDelegating)) {
            return nextRequest;
        }
        return null;
    }

    @Override
    @NotNull
    protected String debugDescription() {
        return "Promote actions: " + IPrintableKt.printToString((Object)CollectionsKt.zip((Iterable)this.backendActionIds, (Iterable)this.areDelegating));
    }
}

