/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdclient.actions.cwm;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionPopupMenu;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ex.ActionManagerEx;
import com.intellij.openapi.actionSystem.ex.ActionPopupMenuListener;
import com.intellij.openapi.client.ClientAppSession;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.jetbrains.ide.model.uiautomation.ComponentId;
import com.jetbrains.rd.actions.ActionsKt;
import com.jetbrains.rd.framework.IRdTask;
import com.jetbrains.rd.framework.RdTaskResult;
import com.jetbrains.rd.ide.model.ActionIdAndPresentationModel;
import com.jetbrains.rd.ide.model.AsyncActionGroupExpandResponse;
import com.jetbrains.rd.ide.model.AsyncActionUpdateRequest;
import com.jetbrains.rd.ide.model.AsyncActionsModel;
import com.jetbrains.rd.ide.model.AsyncActionsModel_GeneratedKt;
import com.jetbrains.rd.ide.model.PresentationModel;
import com.jetbrains.rdclient.actions.ActionPlaceExKt;
import com.jetbrains.rdclient.actions.cwm.FrontendActionUpdateHostBase;
import com.jetbrains.rdclient.actions.cwm.FrontendActionUpdateUtilsKt;
import com.jetbrains.rdclient.actions.cwm.FrontendPresentationDecorator;
import com.jetbrains.rdclient.client.FrontendSessionsUtilKt;
import com.jetbrains.rdclient.services.AppLevelIdeBackend;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CancellationException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 62\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u0001:\u000267B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\u0017H\u0014J\u0018\u0010\u0018\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\u001a\u001a\u00020\rH\u0002J2\u0010\u001b\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u0015\u001a\u00020\u000b2\u000e\u0010\u001f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020 2\u0006\u0010!\u001a\u00020\"H\u0014J\u0010\u0010#\u001a\u00020\u001c2\u0006\u0010$\u001a\u00020\u0010H\u0002J\u001c\u0010%\u001a\u00020\u001c2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00100'2\u0006\u0010(\u001a\u00020)J\u0010\u0010*\u001a\u00020\u00142\u0006\u0010+\u001a\u00020\u0010H\u0002J\u0018\u0010,\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010-2\u0006\u0010\u0019\u001a\u00020\u000bH\u0002J\u001c\u0010.\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00020/2\u0006\u00100\u001a\u000201H\u0014J\u0018\u00102\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u0002032\u0006\u0010\u0015\u001a\u00020\u000bH\u0014J \u00104\u001a\u00020\u001c2\u0006\u00105\u001a\u00020\u00102\b\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u0016\u001a\u00020\u0017R\u0014\u0010\u0006\u001a\u00020\u0002X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR6\u0010\t\u001a*\u0012\u0004\u0012\u00020\u000b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\f0\nj\u0014\u0012\u0004\u0012\u00020\u000b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\f`\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\u00020\u0010X\u0094D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u00068"}, d2={"Lcom/jetbrains/rdclient/actions/cwm/FrontendActionPresentationUpdateHost;", "Lcom/jetbrains/rdclient/actions/cwm/FrontendActionUpdateHostBase;", "Lcom/jetbrains/rd/ide/model/PresentationModel;", "session", "Lcom/intellij/openapi/client/ClientAppSession;", "(Lcom/intellij/openapi/client/ClientAppSession;)V", "invalidValue", "getInvalidValue", "()Lcom/jetbrains/rd/ide/model/PresentationModel;", "pendingUpdates", "Ljava/util/HashMap;", "Lcom/jetbrains/rd/ide/model/AsyncActionUpdateRequest;", "", "Lcom/intellij/openapi/actionSystem/Presentation;", "Lkotlin/collections/HashMap;", "taskName", "", "getTaskName", "()Ljava/lang/String;", "addPendingRequest", "", "request", "actionEvent", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "j", "req", "presentation", "applyTaskResult", "", "action", "Lcom/intellij/openapi/actionSystem/AnAction;", "result", "Lcom/jetbrains/rd/framework/RdTaskResult;", "startTimeNs", "", "j", "place", "disableKeyboardActions", "backendActionIds", "", "componentId", "Lcom/jetbrains/ide/model/uiautomation/ComponentId;", "j", "actionId", "j", "", "retrieveValues", "", "response", "Lcom/jetbrains/rd/ide/model/AsyncActionGroupExpandResponse;", "startTask", "Lcom/jetbrains/rd/framework/IRdTask;", "updatePresentation", "frontendActionId", "Companion", "MyActionPopupMenuListener", "intellij.rd.client"})
@SourceDebugExtension(value={"SMAP\nFrontendActionPresentationUpdateHost.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FrontendActionPresentationUpdateHost.kt\ncom/jetbrains/rdclient/actions/cwm/FrontendActionPresentationUpdateHost\n+ 2 CollectionEx.kt\ncom/jetbrains/rd/util/CollectionExKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,170:1\n66#2,3:171\n65#3,4:174\n65#3,4:178\n65#3,4:182\n1179#4,2:186\n1253#4,4:188\n*S KotlinDebug\n*F\n+ 1 FrontendActionPresentationUpdateHost.kt\ncom/jetbrains/rdclient/actions/cwm/FrontendActionPresentationUpdateHost\n*L\n102#1:171,3\n133#1:174,4\n146#1:178,4\n159#1:182,4\n167#1:186,2\n167#1:188,4\n*E\n"})
public final class FrontendActionPresentationUpdateHost
extends FrontendActionUpdateHostBase<PresentationModel, PresentationModel> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final HashMap<AsyncActionUpdateRequest, Set<Presentation>> pendingUpdates;
    @NotNull
    private final PresentationModel invalidValue;
    @NotNull
    private final String taskName;

    public FrontendActionPresentationUpdateHost(@NotNull ClientAppSession session) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        super(session, true);
        this.pendingUpdates = new HashMap();
        this.invalidValue = new PresentationModel(false, true, null, null, null, false, false, false, false, false, false, false, null, null, null, false, 49152, null);
        this.taskName = "update()";
        ActionManagerEx.Companion.getInstanceEx().addActionPopupMenuListener((ActionPopupMenuListener)new MyActionPopupMenuListener(), (Disposable)this);
    }

    @Override
    @NotNull
    protected PresentationModel getInvalidValue() {
        return this.invalidValue;
    }

    @Override
    @NotNull
    protected String getTaskName() {
        return this.taskName;
    }

    public final void disableKeyboardActions(@NotNull List<String> backendActionIds, @NotNull ComponentId componentId) {
        Intrinsics.checkNotNullParameter(backendActionIds, (String)"backendActionIds");
        Intrinsics.checkNotNullParameter((Object)componentId, (String)"componentId");
        for (String string : backendActionIds) {
            this.getCache().putValue(string, "keyboard shortcut", componentId, this.getInvalidValue());
        }
    }

    public final void updatePresentation(@NotNull String frontendActionId, @Nullable AnAction action3, @NotNull AnActionEvent actionEvent) {
        Intrinsics.checkNotNullParameter((Object)frontendActionId, (String)"frontendActionId");
        Intrinsics.checkNotNullParameter((Object)actionEvent, (String)"actionEvent");
        String string = AppLevelIdeBackend.Companion.getInstance().getBackendActionId(frontendActionId);
        PresentationModel presentationModel = (PresentationModel)this.requestAsyncUpdate(frontendActionId, string, action3, actionEvent);
        if (presentationModel != null) {
            Presentation presentation = actionEvent.getPresentation();
            Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"getPresentation(...)");
            ActionsKt.applyPresentationModel(action3, presentation, presentationModel);
        }
        if (this.j(string)) {
            actionEvent.getPresentation().setEnabled(true);
        }
        Presentation presentation = actionEvent.getPresentation();
        Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"getPresentation(...)");
        String string2 = actionEvent.getPlace();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getPlace(...)");
        FrontendPresentationDecorator.Companion.decorate(string, action3, presentation, string2);
    }

    private final boolean j(String string) {
        Object[] objectArray = new String[]{"Resume", "StepInto", "StepOver", "StepOut", "ForceStepInto", "SmartStepInto", "ForceStepOver"};
        return SetsKt.setOf((Object[])objectArray).contains(string);
    }

    @Override
    protected boolean addPendingRequest(@NotNull AsyncActionUpdateRequest request2, @NotNull AnActionEvent actionEvent) {
        Intrinsics.checkNotNullParameter((Object)request2, (String)"request");
        Intrinsics.checkNotNullParameter((Object)actionEvent, (String)"actionEvent");
        Presentation presentation = actionEvent.getPresentation();
        Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"getPresentation(...)");
        return this.j(request2, presentation);
    }

    @Override
    @NotNull
    protected IRdTask<PresentationModel> startTask(@NotNull AsyncActionUpdateRequest request2) {
        Intrinsics.checkNotNullParameter((Object)request2, (String)"request");
        AsyncActionsModel asyncActionsModel2 = AsyncActionsModel_GeneratedKt.getAsyncActionsModel(FrontendSessionsUtilKt.getProtocol(this.getSession()));
        return asyncActionsModel2.getUpdate().start(this.getServiceLifetime(), (Object)request2);
    }

    private final synchronized boolean j(AsyncActionUpdateRequest asyncActionUpdateRequest, Presentation presentation) {
        Set set;
        Map map = this.pendingUpdates;
        boolean bl = false;
        Object object = map.get(asyncActionUpdateRequest);
        if (object == null) {
            AsyncActionUpdateRequest asyncActionUpdateRequest2 = asyncActionUpdateRequest;
            boolean bl2 = false;
            Set set2 = new HashSet();
            boolean bl3 = false;
            map.put(asyncActionUpdateRequest, set2);
            object = set2;
        }
        boolean bl4 = !((Collection)(set = (Set)object)).isEmpty();
        set.add(presentation);
        return bl4;
    }

    private final synchronized Set<Presentation> j(AsyncActionUpdateRequest asyncActionUpdateRequest) {
        return this.pendingUpdates.remove(asyncActionUpdateRequest);
    }

    private final synchronized void j(String string) {
        Iterator iterator2 = ((Map)this.pendingUpdates).entrySet().iterator();
        while (iterator2.hasNext()) {
            String string2 = ((AsyncActionUpdateRequest)iterator2.next().getKey()).getPlace();
            if (!Intrinsics.areEqual((Object)string2, (Object)string)) continue;
            iterator2.remove();
        }
    }

    @Override
    protected void applyTaskResult(@Nullable AnAction action3, @NotNull AsyncActionUpdateRequest request2, @NotNull RdTaskResult<PresentationModel> result2, long startTimeNs) {
        Intrinsics.checkNotNullParameter((Object)request2, (String)"request");
        Intrinsics.checkNotNullParameter(result2, (String)"result");
        String string = request2.getPlace();
        String string2 = request2.getActionId();
        ComponentId componentId = FrontendActionUpdateUtilsKt.getComponentId(request2);
        try {
            Set<Presentation> set = this.j(request2);
            if (!(result2 instanceof RdTaskResult.Success)) {
                Logger logger = FrontendActionUpdateHostBase.Companion.getLOG();
                boolean bl = false;
                if (logger.isTraceEnabled()) {
                    Logger logger2 = logger;
                    boolean bl2 = false;
                    logger2.trace("Received update with status " + result2 + " for action " + string2 + ", place " + string + ". Skip it.");
                }
                return;
            }
            PresentationModel presentationModel = (PresentationModel)result2.unwrap();
            if (presentationModel == null) {
                FrontendActionPresentationUpdateHost frontendActionPresentationUpdateHost = this;
                boolean bl = false;
                FrontendActionUpdateHostBase.Companion.getLOG().error("Received update with invalid result for action " + string2 + ", place " + string);
                presentationModel = frontendActionPresentationUpdateHost.getInvalidValue();
            }
            PresentationModel presentationModel2 = presentationModel;
            if (set != null) {
                Logger logger = FrontendActionUpdateHostBase.Companion.getLOG();
                boolean bl = false;
                if (logger.isTraceEnabled()) {
                    Logger logger3 = logger;
                    boolean bl3 = false;
                    double d = (double)(System.nanoTime() - startTimeNs) / 1000000.0;
                    logger3.trace("Received update for action " + string2 + " place " + string + ", took " + d + " ms. (enabled=" + presentationModel2.isEnabled() + ", visible=" + presentationModel2.isVisible() + ", hasDescription=" + (presentationModel2.getDescription() != null) + ")");
                }
                this.getCache().putValue(string2, string, componentId, presentationModel2);
                for (Presentation presentation : set) {
                    ActionsKt.applyPresentationModel(action3, presentation, presentationModel2);
                    FrontendPresentationDecorator.Companion.decorate(string2, action3, presentation, string);
                }
            }
        }
        catch (CancellationException cancellationException) {
            Logger logger = FrontendActionUpdateHostBase.Companion.getLOG();
            boolean bl = false;
            if (logger.isTraceEnabled()) {
                Logger logger4 = logger;
                boolean bl4 = false;
                logger4.trace("Action update for " + string2 + " cancelled");
            }
        }
        catch (Throwable throwable) {
            FrontendActionUpdateHostBase.Companion.getLOG().error("Exception occurred while handling action update result", throwable);
        }
    }

    @Override
    @NotNull
    protected Map<String, PresentationModel> retrieveValues(@NotNull AsyncActionGroupExpandResponse response2) {
        Intrinsics.checkNotNullParameter((Object)response2, (String)"response");
        Iterable iterable = response2.getPresentations();
        boolean bl = false;
        int n = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)iterable, (int)10)), (int)16);
        Iterable iterable2 = iterable;
        Map map = new LinkedHashMap(n);
        boolean bl2 = false;
        for (Object t : iterable2) {
            Map map2 = map;
            ActionIdAndPresentationModel actionIdAndPresentationModel = (ActionIdAndPresentationModel)t;
            boolean bl3 = false;
            actionIdAndPresentationModel = new Pair((Object)actionIdAndPresentationModel.getId(), (Object)actionIdAndPresentationModel.getPresentation());
            map2.put(actionIdAndPresentationModel.getFirst(), actionIdAndPresentationModel.getSecond());
        }
        return map;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lcom/jetbrains/rdclient/actions/cwm/FrontendActionPresentationUpdateHost$Companion;", "", "()V", "getInstance", "Lcom/jetbrains/rdclient/actions/cwm/FrontendActionPresentationUpdateHost;", "session", "Lcom/intellij/openapi/client/ClientAppSession;", "intellij.rd.client"})
    @SourceDebugExtension(value={"SMAP\nFrontendActionPresentationUpdateHost.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FrontendActionPresentationUpdateHost.kt\ncom/jetbrains/rdclient/actions/cwm/FrontendActionPresentationUpdateHost$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,170:1\n31#2,2:171\n*S KotlinDebug\n*F\n+ 1 FrontendActionPresentationUpdateHost.kt\ncom/jetbrains/rdclient/actions/cwm/FrontendActionPresentationUpdateHost$Companion\n*L\n25#1:171,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final FrontendActionPresentationUpdateHost getInstance(@NotNull ClientAppSession session) {
            Intrinsics.checkNotNullParameter((Object)session, (String)"session");
            ComponentManager componentManager = (ComponentManager)session;
            boolean bl = false;
            Class<FrontendActionPresentationUpdateHost> clazz = FrontendActionPresentationUpdateHost.class;
            Object object = componentManager.getService(clazz);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)componentManager, clazz);
            }
            return (FrontendActionPresentationUpdateHost)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/jetbrains/rdclient/actions/cwm/FrontendActionPresentationUpdateHost$MyActionPopupMenuListener;", "Lcom/intellij/openapi/actionSystem/ex/ActionPopupMenuListener;", "(Lcom/jetbrains/rdclient/actions/cwm/FrontendActionPresentationUpdateHost;)V", "actionPopupMenuReleased", "", "menu", "Lcom/intellij/openapi/actionSystem/ActionPopupMenu;", "intellij.rd.client"})
    @SourceDebugExtension(value={"SMAP\nFrontendActionPresentationUpdateHost.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FrontendActionPresentationUpdateHost.kt\ncom/jetbrains/rdclient/actions/cwm/FrontendActionPresentationUpdateHost$MyActionPopupMenuListener\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,170:1\n65#2,4:171\n*S KotlinDebug\n*F\n+ 1 FrontendActionPresentationUpdateHost.kt\ncom/jetbrains/rdclient/actions/cwm/FrontendActionPresentationUpdateHost$MyActionPopupMenuListener\n*L\n45#1:171,4\n*E\n"})
    public final class MyActionPopupMenuListener
    implements ActionPopupMenuListener {
        public void actionPopupMenuReleased(@NotNull ActionPopupMenu menu) {
            Intrinsics.checkNotNullParameter((Object)menu, (String)"menu");
            ThreadingAssertions.assertEventDispatchThread();
            String string = menu.getPlace();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPlace(...)");
            String string2 = ActionPlaceExKt.normalizeActionPlace(string);
            if (!FrontendActionUpdateUtilsKt.isTransparentUpdate(string2)) {
                return;
            }
            Logger logger = FrontendActionUpdateHostBase.Companion.getLOG();
            boolean bl = false;
            if (logger.isTraceEnabled()) {
                Logger logger2 = logger;
                boolean bl2 = false;
                logger2.trace("Clearing the cache and cancelling pending actions for transparent place('" + string2 + "').");
            }
            FrontendActionPresentationUpdateHost.this.getCache().clear(string2);
            FrontendActionPresentationUpdateHost.this.j(string2);
        }
    }
}

