/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdclient.actions;

import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.jetbrains.rdclient.actions.ActionCallStrategy;
import com.jetbrains.rdclient.actions.ActionCallStrategyKt;
import com.jetbrains.rdclient.document.DocumentExKt;
import com.jetbrains.rdclient.patches.PatchEngineRegistryKt;
import com.jetbrains.rdclient.services.IdeBackend;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J \u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\f\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\bJ\u0016\u0010\t\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0007\u001a\u00020\bJ\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0012"}, d2={"Lcom/jetbrains/rdclient/actions/ActionCallPolicy;", "", "()V", "getActionCallStrategy", "Lcom/jetbrains/rdclient/actions/ActionCallStrategy;", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "frontendActionId", "", "getCallStrategy", "editor", "Lcom/intellij/openapi/editor/Editor;", "offset", "", "psiElement", "Lcom/intellij/psi/PsiElement;", "getElement", "Companion", "intellij.rd.client"})
public class ActionCallPolicy {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    public ActionCallStrategy getActionCallStrategy(@NotNull DataContext dataContext, @NotNull String frontendActionId) {
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        Intrinsics.checkNotNullParameter((Object)frontendActionId, (String)"frontendActionId");
        if (ActionCallStrategyKt.getCAN_BE_EXECUTED_ON_FRONTEND_AND_BACKEND().contains(frontendActionId)) {
            return ActionCallStrategy.FrontendFirst;
        }
        if (PatchEngineRegistryKt.isPatchEngineEnabled()) {
            return ActionCallStrategy.BackendOnly;
        }
        PsiElement psiElement = this.getElement(dataContext);
        if (psiElement == null) {
            return ActionCallStrategy.FrontendFirst;
        }
        PsiElement psiElement2 = psiElement;
        return this.getCallStrategy(psiElement2, frontendActionId);
    }

    @NotNull
    public final ActionCallStrategy getCallStrategy(@NotNull Editor editor2, int offset, @NotNull String frontendActionId) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)frontendActionId, (String)"frontendActionId");
        Project project = editor2.getProject();
        if (project == null) {
            return ActionCallStrategy.FrontendOnly;
        }
        Project project2 = project;
        if (DocumentExKt.getTextControlId(editor2) == null) {
            return ActionCallStrategy.FrontendOnly;
        }
        if (PatchEngineRegistryKt.isPatchEngineEnabled()) {
            return ActionCallStrategy.BackendOnly;
        }
        PsiFile psiFile = PsiDocumentManager.getInstance((Project)project2).getPsiFile(editor2.getDocument());
        if (psiFile == null) {
            return ActionCallStrategy.FrontendOnly;
        }
        PsiFile psiFile2 = psiFile;
        PsiElement psiElement = psiFile2.findElementAt(offset);
        if (psiElement == null) {
            return ActionCallStrategy.FrontendOnly;
        }
        PsiElement psiElement2 = psiElement;
        return this.getCallStrategy(psiElement2, frontendActionId);
    }

    public static /* synthetic */ ActionCallStrategy getCallStrategy$default(ActionCallPolicy actionCallPolicy, Editor editor2, int n, String string, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getCallStrategy");
        }
        if ((n2 & 2) != 0) {
            n = editor2.getCaretModel().getOffset();
        }
        return actionCallPolicy.getCallStrategy(editor2, n, string);
    }

    @NotNull
    public final ActionCallStrategy getCallStrategy(@NotNull PsiElement psiElement, @NotNull String frontendActionId) {
        Intrinsics.checkNotNullParameter((Object)psiElement, (String)"psiElement");
        Intrinsics.checkNotNullParameter((Object)frontendActionId, (String)"frontendActionId");
        Project project = psiElement.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        IdeBackend ideBackend = IdeBackend.Companion.tryGetInstance(project);
        if (ideBackend == null) {
            return ActionCallStrategy.FrontendOnly;
        }
        IdeBackend ideBackend2 = ideBackend;
        return ideBackend2.getActionCallStrategy(psiElement, ideBackend2.getBackendActionId(frontendActionId));
    }

    @Nullable
    public final PsiElement getElement(@NotNull DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        Editor editor2 = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
        Caret caret = (Caret)CommonDataKeys.CARET.getData(dataContext);
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        Editor editor3 = editor2;
        if ((editor3 != null ? DocumentExKt.getTextControlId(editor3) : null) != null && caret != null && project != null) {
            PsiElement psiElement;
            PsiFile psiFile = PsiDocumentManager.getInstance((Project)project).getPsiFile(editor2.getDocument());
            int n = caret.getOffset();
            PsiFile psiFile2 = psiFile;
            Object object = psiElement = psiFile2 != null ? psiFile2.findElementAt(n) : null;
            if (psiElement != null) {
                return psiElement;
            }
        }
        PsiFile psiFile = (PsiFile)CommonDataKeys.PSI_FILE.getData(dataContext);
        if (psiFile == null) {
            return (PsiElement)CommonDataKeys.PSI_ELEMENT.getData(dataContext);
        }
        return (PsiElement)psiFile;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0003\u001a\u00020\u0004\u00a8\u0006\u0005"}, d2={"Lcom/jetbrains/rdclient/actions/ActionCallPolicy$Companion;", "", "()V", "getInstance", "Lcom/jetbrains/rdclient/actions/ActionCallPolicy;", "intellij.rd.client"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ActionCallPolicy getInstance() {
            ActionCallPolicy actionCallPolicy = (ActionCallPolicy)ApplicationManager.getApplication().getService(ActionCallPolicy.class);
            if (actionCallPolicy == null) {
                actionCallPolicy = new ActionCallPolicy();
            }
            return actionCallPolicy;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

