/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rd.ui.util;

import com.intellij.ui.JBColor;
import com.jetbrains.rd.ui.util.CIELabUtils;
import java.awt.Color;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u0010\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\u001a\u0016\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0001\u001a \u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"getContrastedForeground", "Ljava/awt/Color;", "background", "foreground", "getContrastedForegroundIfNotThemed", "addContrastToForegroundIfNeeded", "", "intellij.rd.ui"})
public final class ColorUtilsKt {
    @NotNull
    public static final Color getContrastedForegroundIfNotThemed(@NotNull Color background, @NotNull Color foreground, boolean addContrastToForegroundIfNeeded) {
        Intrinsics.checkNotNullParameter((Object)background, (String)"background");
        Intrinsics.checkNotNullParameter((Object)foreground, (String)"foreground");
        if (foreground instanceof JBColor || !addContrastToForegroundIfNeeded) {
            return foreground;
        }
        return ColorUtilsKt.getContrastedForeground(background, foreground);
    }

    public static /* synthetic */ Color getContrastedForegroundIfNotThemed$default(Color color, Color color2, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = true;
        }
        return ColorUtilsKt.getContrastedForegroundIfNotThemed(color, color2, bl);
    }

    @NotNull
    public static final Color getContrastedForeground(@NotNull Color background, @NotNull Color foreground) {
        Intrinsics.checkNotNullParameter((Object)background, (String)"background");
        Intrinsics.checkNotNullParameter((Object)foreground, (String)"foreground");
        float f = 0.45f;
        float f2 = 0.02f;
        float f3 = 0.66f;
        float[] fArray = foreground.getColorComponents(null);
        Intrinsics.checkNotNullExpressionValue((Object)fArray, (String)"getColorComponents(...)");
        float[] fArray2 = CIELabUtils.INSTANCE.fromRGB(fArray);
        float f4 = fArray2[0];
        float f5 = fArray2[1];
        float f6 = fArray2[2];
        float[] fArray3 = background.getColorComponents(null);
        Intrinsics.checkNotNullExpressionValue((Object)fArray3, (String)"getColorComponents(...)");
        float[] fArray4 = CIELabUtils.INSTANCE.fromRGB(fArray3);
        float f7 = fArray4[0];
        float f8 = fArray4[1];
        float f9 = fArray4[2];
        if (Math.abs(f7 - f4) / 100.0f < f) {
            float f10;
            f4 = f7 / 100.0f > f3 ? (f7 / 100.0f - (f10 = Math.min(f4 / 100.0f, f2)) < f ? f10 * 100.0f : (f7 / 100.0f - f) * 100.0f) : ((f10 = Math.max(f4 / 100.0f, 1.0f - f2)) - f7 / 100.0f < f ? f10 * 100.0f : (f7 / 100.0f + f) * 100.0f);
            float[] fArray5 = new float[]{f4, f5, f6};
            float[] fArray6 = CIELabUtils.INSTANCE.toRGB(fArray5);
            float f11 = fArray6[0];
            float f12 = fArray6[1];
            float f13 = fArray6[2];
            Color color = new Color(f11, f12, f13);
            int n = Math.min(Math.min(foreground.getRed(), foreground.getGreen()), foreground.getBlue());
            int n2 = Math.max(Math.max(foreground.getRed(), foreground.getGreen()), foreground.getBlue());
            if (n2 != n) {
                double d = (double)(foreground.getRed() - n) / (double)(n2 - n);
                double d2 = (double)(foreground.getGreen() - n) / (double)(n2 - n);
                double d3 = (double)(foreground.getBlue() - n) / (double)(n2 - n);
                Integer[] integerArray = new Integer[]{color.getRed(), color.getGreen(), color.getBlue()};
                Integer[] integerArray2 = integerArray;
                ArraysKt.sort((Object[])integerArray2);
                n = (integerArray2[0] + integerArray2[1]) / 2;
                n2 = integerArray2[2];
                return new Color((int)(d * (double)(n2 - n) + (double)n), (int)(d2 * (double)(n2 - n) + (double)n), (int)(d3 * (double)(n2 - n) + (double)n), foreground.getAlpha());
            }
            return new Color(color.getRed(), color.getGreen(), color.getBlue(), foreground.getAlpha());
        }
        return foreground;
    }
}

