/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rd.ui.icons.converters;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.ui.BadgeDotProvider;
import com.intellij.ui.BadgeIcon;
import com.intellij.ui.BadgeRectProvider;
import com.intellij.ui.BadgeShapeProvider;
import com.jetbrains.rd.ide.model.AbstractColor;
import com.jetbrains.rd.ide.model.BadgeDotProviderModel;
import com.jetbrains.rd.ide.model.BadgeIconModel;
import com.jetbrains.rd.ide.model.BadgeRectProviderModel;
import com.jetbrains.rd.ide.model.BadgeShapeProviderModel;
import com.jetbrains.rd.ide.model.IconModel;
import com.jetbrains.rd.platform.colors.ColorHostKt;
import com.jetbrains.rd.ui.icons.ProtocolIconConverter;
import com.jetbrains.rd.ui.icons.ProtocolIconRegistry;
import com.jetbrains.rd.ui.icons.UtilKt;
import java.awt.Color;
import java.awt.Paint;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0005\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\tH\u0016J\u001a\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\r"}, d2={"Lcom/jetbrains/rd/ui/icons/converters/BadgeIconConverter;", "Lcom/jetbrains/rd/ui/icons/ProtocolIconConverter;", "Lcom/intellij/ui/BadgeIcon;", "Lcom/jetbrains/rd/ide/model/BadgeIconModel;", "()V", "createIcon", "Ljavax/swing/Icon;", "model", "registry", "Lcom/jetbrains/rd/ui/icons/ProtocolIconRegistry;", "createModel", "Lcom/jetbrains/rd/ide/model/IconModel;", "icon", "intellij.rd.ui"})
@SourceDebugExtension(value={"SMAP\nBadgeIconConverter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BadgeIconConverter.kt\ncom/jetbrains/rd/ui/icons/converters/BadgeIconConverter\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,49:1\n23#2:50\n23#2:51\n*S KotlinDebug\n*F\n+ 1 BadgeIconConverter.kt\ncom/jetbrains/rd/ui/icons/converters/BadgeIconConverter\n*L\n28#1:50\n43#1:51\n*E\n"})
public final class BadgeIconConverter
implements ProtocolIconConverter<BadgeIcon, BadgeIconModel> {
    @Override
    @Nullable
    public Icon createIcon(@NotNull BadgeIconModel model2, @NotNull ProtocolIconRegistry registry) {
        BadgeShapeProvider badgeShapeProvider;
        Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
        Intrinsics.checkNotNullParameter((Object)registry, (String)"registry");
        Icon icon2 = UtilKt.fromModel(model2.getIcon());
        Color color = ColorHostKt.toColor(model2.getColor());
        BadgeShapeProviderModel badgeShapeProviderModel = model2.getProvider();
        if (badgeShapeProviderModel instanceof BadgeDotProviderModel) {
            badgeShapeProvider = (BadgeShapeProvider)new BadgeDotProvider(((BadgeDotProviderModel)badgeShapeProviderModel).getX(), ((BadgeDotProviderModel)badgeShapeProviderModel).getY(), ((BadgeDotProviderModel)badgeShapeProviderModel).getRadius(), badgeShapeProviderModel.getBorder());
        } else if (badgeShapeProviderModel instanceof BadgeRectProviderModel) {
            badgeShapeProvider = (BadgeShapeProvider)new BadgeRectProvider(((BadgeRectProviderModel)badgeShapeProviderModel).getArc(), ((BadgeRectProviderModel)badgeShapeProviderModel).getTop(), ((BadgeRectProviderModel)badgeShapeProviderModel).getLeft(), ((BadgeRectProviderModel)badgeShapeProviderModel).getRight(), ((BadgeRectProviderModel)badgeShapeProviderModel).getBottom(), badgeShapeProviderModel.getBorder());
        } else {
            BadgeIconConverter badgeIconConverter = this;
            boolean bl = false;
            Logger logger = Logger.getInstance(BadgeIconConverter.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.error("Unknown BadgeIconProviderModel. " + model2.getProvider());
            return null;
        }
        BadgeShapeProvider badgeShapeProvider2 = badgeShapeProvider;
        return (Icon)new BadgeIcon(icon2, (Paint)color, badgeShapeProvider2);
    }

    @Override
    @Nullable
    public IconModel createModel(@NotNull BadgeIcon icon2, @NotNull ProtocolIconRegistry registry) {
        BadgeShapeProviderModel badgeShapeProviderModel;
        Intrinsics.checkNotNullParameter((Object)icon2, (String)"icon");
        Intrinsics.checkNotNullParameter((Object)registry, (String)"registry");
        IconModel iconModel = registry.createModel(icon2.getIcon());
        if (iconModel == null) {
            return null;
        }
        IconModel iconModel2 = iconModel;
        Paint paint = icon2.getPaint();
        Object object = paint instanceof Color ? (Color)paint : null;
        if (object == null || (object = ColorHostKt.toModel((Color)object)) == null) {
            return null;
        }
        Object object2 = object;
        paint = icon2.getProvider();
        if (paint instanceof BadgeDotProvider) {
            badgeShapeProviderModel = new BadgeDotProviderModel(((BadgeDotProvider)paint).getX(), ((BadgeDotProvider)paint).getY(), ((BadgeDotProvider)paint).getRadius(), paint.getBorder());
        } else if (paint instanceof BadgeRectProvider) {
            badgeShapeProviderModel = new BadgeRectProviderModel(((BadgeRectProvider)paint).getArc(), ((BadgeRectProvider)paint).getTop(), ((BadgeRectProvider)paint).getLeft(), ((BadgeRectProvider)paint).getRight(), ((BadgeRectProvider)paint).getBottom(), paint.getBorder());
        } else {
            BadgeIconConverter badgeIconConverter = this;
            boolean bl = false;
            Logger logger = Logger.getInstance(BadgeIconConverter.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.error("Unknown BadgeIconProvider. " + icon2.getProvider().getClass());
            return null;
        }
        BadgeShapeProviderModel badgeShapeProviderModel2 = badgeShapeProviderModel;
        return new BadgeIconModel(iconModel2, (AbstractColor)object2, badgeShapeProviderModel2);
    }
}

