/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rd.ui.completion;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementPresentation;
import com.intellij.codeInsight.lookup.LookupElementRenderer;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.rd.ide.model.CompletionItem;
import com.jetbrains.rd.ide.model.CompletionPresentationModel;
import com.jetbrains.rd.ide.model.IconModel;
import com.jetbrains.rd.ui.completion.CompletionUtilsKt;
import com.jetbrains.rd.ui.icons.UtilKt;
import java.util.HashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010#\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0016H\u0016J\u0012\u0010\u0017\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u0001\u0018\u00010\u0018H\u0016J\b\u0010\u0019\u001a\u00020\u000eH\u0016J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u001c\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\"\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0086\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\u000f\u0010\u0010\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014\u00a8\u0006\u001e"}, d2={"Lcom/jetbrains/rd/ui/completion/RdLookupItemBase;", "Lcom/intellij/codeInsight/lookup/LookupElement;", "completionItem", "Lcom/jetbrains/rd/ide/model/CompletionItem;", "(Lcom/jetbrains/rd/ide/model/CompletionItem;)V", "getCompletionItem", "()Lcom/jetbrains/rd/ide/model/CompletionItem;", "displayName", "Lcom/jetbrains/rd/ide/model/CompletionPresentationModel;", "getDisplayName", "()Lcom/jetbrains/rd/ide/model/CompletionPresentationModel;", "setDisplayName", "(Lcom/jetbrains/rd/ide/model/CompletionPresentationModel;)V", "typeName", "", "getTypeName$annotations", "()V", "getTypeName", "()Ljava/lang/String;", "setTypeName", "(Ljava/lang/String;)V", "getAllLookupStrings", "", "getExpensiveRenderer", "Lcom/intellij/codeInsight/lookup/LookupElementRenderer;", "getLookupString", "renderElement", "", "presentation", "Lcom/intellij/codeInsight/lookup/LookupElementPresentation;", "intellij.rd.ui"})
public class RdLookupItemBase
extends LookupElement {
    @NotNull
    private final CompletionItem completionItem;
    @Nullable
    private CompletionPresentationModel displayName;
    @Nullable
    private String typeName;

    public RdLookupItemBase(@NotNull CompletionItem completionItem) {
        Intrinsics.checkNotNullParameter((Object)completionItem, (String)"completionItem");
        this.completionItem = completionItem;
        this.displayName = this.completionItem.getDisplayName();
        this.typeName = this.completionItem.getTypeName();
    }

    @NotNull
    public final CompletionItem getCompletionItem() {
        return this.completionItem;
    }

    @Nullable
    public final CompletionPresentationModel getDisplayName() {
        return this.displayName;
    }

    public final void setDisplayName(@Nullable CompletionPresentationModel completionPresentationModel) {
        this.displayName = completionPresentationModel;
    }

    @Nullable
    public final String getTypeName() {
        return this.typeName;
    }

    public final void setTypeName(@Nullable String string) {
        this.typeName = string;
    }

    public static /* synthetic */ void getTypeName$annotations() {
    }

    @NotNull
    public String getLookupString() {
        return this.completionItem.getShortText();
    }

    @NotNull
    public Set<String> getAllLookupStrings() {
        if (!StringsKt.contains$default((CharSequence)this.completionItem.getShortText(), (char)'.', (boolean)false, (int)2, null)) {
            Set set = super.getAllLookupStrings();
            Intrinsics.checkNotNullExpressionValue((Object)set, (String)"getAllLookupStrings(...)");
            return set;
        }
        String string = StringsKt.substringAfter$default((String)this.completionItem.getShortText(), (char)'.', null, (int)2, null);
        Object[] objectArray = new String[]{this.completionItem.getShortText(), string};
        HashSet hashSet = ContainerUtil.newHashSet((Object[])objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)hashSet, (String)"newHashSet(...)");
        return hashSet;
    }

    public void renderElement(@NotNull LookupElementPresentation presentation) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)presentation, (String)"presentation");
            presentation.setItemText(this.completionItem.getShortText());
            String string = this.typeName;
            if (string == null) break block0;
            String string2 = string;
            boolean bl = false;
            presentation.setTypeText(string2);
        }
    }

    @Nullable
    public LookupElementRenderer<? extends LookupElement> getExpensiveRenderer() {
        return (LookupElementRenderer)new LookupElementRenderer<RdLookupItemBase>(this){
            final /* synthetic */ RdLookupItemBase this$0;
            {
                this.this$0 = $receiver;
            }

            public void renderElement(@NotNull RdLookupItemBase element, @NotNull LookupElementPresentation presentation) {
                Intrinsics.checkNotNullParameter((Object)((Object)element), (String)"element");
                Intrinsics.checkNotNullParameter((Object)presentation, (String)"presentation");
                this.this$0.renderElement(presentation);
                CompletionPresentationModel completionPresentationModel = this.this$0.getDisplayName();
                if (completionPresentationModel != null) {
                    CompletionPresentationModel completionPresentationModel2 = completionPresentationModel;
                    boolean bl = false;
                    CompletionUtilsKt.renderCompletionItemByModel(completionPresentationModel2, presentation);
                }
                IconModel iconModel = element.getCompletionItem().getIcon();
                if (iconModel != null) {
                    presentation.setIcon(UtilKt.fromModel(iconModel));
                }
            }
        };
    }
}

