/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rd.ui.bindable.views.listControl;

import com.intellij.util.ui.UIUtil;
import com.jetbrains.rd.ui.bindable.views.listControl.BeTreeTable;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\bH\u0002J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/jetbrains/rd/ui/bindable/views/listControl/TreeTableMouseMotionListener;", "Ljava/awt/event/MouseMotionAdapter;", "treeTable", "Lcom/jetbrains/rd/ui/bindable/views/listControl/BeTreeTable;", "(Lcom/jetbrains/rd/ui/bindable/views/listControl/BeTreeTable;)V", "myIsEngaged", "", "myLastMouseLocation", "Ljava/awt/Point;", "myLastSelectedIndex", "", "j", "location", "mouseMoved", "", "e", "Ljava/awt/event/MouseEvent;", "intellij.rd.ui"})
public final class TreeTableMouseMotionListener
extends MouseMotionAdapter {
    @NotNull
    private final BeTreeTable treeTable;
    private boolean myIsEngaged;
    private int myLastSelectedIndex;
    @Nullable
    private Point myLastMouseLocation;

    public TreeTableMouseMotionListener(@NotNull BeTreeTable treeTable) {
        Intrinsics.checkNotNullParameter((Object)((Object)treeTable), (String)"treeTable");
        this.treeTable = treeTable;
        this.myLastSelectedIndex = -2;
    }

    private final boolean j(Point point) {
        if (this.myLastMouseLocation == null) {
            this.myLastMouseLocation = point;
            return false;
        }
        return !Intrinsics.areEqual((Object)this.myLastMouseLocation, (Object)point);
    }

    @Override
    public void mouseMoved(@NotNull MouseEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Point point = e.getLocationOnScreen();
        Intrinsics.checkNotNullExpressionValue((Object)point, (String)"getLocationOnScreen(...)");
        if (!this.j(point)) {
            return;
        }
        Point point2 = e.getPoint();
        if (this.myIsEngaged && !UIUtil.isSelectionButtonDown((MouseEvent)e) && this.treeTable.getSelectedRowCount() <= 1) {
            int n = this.treeTable.rowAtPoint(point2);
            if (n != this.myLastSelectedIndex && n >= 0) {
                this.treeTable.putClientProperty("byMouseEvent", true);
                this.treeTable.setRowSelectionInterval(n, n);
                this.treeTable.putClientProperty("byMouseEvent", false);
                this.myLastSelectedIndex = n;
            }
        } else {
            this.myIsEngaged = true;
        }
    }
}

