/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rd.ui.bindable.views;

import com.intellij.execution.console.EditorMergedHorizontalScrollBarLayout;
import com.intellij.execution.console.MergedHorizontalScrollBarModel;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.event.EditorMouseEvent;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.EditorPopupHandler;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.impl.ContextMenuPopupHandler;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.ExperimentalUI;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBScrollBar;
import com.intellij.util.ApplicationKt;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.rd.ui.bindable.views.ThinClientConsoleEditorPanel;
import com.jetbrains.rd.util.lifetime.Lifetime;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u0010\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\f\u00a8\u0006\u0012"}, d2={"Lcom/jetbrains/rd/ui/bindable/views/ThinClientConsoleEditorPanel;", "Ljavax/swing/JPanel;", "editor", "Lcom/intellij/openapi/editor/ex/EditorEx;", "commandEditor", "editorPanel", "Ljavax/swing/JComponent;", "commandEditorPanel", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "(Lcom/intellij/openapi/editor/ex/EditorEx;Lcom/intellij/openapi/editor/ex/EditorEx;Ljavax/swing/JComponent;Ljavax/swing/JComponent;Lcom/jetbrains/rd/util/lifetime/Lifetime;)V", "getCommandEditor", "()Lcom/intellij/openapi/editor/ex/EditorEx;", "getEditor", "j", "", "N", "Companion", "intellij.rd.ui"})
public final class ThinClientConsoleEditorPanel
extends JPanel {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final EditorEx editor;
    @NotNull
    private final EditorEx commandEditor;

    public ThinClientConsoleEditorPanel(@NotNull EditorEx editor2, @NotNull EditorEx commandEditor, @NotNull JComponent editorPanel, @NotNull JComponent commandEditorPanel, @NotNull Lifetime lifetime) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)commandEditor, (String)"commandEditor");
        Intrinsics.checkNotNullParameter((Object)editorPanel, (String)"editorPanel");
        Intrinsics.checkNotNullParameter((Object)commandEditorPanel, (String)"commandEditorPanel");
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        this.editor = editor2;
        this.commandEditor = commandEditor;
        JBScrollBar jBScrollBar = new JBScrollBar(0);
        MergedHorizontalScrollBarModel.create((JScrollBar)((JScrollBar)jBScrollBar), (EditorEx)this.editor, (EditorEx)this.commandEditor);
        this.setLayout((LayoutManager)new EditorMergedHorizontalScrollBarLayout((JScrollBar)jBScrollBar, this.editor, this.commandEditor, true, 2));
        this.add(editorPanel);
        this.add(commandEditorPanel);
        this.add((Component)jBScrollBar);
        this.setBackground((Color)JBColor.lazy(() -> ThinClientConsoleEditorPanel.j(this)));
        if (ExperimentalUI.Companion.isNewUI()) {
            this.editor.getSettings().setLineMarkerAreaShown(false);
            this.commandEditor.getSettings().setLineMarkerAreaShown(true);
        }
        this.editor.setCaretEnabled(false);
        KeyAdapter keyAdapter = new KeyAdapter(this){
            final /* synthetic */ ThinClientConsoleEditorPanel this$0;
            {
                this.this$0 = $receiver;
            }

            public void keyTyped(@NotNull KeyEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                if (UIUtil.isReallyTypedEvent((KeyEvent)e)) {
                    IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> keyListener.1.j(this.this$0));
                    this.this$0.getCommandEditor().processKeyTyped(e);
                }
            }

            private static final void j(ThinClientConsoleEditorPanel thinClientConsoleEditorPanel) {
                Intrinsics.checkNotNullParameter((Object)thinClientConsoleEditorPanel, (String)"this$0");
                IdeFocusManager.getGlobalInstance().requestFocus((Component)thinClientConsoleEditorPanel.getCommandEditor().getContentComponent(), true);
            }
        };
        lifetime.bracketIfAlive((Function0)new Function0<Unit>(keyAdapter){
            final /* synthetic */ keyListener.1 $keyListener;
            {
                this.$keyListener = $keyListener;
                super(0);
            }

            public final void invoke() {
                this.getEditor().getContentComponent().addKeyListener(this.$keyListener);
            }
        }, (Function0)new Function0<Unit>(keyAdapter){
            final /* synthetic */ keyListener.1 $keyListener;
            {
                this.$keyListener = $keyListener;
                super(0);
            }

            public final void invoke() {
                this.getEditor().getContentComponent().removeKeyListener(this.$keyListener);
            }
        });
        this.j(this.editor);
        this.N(this.editor);
    }

    @NotNull
    public final EditorEx getEditor() {
        return this.editor;
    }

    @NotNull
    public final EditorEx getCommandEditor() {
        return this.commandEditor;
    }

    private final void j(EditorEx editorEx) {
        editorEx.installPopupHandler((EditorPopupHandler)new ContextMenuPopupHandler(){

            @NotNull
            public ActionGroup getActionGroup(@NotNull EditorMouseEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                AnAction anAction = ActionManager.getInstance().getAction("ConsoleView.PopupMenu");
                Intrinsics.checkNotNull((Object)anAction, (String)"null cannot be cast to non-null type com.intellij.openapi.actionSystem.ActionGroup");
                return (ActionGroup)anAction;
            }
        });
    }

    private final void N(EditorEx editorEx) {
        editorEx.getDocument().addDocumentListener(new DocumentListener(editorEx){
            private boolean shouldStickToEnd;
            final /* synthetic */ EditorEx $editor;
            {
                this.$editor = $editor;
            }

            public final boolean getShouldStickToEnd() {
                return this.shouldStickToEnd;
            }

            public final void setShouldStickToEnd(boolean bl) {
                this.shouldStickToEnd = bl;
            }

            public void beforeDocumentChange(@NotNull DocumentEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                ThreadingAssertions.assertEventDispatchThread();
                if (event.getOffset() < event.getDocument().getTextLength()) {
                    this.shouldStickToEnd = false;
                    return;
                }
                this.shouldStickToEnd = com.jetbrains.rd.ui.bindable.views.ThinClientConsoleEditorPanel$Companion.access$isStickingToEnd(ThinClientConsoleEditorPanel.Companion, this.$editor);
            }

            public void documentChanged(@NotNull DocumentEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                if (event.getOffset() + event.getNewLength() < event.getDocument().getTextLength()) {
                    this.shouldStickToEnd = false;
                    return;
                }
                ApplicationKt.getApplication().invokeLater(() -> setupScrollToEndListener.1.j(this, this.$editor));
            }

            private static final void j(setupScrollToEndListener.1 var0, EditorEx editorEx) {
                Intrinsics.checkNotNullParameter((Object)var0, (String)"this$0");
                Intrinsics.checkNotNullParameter((Object)editorEx, (String)"$editor");
                if (var0.shouldStickToEnd) {
                    EditorUtil.scrollToTheEnd((Editor)((Editor)editorEx));
                    var0.shouldStickToEnd = false;
                }
            }
        });
    }

    private static final Color j(ThinClientConsoleEditorPanel thinClientConsoleEditorPanel) {
        Intrinsics.checkNotNullParameter((Object)thinClientConsoleEditorPanel, (String)"this$0");
        return thinClientConsoleEditorPanel.editor.getBackgroundColor();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\bH\u0002J\u0010\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\bH\u0002\u00a8\u0006\n"}, d2={"Lcom/jetbrains/rd/ui/bindable/views/ThinClientConsoleEditorPanel$Companion;", "", "()V", "j", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "N", "Lcom/intellij/openapi/editor/ex/EditorEx;", "j", "intellij.rd.ui"})
    public static final class Companion {
        private Companion() {
        }

        private final boolean N(EditorEx editorEx) {
            return this.j((Editor)editorEx) || this.j(editorEx);
        }

        private final boolean j(Editor editor2) {
            Document document = editor2.getDocument();
            Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
            Document document2 = document;
            int n = editor2.getCaretModel().getOffset();
            return document2.getLineNumber(n) >= document2.getLineCount() - 1;
        }

        private final boolean j(EditorEx editorEx) {
            JScrollBar jScrollBar = editorEx.getScrollPane().getVerticalScrollBar();
            return jScrollBar.getValue() == jScrollBar.getMaximum() - jScrollBar.getVisibleAmount();
        }

        public static final /* synthetic */ boolean access$isStickingToEnd(Companion $this, EditorEx editor2) {
            return $this.N(editor2);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

