/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rd.ui.bindable.views;

import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.colors.EditorFontType;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.highlighter.EditorHighlighterFactory;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.rd.LifetimeDisposableExKt;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.refactoring.ui.MethodSignatureComponent;
import com.intellij.ui.EditorTextField;
import com.intellij.util.DocumentUtil;
import com.intellij.util.LocalTimeCounter;
import com.jetbrains.ide.model.uiautomation.BeTextControlWithLanguage;
import com.jetbrains.rd.ide.model.RdLanguage;
import com.jetbrains.rd.ide.model.RdProjectId;
import com.jetbrains.rd.lang.ProtocolLanguageManagerKt;
import com.jetbrains.rd.platform.ProjectUtilKt;
import com.jetbrains.rd.ui.bindable.ViewBinder;
import com.jetbrains.rd.ui.bindable.views.TextControlWithLanguageViewControl;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.SequentialLifetimes;
import com.jetbrains.rd.util.reactive.IProperty;
import java.awt.Dimension;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\bH\u0016J.\u0010\t\u001a\u0004\u0018\u00010\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002\u00a8\u0006\u0013"}, d2={"Lcom/jetbrains/rd/ui/bindable/views/TextControlWithLanguageViewControl;", "Lcom/jetbrains/rd/ui/bindable/ViewBinder;", "Lcom/jetbrains/ide/model/uiautomation/BeTextControlWithLanguage;", "()V", "bind", "Ljavax/swing/JComponent;", "viewModel", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "j", "Lcom/intellij/openapi/editor/Document;", "project", "Lcom/intellij/openapi/project/Project;", "fileName", "", "fileType", "Lcom/intellij/openapi/fileTypes/FileType;", "createPsi", "", "intellij.rd.ui"})
public final class TextControlWithLanguageViewControl
implements ViewBinder<BeTextControlWithLanguage> {
    @Override
    @NotNull
    public JComponent bind(@NotNull BeTextControlWithLanguage viewModel, @NotNull Lifetime lifetime) {
        Intrinsics.checkNotNullParameter((Object)((Object)viewModel), (String)"viewModel");
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        RdLanguage rdLanguage = viewModel.getLanguage();
        if (rdLanguage == null || (rdLanguage = ProtocolLanguageManagerKt.toIdeaFileType(rdLanguage)) == null) {
            LanguageFileType languageFileType = FileTypes.PLAIN_TEXT;
            Intrinsics.checkNotNullExpressionValue((Object)languageFileType, (String)"PLAIN_TEXT");
            rdLanguage = (FileType)languageFileType;
        }
        RdLanguage rdLanguage2 = rdLanguage;
        RdProjectId rdProjectId = viewModel.getProjectId();
        Project project = rdProjectId != null ? ProjectUtilKt.toProject(rdProjectId) : null;
        JComponent jComponent = null;
        if (((Boolean)viewModel.getTextControl().getSettings().getReadonly().getValue()).booleanValue()) {
            jComponent = (JComponent)new MethodSignatureComponent(project, (FileType)rdLanguage2){

                @NotNull
                protected EditorEx createEditor() {
                    EditorEx editorEx;
                    EditorEx editorEx2 = super.createEditor();
                    Intrinsics.checkNotNullExpressionValue((Object)editorEx2, (String)"createEditor(...)");
                    EditorEx editorEx3 = editorEx = editorEx2;
                    boolean bl = false;
                    editorEx3.getSettings().setUseSoftWraps(true);
                    this.setMinimumSize(new Dimension(300, 60));
                    return editorEx;
                }
            };
            viewModel.getTextControl().getText().advise(lifetime, (Function1)new Function1<String, Unit>(jComponent){
                final /* synthetic */ JComponent $result;
                {
                    this.$result = $result;
                    super(1);
                }

                public final void invoke(@NotNull String it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    ((Object)this.$result).setSignature(it);
                }
            });
        } else {
            String string = viewModel.getCustomFileName();
            Document document = this.j(project, string, (FileType)rdLanguage2, viewModel.getCreatePsiFile());
            EditorTextField editorTextField = new EditorTextField(document, project, (FileType)rdLanguage2){
                final /* synthetic */ Project $project;
                final /* synthetic */ FileType $fileType;
                {
                    this.$project = $project;
                    this.$fileType = $fileType;
                    super($document, $project, $fileType);
                }

                @NotNull
                protected EditorEx createEditor() {
                    EditorEx editorEx = super.createEditor();
                    Intrinsics.checkNotNullExpressionValue((Object)editorEx, (String)"createEditor(...)");
                    EditorEx editorEx2 = editorEx;
                    Project project = this.$project;
                    FileType fileType = this.$fileType;
                    EditorEx editorEx3 = editorEx2;
                    boolean bl = false;
                    editorEx3.getSettings().setUseSoftWraps(true);
                    editorEx3.setHighlighter(EditorHighlighterFactory.Companion.getInstance().createEditorHighlighter(project, fileType));
                    editorEx3.getSettings().setWhitespacesShown(false);
                    editorEx3.getSettings().setCaretRowShown(true);
                    editorEx3.setHorizontalScrollbarVisible(true);
                    editorEx3.setVerticalScrollbarVisible(true);
                    this.setMinimumSize(new Dimension(300, 60));
                    return editorEx2;
                }

                @Nullable
                public Object getData(@NotNull String dataId) {
                    Intrinsics.checkNotNullParameter((Object)dataId, (String)"dataId");
                    if (CommonDataKeys.PROJECT.is(dataId)) {
                        return this.$project;
                    }
                    return super.getData(dataId);
                }
            };
            editorTextField.setFont(EditorFontType.PLAIN.getGlobalFont());
            editorTextField.setCaretPosition(0);
            Ref.BooleanRef booleanRef = new Ref.BooleanRef();
            DocumentListener documentListener = new DocumentListener(booleanRef, viewModel, editorTextField){
                final /* synthetic */ Ref.BooleanRef $localCookie;
                final /* synthetic */ BeTextControlWithLanguage $viewModel;
                final /* synthetic */ bind.textField.1 $textField;
                {
                    this.$localCookie = $localCookie;
                    this.$viewModel = $viewModel;
                    this.$textField = $textField;
                }

                public void documentChanged(@NotNull DocumentEvent event) {
                    Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                    if (this.$localCookie.element) {
                        return;
                    }
                    this.$localCookie.element = true;
                    IProperty<String> iProperty = this.$viewModel.getTextControl().getText();
                    String string = this.$textField.getText();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                    iProperty.set((Object)string);
                    this.$localCookie.element = false;
                }
            };
            lifetime.bracketIfAlive((Function0)new Function0<Unit>(editorTextField, documentListener){
                final /* synthetic */ bind.textField.1 $textField;
                final /* synthetic */ DocumentListener $value;
                {
                    this.$textField = $textField;
                    this.$value = $value;
                    super(0);
                }

                public final void invoke() {
                    this.$textField.addDocumentListener(this.$value);
                }
            }, (Function0)new Function0<Unit>(editorTextField, documentListener){
                final /* synthetic */ bind.textField.1 $textField;
                final /* synthetic */ DocumentListener $value;
                {
                    this.$textField = $textField;
                    this.$value = $value;
                    super(0);
                }

                public final void invoke() {
                    this.$textField.removeDocumentListener(this.$value);
                }
            });
            viewModel.getTextControl().getText().advise(lifetime, (Function1)new Function1<String, Unit>(booleanRef, editorTextField){
                final /* synthetic */ Ref.BooleanRef $localCookie;
                final /* synthetic */ bind.textField.1 $textField;
                {
                    this.$localCookie = $localCookie;
                    this.$textField = $textField;
                    super(1);
                }

                public final void invoke(@NotNull String it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    if (this.$localCookie.element) {
                        return;
                    }
                    this.$localCookie.element = true;
                    DocumentUtil.writeInRunUndoTransparentAction(() -> bind.5.j(this.$textField, it));
                    this.$localCookie.element = false;
                }

                private static final void j(bind.textField.1 var0, String string) {
                    Intrinsics.checkNotNullParameter((Object)((Object)var0), (String)"$textField");
                    Intrinsics.checkNotNullParameter((Object)string, (String)"$it");
                    var0.getDocument().setText((CharSequence)string);
                }
            });
            editorTextField.setOneLineMode(false);
            AnAction anAction = ActionManager.getInstance().getAction("Find");
            if (anAction != null) {
                editorTextField.addFocusListener(new FocusListener(lifetime, editorTextField, anAction){
                    @NotNull
                    private final SequentialLifetimes sequentialLifetimes;
                    final /* synthetic */ bind.textField.1 $textField;
                    final /* synthetic */ AnAction $findAction;
                    {
                        this.$textField = $textField;
                        this.$findAction = $findAction;
                        this.sequentialLifetimes = new SequentialLifetimes($lifetime);
                    }

                    public void focusGained(@Nullable FocusEvent e) {
                        JComponent jComponent = this.$textField.getComponent();
                        this.$findAction.registerCustomShortcutSet(this.$findAction.getShortcutSet(), jComponent, LifetimeDisposableExKt.createNestedDisposable$default((Lifetime)((Lifetime)this.sequentialLifetimes.next()), null, (int)1, null));
                    }

                    public void focusLost(@Nullable FocusEvent e) {
                        this.sequentialLifetimes.terminateCurrent();
                    }
                });
            }
            jComponent = (JComponent)editorTextField;
        }
        viewModel.getEnabled().advise(lifetime, (Function1)new Function1<Boolean, Unit>(jComponent){
            final /* synthetic */ JComponent $result;
            {
                this.$result = $result;
                super(1);
            }

            public final void invoke(boolean it) {
                this.$result.setEnabled(it);
            }
        });
        return jComponent;
    }

    private final Document j(Project project, String string, FileType fileType, boolean bl) {
        if (!bl || project == null) {
            return EditorFactory.getInstance().createDocument((CharSequence)"");
        }
        PsiFileFactory psiFileFactory = PsiFileFactory.getInstance((Project)project);
        long l = LocalTimeCounter.currentTime();
        Object object = string;
        if (object == null) {
            object = "Dummy." + fileType.getDefaultExtension();
        }
        PsiFile psiFile = psiFileFactory.createFileFromText((String)object, fileType, (CharSequence)"", l, true, false);
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"createFileFromText(...)");
        PsiFile psiFile2 = psiFile;
        return PsiDocumentManager.getInstance((Project)project).getDocument(psiFile2);
    }
}

