/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rd.ui.bindable.views;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.impl.DocumentMarkupModel;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.util.DocumentUtil;
import com.jetbrains.ide.model.highlighterRegistration.TextAttributesKeyModel;
import com.jetbrains.ide.model.uiautomation.BeEditor;
import com.jetbrains.ide.model.uiautomation.BeEditorSettings;
import com.jetbrains.ide.model.uiautomation.BeIdeaEditorSettings;
import com.jetbrains.ide.model.uiautomation.ControlVisibility;
import com.jetbrains.rd.ide.model.RdProjectId;
import com.jetbrains.rd.ide.model.RichAttributedStringModel;
import com.jetbrains.rd.ide.model.RichAttributedTextModel;
import com.jetbrains.rd.platform.ProjectUtilKt;
import com.jetbrains.rd.platform.daemon.TextAttributesRegistrationHost;
import com.jetbrains.rd.ui.bedsl.extensions.LocalChangeKt;
import com.jetbrains.rd.ui.bedsl.extensions.UpdateFlag;
import com.jetbrains.rd.ui.bindable.ViewBinder;
import com.jetbrains.rd.ui.bindable.views.EditorViewControl;
import com.jetbrains.rd.util.lifetime.Lifetime;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\nH\u0016J\u001e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\f0\u0010H\u0002J\u0016\u0010\u0011\u001a\u00020\u00122\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\nR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/jetbrains/rd/ui/bindable/views/EditorViewControl;", "Lcom/jetbrains/rd/ui/bindable/ViewBinder;", "Lcom/jetbrains/ide/model/uiautomation/BeEditor;", "()V", "reentrancyPreventer", "Lcom/jetbrains/rd/ui/bedsl/extensions/UpdateFlag;", "bind", "Ljavax/swing/JComponent;", "viewModel", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "j", "", "document", "Lcom/intellij/openapi/editor/Document;", "action", "Lkotlin/Function0;", "getEditor", "Lcom/intellij/openapi/editor/ex/EditorEx;", "intellij.rd.ui"})
public final class EditorViewControl
implements ViewBinder<BeEditor> {
    @NotNull
    private final UpdateFlag reentrancyPreventer = new UpdateFlag();

    @Override
    @NotNull
    public JComponent bind(@NotNull BeEditor viewModel, @NotNull Lifetime lifetime) {
        Intrinsics.checkNotNullParameter((Object)((Object)viewModel), (String)"viewModel");
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        JComponent jComponent = this.getEditor(viewModel, lifetime).getComponent();
        Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"getComponent(...)");
        return jComponent;
    }

    @NotNull
    public final EditorEx getEditor(@NotNull BeEditor viewModel, @NotNull Lifetime lifetime) {
        Intrinsics.checkNotNullParameter((Object)((Object)viewModel), (String)"viewModel");
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        EditorFactory editorFactory = EditorFactory.getInstance();
        Document document = editorFactory.createDocument((CharSequence)"");
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"createDocument(...)");
        Document document2 = document;
        document2.setReadOnly(((Boolean)viewModel.isReadonly().getValue()).booleanValue());
        RdProjectId rdProjectId = viewModel.getProjectId();
        Project project = rdProjectId != null ? ProjectUtilKt.toProject(rdProjectId) : null;
        Editor editor2 = editorFactory.createEditor(document2, project);
        Intrinsics.checkNotNull((Object)editor2, (String)"null cannot be cast to non-null type com.intellij.openapi.editor.ex.EditorEx");
        EditorEx editorEx = (EditorEx)editor2;
        lifetime.onTermination((Function0)new Function0<Unit>(editorEx){
            final /* synthetic */ EditorEx $editor;
            {
                this.$editor = $editor;
                super(0);
            }

            public final void invoke() {
                if (!this.$editor.isDisposed()) {
                    EditorFactory.getInstance().releaseEditor((Editor)this.$editor);
                }
            }
        });
        BeEditorSettings beEditorSettings = (BeEditorSettings)((Object)viewModel.getSettings().getValue());
        if (beEditorSettings instanceof BeIdeaEditorSettings) {
            editorEx.getSettings().setAdditionalColumnsCount(((BeIdeaEditorSettings)beEditorSettings).getAdditionalColumnsCount());
            editorEx.getSettings().setAdditionalLinesCount(((BeIdeaEditorSettings)beEditorSettings).getAdditionalLinesCount());
            editorEx.getSettings().setCaretRowShown(((BeIdeaEditorSettings)beEditorSettings).isCaretRowShown());
            editorEx.getSettings().setFoldingOutlineShown(((BeIdeaEditorSettings)beEditorSettings).isFoldingOutlineShown());
            editorEx.getSettings().setIndentGuidesShown(((BeIdeaEditorSettings)beEditorSettings).isIndentGuidesShown());
            editorEx.getSettings().setLineMarkerAreaShown(((BeIdeaEditorSettings)beEditorSettings).isLineMarkerAreaShown());
            editorEx.getSettings().setLineNumbersShown(((BeIdeaEditorSettings)beEditorSettings).isLineNumbersShown());
            editorEx.getSettings().setUseSoftWraps(((BeIdeaEditorSettings)beEditorSettings).isUseSoftWraps());
            editorEx.getSettings().setWhitespacesShown(((BeIdeaEditorSettings)beEditorSettings).isWhitespacesShown());
            editorEx.getSettings().setShowingSpecialChars(((BeIdeaEditorSettings)beEditorSettings).isShowingSpecialChars());
        }
        editorEx.setHorizontalScrollbarVisible(true);
        editorEx.setVerticalScrollbarVisible(true);
        viewModel.getText().getText().advise(lifetime, (Function1)new Function1<RichAttributedTextModel, Unit>(this, document2, project){
            final /* synthetic */ EditorViewControl this$0;
            final /* synthetic */ Document $document;
            final /* synthetic */ Project $project;
            {
                this.this$0 = $receiver;
                this.$document = $document;
                this.$project = $project;
                super(1);
            }

            public final void invoke(@NotNull RichAttributedTextModel it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                LocalChangeKt.ignoreOnReentrancy(EditorViewControl.access$getReentrancyPreventer$p(this.this$0), (Function0<Unit>)((Function0)new Function0<Unit>(this.$document, this.$project, this.this$0, it){
                    final /* synthetic */ Document $document;
                    final /* synthetic */ Project $project;
                    final /* synthetic */ EditorViewControl this$0;
                    final /* synthetic */ RichAttributedTextModel $it;
                    {
                        this.$document = $document;
                        this.$project = $project;
                        this.this$0 = $receiver;
                        this.$it = $it;
                        super(0);
                    }

                    public final void invoke() {
                        MarkupModel markupModel = DocumentMarkupModel.forDocument((Document)this.$document, (Project)this.$project, (boolean)true);
                        Intrinsics.checkNotNull((Object)markupModel, (String)"null cannot be cast to non-null type com.intellij.openapi.editor.ex.MarkupModelEx");
                        MarkupModelEx markupModelEx = (MarkupModelEx)markupModel;
                        ApplicationManager.getApplication().invokeLaterOnWriteThread(() -> getEditor.1.j(markupModelEx, this.this$0, this.$document, this.$it));
                    }

                    private static final void N(MarkupModelEx markupModelEx, EditorViewControl editorViewControl, Document document, RichAttributedTextModel richAttributedTextModel) {
                        Intrinsics.checkNotNullParameter((Object)markupModelEx, (String)"$markupModel");
                        Intrinsics.checkNotNullParameter((Object)editorViewControl, (String)"this$0");
                        Intrinsics.checkNotNullParameter((Object)document, (String)"$document");
                        Intrinsics.checkNotNullParameter((Object)richAttributedTextModel, (String)"$it");
                        markupModelEx.removeAllHighlighters();
                        EditorViewControl.access$doIgnoringReadOnly(editorViewControl, document, (Function0)new Function0<Unit>(document, richAttributedTextModel){
                            final /* synthetic */ Document $document;
                            final /* synthetic */ RichAttributedTextModel $it;
                            {
                                this.$document = $document;
                                this.$it = $it;
                                super(0);
                            }

                            public final void invoke() {
                                this.$document.setText((CharSequence)CollectionsKt.joinToString$default((Iterable)this.$it.getParts(), (CharSequence)"", null, null, (int)0, null, (Function1)getEditor.1.1.1.INSTANCE, (int)30, null));
                            }
                        });
                        int n = 0;
                        Iterable iterable = richAttributedTextModel.getParts();
                        boolean bl = false;
                        for (T t : iterable) {
                            RichAttributedStringModel richAttributedStringModel = (RichAttributedStringModel)t;
                            boolean bl2 = false;
                            String string = richAttributedStringModel.getText();
                            TextAttributesKeyModel textAttributesKeyModel = richAttributedStringModel.getTextAttributesKey();
                            if (textAttributesKeyModel != null) {
                                TextAttributesRegistrationHost textAttributesRegistrationHost = TextAttributesRegistrationHost.Companion.getInstance();
                                int n2 = n + string.length();
                                TextAttributes textAttributes = TextAttributesRegistrationHost.getTextAttributes$default(textAttributesRegistrationHost, textAttributesKeyModel, null, 2, null);
                                if (textAttributes == null) {
                                    textAttributes = new TextAttributes();
                                }
                                markupModelEx.addRangeHighlighter(n, n2, 3000, textAttributes, HighlighterTargetArea.EXACT_RANGE);
                            }
                            n += string.length();
                        }
                    }

                    private static final void j(MarkupModelEx markupModelEx, EditorViewControl editorViewControl, Document document, RichAttributedTextModel richAttributedTextModel) {
                        Intrinsics.checkNotNullParameter((Object)markupModelEx, (String)"$markupModel");
                        Intrinsics.checkNotNullParameter((Object)editorViewControl, (String)"this$0");
                        Intrinsics.checkNotNullParameter((Object)document, (String)"$document");
                        Intrinsics.checkNotNullParameter((Object)richAttributedTextModel, (String)"$it");
                        DocumentUtil.writeInRunUndoTransparentAction(() -> getEditor.1.N(markupModelEx, editorViewControl, document, richAttributedTextModel));
                    }
                }));
            }
        });
        viewModel.getEnabled().advise(lifetime, (Function1)new Function1<Boolean, Unit>(editorEx){
            final /* synthetic */ EditorEx $editor;
            {
                this.$editor = $editor;
                super(1);
            }

            public final void invoke(boolean it) {
                this.$editor.getComponent().setEnabled(it);
            }
        });
        viewModel.getVisible().advise(lifetime, (Function1)new Function1<ControlVisibility, Unit>(editorEx){
            final /* synthetic */ EditorEx $editor;
            {
                this.$editor = $editor;
                super(1);
            }

            public final void invoke(@NotNull ControlVisibility it) {
                Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
                this.$editor.getComponent().setVisible(it == ControlVisibility.Visible);
            }
        });
        return editorEx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void j(Document document, Function0<Unit> function0) {
        if (document.isWritable()) {
            function0.invoke();
        } else {
            document.setReadOnly(false);
            try {
                function0.invoke();
            }
            finally {
                document.setReadOnly(true);
            }
        }
    }

    public static final /* synthetic */ UpdateFlag access$getReentrancyPreventer$p(EditorViewControl $this) {
        return $this.reentrancyPreventer;
    }

    public static final /* synthetic */ void access$doIgnoringReadOnly(EditorViewControl $this, Document document, Function0 action3) {
        $this.j(document, (Function0<Unit>)action3);
    }
}

