/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rd.ui.bindable.popup;

import com.intellij.ide.DataManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.client.ClientSessionsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.ex.WindowManagerEx;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.awt.RelativeRectangle;
import com.intellij.ui.popup.AbstractPopup;
import com.intellij.util.ApplicationKt;
import com.jetbrains.ide.model.uiautomation.BeControlSize;
import com.jetbrains.ide.model.uiautomation.DialogResult;
import com.jetbrains.rd.ide.model.BeAbstractPopup;
import com.jetbrains.rd.ide.model.BePopupPositionActiveWindowContext;
import com.jetbrains.rd.ide.model.BePopupPositionComponentContext;
import com.jetbrains.rd.ide.model.BePopupPositionContext;
import com.jetbrains.rd.ide.model.BePopupPositionDataContextContext;
import com.jetbrains.rd.ide.model.BePopupPositionFocusContext;
import com.jetbrains.rd.ide.model.BePopupPositionMousePositionContext;
import com.jetbrains.rd.ide.model.BePopupPositionScreenPointContext;
import com.jetbrains.rd.ide.model.BePopupPositionTreeOrTableSelectedItemContext;
import com.jetbrains.rd.platform.ProjectUtilKt;
import com.jetbrains.rd.ui.bindable.ConverterStorage;
import com.jetbrains.rd.ui.bindable.popup.BeShowPopupHandler;
import com.jetbrains.rd.ui.bindable.popup.PopupProvider;
import com.jetbrains.rd.ui.bindable.popup.PopupUtils;
import com.jetbrains.rd.ui.bindable.popup.PopupViewControl;
import com.jetbrains.rd.ui.bindable.views.contextProviders.BeContextProvider;
import com.jetbrains.rd.ui.bindable.views.listControl.utils.SwingTreeUtilsKt;
import com.jetbrains.rd.ui.bindable.views.utils.MarginTypesKt;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.reactive.ISource;
import com.jetbrains.rd.util.reactive.InterfacesKt;
import com.jetbrains.rdclient.ui.bindableUi.views.utils.BeUtilKt;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.event.KeyAdapter;
import java.awt.event.MouseAdapter;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\b\u0010\r\u001a\u00020\u000eH\u0002J\u0006\u0010\u000f\u001a\u00020\u0010J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/jetbrains/rd/ui/bindable/popup/PopupViewControl;", "", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "project", "Lcom/intellij/openapi/project/Project;", "model", "Lcom/jetbrains/rd/ide/model/BeAbstractPopup;", "isReflection", "", "(Lcom/jetbrains/rd/util/lifetime/Lifetime;Lcom/intellij/openapi/project/Project;Lcom/jetbrains/rd/ide/model/BeAbstractPopup;Z)V", "getLifetime", "()Lcom/jetbrains/rd/util/lifetime/Lifetime;", "j", "Lcom/intellij/openapi/ui/popup/JBPopup;", "showPopup", "", "popup", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "intellij.rd.ui"})
public final class PopupViewControl {
    @NotNull
    private final Lifetime lifetime;
    @Nullable
    private final Project project;
    @NotNull
    private final BeAbstractPopup model;
    private final boolean isReflection;

    public PopupViewControl(@NotNull Lifetime lifetime, @Nullable Project project, @NotNull BeAbstractPopup model2, boolean isReflection) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)((Object)model2), (String)"model");
        this.lifetime = lifetime;
        this.project = project;
        this.model = model2;
        this.isReflection = isReflection;
    }

    @NotNull
    public final Lifetime getLifetime() {
        return this.lifetime;
    }

    public final void showPopup() {
        this.model.getLoaded().advise(this.lifetime, (Function1)new Function1<Unit, Unit>(this){
            final /* synthetic */ PopupViewControl this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull Unit it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                JBPopup jBPopup = PopupViewControl.access$loadPopup(this.this$0);
                DataManager.getInstance().getDataContextFromFocusAsync().onSuccess(arg_0 -> showPopup.1.j((Function1)new Function1<DataContext, Unit>(jBPopup, this.this$0){
                    final /* synthetic */ JBPopup $popup;
                    final /* synthetic */ PopupViewControl this$0;
                    {
                        this.$popup = $popup;
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final void invoke(DataContext dataContext) {
                        SwingUtilities.invokeLater(() -> showPopup.1.j(this.$popup, this.this$0, dataContext));
                    }

                    private static final void j(JBPopup jBPopup, PopupViewControl popupViewControl, DataContext dataContext) {
                        Intrinsics.checkNotNullParameter((Object)jBPopup, (String)"$popup");
                        Intrinsics.checkNotNullParameter((Object)popupViewControl, (String)"this$0");
                        if (jBPopup.isDisposed()) {
                            return;
                        }
                        Intrinsics.checkNotNull((Object)dataContext);
                        PopupViewControl.access$showPopup(popupViewControl, jBPopup, dataContext);
                        Integer n = (Integer)PopupViewControl.access$getModel$p(popupViewControl).getDataId().getValueOrNull();
                        PopupUtils.Companion.putRdPopupId(jBPopup, n != null ? n : -1);
                    }
                }, arg_0));
            }

            private static final void j(Function1 function1, Object object) {
                Intrinsics.checkNotNullParameter((Object)function1, (String)"$tmp0");
                function1.invoke(object);
            }
        });
    }

    private final JBPopup j() {
        JBPopup jBPopup = PopupProvider.Companion.getPopup(this.lifetime, this.project, this.model);
        if (jBPopup == null) {
            throw new IllegalStateException();
        }
        JBPopup jBPopup2 = jBPopup;
        if (jBPopup2 instanceof AbstractPopup) {
            ((AbstractPopup)jBPopup2).setStretchToOwnerWidth(this.model.getSettings().getStretchToOwnerWidth());
            ((AbstractPopup)jBPopup2).setStretchToOwnerHeight(this.model.getSettings().getStretchToOwnerHeight());
            ((AbstractPopup)jBPopup2).setOkHandler(() -> PopupViewControl.j(this));
            Pair<Integer, Integer> pair = (Pair<Integer, Integer>)this.model.getMinimumSize().getValue();
            if (pair != null && (pair = MarginTypesKt.getSize((BeControlSize)pair)) != null) {
                Pair<Integer, Integer> pair2 = pair;
                boolean bl = false;
                ((AbstractPopup)jBPopup2).setMinimumSize(new Dimension(((Number)pair2.getFirst()).intValue(), ((Number)pair2.getSecond()).intValue()));
            }
        }
        this.model.getResult().advise(this.lifetime, (Function1)new Function1<DialogResult, Unit>(jBPopup2){
            final /* synthetic */ JBPopup $popup;
            {
                this.$popup = $popup;
                super(1);
            }

            public final void invoke(@NotNull DialogResult it) {
                Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
                if (it == DialogResult.CLOSE && !this.$popup.isDisposed()) {
                    this.$popup.cancel(null);
                }
            }
        });
        ISource iSource = this.model.getTitle();
        if (iSource != null && (iSource = iSource.getText()) != null && (iSource = iSource.getChange()) != null) {
            iSource.advise(this.lifetime, (Function1)new Function1<String, Unit>(jBPopup2){
                final /* synthetic */ JBPopup $popup;
                {
                    this.$popup = $popup;
                    super(1);
                }

                public final void invoke(@NotNull String it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    this.$popup.setCaption(it);
                }
            });
        }
        this.model.getResize().advise(this.lifetime, (Function1)new Function1<BeControlSize, Unit>(jBPopup2){
            final /* synthetic */ JBPopup $popup;
            {
                this.$popup = $popup;
                super(1);
            }

            public final void invoke(@NotNull BeControlSize it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                Pair<Integer, Integer> pair = MarginTypesKt.getSize(it);
                if (((Number)pair.getFirst()).intValue() < 0 || ((Number)pair.getSecond()).intValue() < 0) {
                    BeUtilKt.resizePopup$default(this.$popup, false, false, 3, null);
                } else {
                    this.$popup.setSize(new Dimension(((Number)pair.getFirst()).intValue(), ((Number)pair.getSecond()).intValue()));
                }
            }
        });
        this.lifetime.onTermination((Function0)new Function0<Unit>(this, jBPopup2){
            final /* synthetic */ PopupViewControl this$0;
            final /* synthetic */ JBPopup $popup;
            {
                this.this$0 = $receiver;
                this.$popup = $popup;
                super(0);
            }

            public final void invoke() {
                PopupViewControl.access$getModel$p(this.this$0).getResult().set((Object)((Object)DialogResult.CLOSE));
                if (this.$popup.isDisposed()) {
                    return;
                }
                this.$popup.cancel();
                Disposer.dispose((Disposable)((Disposable)this.$popup));
            }
        });
        if (this.isReflection) {
            jBPopup2.addListener(new JBPopupListener(){

                public void beforeShown(@NotNull LightweightWindowEvent event) {
                    Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                    JPanel jPanel2 = new JPanel();
                    jPanel2.setOpaque(false);
                    jPanel2.setVisible(true);
                    jPanel2.addMouseListener(new MouseAdapter(){});
                    jPanel2.addKeyListener(new KeyAdapter(){});
                    JRootPane jRootPane = SwingUtilities.getRootPane(event.asPopup().getContent());
                    if (jRootPane != null) {
                        jRootPane.setGlassPane(jPanel2);
                    }
                }
            });
        }
        return jBPopup2;
    }

    private final void j(JBPopup jBPopup, DataContext dataContext) {
        BePopupPositionContext bePopupPositionContext;
        Component component;
        BePopupPositionContext bePopupPositionContext2 = (BePopupPositionContext)((Object)this.model.getContext().getValueOrNull());
        Component component2 = WindowManagerEx.getInstanceEx().getFocusedComponent(this.project);
        if (component2 == null) {
            component2 = component = (Component)WindowManagerEx.getInstanceEx().getMostRecentFocusedWindow();
        }
        if ((bePopupPositionContext = bePopupPositionContext2) instanceof BePopupPositionFocusContext) {
            jBPopup.showInFocusCenter();
        } else if (bePopupPositionContext instanceof BePopupPositionActiveWindowContext) {
            Project project = ProjectUtilKt.toProject(((BePopupPositionActiveWindowContext)bePopupPositionContext2).getProjectId());
            jBPopup.showCenteredInCurrentWindow(project);
        } else if (bePopupPositionContext instanceof BePopupPositionTreeOrTableSelectedItemContext) {
            RelativeRectangle relativeRectangle;
            Component component3;
            Component component4 = component3 = ConverterStorage.Companion.getInstance(ClientSessionsUtil.getCurrentSession((Application)ApplicationKt.getApplication())).tryGetComponentByDataId(((BePopupPositionTreeOrTableSelectedItemContext)bePopupPositionContext2).getComponentId());
            Object object = relativeRectangle = component4 != null ? SwingTreeUtilsKt.tryGetSelectedItemBounds(component4) : null;
            if (relativeRectangle != null) {
                RelativeRectangle relativeRectangle2 = relativeRectangle;
                boolean bl = false;
                Point point = new Point(relativeRectangle2.getPoint().getPoint().x + relativeRectangle2.getDimension().width, relativeRectangle2.getPoint().getPoint().y + relativeRectangle2.getDimension().height / 2);
                jBPopup.show(new RelativePoint(relativeRectangle.getComponent(), point));
            } else {
                jBPopup.showInBestPositionFor(dataContext);
            }
        } else if (bePopupPositionContext instanceof BePopupPositionComponentContext) {
            Project project = this.project;
            if (project == null) {
                project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
            }
            Project project2 = project;
            RelativePoint relativePoint = BeContextProvider.Companion.getPointFromContext(project2, (BePopupPositionComponentContext)bePopupPositionContext2, jBPopup.getContent().getPreferredSize());
            RelativePoint relativePoint2 = relativePoint;
            if (relativePoint2 != null) {
                jBPopup.show(relativePoint2);
            } else {
                Project project3 = project2;
                if (project3 != null) {
                    jBPopup.showCenteredInCurrentWindow(project3);
                } else {
                    jBPopup.showInBestPositionFor(dataContext);
                }
            }
        } else if (bePopupPositionContext instanceof BePopupPositionMousePositionContext) {
            if (component != null) {
                jBPopup.showInScreenCoordinates(component, MouseInfo.getPointerInfo().getLocation());
            } else {
                jBPopup.showInBestPositionFor(dataContext);
            }
        } else if (bePopupPositionContext instanceof BePopupPositionScreenPointContext) {
            if (component != null) {
                jBPopup.showInScreenCoordinates(component, new Point(((BePopupPositionScreenPointContext)bePopupPositionContext2).getX(), ((BePopupPositionScreenPointContext)bePopupPositionContext2).getY()));
            } else {
                jBPopup.showInBestPositionFor(dataContext);
            }
        } else if (bePopupPositionContext instanceof BePopupPositionDataContextContext) {
            jBPopup.showInBestPositionFor(dataContext);
        } else if (!BeShowPopupHandler.Companion.showPopup(jBPopup, bePopupPositionContext2)) {
            jBPopup.showInBestPositionFor(dataContext);
        }
    }

    private static final void j(PopupViewControl popupViewControl) {
        Intrinsics.checkNotNullParameter((Object)popupViewControl, (String)"this$0");
        InterfacesKt.fire(popupViewControl.model.getAccept());
        popupViewControl.model.getResult().set((Object)DialogResult.OK);
        popupViewControl.model.getResult().set((Object)DialogResult.CANCEL);
    }

    public static final /* synthetic */ JBPopup access$loadPopup(PopupViewControl $this) {
        return $this.j();
    }

    public static final /* synthetic */ void access$showPopup(PopupViewControl $this, JBPopup popup, DataContext dataContext) {
        $this.j(popup, dataContext);
    }

    public static final /* synthetic */ BeAbstractPopup access$getModel$p(PopupViewControl $this) {
        return $this.model;
    }
}

