/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rd.ui;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ColorUtil;
import com.jetbrains.rd.ide.model.AbstractColor;
import com.jetbrains.rd.ide.model.EffectStyle;
import com.jetbrains.rd.ide.model.FontStyle;
import com.jetbrains.rd.ide.model.RgbColor;
import com.jetbrains.rd.ide.model.RichStringModel;
import com.jetbrains.rd.ide.model.RichTextBlockModel;
import com.jetbrains.rd.ide.model.RichTextModel;
import com.jetbrains.rd.platform.colors.ColorHostKt;
import com.jetbrains.rd.ui.ProtocolUIKt;
import com.jetbrains.rd.ui.util.ColorUtilsKt;
import java.awt.Color;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000:\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\u0002\u001a \u0010\u0003\u001a\u0018\u0012\t\u0012\u00070\u0005\u00a2\u0006\u0002\b\u0006\u0012\t\u0012\u00070\u0005\u00a2\u0006\u0002\b\u00060\u0004*\u00020\u0007\u001a\u0012\u0010\b\u001a\u00020\u0005*\u00020\t2\u0006\u0010\n\u001a\u00020\u000b\u001a\u001e\u0010\b\u001a\u00020\f*\u00020\t2\n\u0010\r\u001a\u00060\u000ej\u0002`\u000f2\u0006\u0010\n\u001a\u00020\u000b\u001a\u001e\u0010\b\u001a\u00020\f*\u00020\u00072\n\u0010\r\u001a\u00060\u000ej\u0002`\u000f2\u0006\u0010\n\u001a\u00020\u000b\u001a\f\u0010\u0010\u001a\u00020\u0005*\u00020\u0007H\u0007\u00a8\u0006\u0011"}, d2={"isGrayed", "", "Lcom/jetbrains/rd/ide/model/RgbColor;", "splitByGrayColor", "Lkotlin/Pair;", "", "Lorg/jetbrains/annotations/Nls;", "Lcom/jetbrains/rd/ide/model/RichTextModel;", "toHtml", "Lcom/jetbrains/rd/ide/model/RichTextBlockModel;", "bgColor", "Ljava/awt/Color;", "", "stringBuilder", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "toSimpleText", "intellij.rd.ui"})
public final class ProtocolUIKt {
    public static final boolean isGrayed(@NotNull RgbColor $this$isGrayed) {
        Intrinsics.checkNotNullParameter((Object)$this$isGrayed, (String)"<this>");
        return $this$isGrayed.getRed() == $this$isGrayed.getGreen() && $this$isGrayed.getGreen() == $this$isGrayed.getBlue() && $this$isGrayed.getRed() < 255 && $this$isGrayed.getRed() > 0;
    }

    @Nls
    @NotNull
    public static final String toSimpleText(@NotNull RichTextModel $this$toSimpleText) {
        Intrinsics.checkNotNullParameter((Object)$this$toSimpleText, (String)"<this>");
        return CollectionsKt.joinToString$default((Iterable)$this$toSimpleText.getParts(), (CharSequence)"", null, null, (int)0, null, (Function1)toSimpleText.1.INSTANCE, (int)30, null);
    }

    @NotNull
    public static final Pair<String, String> splitByGrayColor(@NotNull RichTextModel $this$splitByGrayColor) {
        Intrinsics.checkNotNullParameter((Object)$this$splitByGrayColor, (String)"<this>");
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilder stringBuilder2 = new StringBuilder();
        for (RichStringModel richStringModel : $this$splitByGrayColor.getParts()) {
            RgbColor rgbColor;
            AbstractColor abstractColor = richStringModel.getForegroundColor();
            RgbColor rgbColor2 = rgbColor = abstractColor instanceof RgbColor ? (RgbColor)abstractColor : null;
            if (rgbColor != null && ProtocolUIKt.isGrayed(rgbColor)) {
                stringBuilder2.append(richStringModel.getText());
                continue;
            }
            if (((CharSequence)stringBuilder2).length() > 0) {
                return new Pair((Object)ProtocolUIKt.toSimpleText($this$splitByGrayColor), (Object)"");
            }
            stringBuilder.append(richStringModel.getText());
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String string2 = stringBuilder2.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        return new Pair((Object)string, (Object)string2);
    }

    public static final void toHtml(@NotNull RichTextModel $this$toHtml, @NotNull StringBuilder stringBuilder, @NotNull Color bgColor) {
        Intrinsics.checkNotNullParameter((Object)$this$toHtml, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)stringBuilder, (String)"stringBuilder");
        Intrinsics.checkNotNullParameter((Object)bgColor, (String)"bgColor");
        for (RichStringModel richStringModel : $this$toHtml.getParts()) {
            FontStyle fontStyle;
            Object object;
            Color color;
            stringBuilder.append("<span style=\"");
            stringBuilder.append("background-color:").append(ColorUtil.toHtmlColor((Color)bgColor)).append(";");
            AbstractColor abstractColor = richStringModel.getForegroundColor();
            Color color2 = color = abstractColor != null ? ColorHostKt.toColor(abstractColor) : null;
            if (color != null) {
                object = ColorUtilsKt.getContrastedForegroundIfNotThemed(bgColor, color, true);
                stringBuilder.append("color:").append(ColorUtil.toHtmlColor((Color)object)).append(';');
            }
            if ((object = richStringModel.getEffectStyle()) != EffectStyle.None) {
                switch (WhenMappings.$EnumSwitchMapping$0[((Enum)object).ordinal()]) {
                    case 1: {
                        stringBuilder.append("text-decoration: underline;");
                        break;
                    }
                    case 2: {
                        stringBuilder.append("text-decoration: underline;");
                        break;
                    }
                    case 3: {
                        stringBuilder.append("text-decoration: line-through;");
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException((EffectStyle)((Object)object) + " is unsupported effect.");
                    }
                }
            }
            if ((fontStyle = richStringModel.getFontStyle()) != FontStyle.Regular) {
                if (fontStyle == FontStyle.Bold) {
                    stringBuilder.append("font-weight: bold;");
                }
                if (fontStyle == FontStyle.Italic) {
                    stringBuilder.append("font-style: italic;");
                }
                if (fontStyle == FontStyle.Strikeout) {
                    stringBuilder.append("text-decoration: line-through;");
                }
                if (fontStyle == FontStyle.Underline) {
                    stringBuilder.append("text-decoration: underline;");
                }
            }
            stringBuilder.append("\">").append(StringUtil.escapeXmlEntities((String)richStringModel.getText())).append("</span>");
        }
    }

    public static final void toHtml(@NotNull RichTextBlockModel $this$toHtml, @NotNull StringBuilder stringBuilder, @NotNull Color bgColor) {
        Intrinsics.checkNotNullParameter((Object)$this$toHtml, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)stringBuilder, (String)"stringBuilder");
        Intrinsics.checkNotNullParameter((Object)bgColor, (String)"bgColor");
        Iterator<RichTextModel> iterator2 = $this$toHtml.getLines().iterator();
        int n = 0;
        while (iterator2.hasNext()) {
            int n2 = n++;
            RichTextModel richTextModel = iterator2.next();
            boolean bl = 1 <= n2 ? n2 < $this$toHtml.getLines().size() : false;
            if (bl) {
                stringBuilder.append("<br/>");
            }
            ProtocolUIKt.toHtml(richTextModel, stringBuilder, bgColor);
        }
    }

    @NotNull
    public static final String toHtml(@NotNull RichTextBlockModel $this$toHtml, @NotNull Color bgColor) {
        Intrinsics.checkNotNullParameter((Object)$this$toHtml, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)bgColor, (String)"bgColor");
        StringBuilder stringBuilder = new StringBuilder();
        ProtocolUIKt.toHtml($this$toHtml, stringBuilder, bgColor);
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[EffectStyle.values().length];
            try {
                nArray[EffectStyle.StraightUnderline.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[EffectStyle.WeavyUnderline.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[EffectStyle.StrikeOut.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

