/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rd.platform.util;

import com.intellij.diagnostic.LoadingState;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.net.HttpConfigurable;
import com.intellij.util.net.ssl.CertificateManager;
import com.intellij.util.proxy.CommonProxy;
import com.jetbrains.rd.platform.util.NetworkUtils;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.ProxySelector;
import java.net.http.HttpClient;
import java.net.http.WebSocket;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.net.ssl.SSLContext;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\t2\u0014\b\u0002\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000bJ\u001c\u0010\u000e\u001a\u00020\u000f2\u0014\b\u0002\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00120\u0011J\u0018\u0010\u0013\u001a\n \u0015*\u0004\u0018\u00010\u00140\u00142\u0006\u0010\u0016\u001a\u00020\u0012H\u0002J\b\u0010\u0017\u001a\u0004\u0018\u00010\u0014J\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/jetbrains/rd/platform/util/NetworkUtils;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "createHttpClientWithGoodDefaults", "Ljava/net/http/HttpClient;", "useProxyAuthenticator", "", "customizer", "Lkotlin/Function1;", "Ljava/net/http/HttpClient$Builder;", "", "createWebSocketBuilderWithRequiredHeaders", "Ljava/net/http/WebSocket$Builder;", "headers", "", "", "getBase64Representation", "", "kotlin.jvm.PlatformType", "input", "getMacAddress", "getSelfExternalAddresses", "", "Ljava/net/InetAddress;", "intellij.rd.platform"})
@SourceDebugExtension(value={"SMAP\nNetworkUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NetworkUtils.kt\ncom/jetbrains/rd/platform/util/NetworkUtils\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,147:1\n1360#2:148\n1446#2,5:149\n766#2:154\n857#2,2:155\n1549#2:157\n1620#2,3:158\n1655#2,8:161\n1045#2:169\n12484#3,2:170\n*S KotlinDebug\n*F\n+ 1 NetworkUtils.kt\ncom/jetbrains/rd/platform/util/NetworkUtils\n*L\n51#1:148\n51#1:149,5\n52#1:154\n52#1:155,2\n53#1:157\n53#1:158,3\n54#1:161,8\n55#1:169\n64#1:170,2\n*E\n"})
public final class NetworkUtils {
    @NotNull
    public static final NetworkUtils INSTANCE = new NetworkUtils();
    @NotNull
    private static final Logger LOG;

    private NetworkUtils() {
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<InetAddress> getSelfExternalAddresses() {
        try {
            void $this$mapTo$iv$iv;
            Iterable $this$filterTo$iv$iv;
            Object it;
            Iterable $this$flatMapTo$iv$iv;
            Enumeration<NetworkInterface> enumeration = NetworkInterface.getNetworkInterfaces();
            Intrinsics.checkNotNullExpressionValue(enumeration, (String)"getNetworkInterfaces(...)");
            ArrayList<NetworkInterface> arrayList = Collections.list(enumeration);
            Intrinsics.checkNotNullExpressionValue(arrayList, (String)"list(...)");
            Iterable $this$flatMap$iv = arrayList;
            boolean $i$f$flatMap = false;
            Iterable iterable = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                it = (NetworkInterface)element$iv$iv;
                boolean bl = false;
                Enumeration<InetAddress> enumeration2 = ((NetworkInterface)it).getInetAddresses();
                Intrinsics.checkNotNullExpressionValue(enumeration2, (String)"getInetAddresses(...)");
                ArrayList<InetAddress> arrayList2 = Collections.list(enumeration2);
                Intrinsics.checkNotNullExpressionValue(arrayList2, (String)"list(...)");
                Iterable list$iv$iv = arrayList2;
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            Iterable $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$filter = false;
            $this$flatMapTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (InetAddress)element$iv$iv;
                boolean bl = false;
                if (!(!((InetAddress)it).isLoopbackAddress() && !((InetAddress)it).isLinkLocalAddress())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (InetAddress)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it);
                collection.add(NetworkUtils.getSelfExternalAddresses$stripIPv6ZoneId((InetAddress)it));
            }
            Iterable $this$distinctBy$iv = (List)destination$iv$iv;
            boolean $i$f$distinctBy = false;
            HashSet<String> set$iv = new HashSet<String>();
            ArrayList list$iv = new ArrayList();
            for (Object e$iv : $this$distinctBy$iv) {
                InetAddress it2 = (InetAddress)e$iv;
                boolean bl = false;
                String key$iv = it2.getHostAddress();
                if (!set$iv.add(key$iv)) continue;
                list$iv.add(e$iv);
            }
            Iterable $this$sortedBy$iv = list$iv;
            boolean $i$f$sortedBy = false;
            return CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    InetAddress it = (InetAddress)a;
                    boolean bl = false;
                    Comparable comparable = (Comparable)((Object)it.getHostAddress());
                    it = (InetAddress)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getHostAddress())));
                }
            });
        }
        catch (Throwable t) {
            LOG.error("Cannot get list of local interfaces", t);
            return CollectionsKt.emptyList();
        }
    }

    @Nullable
    public final byte[] getMacAddress() {
        Enumeration<NetworkInterface> en = NetworkInterface.getNetworkInterfaces();
        if (en != null) {
            while (en.hasMoreElements()) {
                byte[] address;
                NetworkInterface networkInterface = en.nextElement();
                if (networkInterface.isLoopback() || !NetworkUtils.getMacAddress$isGoodAddress(address = networkInterface.getHardwareAddress())) continue;
                return address;
            }
        }
        return null;
    }

    @NotNull
    public final HttpClient createHttpClientWithGoodDefaults(boolean useProxyAuthenticator, @NotNull Function1<? super HttpClient.Builder, Unit> customizer) {
        Intrinsics.checkNotNullParameter(customizer, (String)"customizer");
        HttpClient.Builder httpClientBuilder = HttpClient.newBuilder();
        if (ApplicationManager.getApplication() != null && LoadingState.COMPONENTS_REGISTERED.isOccurred()) {
            httpClientBuilder.sslContext(CertificateManager.Companion.getInstance().getSslContext());
        } else {
            SSLContext sslContext = SSLContext.getInstance("TLSv1.2");
            sslContext.init(null, null, null);
            httpClientBuilder.sslContext(sslContext);
        }
        CommonProxy proxy = CommonProxy.getInstance();
        httpClientBuilder.proxy((ProxySelector)proxy);
        if (useProxyAuthenticator) {
            httpClientBuilder.authenticator(proxy.getAuthenticator());
        }
        Intrinsics.checkNotNull((Object)httpClientBuilder);
        customizer.invoke((Object)httpClientBuilder);
        HttpClient httpClient = httpClientBuilder.build();
        Intrinsics.checkNotNullExpressionValue((Object)httpClient, (String)"build(...)");
        return httpClient;
    }

    public static /* synthetic */ HttpClient createHttpClientWithGoodDefaults$default(NetworkUtils networkUtils, boolean bl, Function1 function1, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        if ((n & 2) != 0) {
            function1 = createHttpClientWithGoodDefaults.1.INSTANCE;
        }
        return networkUtils.createHttpClientWithGoodDefaults(bl, (Function1<? super HttpClient.Builder, Unit>)function1);
    }

    @NotNull
    public final WebSocket.Builder createWebSocketBuilderWithRequiredHeaders(@NotNull Map<String, String> headers) {
        Intrinsics.checkNotNullParameter(headers, (String)"headers");
        boolean useProxyAuthenticator = !headers.containsKey("Authorization");
        HttpClient httpClient = NetworkUtils.createHttpClientWithGoodDefaults$default(this, useProxyAuthenticator, null, 2, null);
        WebSocket.Builder builder = httpClient.newWebSocketBuilder();
        for (Map.Entry<String, String> entry : headers.entrySet()) {
            String headerName = entry.getKey();
            String headerValue = entry.getValue();
            builder.header(headerName, headerValue);
        }
        HttpConfigurable httpSettings = HttpConfigurable.getInstance();
        if (!useProxyAuthenticator && httpSettings.USE_HTTP_PROXY && httpSettings.PROXY_AUTHENTICATION) {
            String login = httpSettings.getProxyLogin();
            String password = httpSettings.getPlainProxyPassword();
            if (login != null && password != null) {
                byte[] base64AuthData = this.getBase64Representation(login + ":" + password);
                Intrinsics.checkNotNull((Object)base64AuthData);
                byte[] byArray = base64AuthData;
                Charset charset = StandardCharsets.ISO_8859_1;
                Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"ISO_8859_1");
                Charset charset2 = charset;
                String encodedAuthString = new String(byArray, charset2);
                builder.header("Proxy-Authorization", "Basic " + encodedAuthString);
            }
        }
        Intrinsics.checkNotNull((Object)builder);
        return builder;
    }

    public static /* synthetic */ WebSocket.Builder createWebSocketBuilderWithRequiredHeaders$default(NetworkUtils networkUtils, Map map, int n, Object object) {
        if ((n & 1) != 0) {
            map = MapsKt.emptyMap();
        }
        return networkUtils.createWebSocketBuilderWithRequiredHeaders(map);
    }

    private final byte[] getBase64Representation(String input) {
        return Base64.getEncoder().encode(StringsKt.encodeToByteArray((String)input));
    }

    /*
     * Enabled aggressive block sorting
     */
    private static final InetAddress getSelfExternalAddresses$stripIPv6ZoneId(InetAddress addr) {
        InetAddress inetAddress;
        if (addr instanceof Inet6Address) {
            String string = ((Inet6Address)addr).getHostAddress();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getHostAddress(...)");
            if (StringsKt.contains$default((CharSequence)string, (CharSequence)"%", (boolean)false, (int)2, null)) {
                LOG.info("Stripping zone id from " + addr + " (scope id " + ((Inet6Address)addr).getScopeId() + ")");
                InetAddress inetAddress2 = Inet6Address.getByAddress(((Inet6Address)addr).getAddress());
                Intrinsics.checkNotNull((Object)inetAddress2);
                inetAddress = inetAddress2;
                return inetAddress;
            }
        }
        inetAddress = addr;
        return inetAddress;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean getMacAddress$isGoodAddress(byte[] address) {
        if (address == null) return false;
        if (address.length != 6) return false;
        byte[] $this$any$iv = address;
        boolean $i$f$any = false;
        int n = 0;
        int n2 = $this$any$iv.length;
        while (n < n2) {
            byte element$iv;
            byte it = element$iv = $this$any$iv[n];
            boolean bl = false;
            if (it != 0) {
                return true;
            }
            boolean bl2 = false;
            if (bl2) {
                return true;
            }
            ++n;
        }
        return false;
    }

    static {
        Logger logger = Logger.getInstance(INSTANCE.getClass());
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }
}

