/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rd.platform.diagnostics;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.module.kotlin.ExtensionsKt;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.util.UriUtilKt;
import com.intellij.util.io.HttpRequests;
import com.intellij.util.net.NetUtils;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URLConnection;
import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00062\b\u0010\f\u001a\u0004\u0018\u00010\rR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rd/platform/diagnostics/SupportInformationUploader;", "", "()V", "objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "uploadsServiceUrl", "", "uploadFile", "Ljava/net/URI;", "file", "Ljava/io/File;", "fileName", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "intellij.rd.platform"})
@SourceDebugExtension(value={"SMAP\nSupportInformationUploader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SupportInformationUploader.kt\ncom/jetbrains/rd/platform/diagnostics/SupportInformationUploader\n+ 2 Iterators.kt\nkotlin/collections/CollectionsKt__IteratorsKt\n*L\n1#1,62:1\n32#2,2:63\n*S KotlinDebug\n*F\n+ 1 SupportInformationUploader.kt\ncom/jetbrains/rd/platform/diagnostics/SupportInformationUploader\n*L\n45#1:63,2\n*E\n"})
public final class SupportInformationUploader {
    @NotNull
    public static final SupportInformationUploader INSTANCE = new SupportInformationUploader();
    @NotNull
    private static final String uploadsServiceUrl = "https://uploads.jetbrains.com";
    @NotNull
    private static final ObjectMapper objectMapper = ExtensionsKt.jacksonObjectMapper$default(null, (int)1, null);

    private SupportInformationUploader() {
    }

    @NotNull
    public final URI uploadFile(@NotNull File file, @NotNull String fileName, @Nullable ProgressIndicator indicator) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        Object object = new char[]{'/'};
        String string = StringsKt.trimEnd((String)uploadsServiceUrl, (char[])object);
        object = (ObjectNode)HttpRequests.post((String)(string + "/sign"), (String)"application/json; charset=utf-8").accept("application/json; charset=utf-8").connect(arg_0 -> SupportInformationUploader.j(fileName, arg_0));
        String string2 = object.get("url").asText();
        String string3 = object.get("folderName").asText();
        JsonNode jsonNode = object.get("headers");
        Intrinsics.checkNotNull((Object)jsonNode, (String)"null cannot be cast to non-null type com.fasterxml.jackson.databind.node.ObjectNode");
        ObjectNode objectNode = (ObjectNode)jsonNode;
        HttpRequests.put((String)string2, (String)"application/octet-stream").productNameAsUserAgent().tuner(arg_0 -> SupportInformationUploader.j(objectNode, arg_0)).connect(arg_0 -> SupportInformationUploader.j(file, indicator, arg_0));
        return UriUtilKt.withFragment((URI)new URI(string + "/browse"), (String)string3);
    }

    private static final ObjectNode j(String string, HttpRequests.Request request2) {
        ObjectNode objectNode;
        Intrinsics.checkNotNullParameter((Object)string, (String)"$fileName");
        Intrinsics.checkNotNullParameter((Object)request2, (String)"request");
        ObjectNode objectNode2 = objectNode = JsonNodeFactory.instance.objectNode();
        boolean bl = false;
        objectNode2.put("filename", string);
        objectNode2.put("method", "put");
        objectNode2.put("contentType", "application/octet-stream");
        ObjectNode objectNode3 = objectNode;
        request2.write(objectNode3.toPrettyString());
        JsonNode jsonNode = objectMapper.readTree((Reader)request2.getReader());
        Intrinsics.checkNotNull((Object)jsonNode, (String)"null cannot be cast to non-null type com.fasterxml.jackson.databind.node.ObjectNode");
        return (ObjectNode)jsonNode;
    }

    private static final void j(ObjectNode objectNode, URLConnection uRLConnection) {
        Intrinsics.checkNotNullParameter((Object)objectNode, (String)"$headers");
        Intrinsics.checkNotNullParameter((Object)uRLConnection, (String)"urlConnection");
        Iterator iterator2 = objectNode.fields();
        Intrinsics.checkNotNullExpressionValue((Object)iterator2, (String)"fields(...)");
        Iterator iterator3 = iterator2;
        boolean bl = false;
        Iterator iterator4 = iterator3;
        while (iterator4.hasNext()) {
            Object e = iterator4.next();
            Map.Entry entry = (Map.Entry)e;
            boolean bl2 = false;
            uRLConnection.addRequestProperty((String)entry.getKey(), ((JsonNode)entry.getValue()).asText());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Long j(File file, ProgressIndicator progressIndicator, HttpRequests.Request request2) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)file, (String)"$file");
        Intrinsics.checkNotNullParameter((Object)request2, (String)"it");
        URLConnection uRLConnection = request2.getConnection();
        Intrinsics.checkNotNull((Object)uRLConnection, (String)"null cannot be cast to non-null type java.net.HttpURLConnection");
        HttpURLConnection httpURLConnection = (HttpURLConnection)uRLConnection;
        int n = (int)file.length();
        httpURLConnection.setFixedLengthStreamingMode(n);
        Closeable closeable = httpURLConnection.getOutputStream();
        Throwable throwable = null;
        try {
            long l;
            object = (OutputStream)closeable;
            boolean bl = false;
            Closeable closeable2 = new FileInputStream(file);
            int n2 = 65536;
            closeable2 = closeable2 instanceof BufferedInputStream ? (BufferedInputStream)closeable2 : new BufferedInputStream((InputStream)closeable2, n2);
            Throwable throwable2 = null;
            try {
                BufferedInputStream bufferedInputStream = (BufferedInputStream)closeable2;
                boolean bl2 = false;
                l = NetUtils.copyStreamContent((ProgressIndicator)progressIndicator, (InputStream)bufferedInputStream, (OutputStream)object, (long)n);
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
            }
            object = l;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return object;
    }
}

