/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rd.platform.diagnostics;

import com.intellij.openapi.diagnostic.Logger;
import com.jetbrains.rd.platform.diagnostics.IMetricConsumer;
import com.jetbrains.rd.platform.diagnostics.StructuredLoggingKt;
import com.jetbrains.rd.util.lifetime.Lifetime;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u001a\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u000e2\b\u0010\u0014\u001a\u0004\u0018\u00010\u0007H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0015"}, d2={"Lcom/jetbrains/rd/platform/diagnostics/SumConsumer;", "Lcom/jetbrains/rd/platform/diagnostics/IMetricConsumer;", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "watchdogName", "", "(Lcom/jetbrains/rd/util/lifetime/Lifetime;Lcom/intellij/openapi/diagnostic/Logger;Ljava/lang/String;)V", "getLogger", "()Lcom/intellij/openapi/diagnostic/Logger;", "n", "", "sum", "", "getWatchdogName", "()Ljava/lang/String;", "consumeValue", "", "value", "comment", "intellij.rd.platform"})
final class SumConsumer
implements IMetricConsumer {
    @NotNull
    private final Logger logger;
    @NotNull
    private final String watchdogName;
    private double sum;
    private int n;

    public SumConsumer(@NotNull Lifetime lifetime, @NotNull Logger logger, @NotNull String watchdogName) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)watchdogName, (String)"watchdogName");
        this.logger = logger;
        this.watchdogName = watchdogName;
        lifetime.onTermination((Function0)new Function0<Unit>(){

            public final void invoke() {
                StructuredLoggingKt.logMeasuredTime$default(this.getLogger(), this.getWatchdogName() + ".sum", (long)sum, null, 4, null);
            }
        });
    }

    @NotNull
    public final Logger getLogger() {
        return this.logger;
    }

    @NotNull
    public final String getWatchdogName() {
        return this.watchdogName;
    }

    @Override
    public void consumeValue(double value2, @Nullable String comment) {
        this.sum += value2;
        if (this.logger.isTraceEnabled()) {
            int n = this.n;
            this.n = n + 1;
            StructuredLoggingKt.logMeasuredTime(this.logger, this.watchdogName + ".N" + n, (long)value2, comment);
        }
    }
}

