/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rd.platform.diagnostics;

import com.intellij.openapi.diagnostic.Logger;
import com.jetbrains.rd.platform.diagnostics.IMetricConsumer;
import com.jetbrains.rd.platform.diagnostics.MetricUnit;
import com.jetbrains.rd.platform.diagnostics.StructuredLoggingKt;
import com.jetbrains.rd.platform.util.estimators.P2QuantileEstimator;
import com.jetbrains.rd.util.lifetime.Lifetime;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0002\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u001a\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u000b2\b\u0010\u001a\u001a\u0004\u0018\u00010\tH\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006\u001c"}, d2={"Lcom/jetbrains/rd/platform/diagnostics/QuantileEstimatorConsumer;", "Lcom/jetbrains/rd/platform/diagnostics/IMetricConsumer;", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "metricUnit", "Lcom/jetbrains/rd/platform/diagnostics/MetricUnit;", "watchdogName", "", "quantile", "", "(Lcom/jetbrains/rd/util/lifetime/Lifetime;Lcom/intellij/openapi/diagnostic/Logger;Lcom/jetbrains/rd/platform/diagnostics/MetricUnit;Ljava/lang/String;D)V", "getLogger", "()Lcom/intellij/openapi/diagnostic/Logger;", "getMetricUnit", "()Lcom/jetbrains/rd/platform/diagnostics/MetricUnit;", "myEstimator", "Lcom/jetbrains/rd/platform/util/estimators/P2QuantileEstimator;", "getQuantile", "()D", "getWatchdogName", "()Ljava/lang/String;", "consumeValue", "", "value", "comment", "Companion", "intellij.rd.platform"})
final class QuantileEstimatorConsumer
implements IMetricConsumer {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final Logger logger;
    @NotNull
    private final MetricUnit metricUnit;
    @NotNull
    private final String watchdogName;
    private final double quantile;
    @NotNull
    private final P2QuantileEstimator myEstimator;
    @NotNull
    private static final DecimalFormat format;

    public QuantileEstimatorConsumer(@NotNull Lifetime lifetime, @NotNull Logger logger, @NotNull MetricUnit metricUnit, @NotNull String watchdogName, double quantile) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)((Object)metricUnit), (String)"metricUnit");
        Intrinsics.checkNotNullParameter((Object)watchdogName, (String)"watchdogName");
        this.logger = logger;
        this.metricUnit = metricUnit;
        this.watchdogName = watchdogName;
        this.quantile = quantile;
        if (this.quantile < 0.0 || this.quantile > 1.0) {
            throw new IllegalArgumentException("quantile: " + this.quantile + " must be greater than or equal to 0 or less than or equal to 1");
        }
        this.myEstimator = new P2QuantileEstimator(this.quantile);
        lifetime.onTermination((Function0)new Function0<Unit>(){

            public final void invoke() {
                if (myEstimator.isEmpty()) {
                    return;
                }
                double d = myEstimator.getQuantile();
                String string = format.format(this.getQuantile() * (double)100);
                StructuredLoggingKt.logMeasurement$default(this.getLogger(), this.getWatchdogName() + ".P" + string, (long)d, this.getMetricUnit(), null, 8, null);
            }
        });
    }

    @NotNull
    public final Logger getLogger() {
        return this.logger;
    }

    @NotNull
    public final MetricUnit getMetricUnit() {
        return this.metricUnit;
    }

    @NotNull
    public final String getWatchdogName() {
        return this.watchdogName;
    }

    public final double getQuantile() {
        return this.quantile;
    }

    @Override
    public void consumeValue(double value2, @Nullable String comment) {
        this.myEstimator.addValue(value2);
    }

    static {
        DecimalFormatSymbols decimalFormatSymbols;
        Companion = new Companion(null);
        DecimalFormatSymbols decimalFormatSymbols2 = decimalFormatSymbols = new DecimalFormatSymbols();
        String string = "0.#";
        boolean bl = false;
        decimalFormatSymbols2.setDecimalSeparator('_');
        DecimalFormatSymbols decimalFormatSymbols3 = decimalFormatSymbols;
        String string2 = string;
        format = new DecimalFormat(string2, decimalFormatSymbols3);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/jetbrains/rd/platform/diagnostics/QuantileEstimatorConsumer$Companion;", "", "()V", "format", "Ljava/text/DecimalFormat;", "intellij.rd.platform"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

