/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rd.platform.diagnostics;

import com.intellij.openapi.diagnostic.Logger;
import com.jetbrains.rd.platform.diagnostics.MetricUnit;
import com.jetbrains.rd.platform.diagnostics.PerformanceAggregatorBase;
import com.jetbrains.rd.platform.diagnostics.TimeLimitOnIntervalConsumer;
import com.jetbrains.rd.util.lifetime.Lifetime;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ1\u0010\t\u001a\u0002H\n\"\u0004\b\u0000\u0010\n2\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\u00072\f\u0010\f\u001a\b\u0012\u0004\u0012\u0002H\n0\rH\u0086\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u000eJ\u0016\u0010\u000f\u001a\u00020\u00002\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006\u0013"}, d2={"Lcom/jetbrains/rd/platform/diagnostics/HotspotWatchdog;", "Lcom/jetbrains/rd/platform/diagnostics/PerformanceAggregatorBase;", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "watchdogName", "", "(Lcom/jetbrains/rd/util/lifetime/Lifetime;Lcom/intellij/openapi/diagnostic/Logger;Ljava/lang/String;)V", "measure", "T", "comment", "action", "Lkotlin/Function0;", "(Ljava/lang/String;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "withTimeLimitOnInterval", "timeLimit", "Ljava/time/Duration;", "observationInterval", "intellij.rd.platform"})
public final class HotspotWatchdog
extends PerformanceAggregatorBase<HotspotWatchdog> {
    public HotspotWatchdog(@NotNull Lifetime lifetime, @NotNull Logger logger, @NotNull String watchdogName) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)watchdogName, (String)"watchdogName");
        super(lifetime, logger, MetricUnit.Millisecond, watchdogName);
    }

    @NotNull
    public final HotspotWatchdog withTimeLimitOnInterval(@NotNull Duration timeLimit, @NotNull Duration observationInterval) {
        Intrinsics.checkNotNullParameter((Object)timeLimit, (String)"timeLimit");
        Intrinsics.checkNotNullParameter((Object)observationInterval, (String)"observationInterval");
        return (HotspotWatchdog)this.addConsumer(new TimeLimitOnIntervalConsumer(this.getLogger(), this.getWatchdogName(), timeLimit, observationInterval));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <T> T measure(@Nullable String comment, @NotNull Function0<? extends T> action3) {
        Object object;
        Intrinsics.checkNotNullParameter(action3, (String)"action");
        boolean bl = false;
        if (this.checkPolicy()) {
            Object object2;
            long l = System.nanoTime();
            try {
                object2 = action3.invoke();
            }
            finally {
                InlineMarker.finallyStart((int)1);
                this.addValue(TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - l), comment);
                InlineMarker.finallyEnd((int)1);
            }
            object = object2;
        } else {
            object = action3.invoke();
        }
        return (T)object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static /* synthetic */ Object measure$default(HotspotWatchdog $this, String comment, Function0 action3, int n, Object object) {
        Object object2;
        if ((n & 1) != 0) {
            comment = null;
        }
        Intrinsics.checkNotNullParameter((Object)action3, (String)"action");
        boolean $i$f$measure = false;
        if ($this.checkPolicy()) {
            Object object3;
            long start = System.nanoTime();
            try {
                object3 = action3.invoke();
            }
            finally {
                InlineMarker.finallyStart((int)1);
                $this.addValue(TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - start), comment);
                InlineMarker.finallyEnd((int)1);
            }
            object2 = object3;
        } else {
            object2 = action3.invoke();
        }
        return object2;
    }
}

