/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rd.lang;

import com.intellij.lang.Language;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.jetbrains.rd.ide.model.IconModel;
import com.jetbrains.rd.ide.model.RdFileType;
import com.jetbrains.rd.ide.model.RdLanguage;
import com.jetbrains.rd.lang.ProtocolLanguageAssociationBean;
import com.jetbrains.rd.lang.ProtocolLanguageManager;
import com.jetbrains.rd.ui.icons.UtilKt;
import com.jetbrains.rd.util.PlatformDependentKt;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 !2\u00020\u0001:\u0001!B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0018\u001a\u00020\rH\u0016J\u0010\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0012\u0010\u001c\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u001d\u001a\u00020\bH\u0016J\u0010\u0010\u001e\u001a\u00020\r2\u0006\u0010\u001f\u001a\u00020\u0010H\u0016J\u0010\u0010 \u001a\u00020\b2\u0006\u0010\u001a\u001a\u00020\u001bH\u0016R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u0006\u001a\u001e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007j\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t`\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u000e\u001a\u001e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\b0\u0007j\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\b`\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00100\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/jetbrains/rd/lang/ProtocolLanguageManagerImpl;", "Lcom/jetbrains/rd/lang/ProtocolLanguageManager;", "()V", "EP_NAME", "Lcom/intellij/openapi/extensions/ExtensionPointName;", "Lcom/jetbrains/rd/lang/ProtocolLanguageAssociationBean;", "backendToFrontendLanguageCache", "Ljava/util/HashMap;", "Lcom/jetbrains/rd/ide/model/RdLanguage;", "", "Lkotlin/collections/HashMap;", "fileTypeToProtocolCache", "", "Lcom/jetbrains/rd/ide/model/RdFileType;", "frontendToBackendLanguageCache", "protocolToFileTypeCache", "Lcom/intellij/openapi/fileTypes/FileType;", "addAssociation", "", "backendLanguageId", "frontendLanguageId", "default", "", "fromRdFileType", "rdFileType", "isProtocolLanguage", "language", "Lcom/intellij/lang/Language;", "toIdeaLanguage", "rdLanguage", "toRdFileType", "fileType", "toRdLanguage", "Companion", "intellij.rd.platform"})
@SourceDebugExtension(value={"SMAP\nProtocolLanguageManagerImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProtocolLanguageManagerImpl.kt\ncom/jetbrains/rd/lang/ProtocolLanguageManagerImpl\n+ 2 util.kt\ncom/intellij/util/containers/UtilKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,112:1\n194#2,9:113\n1#3:122\n13#4:123\n13#4:124\n*S KotlinDebug\n*F\n+ 1 ProtocolLanguageManagerImpl.kt\ncom/jetbrains/rd/lang/ProtocolLanguageManagerImpl\n*L\n27#1:113,9\n79#1:123\n17#1:124\n*E\n"})
public final class ProtocolLanguageManagerImpl
implements ProtocolLanguageManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ExtensionPointName<ProtocolLanguageAssociationBean> EP_NAME = ExtensionPointName.Companion.create("com.intellij.rd.languageAssociation");
    @NotNull
    private final HashMap<RdLanguage, String> backendToFrontendLanguageCache = new HashMap();
    @NotNull
    private final HashMap<String, RdLanguage> frontendToBackendLanguageCache = new HashMap();
    @NotNull
    private final Map<String, RdFileType> fileTypeToProtocolCache = PlatformDependentKt.concurrentMapOf();
    @NotNull
    private final Map<RdFileType, FileType> protocolToFileTypeCache = PlatformDependentKt.concurrentMapOf();
    @NotNull
    private static final Logger LOG;

    public ProtocolLanguageManagerImpl() {
        Collection collection = this.EP_NAME.getExtensionList();
        Logger logger = LOG;
        boolean bl = false;
        for (Object e : collection) {
            try {
                ProtocolLanguageAssociationBean protocolLanguageAssociationBean = (ProtocolLanguageAssociationBean)e;
                boolean bl2 = false;
                String string = protocolLanguageAssociationBean.getBackendLanguage();
                Intrinsics.checkNotNull((Object)string);
                String string2 = protocolLanguageAssociationBean.getFrontendLanguage();
                Intrinsics.checkNotNull((Object)string2);
                this.addAssociation(string, string2, protocolLanguageAssociationBean.isDefault());
            }
            catch (Throwable throwable) {
                logger.error(throwable);
            }
        }
    }

    @Override
    @NotNull
    public RdLanguage toRdLanguage(@NotNull Language language) {
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        RdLanguage rdLanguage = this.frontendToBackendLanguageCache.get(language.getID());
        if (rdLanguage == null) {
            String string = language.getID();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getID(...)");
            rdLanguage = new RdLanguage(string);
        }
        return rdLanguage;
    }

    @Override
    @Nullable
    public FileType fromRdFileType(@NotNull RdFileType rdFileType) {
        Intrinsics.checkNotNullParameter((Object)rdFileType, (String)"rdFileType");
        FileType fileType = this.protocolToFileTypeCache.get(rdFileType);
        if (fileType != null) {
            return fileType;
        }
        FileType fileType2 = FileTypeManager.getInstance().findFileTypeByName(rdFileType.getName());
        if (fileType2 != null) {
            this.protocolToFileTypeCache.put(rdFileType, fileType2);
            Map<String, RdFileType> map = this.fileTypeToProtocolCache;
            String string = fileType2.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            map.put(string, rdFileType);
        }
        return fileType2;
    }

    @Override
    @NotNull
    public RdFileType toRdFileType(@NotNull FileType fileType) {
        IconModel iconModel;
        Icon icon2;
        RdLanguage rdLanguage;
        RdFileType rdFileType;
        Intrinsics.checkNotNullParameter((Object)fileType, (String)"fileType");
        RdFileType rdFileType2 = rdFileType = this.fileTypeToProtocolCache.get(fileType.getName());
        if (rdFileType2 != null) {
            return rdFileType2;
        }
        LanguageFileType languageFileType = fileType instanceof LanguageFileType ? (LanguageFileType)fileType : null;
        if (languageFileType != null && (languageFileType = languageFileType.getLanguage()) != null) {
            LanguageFileType languageFileType2 = languageFileType;
            boolean bl = false;
            rdLanguage = this.toRdLanguage((Language)languageFileType2);
        } else {
            rdLanguage = null;
        }
        RdLanguage rdLanguage2 = rdLanguage;
        FileType fileType2 = fileType;
        boolean bl = false;
        String string = fileType2.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        String string2 = fileType2.getDescription();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getDescription(...)");
        String string3 = fileType2.getDefaultExtension();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getDefaultExtension(...)");
        Icon icon3 = icon2 = fileType2.getIcon();
        if (icon3 != null) {
            Intrinsics.checkNotNull((Object)icon3);
            iconModel = UtilKt.toModel(icon2);
        } else {
            iconModel = null;
        }
        RdFileType rdFileType3 = new RdFileType(string, string2, string3, iconModel, fileType2.isBinary(), fileType2.isReadOnly(), rdLanguage2);
        this.protocolToFileTypeCache.put(rdFileType3, fileType);
        Map<String, RdFileType> map = this.fileTypeToProtocolCache;
        String string4 = fileType.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getName(...)");
        map.put(string4, rdFileType3);
        return rdFileType3;
    }

    @Override
    public boolean isProtocolLanguage(@NotNull Language language) {
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        return this.frontendToBackendLanguageCache.containsKey(language.getID());
    }

    @Override
    @Nullable
    public Language toIdeaLanguage(@NotNull RdLanguage rdLanguage) {
        Object v2;
        String string;
        block5: {
            Intrinsics.checkNotNullParameter((Object)rdLanguage, (String)"rdLanguage");
            string = this.backendToFrontendLanguageCache.get(rdLanguage);
            if (string != null) {
                Language language = Language.findLanguageByID((String)string);
                if (language == null) {
                    boolean bl = false;
                    Logger logger = Logger.getInstance(ProtocolLanguageManager.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                    logger.error("Unable to find '" + string + "'. Possibly it's incorrect or com.intellij.lang.Language is not initialized");
                }
                return language;
            }
            Collection collection = Language.getRegisteredLanguages();
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getRegisteredLanguages(...)");
            Iterable iterable = collection;
            for (Object t : iterable) {
                Language language = (Language)t;
                boolean bl = false;
                if (!StringsKt.equals((String)language.getID(), (String)rdLanguage.getId(), (boolean)true)) continue;
                v2 = t;
                break block5;
            }
            v2 = null;
        }
        Language language = v2;
        if (language == null) {
            return null;
        }
        Language language2 = language;
        string = language2.getID();
        ((Map)this.backendToFrontendLanguageCache).put(rdLanguage, string);
        if (!this.frontendToBackendLanguageCache.containsKey(string)) {
            ((Map)this.frontendToBackendLanguageCache).put(string, rdLanguage);
        }
        return language2;
    }

    @Override
    public void addAssociation(@NotNull String backendLanguageId, @NotNull String frontendLanguageId, boolean bl) {
        Intrinsics.checkNotNullParameter((Object)backendLanguageId, (String)"backendLanguageId");
        Intrinsics.checkNotNullParameter((Object)frontendLanguageId, (String)"frontendLanguageId");
        if (bl) {
            RdLanguage rdLanguage = new RdLanguage(backendLanguageId);
            ((Map)this.frontendToBackendLanguageCache).put(frontendLanguageId, rdLanguage);
            ((Map)this.backendToFrontendLanguageCache).put(rdLanguage, frontendLanguageId);
            return;
        }
        RdLanguage rdLanguage = new RdLanguage(backendLanguageId);
        if (!this.frontendToBackendLanguageCache.containsKey(frontendLanguageId)) {
            ((Map)this.frontendToBackendLanguageCache).put(frontendLanguageId, rdLanguage);
        }
        if (!this.backendToFrontendLanguageCache.containsKey(rdLanguage)) {
            ((Map)this.backendToFrontendLanguageCache).put(rdLanguage, frontendLanguageId);
        }
    }

    static {
        boolean bl = false;
        Logger logger = Logger.getInstance(ProtocolLanguageManager.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/jetbrains/rd/lang/ProtocolLanguageManagerImpl$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.rd.platform"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

