/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rd.ide.editor;

import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.CaretState;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtilEx;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.impl.FoldingModelImpl;
import com.intellij.openapi.util.ProperTextRange;
import com.intellij.openapi.util.Segment;
import com.jetbrains.rd.ide.document.DocumentExKt;
import com.jetbrains.rd.ide.editor.CaretRestoreHelper;
import com.jetbrains.rd.ide.editor.UtilKt;
import com.jetbrains.rd.ide.model.DocOffsetAndVirtualModel;
import com.jetbrains.rd.ide.model.RdCaret;
import com.jetbrains.rd.ide.model.RdCaretId;
import com.jetbrains.rd.ide.model.RdCaretState;
import com.jetbrains.rd.ide.model.RdCaretStateChange;
import com.jetbrains.rd.ide.model.RdCaretStateSnapshot;
import com.jetbrains.rd.ide.model.RdCaretStateSnapshotBase;
import com.jetbrains.rd.ide.model.RdDocumentChange;
import com.jetbrains.rd.ide.model.RdFileEditorCompositeId;
import com.jetbrains.rd.ide.model.RdFileEditorId;
import com.jetbrains.rd.ide.model.RdSelection;
import com.jetbrains.rd.ide.model.RdSelectionChangeBase;
import com.jetbrains.rd.ide.model.ScrollKind;
import com.jetbrains.rd.ide.model.TextControlId;
import com.jetbrains.rd.ide.model.TextControlLocation;
import com.jetbrains.rd.ide.model.VisibleRange;
import com.jetbrains.rd.platform.util.UserDataHolderKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference1;
import kotlin.jvm.internal.MutablePropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.properties.ReadWriteProperty;
import kotlin.reflect.KProperty;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u009c\u0001\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\"\u0010\n\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\b\u0002\u0010\u000f\u001a\u00020\u0010\u001a\"\u0010\n\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\r\u001a\u00020\u000e2\b\b\u0002\u0010\u000f\u001a\u00020\u0010\u001a\u001e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u000e\u001a\u0016\u0010\u0018\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\r\u001a\u00020\u000e\u001a\u001e\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\u001f\u001a\u000e\u0010 \u001a\u00020!2\u0006\u0010\r\u001a\u00020\u000e\u001a\r\u0010\"\u001a\u00020\u001c*\u00020#H\u0086\u0002\u001a\u000f\u0010\"\u001a\u00020\u001c*\u0004\u0018\u00010\u001fH\u0086\u0002\u001a\r\u0010$\u001a\u00020\u001c*\u00020#H\u0086\u0002\u001a\u000f\u0010$\u001a\u00020\u001c*\u0004\u0018\u00010\u001fH\u0086\u0002\u001a\n\u0010%\u001a\u00020&*\u00020'\u001a\n\u0010(\u001a\u00020\u0012*\u00020\u0003\u001a\n\u0010)\u001a\u00020\u001a*\u00020*\u001a\u0010\u0010+\u001a\b\u0012\u0004\u0012\u00020\u00120,*\u00020*\u001a-\u0010-\u001a\u00020\f*\u00020\u00032\u0006\u0010.\u001a\u00020\u001c2\u0006\u0010/\u001a\u00020\u00102\u000e\b\u0004\u00100\u001a\b\u0012\u0004\u0012\u00020\u001f01H\u0082\b\u001a\u0012\u00102\u001a\u00020\u001f*\u00020\u000e2\u0006\u00103\u001a\u00020\f\u001a\"\u00102\u001a\u00020\u001f*\u00020\u000e2\u0006\u0010.\u001a\u00020\u001c2\u0006\u00104\u001a\u00020\u001c2\u0006\u00105\u001a\u00020\u0010\u001a\n\u00106\u001a\u00020\u001a*\u000207\u001a\u0014\u00108\u001a\u0004\u0018\u00010\u0003*\u00020*2\u0006\u0010\u0002\u001a\u00020\u0001\u001a\n\u00109\u001a\u00020:*\u00020:\u001a\n\u00109\u001a\u000207*\u000207\u001a\n\u0010;\u001a\u00020&*\u00020\f\u001a\n\u0010;\u001a\u00020&*\u00020\u0012\u001a\n\u0010;\u001a\u00020&*\u00020\u0001\u001a\n\u0010;\u001a\u00020&*\u00020\u001a\u001a\n\u0010;\u001a\u00020&*\u00020<\u001a\n\u0010;\u001a\u00020&*\u00020=\u001a\n\u0010;\u001a\u00020&*\u00020\u0016\u001a\n\u0010;\u001a\u00020&*\u00020'\u001a\n\u0010>\u001a\u00020?*\u00020@\"3\u0010\u0002\u001a\u0004\u0018\u00010\u0001*\u00020\u00032\b\u0010\u0000\u001a\u0004\u0018\u00010\u00018F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\b\u0010\t\u001a\u0004\b\u0004\u0010\u0005\"\u0004\b\u0006\u0010\u0007\u00a8\u0006A"}, d2={"<set-?>", "Lcom/jetbrains/rd/ide/model/RdCaretId;", "id", "Lcom/intellij/openapi/editor/Caret;", "getId", "(Lcom/intellij/openapi/editor/Caret;)Lcom/jetbrains/rd/ide/model/RdCaretId;", "setId", "(Lcom/intellij/openapi/editor/Caret;Lcom/jetbrains/rd/ide/model/RdCaretId;)V", "id$delegate", "Lkotlin/properties/ReadWriteProperty;", "addCaretTo", "positionModel", "Lcom/jetbrains/rd/ide/model/DocOffsetAndVirtualModel;", "editor", "Lcom/intellij/openapi/editor/Editor;", "isPrimary", "", "caret", "Lcom/jetbrains/rd/ide/model/RdCaret;", "applySelectionTo", "", "selectionModel", "Lcom/jetbrains/rd/ide/model/RdSelection;", "caretToSync", "applyStateTo", "newState", "Lcom/jetbrains/rd/ide/model/RdCaretState;", "calcVirtualDelta", "", "caretOffset", "visualPosition", "Lcom/intellij/openapi/editor/VisualPosition;", "calculateVisibleRange", "Lcom/jetbrains/rd/ide/model/VisibleRange;", "component1", "Lcom/intellij/openapi/editor/LogicalPosition;", "component2", "createLogCategory", "", "Lcom/jetbrains/rd/ide/model/TextControlId;", "createModelCaret", "createModelCaretState", "Lcom/intellij/openapi/editor/CaretModel;", "createModelCarets", "", "j", "offset", "ignoreVirtualDelta", "calcVisualPosition", "Lkotlin/Function0;", "docOffsetAndVirtualToVisualPosition", "pos", "virtualDelta", "logicalLeansForward", "getActualState", "Lcom/jetbrains/rd/ide/model/RdSelectionChangeBase;", "getCaretById", "reverse", "Lcom/jetbrains/rd/ide/model/RdDocumentChange;", "toDebugString", "Lcom/jetbrains/rd/ide/model/RdFileEditorCompositeId;", "Lcom/jetbrains/rd/ide/model/RdFileEditorId;", "toScrollType", "Lcom/intellij/openapi/editor/ScrollType;", "Lcom/jetbrains/rd/ide/model/ScrollKind;", "intellij.rd.platform"})
@SourceDebugExtension(value={"SMAP\nUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Util.kt\ncom/jetbrains/rd/ide/editor/UtilKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,216:1\n163#1,6:224\n163#1,6:230\n163#1,6:236\n288#2,2:217\n1045#2:219\n1549#2:220\n1620#2,3:221\n1549#2:242\n1620#2,3:243\n1549#2:246\n1620#2,3:247\n*S KotlinDebug\n*F\n+ 1 Util.kt\ncom/jetbrains/rd/ide/editor/UtilKt\n*L\n136#1:224,6\n137#1:230,6\n138#1:236,6\n11#1:217,2\n67#1:219\n73#1:220\n73#1:221,3\n144#1:242\n144#1:243,3\n195#1:246\n195#1:247,3\n*E\n"})
public final class UtilKt {
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private static final ReadWriteProperty id$delegate;

    @Nullable
    public static final Caret getCaretById(@NotNull CaretModel $this$getCaretById, @NotNull RdCaretId id) {
        Object v1;
        block1: {
            Intrinsics.checkNotNullParameter((Object)$this$getCaretById, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            List list2 = $this$getCaretById.getAllCarets();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getAllCarets(...)");
            Iterable iterable = list2;
            boolean bl = false;
            for (Object t : iterable) {
                Caret caret = (Caret)t;
                boolean bl2 = false;
                Intrinsics.checkNotNull((Object)caret);
                if (!Intrinsics.areEqual((Object)UtilKt.getId(caret), (Object)id)) continue;
                v1 = t;
                break block1;
            }
            v1 = null;
        }
        return v1;
    }

    @Nullable
    public static final RdCaretId getId(@NotNull Caret $this$id) {
        Intrinsics.checkNotNullParameter((Object)$this$id, (String)"<this>");
        return (RdCaretId)id$delegate.getValue((Object)$this$id, $$delegatedProperties[0]);
    }

    public static final void setId(@NotNull Caret $this$id, @Nullable RdCaretId rdCaretId) {
        Intrinsics.checkNotNullParameter((Object)$this$id, (String)"<this>");
        id$delegate.setValue((Object)$this$id, $$delegatedProperties[0], (Object)rdCaretId);
    }

    @NotNull
    public static final ScrollType toScrollType(@NotNull ScrollKind $this$toScrollType) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$toScrollType), (String)"<this>");
        return switch (WhenMappings.$EnumSwitchMapping$0[$this$toScrollType.ordinal()]) {
            case 1 -> ScrollType.MAKE_VISIBLE;
            case 2 -> ScrollType.RELATIVE;
            case 3 -> ScrollType.CENTER;
            case 4 -> ScrollType.CENTER_DOWN;
            case 5 -> ScrollType.CENTER_UP;
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    @NotNull
    public static final VisualPosition docOffsetAndVirtualToVisualPosition(@NotNull Editor $this$docOffsetAndVirtualToVisualPosition, @NotNull DocOffsetAndVirtualModel pos) {
        Intrinsics.checkNotNullParameter((Object)$this$docOffsetAndVirtualToVisualPosition, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Boolean bl = pos.getLogicalLeansForward();
        return UtilKt.docOffsetAndVirtualToVisualPosition($this$docOffsetAndVirtualToVisualPosition, pos.getOffset(), pos.getVirtualDelta(), bl != null ? bl : false);
    }

    @NotNull
    public static final VisualPosition docOffsetAndVirtualToVisualPosition(@NotNull Editor $this$docOffsetAndVirtualToVisualPosition, int offset, int virtualDelta, boolean logicalLeansForward) {
        Intrinsics.checkNotNullParameter((Object)$this$docOffsetAndVirtualToVisualPosition, (String)"<this>");
        if (!(virtualDelta >= 0)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        VisualPosition visualPosition = $this$docOffsetAndVirtualToVisualPosition.offsetToVisualPosition(offset, logicalLeansForward, false);
        Intrinsics.checkNotNullExpressionValue((Object)visualPosition, (String)"offsetToVisualPosition(...)");
        VisualPosition visualPosition2 = visualPosition;
        return virtualDelta == 0 ? visualPosition2 : new VisualPosition(visualPosition2.line, visualPosition2.column + virtualDelta, visualPosition2.leansRight);
    }

    @NotNull
    public static final VisibleRange calculateVisibleRange(@NotNull Editor editor2) {
        List list2;
        Sequence sequence;
        Sequence sequence2;
        Sequence sequence3;
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        ProperTextRange properTextRange = editor2.calculateVisibleRange();
        Intrinsics.checkNotNullExpressionValue((Object)properTextRange, (String)"calculateVisibleRange(...)");
        ProperTextRange properTextRange2 = properTextRange;
        Object[] objectArray = editor2.getFoldingModel();
        FoldingModelImpl foldingModelImpl = objectArray instanceof FoldingModelImpl ? (FoldingModelImpl)objectArray : null;
        List list3 = foldingModelImpl != null && (objectArray = foldingModelImpl.fetchVisible()) != null && (sequence3 = ArraysKt.asSequence((Object[])objectArray)) != null && (sequence2 = SequencesKt.filter((Sequence)sequence3, (Function1)((Function1)new Function1<FoldRegion, Boolean>(properTextRange2){
            final /* synthetic */ ProperTextRange $visibleRange;
            {
                this.$visibleRange = $visibleRange;
                super(1);
            }

            @NotNull
            public final Boolean invoke(FoldRegion it) {
                return this.$visibleRange.contains((Segment)it) && !it.isExpanded();
            }
        }))) != null && (sequence = SequencesKt.map((Sequence)sequence2, (Function1)calculateVisibleRange.regionsOverlapping.2.INSTANCE)) != null && (list2 = SequencesKt.toList((Sequence)sequence)) != null ? list2 : CollectionsKt.emptyList();
        return new VisibleRange(properTextRange2.getStartOffset(), properTextRange2.getEndOffset(), list3);
    }

    public static final void applyStateTo(@NotNull RdCaretState newState, @NotNull Editor editor2) {
        Intrinsics.checkNotNullParameter((Object)newState, (String)"newState");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        if (editor2.isDisposed()) {
            return;
        }
        Iterable iterable = newState.getCarets();
        boolean bl = false;
        List list2 = CollectionsKt.sortedWith((Iterable)iterable, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                RdCaret rdCaret = (RdCaret)a;
                boolean bl = false;
                Comparable comparable = Long.valueOf(rdCaret.getId().getNumber());
                rdCaret = (RdCaret)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Long.valueOf(rdCaret.getId().getNumber()));
            }
        });
        Caret caret = editor2.getCaretModel().getPrimaryCaret();
        Intrinsics.checkNotNullExpressionValue((Object)caret, (String)"getPrimaryCaret(...)");
        iterable = caret;
        bl = iterable.getLogicalPosition().leansForward;
        int n = iterable.getOffset();
        Boolean bl2 = CaretRestoreHelper.Companion.getInstance().getLastCaretBeforeRollbackLeansForward();
        Iterable iterable2 = list2;
        boolean bl3 = false;
        Object object = iterable2;
        Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)iterable2, (int)10));
        boolean bl4 = false;
        Iterator iterator2 = object.iterator();
        while (iterator2.hasNext()) {
            boolean bl5;
            boolean bl6;
            Object t = iterator2.next();
            RdCaret rdCaret = (RdCaret)t;
            Collection collection2 = collection;
            boolean bl7 = false;
            boolean bl8 = bl6 = n == rdCaret.getOffset().getOffset();
            if (bl6) {
                bl5 = bl;
            } else {
                Boolean bl9 = bl2;
                bl5 = bl9 != null ? bl9 : false;
            }
            boolean bl10 = bl5;
            Boolean bl11 = rdCaret.getOffset().getLogicalLeansForward();
            LogicalPosition logicalPosition = editor2.offsetToLogicalPosition(rdCaret.getOffset().getOffset()).leanForward(bl11 != null ? bl11 : bl10);
            Boolean bl12 = rdCaret.getSelection().getStart().getLogicalLeansForward();
            LogicalPosition logicalPosition2 = editor2.offsetToLogicalPosition(rdCaret.getSelection().getStart().getOffset()).leanForward(bl12 != null ? bl12 : bl10);
            Boolean bl13 = rdCaret.getSelection().getEnd().getLogicalLeansForward();
            LogicalPosition logicalPosition3 = editor2.offsetToLogicalPosition(rdCaret.getSelection().getEnd().getOffset()).leanForward(bl13 != null ? bl13 : bl10);
            collection2.add(new CaretState(logicalPosition, rdCaret.getOffset().getVirtualDelta(), logicalPosition2, logicalPosition3));
        }
        List list3 = (List)collection;
        editor2.getCaretModel().setCaretsAndSelections(list3);
        for (RdCaret rdCaret : list2) {
            Caret caret2;
            Boolean bl14;
            if (rdCaret.getOffset().getOffset() == n) {
                Boolean bl15 = rdCaret.getOffset().getLogicalLeansForward();
                bl14 = bl15 != null ? bl15 : bl;
            } else {
                bl14 = rdCaret.getOffset().getLogicalLeansForward();
                if (bl14 == null) {
                    bl14 = bl2;
                }
            }
            object = bl14;
            Object object2 = object;
            collection = UtilKt.docOffsetAndVirtualToVisualPosition(editor2, rdCaret.getOffset().getOffset(), rdCaret.getOffset().getVirtualDelta(), object2 != null ? (Boolean)object2 : false);
            if (editor2.getCaretModel().getCaretAt((VisualPosition)collection) == null) {
                throw new IllegalStateException(("Cannot find caret at " + (VisualPosition)collection).toString());
            }
            UtilKt.setId(caret2, rdCaret.getId());
            if (!Intrinsics.areEqual((Object)rdCaret.getId(), (Object)newState.getPrimaryCaretId()) || editor2.getCaretModel().getPrimaryCaret() == caret2) continue;
            editor2.getCaretModel().removeCaret(caret2);
            UtilKt.addCaretTo(rdCaret, editor2, true);
        }
    }

    public static final void applySelectionTo(@NotNull RdSelection selectionModel, @NotNull Caret caretToSync, @NotNull Editor editor2) {
        Intrinsics.checkNotNullParameter((Object)selectionModel, (String)"selectionModel");
        Intrinsics.checkNotNullParameter((Object)caretToSync, (String)"caretToSync");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        DocOffsetAndVirtualModel docOffsetAndVirtualModel = selectionModel.getStart();
        int n = docOffsetAndVirtualModel.component1();
        int n2 = docOffsetAndVirtualModel.component2();
        DocOffsetAndVirtualModel docOffsetAndVirtualModel2 = selectionModel.getEnd();
        int n3 = docOffsetAndVirtualModel2.component1();
        int n4 = docOffsetAndVirtualModel2.component2();
        if (n2 > 0 || n4 > 0) {
            VisualPosition visualPosition = UtilKt.docOffsetAndVirtualToVisualPosition(editor2, selectionModel.getStart());
            VisualPosition visualPosition2 = UtilKt.docOffsetAndVirtualToVisualPosition(editor2, selectionModel.getEnd());
            caretToSync.setSelection(visualPosition, n, visualPosition2, n3);
        } else {
            caretToSync.setSelection(n, n3);
        }
    }

    @Nullable
    public static final Caret addCaretTo(@NotNull RdCaret caret, @NotNull Editor editor2, boolean isPrimary) {
        Intrinsics.checkNotNullParameter((Object)caret, (String)"caret");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Caret caret2 = UtilKt.addCaretTo(caret.getOffset(), editor2, isPrimary);
        if (caret2 == null) {
            return null;
        }
        Caret caret3 = caret2;
        UtilKt.applySelectionTo(caret.getSelection(), caret3, editor2);
        UtilKt.setId(caret3, caret.getId());
        return caret3;
    }

    public static /* synthetic */ Caret addCaretTo$default(RdCaret rdCaret, Editor editor2, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = true;
        }
        return UtilKt.addCaretTo(rdCaret, editor2, bl);
    }

    @Nullable
    public static final Caret addCaretTo(@NotNull DocOffsetAndVirtualModel positionModel, @NotNull Editor editor2, boolean isPrimary) {
        Intrinsics.checkNotNullParameter((Object)positionModel, (String)"positionModel");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        VisualPosition visualPosition = UtilKt.docOffsetAndVirtualToVisualPosition(editor2, positionModel);
        return editor2.getCaretModel().addCaret(visualPosition, isPrimary);
    }

    public static /* synthetic */ Caret addCaretTo$default(DocOffsetAndVirtualModel docOffsetAndVirtualModel, Editor editor2, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = true;
        }
        return UtilKt.addCaretTo(docOffsetAndVirtualModel, editor2, bl);
    }

    @NotNull
    public static final RdCaret createModelCaret(@NotNull Caret $this$createModelCaret) {
        DocOffsetAndVirtualModel docOffsetAndVirtualModel;
        int n;
        DocOffsetAndVirtualModel docOffsetAndVirtualModel2;
        int n2;
        DocOffsetAndVirtualModel docOffsetAndVirtualModel3;
        Intrinsics.checkNotNullParameter((Object)$this$createModelCaret, (String)"<this>");
        RdCaretId rdCaretId = UtilKt.getId($this$createModelCaret);
        if (rdCaretId == null) {
            throw new IllegalStateException("Caret has no ID assigned".toString());
        }
        RdCaretId rdCaretId2 = rdCaretId;
        Object object = $this$createModelCaret;
        int n3 = $this$createModelCaret.getOffset();
        int n4 = 0;
        int n5 = 0;
        boolean bl = object.getEditor().getDocument().isInBulkUpdate();
        if (bl) {
            docOffsetAndVirtualModel3 = new DocOffsetAndVirtualModel(n3, 0, false);
        } else {
            Editor editor2 = object.getEditor();
            Intrinsics.checkNotNullExpressionValue((Object)editor2, (String)"getEditor(...)");
            int n6 = n3;
            Editor editor3 = editor2;
            n2 = 0;
            VisualPosition visualPosition = $this$createModelCaret.getVisualPosition();
            Intrinsics.checkNotNullExpressionValue((Object)visualPosition, (String)"getVisualPosition(...)");
            VisualPosition visualPosition2 = visualPosition;
            n2 = UtilKt.calcVirtualDelta(editor3, n6, visualPosition2);
            docOffsetAndVirtualModel3 = new DocOffsetAndVirtualModel(n3, n2, object.getLogicalPosition().leansForward);
        }
        DocOffsetAndVirtualModel docOffsetAndVirtualModel4 = docOffsetAndVirtualModel3;
        Object object2 = $this$createModelCaret;
        n4 = $this$createModelCaret.getSelectionStart();
        n5 = 1;
        bl = false;
        n2 = object2.getEditor().getDocument().isInBulkUpdate() ? 1 : 0;
        if (n2 != 0) {
            docOffsetAndVirtualModel2 = new DocOffsetAndVirtualModel(n4, 0, false);
        } else {
            n = 0;
            docOffsetAndVirtualModel2 = new DocOffsetAndVirtualModel(n4, n, object2.getLogicalPosition().leansForward);
        }
        object = docOffsetAndVirtualModel2;
        Object object3 = $this$createModelCaret;
        n5 = $this$createModelCaret.getSelectionEnd();
        bl = true;
        n2 = 0;
        n = object3.getEditor().getDocument().isInBulkUpdate() ? 1 : 0;
        if (n != 0) {
            docOffsetAndVirtualModel = new DocOffsetAndVirtualModel(n5, 0, false);
        } else {
            int n7 = 0;
            docOffsetAndVirtualModel = new DocOffsetAndVirtualModel(n5, n7, object3.getLogicalPosition().leansForward);
        }
        object2 = docOffsetAndVirtualModel;
        object3 = new RdSelection((DocOffsetAndVirtualModel)object, (DocOffsetAndVirtualModel)object2);
        return new RdCaret(rdCaretId2, docOffsetAndVirtualModel4, (RdSelection)object3);
    }

    @NotNull
    public static final List<RdCaret> createModelCarets(@NotNull CaretModel $this$createModelCarets) {
        Intrinsics.checkNotNullParameter((Object)$this$createModelCarets, (String)"<this>");
        List list2 = $this$createModelCarets.getAllCarets();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getAllCarets(...)");
        Iterable iterable = list2;
        boolean bl = false;
        Iterable iterable2 = iterable;
        Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)iterable, (int)10));
        boolean bl2 = false;
        for (Object t : iterable2) {
            Caret caret = (Caret)t;
            Collection collection2 = collection;
            boolean bl3 = false;
            Intrinsics.checkNotNull((Object)caret);
            collection2.add(UtilKt.createModelCaret(caret));
        }
        return (List)collection;
    }

    @NotNull
    public static final RdCaretState createModelCaretState(@NotNull CaretModel $this$createModelCaretState) {
        Intrinsics.checkNotNullParameter((Object)$this$createModelCaretState, (String)"<this>");
        Caret caret = $this$createModelCaretState.getPrimaryCaret();
        Intrinsics.checkNotNullExpressionValue((Object)caret, (String)"getPrimaryCaret(...)");
        RdCaretId rdCaretId = UtilKt.getId(caret);
        if (rdCaretId == null) {
            throw new IllegalStateException("Primary caret has no ID assigned".toString());
        }
        RdCaretId rdCaretId2 = rdCaretId;
        return new RdCaretState(rdCaretId2, UtilKt.createModelCarets($this$createModelCaretState));
    }

    @NotNull
    public static final RdCaretState getActualState(@NotNull RdSelectionChangeBase $this$getActualState) {
        RdCaretState rdCaretState;
        Intrinsics.checkNotNullParameter((Object)$this$getActualState, (String)"<this>");
        RdSelectionChangeBase rdSelectionChangeBase = $this$getActualState;
        if (rdSelectionChangeBase instanceof RdCaretStateChange) {
            rdCaretState = ((RdCaretStateChange)$this$getActualState).getNewState();
        } else if (rdSelectionChangeBase instanceof RdCaretStateSnapshotBase) {
            rdCaretState = ((RdCaretStateSnapshotBase)$this$getActualState).getState();
        } else {
            throw new IllegalStateException(("Unsupported selection change: " + $this$getActualState).toString());
        }
        return rdCaretState;
    }

    private static final DocOffsetAndVirtualModel j(Caret caret, int n, boolean bl, Function0<VisualPosition> function0) {
        int n2;
        boolean bl2 = false;
        boolean bl3 = caret.getEditor().getDocument().isInBulkUpdate();
        if (bl3) {
            return new DocOffsetAndVirtualModel(n, 0, false);
        }
        if (bl) {
            n2 = 0;
        } else {
            Editor editor2 = caret.getEditor();
            Intrinsics.checkNotNullExpressionValue((Object)editor2, (String)"getEditor(...)");
            n2 = UtilKt.calcVirtualDelta(editor2, n, (VisualPosition)function0.invoke());
        }
        int n3 = n2;
        return new DocOffsetAndVirtualModel(n, n3, caret.getLogicalPosition().leansForward);
    }

    public static final int calcVirtualDelta(@NotNull Editor editor2, int caretOffset, @NotNull VisualPosition visualPosition) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)visualPosition, (String)"visualPosition");
        LogicalPosition logicalPosition = editor2.visualToLogicalPosition(visualPosition);
        Intrinsics.checkNotNullExpressionValue((Object)logicalPosition, (String)"visualToLogicalPosition(...)");
        LogicalPosition logicalPosition2 = logicalPosition;
        int n = EditorModificationUtilEx.calcAfterLineEnd((Editor)editor2, (int)caretOffset, (LogicalPosition)logicalPosition2, (VisualPosition)visualPosition);
        return n < 0 ? 0 : n;
    }

    @NotNull
    public static final RdSelectionChangeBase reverse(@NotNull RdSelectionChangeBase $this$reverse) {
        RdSelectionChangeBase rdSelectionChangeBase;
        Intrinsics.checkNotNullParameter((Object)$this$reverse, (String)"<this>");
        RdSelectionChangeBase rdSelectionChangeBase2 = $this$reverse;
        if (rdSelectionChangeBase2 instanceof RdCaretStateChange) {
            rdSelectionChangeBase = new RdCaretStateChange(((RdCaretStateChange)$this$reverse).getNewState(), ((RdCaretStateChange)$this$reverse).getOldState(), $this$reverse.getEditorId());
        } else if (rdSelectionChangeBase2 instanceof RdCaretStateSnapshot) {
            rdSelectionChangeBase = $this$reverse;
        } else {
            throw new IllegalStateException(("unsupported change type " + $this$reverse).toString());
        }
        return rdSelectionChangeBase;
    }

    @NotNull
    public static final RdDocumentChange reverse(@NotNull RdDocumentChange $this$reverse) {
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$reverse, (String)"<this>");
        String string2 = $this$reverse.getText();
        if (string2 != null) {
            String string3 = string2;
            int n = $this$reverse.getOffset();
            int n2 = $this$reverse.getOffset() + $this$reverse.getNewText().length();
            CharSequence charSequence = $this$reverse.getOldText();
            string = ((Object)StringsKt.replaceRange((CharSequence)string3, (int)n, (int)n2, (CharSequence)charSequence)).toString();
        } else {
            string = null;
        }
        String string4 = string;
        return new RdDocumentChange($this$reverse.getOffset(), $this$reverse.getMoveOffset(), $this$reverse.getOldText(), $this$reverse.getNewText(), $this$reverse.getModificationKind(), $this$reverse.getOldDocumentLength() - $this$reverse.getOldText().length() + $this$reverse.getNewText().length(), string4, $this$reverse.isWholeTextReplaced(), $this$reverse.getDocumentId());
    }

    @NotNull
    public static final String toDebugString(@NotNull RdCaretState $this$toDebugString) {
        Intrinsics.checkNotNullParameter((Object)$this$toDebugString, (String)"<this>");
        Iterable iterable = $this$toDebugString.getCarets();
        String string = UtilKt.toDebugString($this$toDebugString.getPrimaryCaretId());
        boolean bl = false;
        Iterable iterable2 = iterable;
        Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)iterable, (int)10));
        boolean bl2 = false;
        for (Object t : iterable2) {
            RdCaret rdCaret = (RdCaret)t;
            Collection collection2 = collection;
            boolean bl3 = false;
            collection2.add(UtilKt.toDebugString(rdCaret));
        }
        return "(primary: " + string + ", carets: " + (List)collection + ")";
    }

    @NotNull
    public static final String toDebugString(@NotNull RdCaret $this$toDebugString) {
        Intrinsics.checkNotNullParameter((Object)$this$toDebugString, (String)"<this>");
        return "(id: " + UtilKt.toDebugString($this$toDebugString.getId()) + ", offset: " + UtilKt.toDebugString($this$toDebugString.getOffset()) + ", selection: " + UtilKt.toDebugString($this$toDebugString.getSelection()) + ")";
    }

    @NotNull
    public static final String toDebugString(@NotNull RdCaretId $this$toDebugString) {
        Intrinsics.checkNotNullParameter((Object)$this$toDebugString, (String)"<this>");
        return ($this$toDebugString.isClient() ? "c" : "s") + $this$toDebugString.getNumber();
    }

    @NotNull
    public static final String toDebugString(@NotNull DocOffsetAndVirtualModel $this$toDebugString) {
        Intrinsics.checkNotNullParameter((Object)$this$toDebugString, (String)"<this>");
        return "(" + $this$toDebugString.getOffset() + ", " + $this$toDebugString.getVirtualDelta() + ", " + $this$toDebugString.getLogicalLeansForward() + ")";
    }

    @NotNull
    public static final String toDebugString(@NotNull RdSelection $this$toDebugString) {
        Intrinsics.checkNotNullParameter((Object)$this$toDebugString, (String)"<this>");
        return "(start: " + UtilKt.toDebugString($this$toDebugString.getStart()) + " - end: " + UtilKt.toDebugString($this$toDebugString.getEnd()) + ")";
    }

    @NotNull
    public static final String toDebugString(@NotNull TextControlId $this$toDebugString) {
        Intrinsics.checkNotNullParameter((Object)$this$toDebugString, (String)"<this>");
        return "(" + DocumentExKt.toDebugString($this$toDebugString.getDocumentId()) + ", " + $this$toDebugString.getClientId() + ", " + $this$toDebugString.getTabIndex() + ", " + $this$toDebugString.getKind() + ")";
    }

    @NotNull
    public static final String toDebugString(@NotNull RdFileEditorId $this$toDebugString) {
        Intrinsics.checkNotNullParameter((Object)$this$toDebugString, (String)"<this>");
        return "(" + $this$toDebugString.getCompositeId() + ", " + $this$toDebugString.getProviderId() + ", " + $this$toDebugString.getIndex() + ")";
    }

    @NotNull
    public static final String toDebugString(@NotNull RdFileEditorCompositeId $this$toDebugString) {
        Intrinsics.checkNotNullParameter((Object)$this$toDebugString, (String)"<this>");
        return "(" + $this$toDebugString.getFileId() + ", " + $this$toDebugString.getClientId() + ", " + $this$toDebugString.getIndex() + ")";
    }

    @NotNull
    public static final String createLogCategory(@NotNull TextControlId $this$createLogCategory) {
        Intrinsics.checkNotNullParameter((Object)$this$createLogCategory, (String)"<this>");
        String string = DocumentExKt.createLogCategory($this$createLogCategory.getDocumentId());
        int n = $this$createLogCategory.getTabIndex();
        TextControlLocation textControlLocation = $this$createLogCategory.getKind();
        return string + ", " + n + ", " + textControlLocation;
    }

    public static final int component1(@Nullable VisualPosition $this$component1) {
        VisualPosition visualPosition = $this$component1;
        return visualPosition != null ? visualPosition.line : -1;
    }

    public static final int component2(@Nullable VisualPosition $this$component2) {
        VisualPosition visualPosition = $this$component2;
        return visualPosition != null ? visualPosition.column : -1;
    }

    public static final int component1(@NotNull LogicalPosition $this$component1) {
        Intrinsics.checkNotNullParameter((Object)$this$component1, (String)"<this>");
        return $this$component1.line;
    }

    public static final int component2(@NotNull LogicalPosition $this$component2) {
        Intrinsics.checkNotNullParameter((Object)$this$component2, (String)"<this>");
        return $this$component2.column;
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(UtilKt.class, "id", "getId(Lcom/intellij/openapi/editor/Caret;)Lcom/jetbrains/rd/ide/model/RdCaretId;", 1)))};
        $$delegatedProperties = kPropertyArray;
        id$delegate = UserDataHolderKt.userData$default(null, 1, null);
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ScrollKind.values().length];
            try {
                nArray[ScrollKind.Smart.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ScrollKind.Relative.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ScrollKind.Center.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ScrollKind.LowerHalf.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ScrollKind.UpperHalf.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

