/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rd.ide.editor;

import com.intellij.codeWithMe.ClientId;
import com.intellij.concurrency.client.ClientIdPropagation;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.client.ClientAppSession;
import com.intellij.openapi.client.ClientSessionsManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.CaretActionListener;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.event.SelectionEvent;
import com.intellij.openapi.editor.event.SelectionListener;
import com.intellij.openapi.editor.event.VisibleAreaEvent;
import com.intellij.openapi.editor.event.VisibleAreaListener;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.FocusChangeListener;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.rd.DisposableEx;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import com.jetbrains.rd.ide.editor.EditorSynchronizer;
import com.jetbrains.rd.ide.editor.EditorSynchronizerBase;
import com.jetbrains.rd.ide.editor.UtilKt;
import com.jetbrains.rd.ide.model.RdCaretState;
import com.jetbrains.rd.ide.model.RdOpenFileDescriptor;
import com.jetbrains.rd.ide.model.ScrollingInfo;
import com.jetbrains.rd.ide.model.TextControlId;
import com.jetbrains.rd.ide.model.TextControlModel;
import com.jetbrains.rd.ide.model.VisibleRange;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.reactive.ISignal;
import com.jetbrains.rd.util.reactive.ISource;
import com.jetbrains.rd.util.reactive.Signal;
import com.jetbrains.rd.util.reactive.SourceExKt;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KMutableProperty1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00aa\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u0000 _2\u00020\u0001:\u0002_`B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\b\u0010:\u001a\u00020;H\u0002J\u0010\u0010<\u001a\u00020;2\u0006\u0010=\u001a\u00020>H\u0016J\u0010\u0010?\u001a\u00020;2\u0006\u0010=\u001a\u00020>H\u0016J\u0010\u0010@\u001a\u00020;2\u0006\u0010=\u001a\u00020>H\u0016J\b\u0010A\u001a\u00020BH\u0014J\b\u0010C\u001a\u00020;H\u0007J\u0010\u0010D\u001a\u00020;2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010E\u001a\u00020;2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010F\u001a\u00020;H\u0014J\u0018\u0010G\u001a\u00020;2\u0006\u0010H\u001a\u00020\u00172\u0006\u0010I\u001a\u00020JH\u0016J\u0018\u0010K\u001a\u00020;2\u0006\u0010H\u001a\u00020\u00172\u0006\u0010I\u001a\u00020JH\u0002J\u0010\u0010L\u001a\u00020;2\u0006\u0010M\u001a\u00020\u0013H\u0004J\u0010\u0010N\u001a\u00020;2\u0006\u0010I\u001a\u00020JH\u0016J\u0010\u0010O\u001a\u00020;2\u0006\u0010M\u001a\u00020\u0013H\u0016J\b\u0010P\u001a\u00020;H\u0014J\b\u0010Q\u001a\u00020;H\u0002J\u0010\u0010R\u001a\u00020;2\u0006\u0010=\u001a\u00020SH\u0016J\u0010\u0010T\u001a\u00020;2\u0006\u0010U\u001a\u00020VH$J\u0018\u0010W\u001a\u00020;2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010X\u001a\u00020\u0017H\u0002J\u0010\u0010Y\u001a\u00020;2\u0006\u0010Z\u001a\u00020\u0017H\u0016J\u0010\u0010[\u001a\u00020;2\u0006\u0010Z\u001a\u00020\u0017H\u0016J\u0010\u0010\\\u001a\u00020;2\u0006\u0010Z\u001a\u00020\u0017H\u0016J\u0010\u0010]\u001a\u00020;2\u0006\u0010=\u001a\u00020^H\u0016R\u0014\u0010\r\u001a\u00020\u000eX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0016\u001a\u00020\u0017X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0018\u0010 \u001a\f\u0012\u0004\u0012\u00020\u00170!R\u00020\u0000X\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\"\u001a\u00020\u00178VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010\u0019R\u0014\u0010#\u001a\u00020$X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&R\u0013\u0010'\u001a\u0004\u0018\u00010(8F\u00a2\u0006\u0006\u001a\u0004\b)\u0010*R\u000e\u0010+\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0017\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00130-\u00a2\u0006\b\n\u0000\u001a\u0004\b.\u0010/R\u0018\u00100\u001a\f\u0012\u0004\u0012\u00020\u00170!R\u00020\u0000X\u0082.\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b1\u00102R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b3\u00104R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b5\u00106R\u000e\u00107\u001a\u000208X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u00109\u001a\f\u0012\u0004\u0012\u00020\u00170!R\u00020\u0000X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006a"}, d2={"Lcom/jetbrains/rd/ide/editor/EditorSynchronizerBase;", "Lcom/jetbrains/rd/ide/editor/EditorSynchronizer;", "session", "Lcom/intellij/openapi/client/ClientAppSession;", "textControlLifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "textControlId", "Lcom/jetbrains/rd/ide/model/TextControlId;", "editorModel", "Lcom/jetbrains/rd/ide/model/TextControlModel;", "editor", "Lcom/intellij/openapi/editor/Editor;", "(Lcom/intellij/openapi/client/ClientAppSession;Lcom/jetbrains/rd/util/lifetime/Lifetime;Lcom/jetbrains/rd/ide/model/TextControlId;Lcom/jetbrains/rd/ide/model/TextControlModel;Lcom/intellij/openapi/editor/Editor;)V", "clientId", "Lcom/intellij/codeWithMe/ClientId;", "getClientId", "()Lcom/intellij/codeWithMe/ClientId;", "deferredScrollingRequests", "", "Lcom/jetbrains/rd/ide/model/ScrollingInfo;", "disposable", "Lcom/intellij/openapi/Disposable;", "dontSendChange", "", "getDontSendChange", "()Z", "setDontSendChange", "(Z)V", "getEditor", "()Lcom/intellij/openapi/editor/Editor;", "getEditorModel", "()Lcom/jetbrains/rd/ide/model/TextControlModel;", "focusChangedSignalBucket", "Lcom/jetbrains/rd/ide/editor/EditorSynchronizerBase$EventSignalBucket;", "isReceivingChange", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "getLogger", "()Lcom/intellij/openapi/diagnostic/Logger;", "project", "Lcom/intellij/openapi/project/Project;", "getProject", "()Lcom/intellij/openapi/project/Project;", "scheduledScrollingRequests", "scrollingReceived", "Lcom/jetbrains/rd/util/reactive/Signal;", "getScrollingReceived", "()Lcom/jetbrains/rd/util/reactive/Signal;", "selectedSignalBucket", "getSession", "()Lcom/intellij/openapi/client/ClientAppSession;", "getTextControlId", "()Lcom/jetbrains/rd/ide/model/TextControlId;", "getTextControlLifetime", "()Lcom/jetbrains/rd/util/lifetime/Lifetime;", "visibleAreaChangesQueue", "Lcom/intellij/util/ui/update/MergingUpdateQueue;", "visibleSignalBucket", "N", "", "caretAdded", "e", "Lcom/intellij/openapi/editor/event/CaretEvent;", "caretPositionChanged", "caretRemoved", "createModelCaretState", "Lcom/jetbrains/rd/ide/model/RdCaretState;", "flushVisibleAreaChangesQueue", "focusGained", "focusLost", "init", "openEditor", "focus", "descriptor", "Lcom/jetbrains/rd/ide/model/RdOpenFileDescriptor;", "j", "performScrollingRequest", "request", "receiveFocusRequestFromModel", "receiveScrollingRequest", "receiveVisibleRequestFromModel", "j", "selectionChanged", "Lcom/intellij/openapi/editor/event/SelectionEvent;", "sendCaretStateChange", "reason", "", "j", "isFocused", "setFocused", "value", "setSelected", "setVisible", "visibleAreaChanged", "Lcom/intellij/openapi/editor/event/VisibleAreaEvent;", "Companion", "EventSignalBucket", "intellij.rd.platform"})
@SourceDebugExtension(value={"SMAP\nEditorSynchronizerBase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EditorSynchronizerBase.kt\ncom/jetbrains/rd/ide/editor/EditorSynchronizerBase\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 ReflectionUtil.kt\ncom/jetbrains/rd/util/reflection/ReflectionUtilKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,306:1\n65#2,4:307\n65#2,4:311\n65#2,4:327\n65#2,4:334\n11#3,12:315\n11#3,3:331\n16#3,7:338\n1855#4,2:345\n*S KotlinDebug\n*F\n+ 1 EditorSynchronizerBase.kt\ncom/jetbrains/rd/ide/editor/EditorSynchronizerBase\n*L\n108#1:307,4\n117#1:311,4\n139#1:327,4\n254#1:334,4\n132#1:315,12\n253#1:331,3\n253#1:338,7\n212#1:345,2\n*E\n"})
public abstract class EditorSynchronizerBase
implements EditorSynchronizer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ClientAppSession session;
    @NotNull
    private final Lifetime textControlLifetime;
    @NotNull
    private final TextControlId textControlId;
    @NotNull
    private final TextControlModel editorModel;
    @NotNull
    private final Editor editor;
    @NotNull
    private final Logger logger;
    @NotNull
    private final Disposable disposable;
    @NotNull
    private final MergingUpdateQueue visibleAreaChangesQueue;
    @NotNull
    private final List<ScrollingInfo> deferredScrollingRequests;
    private boolean scheduledScrollingRequests;
    private boolean dontSendChange;
    @NotNull
    private final ClientId clientId;
    @NotNull
    private final Signal<ScrollingInfo> scrollingReceived;
    private EventSignalBucket<Boolean> visibleSignalBucket;
    private EventSignalBucket<Boolean> focusChangedSignalBucket;
    private EventSignalBucket<Boolean> selectedSignalBucket;
    private static int debugId;

    public EditorSynchronizerBase(@NotNull ClientAppSession session, @NotNull Lifetime textControlLifetime, @NotNull TextControlId textControlId, @NotNull TextControlModel editorModel, @NotNull Editor editor2) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)textControlLifetime, (String)"textControlLifetime");
        Intrinsics.checkNotNullParameter((Object)textControlId, (String)"textControlId");
        Intrinsics.checkNotNullParameter((Object)((Object)editorModel), (String)"editorModel");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        this.session = session;
        this.textControlLifetime = textControlLifetime;
        this.textControlId = textControlId;
        this.editorModel = editorModel;
        this.editor = editor2;
        int n = debugId;
        debugId = n + 1;
        Logger logger = Logger.getInstance((String)("#" + this.getClass().getCanonicalName() + "#" + n + "(" + UtilKt.createLogCategory(this.textControlId) + ")"));
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        this.logger = logger;
        this.disposable = DisposableEx.createNestedDisposable(this.textControlLifetime, "textControlLifetime");
        this.visibleAreaChangesQueue = new MergingUpdateQueue("updateViewportQueue", 100, true, MergingUpdateQueue.ANY_COMPONENT, this.disposable, this.editor.getComponent(), true);
        this.deferredScrollingRequests = new ArrayList();
        this.clientId = new ClientId(this.textControlId.getClientId());
        this.scrollingReceived = new Signal();
    }

    @NotNull
    public final ClientAppSession getSession() {
        return this.session;
    }

    @Override
    @NotNull
    public final Lifetime getTextControlLifetime() {
        return this.textControlLifetime;
    }

    @Override
    @NotNull
    public final TextControlId getTextControlId() {
        return this.textControlId;
    }

    @Override
    @NotNull
    public TextControlModel getEditorModel() {
        return this.editorModel;
    }

    @Override
    @NotNull
    public final Editor getEditor() {
        return this.editor;
    }

    @Nullable
    public final Project getProject() {
        return this.editor.getProject();
    }

    @NotNull
    protected final Logger getLogger() {
        return this.logger;
    }

    protected final boolean getDontSendChange() {
        return this.dontSendChange;
    }

    protected final void setDontSendChange(boolean bl) {
        this.dontSendChange = bl;
    }

    @NotNull
    protected final ClientId getClientId() {
        return this.clientId;
    }

    @NotNull
    public final Signal<ScrollingInfo> getScrollingReceived() {
        return this.scrollingReceived;
    }

    @Override
    public boolean isReceivingChange() {
        ThreadingAssertions.assertEventDispatchThread();
        return this.dontSendChange;
    }

    protected void init() {
        this.visibleSignalBucket = new EventSignalBucket<Boolean>(this, this.textControlLifetime, this.getEditorModel().getVisibleChangedFromFrontend(), "visibleChangedFromFrontend");
        this.focusChangedSignalBucket = new EventSignalBucket<Boolean>(this, this.textControlLifetime, this.getEditorModel().getFocusChangedFromFrontend(), "focusChangedFromFrontend");
        this.selectedSignalBucket = new EventSignalBucket<Boolean>(this, this.textControlLifetime, this.getEditorModel().getSelectedEditorChangedFromFrontend(), "selectedEditorChangedFromFrontend");
        this.visibleAreaChangesQueue.setRestartTimerOnAdd(true);
        Editor editor2 = this.editor;
        Intrinsics.checkNotNull((Object)editor2, (String)"null cannot be cast to non-null type com.intellij.openapi.editor.impl.EditorImpl");
        ((EditorImpl)editor2).addFocusListener((FocusChangeListener)this, this.disposable);
        ((EditorImpl)this.editor).getDocument().addDocumentListener((DocumentListener)this, this.disposable);
        ((EditorImpl)this.editor).getSelectionModel().addSelectionListener((SelectionListener)this, this.disposable);
        ((EditorImpl)this.editor).getCaretModel().addCaretActionListener((CaretActionListener)this, this.disposable);
        ((EditorImpl)this.editor).getCaretModel().addCaretListener((CaretListener)this, this.disposable);
        ((EditorImpl)this.editor).getScrollingModel().addVisibleAreaListener((VisibleAreaListener)this, this.disposable);
        this.getEditorModel().getTabSize().advise(this.textControlLifetime, (Function1)new Function1<Integer, Unit>(this){
            final /* synthetic */ EditorSynchronizerBase this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(int it) {
                EditorSynchronizerBase.access$applySettingsFromModel(this.this$0);
            }
        });
        this.getEditorModel().getIndentSize().advise(this.textControlLifetime, (Function1)new Function1<Integer, Unit>(this){
            final /* synthetic */ EditorSynchronizerBase this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(int it) {
                EditorSynchronizerBase.access$applySettingsFromModel(this.this$0);
            }
        });
        this.getEditorModel().getUseTab().advise(this.textControlLifetime, (Function1)new Function1<Boolean, Unit>(this){
            final /* synthetic */ EditorSynchronizerBase this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(boolean it) {
                EditorSynchronizerBase.access$applySettingsFromModel(this.this$0);
            }
        });
        this.getEditorModel().getRightMargin().advise(this.textControlLifetime, (Function1)new Function1<Integer, Unit>(this){
            final /* synthetic */ EditorSynchronizerBase this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(int rightMargin) {
                if (rightMargin != 0) {
                    ((EditorImpl)this.this$0.getEditor()).getSettings().setRightMargin(rightMargin);
                }
            }
        });
        this.getEditorModel().getRequestFocusFromBackend().advise(this.textControlLifetime, (Function1)new Function1<RdOpenFileDescriptor, Unit>(this){
            final /* synthetic */ EditorSynchronizerBase this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull RdOpenFileDescriptor it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                this.this$0.receiveFocusRequestFromModel(it);
            }
        });
        this.getEditorModel().getRequestVisibleFromBackend().advise(this.textControlLifetime, (Function1)new Function1<Unit, Unit>(this){
            final /* synthetic */ EditorSynchronizerBase this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull Unit it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                this.this$0.receiveVisibleRequestFromModel();
            }
        });
    }

    private final void N() {
        CodeStyleSettingsManager.getInstance((Project)this.getProject()).notifyCodeStyleSettingsChanged();
        Editor editor2 = this.editor;
        Intrinsics.checkNotNull((Object)editor2, (String)"null cannot be cast to non-null type com.intellij.openapi.editor.ex.EditorEx");
        ((EditorEx)editor2).reinitSettings();
    }

    protected void receiveVisibleRequestFromModel() {
        Logger logger = this.logger;
        boolean bl = false;
        if (logger.isTraceEnabled()) {
            Logger logger2 = logger;
            boolean bl2 = false;
            logger2.trace("Got visible request from model. Marking editor as not focused");
        }
        UIUtil.markAsFocused((JComponent)this.editor.getContentComponent(), (boolean)false);
        this.j(false, new RdOpenFileDescriptor(null));
    }

    @Override
    public void receiveFocusRequestFromModel(@NotNull RdOpenFileDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        Logger logger = this.logger;
        boolean bl = false;
        if (logger.isTraceEnabled()) {
            Logger logger2 = logger;
            boolean bl2 = false;
            logger2.trace("Got focus request from model. Marking editor as 'hasFocus'");
        }
        UIUtil.markAsFocused((JComponent)this.editor.getContentComponent(), (boolean)true);
        this.j(true, descriptor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void j(boolean bl, RdOpenFileDescriptor rdOpenFileDescriptor) {
        EditorSynchronizerBase editorSynchronizerBase = this;
        KMutableProperty1 kMutableProperty1 = (KMutableProperty1)openEditorDontSendChange.1.INSTANCE;
        boolean bl2 = true;
        boolean bl3 = false;
        if (!((Boolean)kMutableProperty1.get((Object)editorSynchronizerBase) == false)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        try {
            kMutableProperty1.set((Object)editorSynchronizerBase, (Object)true);
            boolean bl4 = false;
            this.openEditor(bl, rdOpenFileDescriptor);
            Unit unit = Unit.INSTANCE;
        }
        finally {
            kMutableProperty1.set((Object)editorSynchronizerBase, (Object)false);
        }
    }

    @Override
    public void openEditor(boolean focus, @NotNull RdOpenFileDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        Editor editor2 = this.editor;
        Intrinsics.checkNotNull((Object)editor2, (String)"null cannot be cast to non-null type com.intellij.openapi.editor.impl.EditorImpl");
        VirtualFile virtualFile = ((EditorImpl)editor2).getVirtualFile();
        Logger logger = this.logger;
        boolean bl = false;
        if (logger.isTraceEnabled()) {
            Logger logger2 = logger;
            boolean bl2 = false;
            logger2.trace("Opening text editor for file " + virtualFile + " and 'focusEditor=false'");
        }
        if (virtualFile == null) {
            return;
        }
        Project project = this.getProject();
        if (project == null) {
            return;
        }
        logger = project;
        Integer n = descriptor.getDocOffset();
        FileEditorManager.getInstance((Project)logger).openTextEditor(new OpenFileDescriptor((Project)logger, virtualFile, n != null ? n : -1), focus);
        if (focus) {
            IdeFocusManager.getInstance((Project)logger).requestFocusInProject((Component)((EditorImpl)this.editor).getContentComponent(), (Project)logger);
        }
    }

    public void focusGained(@NotNull Editor editor2) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        this.j(editor2, true);
    }

    public void focusLost(@NotNull Editor editor2) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        this.j(editor2, false);
    }

    private final void j(Editor editor2, boolean bl) {
        if (!Intrinsics.areEqual((Object)editor2, (Object)this.editor)) {
            return;
        }
        this.setFocused(bl);
    }

    public void caretAdded(@NotNull CaretEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        this.sendCaretStateChange("Caret was added");
    }

    public void caretRemoved(@NotNull CaretEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        this.sendCaretStateChange("Caret was removed");
    }

    public void caretPositionChanged(@NotNull CaretEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        this.sendCaretStateChange("Caret was changed");
    }

    public void selectionChanged(@NotNull SelectionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        this.sendCaretStateChange("Selection was changed");
    }

    protected abstract void sendCaretStateChange(@NotNull String var1);

    @NotNull
    protected RdCaretState createModelCaretState() {
        CaretModel caretModel = this.editor.getCaretModel();
        Intrinsics.checkNotNullExpressionValue((Object)caretModel, (String)"getCaretModel(...)");
        return UtilKt.createModelCaretState(caretModel);
    }

    public void visibleAreaChanged(@NotNull VisibleAreaEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (this.dontSendChange) {
            return;
        }
        if (!this.deferredScrollingRequests.isEmpty() && !e.getNewRectangle().isEmpty()) {
            this.j();
        }
        this.visibleAreaChangesQueue.queue(new Update(this){
            final /* synthetic */ EditorSynchronizerBase this$0;
            {
                this.this$0 = $receiver;
                super((Object)"SendViewport");
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                ClientId.Companion companion = ClientId.Companion;
                ClientId clientId = this.this$0.getClientId();
                EditorSynchronizerBase editorSynchronizerBase = this.this$0;
                boolean bl = false;
                ClientSessionsManager clientSessionsManager = companion.getCachedService();
                if (clientSessionsManager == null) {
                    boolean bl2 = false;
                    VisibleRange visibleRange = UtilKt.calculateVisibleRange(editorSynchronizerBase.getEditor());
                    Logger logger = editorSynchronizerBase.getLogger();
                    boolean bl3 = false;
                    if (logger.isTraceEnabled()) {
                        Logger logger2 = logger;
                        boolean bl4 = false;
                        logger2.trace("Sending viewport (" + visibleRange.getStartOffset() + ", " + visibleRange.getEndOffset() + ").");
                    }
                    editorSynchronizerBase.getEditorModel().getVisibleRange().set((Object)((Object)visibleRange));
                } else {
                    Object object;
                    String string;
                    ClientSessionsManager clientSessionsManager2 = clientSessionsManager;
                    if (clientId == null || clientSessionsManager2.isValid(clientId)) {
                        if (clientId != null && companion.isFakeLocalId(clientId)) {
                            string = companion.getLocalId().getValue();
                        } else {
                            ClientId clientId2 = clientId;
                            string = clientId2 != null ? clientId2.getValue() : null;
                        }
                    } else {
                        object = companion.getClientIdLogger();
                        boolean bl5 = false;
                        if (object.isTraceEnabled()) {
                            Object object2 = object;
                            boolean bl6 = false;
                            object2.trace("Invalid ClientId " + clientId + " replaced with null at " + new Throwable().fillInStackTrace());
                        }
                        string = null;
                    }
                    String string2 = string;
                    object = ClientIdPropagation.getCurrentClientIdString();
                    try {
                        ClientIdPropagation.setCurrentClientIdString((String)string2);
                        boolean bl7 = false;
                        VisibleRange visibleRange = UtilKt.calculateVisibleRange(editorSynchronizerBase.getEditor());
                        Logger logger = editorSynchronizerBase.getLogger();
                        boolean bl8 = false;
                        if (logger.isTraceEnabled()) {
                            Logger logger3 = logger;
                            boolean bl9 = false;
                            logger3.trace("Sending viewport (" + visibleRange.getStartOffset() + ", " + visibleRange.getEndOffset() + ").");
                        }
                        editorSynchronizerBase.getEditorModel().getVisibleRange().set((Object)((Object)visibleRange));
                        Unit unit = Unit.INSTANCE;
                    }
                    finally {
                        ClientIdPropagation.setCurrentClientIdString((String)object);
                    }
                }
            }

            public boolean isDisposed() {
                return this.this$0.getEditor().isDisposed();
            }
        });
    }

    private final void j() {
        if (!this.scheduledScrollingRequests) {
            this.scheduledScrollingRequests = true;
            SwingUtilities.invokeLater(() -> EditorSynchronizerBase.j(this));
        }
    }

    @Override
    public void setVisible(boolean value2) {
        EventSignalBucket<Boolean> eventSignalBucket = this.visibleSignalBucket;
        if (eventSignalBucket == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"visibleSignalBucket");
            eventSignalBucket = null;
        }
        eventSignalBucket.fire(value2);
    }

    @Override
    public void setFocused(boolean value2) {
        EventSignalBucket<Boolean> eventSignalBucket = this.focusChangedSignalBucket;
        if (eventSignalBucket == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"focusChangedSignalBucket");
            eventSignalBucket = null;
        }
        eventSignalBucket.fire(value2);
    }

    @Override
    public void setSelected(boolean value2) {
        EventSignalBucket<Boolean> eventSignalBucket = this.selectedSignalBucket;
        if (eventSignalBucket == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"selectedSignalBucket");
            eventSignalBucket = null;
        }
        eventSignalBucket.fire(value2);
    }

    @Override
    public void receiveScrollingRequest(@NotNull ScrollingInfo request2) {
        Intrinsics.checkNotNullParameter((Object)request2, (String)"request");
        this.scrollingReceived.fire((Object)request2);
        if (this.editor.getScrollingModel().getVisibleArea().isEmpty() || !this.deferredScrollingRequests.isEmpty()) {
            this.deferredScrollingRequests.add(request2);
        } else {
            this.performScrollingRequest(request2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void performScrollingRequest(@NotNull ScrollingInfo request2) {
        Intrinsics.checkNotNullParameter((Object)request2, (String)"request");
        EditorSynchronizerBase editorSynchronizerBase = this;
        KMutableProperty1 kMutableProperty1 = (KMutableProperty1)performScrollingRequest.1.INSTANCE;
        boolean bl = true;
        boolean bl2 = false;
        if (!((Boolean)kMutableProperty1.get((Object)editorSynchronizerBase) == false)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        try {
            kMutableProperty1.set((Object)editorSynchronizerBase, (Object)true);
            boolean bl3 = false;
            Object object = this.logger;
            boolean bl4 = false;
            if (object.isTraceEnabled()) {
                Logger logger = object;
                boolean bl5 = false;
                logger.trace("Applying backend scrolling to (" + request2 + ")");
            }
            object = request2.getDocOffset();
            ScrollType scrollType = UtilKt.toScrollType(request2.getKind());
            if (object != null) {
                LogicalPosition logicalPosition = this.editor.offsetToLogicalPosition(((Integer)object).intValue());
                Intrinsics.checkNotNullExpressionValue((Object)logicalPosition, (String)"offsetToLogicalPosition(...)");
                LogicalPosition logicalPosition2 = logicalPosition;
                this.editor.getScrollingModel().scrollTo(logicalPosition2, scrollType);
            } else {
                this.editor.getScrollingModel().scrollToCaret(scrollType);
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            kMutableProperty1.set((Object)editorSynchronizerBase, (Object)false);
        }
    }

    @TestOnly
    public final void flushVisibleAreaChangesQueue() {
        this.visibleAreaChangesQueue.flush();
    }

    private static final void j(EditorSynchronizerBase editorSynchronizerBase) {
        Intrinsics.checkNotNullParameter((Object)editorSynchronizerBase, (String)"this$0");
        editorSynchronizerBase.scheduledScrollingRequests = false;
        if (!editorSynchronizerBase.editor.isDisposed() && !editorSynchronizerBase.editor.getScrollingModel().getVisibleArea().isEmpty()) {
            Iterable iterable = editorSynchronizerBase.deferredScrollingRequests;
            boolean bl = false;
            for (Object t : iterable) {
                ScrollingInfo scrollingInfo = (ScrollingInfo)t;
                boolean bl2 = false;
                editorSynchronizerBase.performScrollingRequest(scrollingInfo);
            }
            editorSynchronizerBase.deferredScrollingRequests.clear();
        }
    }

    public static final /* synthetic */ void access$applySettingsFromModel(EditorSynchronizerBase $this) {
        $this.N();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/jetbrains/rd/ide/editor/EditorSynchronizerBase$Companion;", "", "()V", "debugId", "", "intellij.rd.platform"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0082\u0004\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B%\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0015\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00028\u0000H\u0007\u00a2\u0006\u0002\u0010\u000fR\u0012\u0010\n\u001a\u0004\u0018\u00018\u0000X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u000bR\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/jetbrains/rd/ide/editor/EditorSynchronizerBase$EventSignalBucket;", "T", "", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "signal", "Lcom/jetbrains/rd/util/reactive/ISignal;", "name", "", "(Lcom/jetbrains/rd/ide/editor/EditorSynchronizerBase;Lcom/jetbrains/rd/util/lifetime/Lifetime;Lcom/jetbrains/rd/util/reactive/ISignal;Ljava/lang/String;)V", "beforeReadyState", "Ljava/lang/Object;", "fire", "", "state", "(Ljava/lang/Object;)V", "intellij.rd.platform"})
    @SourceDebugExtension(value={"SMAP\nEditorSynchronizerBase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EditorSynchronizerBase.kt\ncom/jetbrains/rd/ide/editor/EditorSynchronizerBase$EventSignalBucket\n+ 2 ClientId.kt\ncom/intellij/codeWithMe/ClientId$Companion\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,306:1\n231#2:307\n233#2,8:312\n241#2,10:324\n65#3,4:308\n65#3,4:320\n65#3,4:334\n*S KotlinDebug\n*F\n+ 1 EditorSynchronizerBase.kt\ncom/jetbrains/rd/ide/editor/EditorSynchronizerBase$EventSignalBucket\n*L\n295#1:307\n295#1:312,8\n295#1:324,10\n296#1:308,4\n295#1:320,4\n301#1:334,4\n*E\n"})
    private final class EventSignalBucket<T> {
        @NotNull
        private final ISignal<T> signal;
        @NotNull
        private final String name;
        @Nullable
        private T beforeReadyState;
        final /* synthetic */ EditorSynchronizerBase this$0;

        public EventSignalBucket(@NotNull EditorSynchronizerBase this$0, @NotNull Lifetime lifetime, @NotNull ISignal<T> signal, String name) {
            Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
            Intrinsics.checkNotNullParameter(signal, (String)"signal");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            this.this$0 = this$0;
            this.signal = signal;
            this.name = name;
            if (!Intrinsics.areEqual((Object)this.this$0.getEditorModel().getBackendReadyForEvents().getValueOrNull(), (Object)true)) {
                SourceExKt.adviseUntil((ISource)((ISource)this.this$0.getEditorModel().getBackendReadyForEvents()), (Lifetime)lifetime, (Function1)((Function1)new Function1<Boolean, Boolean>(){

                    @NotNull
                    public final Boolean invoke(boolean isReady) {
                        ThreadingAssertions.assertEventDispatchThread();
                        if (!isReady) {
                            return false;
                        }
                        Object object = beforeReadyState;
                        if (object == null) {
                            return true;
                        }
                        Object object2 = object;
                        Logger logger = this$0.getLogger();
                        EventSignalBucket eventSignalBucket = this;
                        boolean bl = false;
                        if (logger.isTraceEnabled()) {
                            Logger logger2 = logger;
                            boolean bl2 = false;
                            logger2.trace("backendReadyForEvents setted to true, sending " + eventSignalBucket.name + " = " + eventSignalBucket.beforeReadyState);
                        }
                        this.fire(object2);
                        return true;
                    }
                }));
            }
        }

        public /* synthetic */ EventSignalBucket(EditorSynchronizerBase editorSynchronizerBase, Lifetime lifetime, ISignal iSignal, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                string = "EventSignalBucket";
            }
            this(editorSynchronizerBase, lifetime, iSignal, string);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @RequiresEdt
        public final void fire(T state) {
            if (Intrinsics.areEqual((Object)this.this$0.getEditorModel().getBackendReadyForEvents().getValueOrNull(), (Object)true)) {
                ClientId.Companion companion = ClientId.Companion;
                ClientId clientId = this.this$0.getClientId();
                EditorSynchronizerBase editorSynchronizerBase = this.this$0;
                boolean bl = false;
                ClientSessionsManager clientSessionsManager = companion.getCachedService();
                if (clientSessionsManager == null) {
                    boolean bl2 = false;
                    Logger logger = editorSynchronizerBase.getLogger();
                    boolean bl3 = false;
                    if (logger.isTraceEnabled()) {
                        Logger logger2 = logger;
                        boolean bl4 = false;
                        logger2.trace("Sending " + this.name + "=" + state);
                    }
                    this.signal.fire(state);
                } else {
                    Object object;
                    String string;
                    ClientSessionsManager clientSessionsManager2 = clientSessionsManager;
                    if (clientId == null || clientSessionsManager2.isValid(clientId)) {
                        if (clientId != null && companion.isFakeLocalId(clientId)) {
                            string = companion.getLocalId().getValue();
                        } else {
                            ClientId clientId2 = clientId;
                            string = clientId2 != null ? clientId2.getValue() : null;
                        }
                    } else {
                        object = companion.getClientIdLogger();
                        boolean bl5 = false;
                        if (object.isTraceEnabled()) {
                            Object object2 = object;
                            boolean bl6 = false;
                            object2.trace("Invalid ClientId " + clientId + " replaced with null at " + new Throwable().fillInStackTrace());
                        }
                        string = null;
                    }
                    String string2 = string;
                    object = ClientIdPropagation.getCurrentClientIdString();
                    try {
                        ClientIdPropagation.setCurrentClientIdString((String)string2);
                        boolean bl7 = false;
                        Logger logger = editorSynchronizerBase.getLogger();
                        boolean bl8 = false;
                        if (logger.isTraceEnabled()) {
                            Logger logger3 = logger;
                            boolean bl9 = false;
                            logger3.trace("Sending " + this.name + "=" + state);
                        }
                        this.signal.fire(state);
                        Unit unit = Unit.INSTANCE;
                    }
                    finally {
                        ClientIdPropagation.setCurrentClientIdString((String)object);
                    }
                }
            } else {
                Logger logger = this.this$0.getLogger();
                boolean bl = false;
                if (logger.isTraceEnabled()) {
                    Logger logger4 = logger;
                    boolean bl10 = false;
                    logger4.trace("Backend is not ready to events, saving value for " + this.name + " = " + state);
                }
                this.beforeReadyState = state;
            }
        }
    }
}

